@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.appmesh

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.Unit
import software.amazon.awscdk.services.appmesh.BackendConfig
import software.amazon.awscdk.services.appmesh.CfnVirtualNode

/**
 * Properties for a backend.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * BackendConfig backendConfig = BackendConfig.builder()
 * .virtualServiceBackend(BackendProperty.builder()
 * .virtualService(VirtualServiceBackendProperty.builder()
 * .virtualServiceName("virtualServiceName")
 * // the properties below are optional
 * .clientPolicy(ClientPolicyProperty.builder()
 * .tls(ClientPolicyTlsProperty.builder()
 * .validation(TlsValidationContextProperty.builder()
 * .trust(TlsValidationContextTrustProperty.builder()
 * .acm(TlsValidationContextAcmTrustProperty.builder()
 * .certificateAuthorityArns(List.of("certificateAuthorityArns"))
 * .build())
 * .file(TlsValidationContextFileTrustProperty.builder()
 * .certificateChain("certificateChain")
 * .build())
 * .sds(TlsValidationContextSdsTrustProperty.builder()
 * .secretName("secretName")
 * .build())
 * .build())
 * // the properties below are optional
 * .subjectAlternativeNames(SubjectAlternativeNamesProperty.builder()
 * .match(SubjectAlternativeNameMatchersProperty.builder()
 * .exact(List.of("exact"))
 * .build())
 * .build())
 * .build())
 * // the properties below are optional
 * .certificate(ClientTlsCertificateProperty.builder()
 * .file(ListenerTlsFileCertificateProperty.builder()
 * .certificateChain("certificateChain")
 * .privateKey("privateKey")
 * .build())
 * .sds(ListenerTlsSdsCertificateProperty.builder()
 * .secretName("secretName")
 * .build())
 * .build())
 * .enforce(false)
 * .ports(List.of(123))
 * .build())
 * .build())
 * .build())
 * .build())
 * .build();
 * ```
 */
@CdkDslMarker
public class BackendConfigDsl {
  private val cdkBuilder: BackendConfig.Builder = BackendConfig.builder()

  /**
   * @param virtualServiceBackend Config for a Virtual Service backend. 
   */
  public
      fun virtualServiceBackend(virtualServiceBackend: CfnVirtualNodeBackendPropertyDsl.() -> Unit =
      {}) {
    val builder = CfnVirtualNodeBackendPropertyDsl()
    builder.apply(virtualServiceBackend)
    cdkBuilder.virtualServiceBackend(builder.build())
  }

  /**
   * @param virtualServiceBackend Config for a Virtual Service backend. 
   */
  public fun virtualServiceBackend(virtualServiceBackend: CfnVirtualNode.BackendProperty) {
    cdkBuilder.virtualServiceBackend(virtualServiceBackend)
  }

  public fun build(): BackendConfig = cdkBuilder.build()
}
