@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.appsync

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.IResolvable
import software.amazon.awscdk.services.appsync.CfnSourceApiAssociation
import software.constructs.Construct

/**
 * Describes the configuration of a source API.
 *
 * A source API is a GraphQL API that is linked to a merged API. There can be multiple source APIs
 * attached to each merged API. When linked to a merged API, the source API's schema, data sources, and
 * resolvers will be combined with other linked source API data to form a new, singular API. Source
 * APIs can originate from your account or from other accounts via Resource Access Manager.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnSourceApiAssociation cfnSourceApiAssociation = CfnSourceApiAssociation.Builder.create(this,
 * "MyCfnSourceApiAssociation")
 * .description("description")
 * .mergedApiIdentifier("mergedApiIdentifier")
 * .sourceApiAssociationConfig(SourceApiAssociationConfigProperty.builder()
 * .mergeType("mergeType")
 * .build())
 * .sourceApiIdentifier("sourceApiIdentifier")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html)
 */
@CdkDslMarker
public class CfnSourceApiAssociationDsl(
  scope: Construct,
  id: String,
) {
  private val cdkBuilder: CfnSourceApiAssociation.Builder =
      CfnSourceApiAssociation.Builder.create(scope, id)

  /**
   * The description field of the association configuration.
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html#cfn-appsync-sourceapiassociation-description)
   * @param description The description field of the association configuration. 
   */
  public fun description(description: String) {
    cdkBuilder.description(description)
  }

  /**
   * The identifier of the AppSync Merged API.
   *
   * This is generated by the AppSync service. In most cases, Merged APIs (especially in your
   * account) only require the API ID value or ARN of the merged API. However, Merged APIs from other
   * accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html#cfn-appsync-sourceapiassociation-mergedapiidentifier)
   * @param mergedApiIdentifier The identifier of the AppSync Merged API. 
   */
  public fun mergedApiIdentifier(mergedApiIdentifier: String) {
    cdkBuilder.mergedApiIdentifier(mergedApiIdentifier)
  }

  /**
   * The `SourceApiAssociationConfig` object data.
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html#cfn-appsync-sourceapiassociation-sourceapiassociationconfig)
   * @param sourceApiAssociationConfig The `SourceApiAssociationConfig` object data. 
   */
  public fun sourceApiAssociationConfig(sourceApiAssociationConfig: IResolvable) {
    cdkBuilder.sourceApiAssociationConfig(sourceApiAssociationConfig)
  }

  /**
   * The `SourceApiAssociationConfig` object data.
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html#cfn-appsync-sourceapiassociation-sourceapiassociationconfig)
   * @param sourceApiAssociationConfig The `SourceApiAssociationConfig` object data. 
   */
  public
      fun sourceApiAssociationConfig(sourceApiAssociationConfig: CfnSourceApiAssociation.SourceApiAssociationConfigProperty) {
    cdkBuilder.sourceApiAssociationConfig(sourceApiAssociationConfig)
  }

  /**
   * The identifier of the AppSync Source API.
   *
   * This is generated by the AppSync service. In most cases, source APIs (especially in your
   * account) only require the API ID value or ARN of the source API. However, source APIs from other
   * accounts (cross-account use cases) strictly require the full resource ARN of the source API.
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html#cfn-appsync-sourceapiassociation-sourceapiidentifier)
   * @param sourceApiIdentifier The identifier of the AppSync Source API. 
   */
  public fun sourceApiIdentifier(sourceApiIdentifier: String) {
    cdkBuilder.sourceApiIdentifier(sourceApiIdentifier)
  }

  public fun build(): CfnSourceApiAssociation = cdkBuilder.build()
}
