@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.appsync

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.IResolvable
import software.amazon.awscdk.services.appsync.CfnSourceApiAssociation
import software.amazon.awscdk.services.appsync.CfnSourceApiAssociationProps

/**
 * Properties for defining a `CfnSourceApiAssociation`.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnSourceApiAssociationProps cfnSourceApiAssociationProps =
 * CfnSourceApiAssociationProps.builder()
 * .description("description")
 * .mergedApiIdentifier("mergedApiIdentifier")
 * .sourceApiAssociationConfig(SourceApiAssociationConfigProperty.builder()
 * .mergeType("mergeType")
 * .build())
 * .sourceApiIdentifier("sourceApiIdentifier")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appsync-sourceapiassociation.html)
 */
@CdkDslMarker
public class CfnSourceApiAssociationPropsDsl {
  private val cdkBuilder: CfnSourceApiAssociationProps.Builder =
      CfnSourceApiAssociationProps.builder()

  /**
   * @param description The description field of the association configuration.
   */
  public fun description(description: String) {
    cdkBuilder.description(description)
  }

  /**
   * @param mergedApiIdentifier The identifier of the AppSync Merged API.
   * This is generated by the AppSync service. In most cases, Merged APIs (especially in your
   * account) only require the API ID value or ARN of the merged API. However, Merged APIs from other
   * accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
   */
  public fun mergedApiIdentifier(mergedApiIdentifier: String) {
    cdkBuilder.mergedApiIdentifier(mergedApiIdentifier)
  }

  /**
   * @param sourceApiAssociationConfig The `SourceApiAssociationConfig` object data.
   */
  public fun sourceApiAssociationConfig(sourceApiAssociationConfig: IResolvable) {
    cdkBuilder.sourceApiAssociationConfig(sourceApiAssociationConfig)
  }

  /**
   * @param sourceApiAssociationConfig The `SourceApiAssociationConfig` object data.
   */
  public
      fun sourceApiAssociationConfig(sourceApiAssociationConfig: CfnSourceApiAssociation.SourceApiAssociationConfigProperty) {
    cdkBuilder.sourceApiAssociationConfig(sourceApiAssociationConfig)
  }

  /**
   * @param sourceApiIdentifier The identifier of the AppSync Source API.
   * This is generated by the AppSync service. In most cases, source APIs (especially in your
   * account) only require the API ID value or ARN of the source API. However, source APIs from other
   * accounts (cross-account use cases) strictly require the full resource ARN of the source API.
   */
  public fun sourceApiIdentifier(sourceApiIdentifier: String) {
    cdkBuilder.sourceApiIdentifier(sourceApiIdentifier)
  }

  public fun build(): CfnSourceApiAssociationProps = cdkBuilder.build()
}
