@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.autoscaling

import cloudshift.awscdk.common.CdkDslMarker
import cloudshift.awscdk.dsl.services.ec2.SubnetSelectionDsl
import kotlin.Boolean
import kotlin.Number
import kotlin.String
import kotlin.Unit
import kotlin.collections.Collection
import kotlin.collections.MutableList
import software.amazon.awscdk.Duration
import software.amazon.awscdk.services.autoscaling.ApplyCloudFormationInitOptions
import software.amazon.awscdk.services.autoscaling.AutoScalingGroup
import software.amazon.awscdk.services.autoscaling.BlockDevice
import software.amazon.awscdk.services.autoscaling.GroupMetrics
import software.amazon.awscdk.services.autoscaling.HealthCheck
import software.amazon.awscdk.services.autoscaling.MixedInstancesPolicy
import software.amazon.awscdk.services.autoscaling.Monitoring
import software.amazon.awscdk.services.autoscaling.NotificationConfiguration
import software.amazon.awscdk.services.autoscaling.Signals
import software.amazon.awscdk.services.autoscaling.TerminationPolicy
import software.amazon.awscdk.services.autoscaling.UpdatePolicy
import software.amazon.awscdk.services.ec2.CloudFormationInit
import software.amazon.awscdk.services.ec2.ILaunchTemplate
import software.amazon.awscdk.services.ec2.IMachineImage
import software.amazon.awscdk.services.ec2.ISecurityGroup
import software.amazon.awscdk.services.ec2.IVpc
import software.amazon.awscdk.services.ec2.InstanceType
import software.amazon.awscdk.services.ec2.SubnetSelection
import software.amazon.awscdk.services.ec2.UserData
import software.amazon.awscdk.services.iam.IRole
import software.constructs.Construct

/**
 * A Fleet represents a managed set of EC2 instances.
 *
 * The Fleet models a number of AutoScalingGroups, a launch configuration, a
 * security group and an instance role.
 *
 * It allows adding arbitrary commands to the startup scripts of the instances
 * in the fleet.
 *
 * The ASG spans the availability zones specified by vpcSubnets, falling back to
 * the Vpc default strategy if not specified.
 *
 * Example:
 *
 * ```
 * Vpc vpc;
 * InstanceType instanceType;
 * IMachineImage machineImage;
 * AutoScalingGroup.Builder.create(this, "ASG")
 * .vpc(vpc)
 * .instanceType(instanceType)
 * .machineImage(machineImage)
 * // ...
 * .init(CloudFormationInit.fromElements(InitFile.fromString("/etc/my_instance", "This got written
 * during instance startup")))
 * .signals(Signals.waitForAll(SignalsOptions.builder()
 * .timeout(Duration.minutes(10))
 * .build()))
 * .build();
 * ```
 */
@CdkDslMarker
public class AutoScalingGroupDsl(
  scope: Construct,
  id: String,
) {
  private val cdkBuilder: AutoScalingGroup.Builder = AutoScalingGroup.Builder.create(scope, id)

  private val _blockDevices: MutableList<BlockDevice> = mutableListOf()

  private val _groupMetrics: MutableList<GroupMetrics> = mutableListOf()

  private val _notifications: MutableList<NotificationConfiguration> = mutableListOf()

  private val _terminationPolicies: MutableList<TerminationPolicy> = mutableListOf()

  /**
   * Whether the instances can initiate connections to anywhere by default.
   *
   * Default: true
   *
   * @param allowAllOutbound Whether the instances can initiate connections to anywhere by default. 
   */
  public fun allowAllOutbound(allowAllOutbound: Boolean) {
    cdkBuilder.allowAllOutbound(allowAllOutbound)
  }

  /**
   * Whether instances in the Auto Scaling Group should have public IP addresses associated with
   * them.
   *
   * `launchTemplate` and `mixedInstancesPolicy` must not be specified when this property is
   * specified
   *
   * Default: - Use subnet setting.
   *
   * @param associatePublicIpAddress Whether instances in the Auto Scaling Group should have public
   * IP addresses associated with them. 
   */
  public fun associatePublicIpAddress(associatePublicIpAddress: Boolean) {
    cdkBuilder.associatePublicIpAddress(associatePublicIpAddress)
  }

  /**
   * The name of the Auto Scaling group.
   *
   * This name must be unique per Region per account.
   *
   * Default: - Auto generated by CloudFormation
   *
   * @param autoScalingGroupName The name of the Auto Scaling group. 
   */
  public fun autoScalingGroupName(autoScalingGroupName: String) {
    cdkBuilder.autoScalingGroupName(autoScalingGroupName)
  }

  /**
   * Specifies how block devices are exposed to the instance. You can specify virtual devices and
   * EBS volumes.
   *
   * Each instance that is launched has an associated root device volume,
   * either an Amazon EBS volume or an instance store volume.
   * You can use block device mappings to specify additional EBS volumes or
   * instance store volumes to attach to an instance when it is launched.
   *
   * `launchTemplate` and `mixedInstancesPolicy` must not be specified when this property is
   * specified
   *
   * Default: - Uses the block device mapping of the AMI
   *
   * [Documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
   * @param blockDevices Specifies how block devices are exposed to the instance. You can specify
   * virtual devices and EBS volumes. 
   */
  public fun blockDevices(blockDevices: BlockDeviceDsl.() -> Unit) {
    _blockDevices.add(BlockDeviceDsl().apply(blockDevices).build())
  }

  /**
   * Specifies how block devices are exposed to the instance. You can specify virtual devices and
   * EBS volumes.
   *
   * Each instance that is launched has an associated root device volume,
   * either an Amazon EBS volume or an instance store volume.
   * You can use block device mappings to specify additional EBS volumes or
   * instance store volumes to attach to an instance when it is launched.
   *
   * `launchTemplate` and `mixedInstancesPolicy` must not be specified when this property is
   * specified
   *
   * Default: - Uses the block device mapping of the AMI
   *
   * [Documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
   * @param blockDevices Specifies how block devices are exposed to the instance. You can specify
   * virtual devices and EBS volumes. 
   */
  public fun blockDevices(blockDevices: Collection<BlockDevice>) {
    _blockDevices.addAll(blockDevices)
  }

  /**
   * Indicates whether Capacity Rebalancing is enabled.
   *
   * When you turn on Capacity Rebalancing, Amazon EC2 Auto Scaling
   * attempts to launch a Spot Instance whenever Amazon EC2 notifies that a Spot Instance is at an
   * elevated risk of
   * interruption. After launching a new instance, it then terminates an old instance.
   *
   * Default: false
   *
   * [Documentation](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-capacityrebalance)
   * @param capacityRebalance Indicates whether Capacity Rebalancing is enabled. 
   */
  public fun capacityRebalance(capacityRebalance: Boolean) {
    cdkBuilder.capacityRebalance(capacityRebalance)
  }

  /**
   * Default scaling cooldown for this AutoScalingGroup.
   *
   * Default: Duration.minutes(5)
   *
   * @param cooldown Default scaling cooldown for this AutoScalingGroup. 
   */
  public fun cooldown(cooldown: Duration) {
    cdkBuilder.cooldown(cooldown)
  }

  /**
   * The amount of time, in seconds, until a newly launched instance can contribute to the Amazon
   * CloudWatch metrics.
   *
   * This delay lets an instance finish initializing before Amazon EC2 Auto Scaling aggregates
   * instance metrics,
   * resulting in more reliable usage data. Set this value equal to the amount of time that it takes
   * for resource
   * consumption to become stable after an instance reaches the InService state.
   *
   * To optimize the performance of scaling policies that scale continuously, such as target
   * tracking and
   * step scaling policies, we strongly recommend that you enable the default instance warmup, even
   * if its value is set to 0 seconds
   *
   * Default instance warmup will not be added if no value is specified
   *
   * Default: None
   *
   * [Documentation](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-default-instance-warmup.html)
   * @param defaultInstanceWarmup The amount of time, in seconds, until a newly launched instance
   * can contribute to the Amazon CloudWatch metrics. 
   */
  public fun defaultInstanceWarmup(defaultInstanceWarmup: Duration) {
    cdkBuilder.defaultInstanceWarmup(defaultInstanceWarmup)
  }

  /**
   * Initial amount of instances in the fleet.
   *
   * If this is set to a number, every deployment will reset the amount of
   * instances to this number. It is recommended to leave this value blank.
   *
   * Default: minCapacity, and leave unchanged during deployment
   *
   * [Documentation](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-desiredcapacity)
   * @param desiredCapacity Initial amount of instances in the fleet. 
   */
  public fun desiredCapacity(desiredCapacity: Number) {
    cdkBuilder.desiredCapacity(desiredCapacity)
  }

  /**
   * Enable monitoring for group metrics, these metrics describe the group rather than any of its
   * instances.
   *
   * To report all group metrics use `GroupMetrics.all()`
   * Group metrics are reported in a granularity of 1 minute at no additional charge.
   *
   * Default: - no group metrics will be reported
   *
   * @param groupMetrics Enable monitoring for group metrics, these metrics describe the group
   * rather than any of its instances. 
   */
  public fun groupMetrics(vararg groupMetrics: GroupMetrics) {
    _groupMetrics.addAll(listOf(*groupMetrics))
  }

  /**
   * Enable monitoring for group metrics, these metrics describe the group rather than any of its
   * instances.
   *
   * To report all group metrics use `GroupMetrics.all()`
   * Group metrics are reported in a granularity of 1 minute at no additional charge.
   *
   * Default: - no group metrics will be reported
   *
   * @param groupMetrics Enable monitoring for group metrics, these metrics describe the group
   * rather than any of its instances. 
   */
  public fun groupMetrics(groupMetrics: Collection<GroupMetrics>) {
    _groupMetrics.addAll(groupMetrics)
  }

  /**
   * Configuration for health checks.
   *
   * Default: - HealthCheck.ec2 with no grace period
   *
   * @param healthCheck Configuration for health checks. 
   */
  public fun healthCheck(healthCheck: HealthCheck) {
    cdkBuilder.healthCheck(healthCheck)
  }

  /**
   * If the ASG has scheduled actions, don't reset unchanged group sizes.
   *
   * Only used if the ASG has scheduled actions (which may scale your ASG up
   * or down regardless of cdk deployments). If true, the size of the group
   * will only be reset if it has been changed in the CDK app. If false, the
   * sizes will always be changed back to what they were in the CDK app
   * on deployment.
   *
   * Default: true
   *
   * @param ignoreUnmodifiedSizeProperties If the ASG has scheduled actions, don't reset unchanged
   * group sizes. 
   */
  public fun ignoreUnmodifiedSizeProperties(ignoreUnmodifiedSizeProperties: Boolean) {
    cdkBuilder.ignoreUnmodifiedSizeProperties(ignoreUnmodifiedSizeProperties)
  }

  /**
   * Apply the given CloudFormation Init configuration to the instances in the AutoScalingGroup at
   * startup.
   *
   * If you specify `init`, you must also specify `signals` to configure
   * the number of instances to wait for and the timeout for waiting for the
   * init process.
   *
   * Default: - no CloudFormation init
   *
   * @param init Apply the given CloudFormation Init configuration to the instances in the
   * AutoScalingGroup at startup. 
   */
  public fun `init`(`init`: CloudFormationInit) {
    cdkBuilder.`init`(`init`)
  }

  /**
   * Use the given options for applying CloudFormation Init.
   *
   * Describes the configsets to use and the timeout to wait
   *
   * Default: - default options
   *
   * @param initOptions Use the given options for applying CloudFormation Init. 
   */
  public fun initOptions(initOptions: ApplyCloudFormationInitOptionsDsl.() -> Unit = {}) {
    val builder = ApplyCloudFormationInitOptionsDsl()
    builder.apply(initOptions)
    cdkBuilder.initOptions(builder.build())
  }

  /**
   * Use the given options for applying CloudFormation Init.
   *
   * Describes the configsets to use and the timeout to wait
   *
   * Default: - default options
   *
   * @param initOptions Use the given options for applying CloudFormation Init. 
   */
  public fun initOptions(initOptions: ApplyCloudFormationInitOptions) {
    cdkBuilder.initOptions(initOptions)
  }

  /**
   * Controls whether instances in this group are launched with detailed or basic monitoring.
   *
   * When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your
   * account
   * is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5
   * minutes.
   *
   * `launchTemplate` and `mixedInstancesPolicy` must not be specified when this property is
   * specified
   *
   * Default: - Monitoring.DETAILED
   *
   * [Documentation](https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics)
   * @param instanceMonitoring Controls whether instances in this group are launched with detailed
   * or basic monitoring. 
   */
  public fun instanceMonitoring(instanceMonitoring: Monitoring) {
    cdkBuilder.instanceMonitoring(instanceMonitoring)
  }

  /**
   * Type of instance to launch.
   *
   * `launchTemplate` and `mixedInstancesPolicy` must not be specified when this property is
   * specified
   *
   * Default: - Do not provide any instance type
   *
   * @param instanceType Type of instance to launch. 
   */
  public fun instanceType(instanceType: InstanceType) {
    cdkBuilder.instanceType(instanceType)
  }

  /**
   * Name of SSH keypair to grant access to instances.
   *
   * `launchTemplate` and `mixedInstancesPolicy` must not be specified when this property is
   * specified
   *
   * Default: - No SSH access will be possible.
   *
   * @param keyName Name of SSH keypair to grant access to instances. 
   */
  public fun keyName(keyName: String) {
    cdkBuilder.keyName(keyName)
  }

  /**
   * Launch template to use.
   *
   * Launch configuration related settings and MixedInstancesPolicy must not be specified when a
   * launch template is specified.
   *
   * Default: - Do not provide any launch template
   *
   * @param launchTemplate Launch template to use. 
   */
  public fun launchTemplate(launchTemplate: ILaunchTemplate) {
    cdkBuilder.launchTemplate(launchTemplate)
  }

  /**
   * AMI to launch.
   *
   * `launchTemplate` and `mixedInstancesPolicy` must not be specified when this property is
   * specified
   *
   * Default: - Do not provide any machine image
   *
   * @param machineImage AMI to launch. 
   */
  public fun machineImage(machineImage: IMachineImage) {
    cdkBuilder.machineImage(machineImage)
  }

  /**
   * Maximum number of instances in the fleet.
   *
   * Default: desiredCapacity
   *
   * @param maxCapacity Maximum number of instances in the fleet. 
   */
  public fun maxCapacity(maxCapacity: Number) {
    cdkBuilder.maxCapacity(maxCapacity)
  }

  /**
   * The maximum amount of time that an instance can be in service.
   *
   * The maximum duration applies
   * to all current and future instances in the group. As an instance approaches its maximum
   * duration,
   * it is terminated and replaced, and cannot be used again.
   *
   * You must specify a value of at least 604,800 seconds (7 days). To clear a previously set value,
   * leave this property undefined.
   *
   * Default: none
   *
   * [Documentation](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html)
   * @param maxInstanceLifetime The maximum amount of time that an instance can be in service. 
   */
  public fun maxInstanceLifetime(maxInstanceLifetime: Duration) {
    cdkBuilder.maxInstanceLifetime(maxInstanceLifetime)
  }

  /**
   * Minimum number of instances in the fleet.
   *
   * Default: 1
   *
   * @param minCapacity Minimum number of instances in the fleet. 
   */
  public fun minCapacity(minCapacity: Number) {
    cdkBuilder.minCapacity(minCapacity)
  }

  /**
   * Mixed Instances Policy to use.
   *
   * Launch configuration related settings and Launch Template  must not be specified when a
   * MixedInstancesPolicy is specified.
   *
   * Default: - Do not provide any MixedInstancesPolicy
   *
   * @param mixedInstancesPolicy Mixed Instances Policy to use. 
   */
  public fun mixedInstancesPolicy(mixedInstancesPolicy: MixedInstancesPolicyDsl.() -> Unit = {}) {
    val builder = MixedInstancesPolicyDsl()
    builder.apply(mixedInstancesPolicy)
    cdkBuilder.mixedInstancesPolicy(builder.build())
  }

  /**
   * Mixed Instances Policy to use.
   *
   * Launch configuration related settings and Launch Template  must not be specified when a
   * MixedInstancesPolicy is specified.
   *
   * Default: - Do not provide any MixedInstancesPolicy
   *
   * @param mixedInstancesPolicy Mixed Instances Policy to use. 
   */
  public fun mixedInstancesPolicy(mixedInstancesPolicy: MixedInstancesPolicy) {
    cdkBuilder.mixedInstancesPolicy(mixedInstancesPolicy)
  }

  /**
   * Whether newly-launched instances are protected from termination by Amazon EC2 Auto Scaling when
   * scaling in.
   *
   * By default, Auto Scaling can terminate an instance at any time after launch
   * when scaling in an Auto Scaling Group, subject to the group's termination
   * policy. However, you may wish to protect newly-launched instances from
   * being scaled in if they are going to run critical applications that should
   * not be prematurely terminated.
   *
   * This flag must be enabled if the Auto Scaling Group will be associated with
   * an ECS Capacity Provider with managed termination protection.
   *
   * Default: false
   *
   * @param newInstancesProtectedFromScaleIn Whether newly-launched instances are protected from
   * termination by Amazon EC2 Auto Scaling when scaling in. 
   */
  public fun newInstancesProtectedFromScaleIn(newInstancesProtectedFromScaleIn: Boolean) {
    cdkBuilder.newInstancesProtectedFromScaleIn(newInstancesProtectedFromScaleIn)
  }

  /**
   * Configure autoscaling group to send notifications about fleet changes to an SNS topic(s).
   *
   * Default: - No fleet change notifications will be sent.
   *
   * [Documentation](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations)
   * @param notifications Configure autoscaling group to send notifications about fleet changes to
   * an SNS topic(s). 
   */
  public fun notifications(notifications: NotificationConfigurationDsl.() -> Unit) {
    _notifications.add(NotificationConfigurationDsl().apply(notifications).build())
  }

  /**
   * Configure autoscaling group to send notifications about fleet changes to an SNS topic(s).
   *
   * Default: - No fleet change notifications will be sent.
   *
   * [Documentation](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations)
   * @param notifications Configure autoscaling group to send notifications about fleet changes to
   * an SNS topic(s). 
   */
  public fun notifications(notifications: Collection<NotificationConfiguration>) {
    _notifications.addAll(notifications)
  }

  /**
   * Whether IMDSv2 should be required on launched instances.
   *
   * Default: false
   *
   * @param requireImdsv2 Whether IMDSv2 should be required on launched instances. 
   */
  public fun requireImdsv2(requireImdsv2: Boolean) {
    cdkBuilder.requireImdsv2(requireImdsv2)
  }

  /**
   * An IAM role to associate with the instance profile assigned to this Auto Scaling Group.
   *
   * The role must be assumable by the service principal `ec2.amazonaws.com`:
   *
   * `launchTemplate` and `mixedInstancesPolicy` must not be specified when this property is
   * specified
   *
   * Default: A role will automatically be created, it can be accessed via the `role` property
   *
   * Example:
   *
   * ```
   * Role role = Role.Builder.create(this, "MyRole")
   * .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
   * .build();
   * ```
   *
   * @param role An IAM role to associate with the instance profile assigned to this Auto Scaling
   * Group. 
   */
  public fun role(role: IRole) {
    cdkBuilder.role(role)
  }

  /**
   * Security group to launch the instances in.
   *
   * `launchTemplate` and `mixedInstancesPolicy` must not be specified when this property is
   * specified
   *
   * Default: - A SecurityGroup will be created if none is specified.
   *
   * @param securityGroup Security group to launch the instances in. 
   */
  public fun securityGroup(securityGroup: ISecurityGroup) {
    cdkBuilder.securityGroup(securityGroup)
  }

  /**
   * Configure waiting for signals during deployment.
   *
   * Use this to pause the CloudFormation deployment to wait for the instances
   * in the AutoScalingGroup to report successful startup during
   * creation and updates. The UserData script needs to invoke `cfn-signal`
   * with a success or failure code after it is done setting up the instance.
   *
   * Without waiting for signals, the CloudFormation deployment will proceed as
   * soon as the AutoScalingGroup has been created or updated but before the
   * instances in the group have been started.
   *
   * For example, to have instances wait for an Elastic Load Balancing health check before
   * they signal success, add a health-check verification by using the
   * cfn-init helper script. For an example, see the verify_instance_health
   * command in the Auto Scaling rolling updates sample template:
   *
   * https://github.com/awslabs/aws-cloudformation-templates/blob/master/aws/services/AutoScaling/AutoScalingRollingUpdates.yaml
   *
   * Default: - Do not wait for signals
   *
   * @param signals Configure waiting for signals during deployment. 
   */
  public fun signals(signals: Signals) {
    cdkBuilder.signals(signals)
  }

  /**
   * The maximum hourly price (in USD) to be paid for any Spot Instance launched to fulfill the
   * request.
   *
   * Spot Instances are
   * launched when the price you specify exceeds the current Spot market price.
   *
   * `launchTemplate` and `mixedInstancesPolicy` must not be specified when this property is
   * specified
   *
   * Default: none
   *
   * @param spotPrice The maximum hourly price (in USD) to be paid for any Spot Instance launched to
   * fulfill the request. 
   */
  public fun spotPrice(spotPrice: String) {
    cdkBuilder.spotPrice(spotPrice)
  }

  /**
   * Add SSM session permissions to the instance role.
   *
   * Setting this to `true` adds the necessary permissions to connect
   * to the instance using SSM Session Manager. You can do this
   * from the AWS Console.
   *
   * NOTE: Setting this flag to `true` may not be enough by itself.
   * You must also use an AMI that comes with the SSM Agent, or install
   * the SSM Agent yourself. See
   * [Working with SSM
   * Agent](https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-agent.html)
   * in the SSM Developer Guide.
   *
   * Default: false
   *
   * @param ssmSessionPermissions Add SSM session permissions to the instance role. 
   */
  public fun ssmSessionPermissions(ssmSessionPermissions: Boolean) {
    cdkBuilder.ssmSessionPermissions(ssmSessionPermissions)
  }

  /**
   * A policy or a list of policies that are used to select the instances to terminate.
   *
   * The policies are executed in the order that you list them.
   *
   * Default: - `TerminationPolicy.DEFAULT`
   *
   * [Documentation](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html)
   * @param terminationPolicies A policy or a list of policies that are used to select the instances
   * to terminate. 
   */
  public fun terminationPolicies(vararg terminationPolicies: TerminationPolicy) {
    _terminationPolicies.addAll(listOf(*terminationPolicies))
  }

  /**
   * A policy or a list of policies that are used to select the instances to terminate.
   *
   * The policies are executed in the order that you list them.
   *
   * Default: - `TerminationPolicy.DEFAULT`
   *
   * [Documentation](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html)
   * @param terminationPolicies A policy or a list of policies that are used to select the instances
   * to terminate. 
   */
  public fun terminationPolicies(terminationPolicies: Collection<TerminationPolicy>) {
    _terminationPolicies.addAll(terminationPolicies)
  }

  /**
   * What to do when an AutoScalingGroup's instance configuration is changed.
   *
   * This is applied when any of the settings on the ASG are changed that
   * affect how the instances should be created (VPC, instance type, startup
   * scripts, etc.). It indicates how the existing instances should be
   * replaced with new instances matching the new config. By default, nothing
   * is done and only new instances are launched with the new config.
   *
   * Default: - `UpdatePolicy.rollingUpdate()` if using `init`, `UpdatePolicy.none()` otherwise
   *
   * @param updatePolicy What to do when an AutoScalingGroup's instance configuration is changed. 
   */
  public fun updatePolicy(updatePolicy: UpdatePolicy) {
    cdkBuilder.updatePolicy(updatePolicy)
  }

  /**
   * Specific UserData to use.
   *
   * The UserData may still be mutated after creation.
   *
   * `launchTemplate` and `mixedInstancesPolicy` must not be specified when this property is
   * specified
   *
   * Default: - A UserData object appropriate for the MachineImage's
   * Operating System is created.
   *
   * @param userData Specific UserData to use. 
   */
  public fun userData(userData: UserData) {
    cdkBuilder.userData(userData)
  }

  /**
   * VPC to launch these instances in.
   *
   * @param vpc VPC to launch these instances in. 
   */
  public fun vpc(vpc: IVpc) {
    cdkBuilder.vpc(vpc)
  }

  /**
   * Where to place instances within the VPC.
   *
   * Default: - All Private subnets.
   *
   * @param vpcSubnets Where to place instances within the VPC. 
   */
  public fun vpcSubnets(vpcSubnets: SubnetSelectionDsl.() -> Unit = {}) {
    val builder = SubnetSelectionDsl()
    builder.apply(vpcSubnets)
    cdkBuilder.vpcSubnets(builder.build())
  }

  /**
   * Where to place instances within the VPC.
   *
   * Default: - All Private subnets.
   *
   * @param vpcSubnets Where to place instances within the VPC. 
   */
  public fun vpcSubnets(vpcSubnets: SubnetSelection) {
    cdkBuilder.vpcSubnets(vpcSubnets)
  }

  public fun build(): AutoScalingGroup {
    if(_blockDevices.isNotEmpty()) cdkBuilder.blockDevices(_blockDevices)
    if(_groupMetrics.isNotEmpty()) cdkBuilder.groupMetrics(_groupMetrics)
    if(_notifications.isNotEmpty()) cdkBuilder.notifications(_notifications)
    if(_terminationPolicies.isNotEmpty()) cdkBuilder.terminationPolicies(_terminationPolicies)
    return cdkBuilder.build()
  }
}
