@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.cloudfront.origins

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.Boolean
import kotlin.Number
import kotlin.String
import kotlin.collections.Map
import software.amazon.awscdk.Duration
import software.amazon.awscdk.services.cloudfront.IOriginAccessIdentity
import software.amazon.awscdk.services.cloudfront.origins.S3Origin
import software.amazon.awscdk.services.s3.IBucket

/**
 * An Origin that is backed by an S3 bucket.
 *
 * If the bucket is configured for website hosting, this origin will be configured to use the bucket
 * as an
 * HTTP server origin and will use the bucket's configured website redirects and error handling.
 * Otherwise,
 * the origin is created as a bucket origin and will use CloudFront's redirect and error handling.
 *
 * Example:
 *
 * ```
 * // Adding an existing Lambda&#64;Edge function created in a different stack
 * // to a CloudFront distribution.
 * Bucket s3Bucket;
 * IVersion functionVersion = Version.fromVersionArn(this, "Version",
 * "arn:aws:lambda:us-east-1:123456789012:function:functionName:1");
 * Distribution.Builder.create(this, "distro")
 * .defaultBehavior(BehaviorOptions.builder()
 * .origin(new S3Origin(s3Bucket))
 * .edgeLambdas(List.of(EdgeLambda.builder()
 * .functionVersion(functionVersion)
 * .eventType(LambdaEdgeEventType.VIEWER_REQUEST)
 * .build()))
 * .build())
 * .build();
 * ```
 */
@CdkDslMarker
public class S3OriginDsl(
  bucket: IBucket,
) {
  private val cdkBuilder: S3Origin.Builder = S3Origin.Builder.create(bucket)

  /**
   * The number of times that CloudFront attempts to connect to the origin;
   *
   * valid values are 1, 2, or 3 attempts.
   *
   * Default: 3
   *
   * @param connectionAttempts The number of times that CloudFront attempts to connect to the
   * origin;. 
   */
  public fun connectionAttempts(connectionAttempts: Number) {
    cdkBuilder.connectionAttempts(connectionAttempts)
  }

  /**
   * The number of seconds that CloudFront waits when trying to establish a connection to the
   * origin.
   *
   * Valid values are 1-10 seconds, inclusive.
   *
   * Default: Duration.seconds(10)
   *
   * @param connectionTimeout The number of seconds that CloudFront waits when trying to establish a
   * connection to the origin. 
   */
  public fun connectionTimeout(connectionTimeout: Duration) {
    cdkBuilder.connectionTimeout(connectionTimeout)
  }

  /**
   * A list of HTTP header names and values that CloudFront adds to requests it sends to the origin.
   *
   * Default: {}
   *
   * @param customHeaders A list of HTTP header names and values that CloudFront adds to requests it
   * sends to the origin. 
   */
  public fun customHeaders(customHeaders: Map<String, String>) {
    cdkBuilder.customHeaders(customHeaders)
  }

  /**
   * An optional Origin Access Identity of the origin identity cloudfront will use when calling your
   * s3 bucket.
   *
   * Default: - An Origin Access Identity will be created.
   *
   * @param originAccessIdentity An optional Origin Access Identity of the origin identity
   * cloudfront will use when calling your s3 bucket. 
   */
  public fun originAccessIdentity(originAccessIdentity: IOriginAccessIdentity) {
    cdkBuilder.originAccessIdentity(originAccessIdentity)
  }

  /**
   * A unique identifier for the origin.
   *
   * This value must be unique within the distribution.
   *
   * Default: - an originid will be generated for you
   *
   * @param originId A unique identifier for the origin. 
   */
  public fun originId(originId: String) {
    cdkBuilder.originId(originId)
  }

  /**
   * An optional path that CloudFront appends to the origin domain name when CloudFront requests
   * content from the origin.
   *
   * Must begin, but not end, with '/' (e.g., '/production/images').
   *
   * Default: '/'
   *
   * @param originPath An optional path that CloudFront appends to the origin domain name when
   * CloudFront requests content from the origin. 
   */
  public fun originPath(originPath: String) {
    cdkBuilder.originPath(originPath)
  }

  /**
   * Origin Shield is enabled by setting originShieldRegion to a valid region, after this to disable
   * Origin Shield again you must set this flag to false.
   *
   * Default: - true
   *
   * @param originShieldEnabled Origin Shield is enabled by setting originShieldRegion to a valid
   * region, after this to disable Origin Shield again you must set this flag to false. 
   */
  public fun originShieldEnabled(originShieldEnabled: Boolean) {
    cdkBuilder.originShieldEnabled(originShieldEnabled)
  }

  /**
   * When you enable Origin Shield in the AWS Region that has the lowest latency to your origin, you
   * can get better network performance.
   *
   * Default: - origin shield not enabled
   *
   * [Documentation](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html)
   * @param originShieldRegion When you enable Origin Shield in the AWS Region that has the lowest
   * latency to your origin, you can get better network performance. 
   */
  public fun originShieldRegion(originShieldRegion: String) {
    cdkBuilder.originShieldRegion(originShieldRegion)
  }

  public fun build(): S3Origin = cdkBuilder.build()
}
