@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.codedeploy

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.services.codedeploy.ServerApplication
import software.constructs.Construct

/**
 * A CodeDeploy Application that deploys to EC2/on-premise instances.
 *
 * Example:
 *
 * ```
 * ServerApplication application = ServerApplication.Builder.create(this, "CodeDeployApplication")
 * .applicationName("MyApplication")
 * .build();
 * ```
 */
@CdkDslMarker
public class ServerApplicationDsl(
  scope: Construct,
  id: String,
) {
  private val cdkBuilder: ServerApplication.Builder = ServerApplication.Builder.create(scope, id)

  /**
   * The physical, human-readable name of the CodeDeploy Application.
   *
   * Default: an auto-generated name will be used
   *
   * @param applicationName The physical, human-readable name of the CodeDeploy Application. 
   */
  public fun applicationName(applicationName: String) {
    cdkBuilder.applicationName(applicationName)
  }

  public fun build(): ServerApplication = cdkBuilder.build()
}
