@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.cognito

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.Number
import kotlin.String
import software.amazon.awscdk.services.cognito.CfnUserPoolGroupProps

/**
 * Properties for defining a `CfnUserPoolGroup`.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * CfnUserPoolGroupProps cfnUserPoolGroupProps = CfnUserPoolGroupProps.builder()
 * .userPoolId("userPoolId")
 * // the properties below are optional
 * .description("description")
 * .groupName("groupName")
 * .precedence(123)
 * .roleArn("roleArn")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cognito-userpoolgroup.html)
 */
@CdkDslMarker
public class CfnUserPoolGroupPropsDsl {
  private val cdkBuilder: CfnUserPoolGroupProps.Builder = CfnUserPoolGroupProps.builder()

  /**
   * @param description A string containing the description of the group.
   */
  public fun description(description: String) {
    cdkBuilder.description(description)
  }

  /**
   * @param groupName The name of the group.
   * Must be unique.
   */
  public fun groupName(groupName: String) {
    cdkBuilder.groupName(groupName)
  }

  /**
   * @param precedence A non-negative integer value that specifies the precedence of this group
   * relative to the other groups that a user can belong to in the user pool.
   * Zero is the highest precedence value. Groups with lower `Precedence` values take precedence
   * over groups with higher or null `Precedence` values. If a user belongs to two or more groups, it
   * is the group with the lowest precedence value whose role ARN is given in the user's tokens for the
   * `cognito:roles` and `cognito:preferred_role` claims.
   *
   * Two groups can have the same `Precedence` value. If this happens, neither group takes
   * precedence over the other. If two groups with the same `Precedence` have the same role ARN, that
   * role is used in the `cognito:preferred_role` claim in tokens for users in each group. If the two
   * groups have different role ARNs, the `cognito:preferred_role` claim isn't set in users' tokens.
   *
   * The default `Precedence` value is null. The maximum `Precedence` value is `2^31-1` .
   */
  public fun precedence(precedence: Number) {
    cdkBuilder.precedence(precedence)
  }

  /**
   * @param roleArn The role Amazon Resource Name (ARN) for the group.
   */
  public fun roleArn(roleArn: String) {
    cdkBuilder.roleArn(roleArn)
  }

  /**
   * @param userPoolId The user pool ID for the user pool. 
   */
  public fun userPoolId(userPoolId: String) {
    cdkBuilder.userPoolId(userPoolId)
  }

  public fun build(): CfnUserPoolGroupProps = cdkBuilder.build()
}
