@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.cognito

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.Boolean
import kotlin.Number
import software.amazon.awscdk.Duration
import software.amazon.awscdk.services.cognito.PasswordPolicy

/**
 * Password policy for User Pools.
 *
 * Example:
 *
 * ```
 * UserPool.Builder.create(this, "myuserpool")
 * // ...
 * .passwordPolicy(PasswordPolicy.builder()
 * .minLength(12)
 * .requireLowercase(true)
 * .requireUppercase(true)
 * .requireDigits(true)
 * .requireSymbols(true)
 * .tempPasswordValidity(Duration.days(3))
 * .build())
 * .build();
 * ```
 */
@CdkDslMarker
public class PasswordPolicyDsl {
  private val cdkBuilder: PasswordPolicy.Builder = PasswordPolicy.builder()

  /**
   * @param minLength Minimum length required for a user's password.
   */
  public fun minLength(minLength: Number) {
    cdkBuilder.minLength(minLength)
  }

  /**
   * @param requireDigits Whether the user is required to have digits in their password.
   */
  public fun requireDigits(requireDigits: Boolean) {
    cdkBuilder.requireDigits(requireDigits)
  }

  /**
   * @param requireLowercase Whether the user is required to have lowercase characters in their
   * password.
   */
  public fun requireLowercase(requireLowercase: Boolean) {
    cdkBuilder.requireLowercase(requireLowercase)
  }

  /**
   * @param requireSymbols Whether the user is required to have symbols in their password.
   */
  public fun requireSymbols(requireSymbols: Boolean) {
    cdkBuilder.requireSymbols(requireSymbols)
  }

  /**
   * @param requireUppercase Whether the user is required to have uppercase characters in their
   * password.
   */
  public fun requireUppercase(requireUppercase: Boolean) {
    cdkBuilder.requireUppercase(requireUppercase)
  }

  /**
   * @param tempPasswordValidity The length of time the temporary password generated by an admin is
   * valid.
   * This must be provided as whole days, like Duration.days(3) or Duration.hours(48).
   * Fractional days, such as Duration.hours(20), will generate an error.
   */
  public fun tempPasswordValidity(tempPasswordValidity: Duration) {
    cdkBuilder.tempPasswordValidity(tempPasswordValidity)
  }

  public fun build(): PasswordPolicy = cdkBuilder.build()
}
