@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.config

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.services.config.CfnDeliveryChannel

/**
 * Provides options for how often AWS Config delivers configuration snapshots to the Amazon S3
 * bucket in your delivery channel.
 *
 *
 * If you want to create a rule that triggers evaluations for your resources when AWS Config
 * delivers the configuration snapshot, see the following:
 *
 *
 * The frequency for a rule that triggers evaluations for your resources when AWS Config delivers
 * the configuration snapshot is set by one of two values, depending on which is less frequent:
 *
 * * The value for the `deliveryFrequency` parameter within the delivery channel configuration,
 * which sets how often AWS Config delivers configuration snapshots. This value also sets how often AWS
 * Config invokes evaluations for AWS Config rules.
 * * The value for the `MaximumExecutionFrequency` parameter, which sets the maximum frequency with
 * which AWS Config invokes evaluations for the rule. For more information, see
 * [ConfigRule](https://docs.aws.amazon.com/config/latest/APIReference/API_ConfigRule.html) .
 *
 * If the `deliveryFrequency` value is less frequent than the `MaximumExecutionFrequency` value for
 * a rule, AWS Config invokes the rule only as often as the `deliveryFrequency` value.
 *
 * * For example, you want your rule to run evaluations when AWS Config delivers the configuration
 * snapshot.
 * * You specify the `MaximumExecutionFrequency` value for `Six_Hours` .
 * * You then specify the delivery channel `deliveryFrequency` value for `TwentyFour_Hours` .
 * * Because the value for `deliveryFrequency` is less frequent than `MaximumExecutionFrequency` ,
 * AWS Config invokes evaluations for the rule every 24 hours.
 *
 * You should set the `MaximumExecutionFrequency` value to be at least as frequent as the
 * `deliveryFrequency` value. You can view the `deliveryFrequency` value by using the
 * `DescribeDeliveryChannnels` action.
 *
 * To update the `deliveryFrequency` with which AWS Config delivers your configuration snapshots,
 * use the `PutDeliveryChannel` action.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * ConfigSnapshotDeliveryPropertiesProperty configSnapshotDeliveryPropertiesProperty =
 * ConfigSnapshotDeliveryPropertiesProperty.builder()
 * .deliveryFrequency("deliveryFrequency")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-config-deliverychannel-configsnapshotdeliveryproperties.html)
 */
@CdkDslMarker
public class CfnDeliveryChannelConfigSnapshotDeliveryPropertiesPropertyDsl {
  private val cdkBuilder: CfnDeliveryChannel.ConfigSnapshotDeliveryPropertiesProperty.Builder =
      CfnDeliveryChannel.ConfigSnapshotDeliveryPropertiesProperty.builder()

  /**
   * @param deliveryFrequency The frequency with which AWS Config delivers configuration snapshots.
   */
  public fun deliveryFrequency(deliveryFrequency: String) {
    cdkBuilder.deliveryFrequency(deliveryFrequency)
  }

  public fun build(): CfnDeliveryChannel.ConfigSnapshotDeliveryPropertiesProperty =
      cdkBuilder.build()
}
