@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.databrew

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.IResolvable
import software.amazon.awscdk.services.databrew.CfnJob

/**
 * Represents a JDBC database output object which defines the output destination for a DataBrew
 * recipe job to write into.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.databrew.*;
 * DatabaseOutputProperty databaseOutputProperty = DatabaseOutputProperty.builder()
 * .databaseOptions(DatabaseTableOutputOptionsProperty.builder()
 * .tableName("tableName")
 * // the properties below are optional
 * .tempDirectory(S3LocationProperty.builder()
 * .bucket("bucket")
 * // the properties below are optional
 * .bucketOwner("bucketOwner")
 * .key("key")
 * .build())
 * .build())
 * .glueConnectionName("glueConnectionName")
 * // the properties below are optional
 * .databaseOutputMode("databaseOutputMode")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databaseoutput.html)
 */
@CdkDslMarker
public class CfnJobDatabaseOutputPropertyDsl {
  private val cdkBuilder: CfnJob.DatabaseOutputProperty.Builder =
      CfnJob.DatabaseOutputProperty.builder()

  /**
   * @param databaseOptions Represents options that specify how and where DataBrew writes the
   * database output generated by recipe jobs. 
   */
  public fun databaseOptions(databaseOptions: IResolvable) {
    cdkBuilder.databaseOptions(databaseOptions)
  }

  /**
   * @param databaseOptions Represents options that specify how and where DataBrew writes the
   * database output generated by recipe jobs. 
   */
  public fun databaseOptions(databaseOptions: CfnJob.DatabaseTableOutputOptionsProperty) {
    cdkBuilder.databaseOptions(databaseOptions)
  }

  /**
   * @param databaseOutputMode The output mode to write into the database.
   * Currently supported option: NEW_TABLE.
   */
  public fun databaseOutputMode(databaseOutputMode: String) {
    cdkBuilder.databaseOutputMode(databaseOutputMode)
  }

  /**
   * @param glueConnectionName The AWS Glue connection that stores the connection information for
   * the target database. 
   */
  public fun glueConnectionName(glueConnectionName: String) {
    cdkBuilder.glueConnectionName(glueConnectionName)
  }

  public fun build(): CfnJob.DatabaseOutputProperty = cdkBuilder.build()
}
