@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.databrew

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.IResolvable
import software.amazon.awscdk.services.databrew.CfnJob

/**
 * Represents options that specify how and where DataBrew writes the database output generated by
 * recipe jobs.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.databrew.*;
 * DatabaseTableOutputOptionsProperty databaseTableOutputOptionsProperty =
 * DatabaseTableOutputOptionsProperty.builder()
 * .tableName("tableName")
 * // the properties below are optional
 * .tempDirectory(S3LocationProperty.builder()
 * .bucket("bucket")
 * // the properties below are optional
 * .bucketOwner("bucketOwner")
 * .key("key")
 * .build())
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-databasetableoutputoptions.html)
 */
@CdkDslMarker
public class CfnJobDatabaseTableOutputOptionsPropertyDsl {
  private val cdkBuilder: CfnJob.DatabaseTableOutputOptionsProperty.Builder =
      CfnJob.DatabaseTableOutputOptionsProperty.builder()

  /**
   * @param tableName A prefix for the name of a table DataBrew will create in the database. 
   */
  public fun tableName(tableName: String) {
    cdkBuilder.tableName(tableName)
  }

  /**
   * @param tempDirectory Represents an Amazon S3 location (bucket name and object key) where
   * DataBrew can store intermediate results.
   */
  public fun tempDirectory(tempDirectory: IResolvable) {
    cdkBuilder.tempDirectory(tempDirectory)
  }

  /**
   * @param tempDirectory Represents an Amazon S3 location (bucket name and object key) where
   * DataBrew can store intermediate results.
   */
  public fun tempDirectory(tempDirectory: CfnJob.S3LocationProperty) {
    cdkBuilder.tempDirectory(tempDirectory)
  }

  public fun build(): CfnJob.DatabaseTableOutputOptionsProperty = cdkBuilder.build()
}
