@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.databrew

import cloudshift.awscdk.common.CdkDslMarker
import software.amazon.awscdk.IResolvable
import software.amazon.awscdk.services.databrew.CfnJob

/**
 * Represents options that specify how and where DataBrew writes the Amazon S3 output generated by
 * recipe jobs.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.databrew.*;
 * S3TableOutputOptionsProperty s3TableOutputOptionsProperty =
 * S3TableOutputOptionsProperty.builder()
 * .location(S3LocationProperty.builder()
 * .bucket("bucket")
 * // the properties below are optional
 * .bucketOwner("bucketOwner")
 * .key("key")
 * .build())
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3tableoutputoptions.html)
 */
@CdkDslMarker
public class CfnJobS3TableOutputOptionsPropertyDsl {
  private val cdkBuilder: CfnJob.S3TableOutputOptionsProperty.Builder =
      CfnJob.S3TableOutputOptionsProperty.builder()

  /**
   * @param location Represents an Amazon S3 location (bucket name and object key) where DataBrew
   * can write output from a job. 
   */
  public fun location(location: IResolvable) {
    cdkBuilder.location(location)
  }

  /**
   * @param location Represents an Amazon S3 location (bucket name and object key) where DataBrew
   * can write output from a job. 
   */
  public fun location(location: CfnJob.S3LocationProperty) {
    cdkBuilder.location(location)
  }

  public fun build(): CfnJob.S3TableOutputOptionsProperty = cdkBuilder.build()
}
