@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.dms

import cloudshift.awscdk.common.CdkDslMarker
import cloudshift.awscdk.dsl.CfnTagDsl
import kotlin.Boolean
import kotlin.String
import kotlin.Unit
import kotlin.collections.Collection
import kotlin.collections.MutableList
import software.amazon.awscdk.CfnTag
import software.amazon.awscdk.IResolvable
import software.amazon.awscdk.services.dms.CfnEventSubscriptionProps

/**
 * Properties for defining a `CfnEventSubscription`.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dms.*;
 * CfnEventSubscriptionProps cfnEventSubscriptionProps = CfnEventSubscriptionProps.builder()
 * .snsTopicArn("snsTopicArn")
 * // the properties below are optional
 * .enabled(false)
 * .eventCategories(List.of("eventCategories"))
 * .sourceIds(List.of("sourceIds"))
 * .sourceType("sourceType")
 * .subscriptionName("subscriptionName")
 * .tags(List.of(CfnTag.builder()
 * .key("key")
 * .value("value")
 * .build()))
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html)
 */
@CdkDslMarker
public class CfnEventSubscriptionPropsDsl {
  private val cdkBuilder: CfnEventSubscriptionProps.Builder = CfnEventSubscriptionProps.builder()

  private val _eventCategories: MutableList<String> = mutableListOf()

  private val _sourceIds: MutableList<String> = mutableListOf()

  private val _tags: MutableList<CfnTag> = mutableListOf()

  /**
   * @param enabled Indicates whether to activate the subscription.
   * If you don't specify this property, AWS CloudFormation activates the subscription.
   */
  public fun enabled(enabled: Boolean) {
    cdkBuilder.enabled(enabled)
  }

  /**
   * @param enabled Indicates whether to activate the subscription.
   * If you don't specify this property, AWS CloudFormation activates the subscription.
   */
  public fun enabled(enabled: IResolvable) {
    cdkBuilder.enabled(enabled)
  }

  /**
   * @param eventCategories A list of event categories for a source type that you want to subscribe
   * to.
   * If you don't specify this property, you are notified about all event categories. For more
   * information, see [Working with Events and
   * Notifications](https://docs.aws.amazon.com//dms/latest/userguide/CHAP_Events.html) in the *AWS DMS
   * User Guide* .
   */
  public fun eventCategories(vararg eventCategories: String) {
    _eventCategories.addAll(listOf(*eventCategories))
  }

  /**
   * @param eventCategories A list of event categories for a source type that you want to subscribe
   * to.
   * If you don't specify this property, you are notified about all event categories. For more
   * information, see [Working with Events and
   * Notifications](https://docs.aws.amazon.com//dms/latest/userguide/CHAP_Events.html) in the *AWS DMS
   * User Guide* .
   */
  public fun eventCategories(eventCategories: Collection<String>) {
    _eventCategories.addAll(eventCategories)
  }

  /**
   * @param snsTopicArn The Amazon Resource Name (ARN) of the Amazon SNS topic created for event
   * notification. 
   * The ARN is created by Amazon SNS when you create a topic and subscribe to it.
   */
  public fun snsTopicArn(snsTopicArn: String) {
    cdkBuilder.snsTopicArn(snsTopicArn)
  }

  /**
   * @param sourceIds A list of identifiers for which AWS DMS provides notification events.
   * If you don't specify a value, notifications are provided for all sources.
   *
   * If you specify multiple values, they must be of the same type. For example, if you specify a
   * database instance ID, then all of the other values must be database instance IDs.
   */
  public fun sourceIds(vararg sourceIds: String) {
    _sourceIds.addAll(listOf(*sourceIds))
  }

  /**
   * @param sourceIds A list of identifiers for which AWS DMS provides notification events.
   * If you don't specify a value, notifications are provided for all sources.
   *
   * If you specify multiple values, they must be of the same type. For example, if you specify a
   * database instance ID, then all of the other values must be database instance IDs.
   */
  public fun sourceIds(sourceIds: Collection<String>) {
    _sourceIds.addAll(sourceIds)
  }

  /**
   * @param sourceType The type of AWS DMS resource that generates the events.
   * For example, if you want to be notified of events generated by a replication instance, you set
   * this parameter to `replication-instance` . If this value isn't specified, all events are returned.
   *
   * *Valid values* : `replication-instance` | `replication-task`
   */
  public fun sourceType(sourceType: String) {
    cdkBuilder.sourceType(sourceType)
  }

  /**
   * @param subscriptionName The name of the AWS DMS event notification subscription.
   * This name must be less than 255 characters.
   */
  public fun subscriptionName(subscriptionName: String) {
    cdkBuilder.subscriptionName(subscriptionName)
  }

  /**
   * @param tags One or more tags to be assigned to the event subscription.
   */
  public fun tags(tags: CfnTagDsl.() -> Unit) {
    _tags.add(CfnTagDsl().apply(tags).build())
  }

  /**
   * @param tags One or more tags to be assigned to the event subscription.
   */
  public fun tags(tags: Collection<CfnTag>) {
    _tags.addAll(tags)
  }

  public fun build(): CfnEventSubscriptionProps {
    if(_eventCategories.isNotEmpty()) cdkBuilder.eventCategories(_eventCategories)
    if(_sourceIds.isNotEmpty()) cdkBuilder.sourceIds(_sourceIds)
    if(_tags.isNotEmpty()) cdkBuilder.tags(_tags)
    return cdkBuilder.build()
  }
}
