@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.ec2

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.Boolean
import software.amazon.awscdk.services.ec2.AmazonLinuxCpuType
import software.amazon.awscdk.services.ec2.AmazonLinuxEdition
import software.amazon.awscdk.services.ec2.AmazonLinuxGeneration
import software.amazon.awscdk.services.ec2.AmazonLinuxImage
import software.amazon.awscdk.services.ec2.AmazonLinuxKernel
import software.amazon.awscdk.services.ec2.AmazonLinuxStorage
import software.amazon.awscdk.services.ec2.AmazonLinuxVirt
import software.amazon.awscdk.services.ec2.UserData

/**
 * Selects the latest version of Amazon Linux.
 *
 * This Machine Image automatically updates to the latest version on every
 * deployment. Be aware this will cause your instances to be replaced when a
 * new version of the image becomes available. Do not store stateful information
 * on the instance if you are using this image.
 *
 * The AMI ID is selected using the values published to the SSM parameter store.
 *
 * Example:
 *
 * ```
 * ISecurityGroup sg = SecurityGroup.fromSecurityGroupId(this, "FsxSecurityGroup",
 * "{SECURITY-GROUP-ID}");
 * IFileSystem fs = LustreFileSystem.fromLustreFileSystemAttributes(this, "FsxLustreFileSystem",
 * FileSystemAttributes.builder()
 * .dnsName("{FILE-SYSTEM-DNS-NAME}")
 * .fileSystemId("{FILE-SYSTEM-ID}")
 * .securityGroup(sg)
 * .build());
 * IVpc vpc = Vpc.fromVpcAttributes(this, "Vpc", VpcAttributes.builder()
 * .availabilityZones(List.of("us-west-2a", "us-west-2b"))
 * .publicSubnetIds(List.of("{US-WEST-2A-SUBNET-ID}", "{US-WEST-2B-SUBNET-ID}"))
 * .vpcId("{VPC-ID}")
 * .build());
 * Instance inst = Instance.Builder.create(this, "inst")
 * .instanceType(InstanceType.of(InstanceClass.T2, InstanceSize.LARGE))
 * .machineImage(AmazonLinuxImage.Builder.create()
 * .generation(AmazonLinuxGeneration.AMAZON_LINUX_2)
 * .build())
 * .vpc(vpc)
 * .vpcSubnets(SubnetSelection.builder()
 * .subnetType(SubnetType.PUBLIC)
 * .build())
 * .build();
 * fs.connections.allowDefaultPortFrom(inst);
 * ```
 */
@CdkDslMarker
public class AmazonLinuxImageDsl {
  private val cdkBuilder: AmazonLinuxImage.Builder = AmazonLinuxImage.Builder.create()

  /**
   * Whether the AMI ID is cached to be stable between deployments.
   *
   * By default, the newest image is used on each deployment. This will cause
   * instances to be replaced whenever a new version is released, and may cause
   * downtime if there aren't enough running instances in the AutoScalingGroup
   * to reschedule the tasks on.
   *
   * If set to true, the AMI ID will be cached in `cdk.context.json` and the
   * same value will be used on future runs. Your instances will not be replaced
   * but your AMI version will grow old over time. To refresh the AMI lookup,
   * you will have to evict the value from the cache using the `cdk context`
   * command. See https://docs.aws.amazon.com/cdk/latest/guide/context.html for
   * more information.
   *
   * Can not be set to `true` in environment-agnostic stacks.
   *
   * Default: false
   *
   * @param cachedInContext Whether the AMI ID is cached to be stable between deployments. 
   */
  public fun cachedInContext(cachedInContext: Boolean) {
    cdkBuilder.cachedInContext(cachedInContext)
  }

  /**
   * CPU Type.
   *
   * Default: X86_64
   *
   * @param cpuType CPU Type. 
   */
  public fun cpuType(cpuType: AmazonLinuxCpuType) {
    cdkBuilder.cpuType(cpuType)
  }

  /**
   * What edition of Amazon Linux to use.
   *
   * Default: Standard
   *
   * @param edition What edition of Amazon Linux to use. 
   */
  public fun edition(edition: AmazonLinuxEdition) {
    cdkBuilder.edition(edition)
  }

  /**
   * What generation of Amazon Linux to use.
   *
   * Default: AmazonLinux
   *
   * @param generation What generation of Amazon Linux to use. 
   */
  public fun generation(generation: AmazonLinuxGeneration) {
    cdkBuilder.generation(generation)
  }

  /**
   * What kernel version of Amazon Linux to use.
   *
   * Default: -
   *
   * @param kernel What kernel version of Amazon Linux to use. 
   */
  public fun kernel(kernel: AmazonLinuxKernel) {
    cdkBuilder.kernel(kernel)
  }

  /**
   * What storage backed image to use.
   *
   * Default: GeneralPurpose
   *
   * @param storage What storage backed image to use. 
   */
  public fun storage(storage: AmazonLinuxStorage) {
    cdkBuilder.storage(storage)
  }

  /**
   * Initial user data.
   *
   * Default: - Empty UserData for Linux machines
   *
   * @param userData Initial user data. 
   */
  public fun userData(userData: UserData) {
    cdkBuilder.userData(userData)
  }

  /**
   * Virtualization type.
   *
   * Default: HVM
   *
   * @param virtualization Virtualization type. 
   */
  public fun virtualization(virtualization: AmazonLinuxVirt) {
    cdkBuilder.virtualization(virtualization)
  }

  public fun build(): AmazonLinuxImage = cdkBuilder.build()
}
