@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.ec2

import cloudshift.awscdk.common.CdkDslMarker
import cloudshift.awscdk.common.MapBuilder
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Unit
import kotlin.collections.Collection
import kotlin.collections.MutableList
import software.amazon.awscdk.IResolvable
import software.amazon.awscdk.services.ec2.CfnVPCEndpointProps

/**
 * Properties for defining a `CfnVPCEndpoint`.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * Object policyDocument;
 * CfnVPCEndpointProps cfnVPCEndpointProps = CfnVPCEndpointProps.builder()
 * .serviceName("serviceName")
 * .vpcId("vpcId")
 * // the properties below are optional
 * .policyDocument(policyDocument)
 * .privateDnsEnabled(false)
 * .routeTableIds(List.of("routeTableIds"))
 * .securityGroupIds(List.of("securityGroupIds"))
 * .subnetIds(List.of("subnetIds"))
 * .vpcEndpointType("vpcEndpointType")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html)
 */
@CdkDslMarker
public class CfnVPCEndpointPropsDsl {
  private val cdkBuilder: CfnVPCEndpointProps.Builder = CfnVPCEndpointProps.builder()

  private val _routeTableIds: MutableList<String> = mutableListOf()

  private val _securityGroupIds: MutableList<String> = mutableListOf()

  private val _subnetIds: MutableList<String> = mutableListOf()

  /**
   * @param policyDocument An endpoint policy, which controls access to the service from the VPC.
   * The default endpoint policy allows full access to the service. Endpoint policies are supported
   * only for gateway and interface endpoints.
   *
   * For CloudFormation templates in YAML, you can provide the policy in JSON or YAML format. AWS
   * CloudFormation converts YAML policies to JSON format before calling the API to create or modify
   * the VPC endpoint.
   */
  public fun policyDocument(policyDocument: MapBuilder.() -> Unit = {}) {
    val builder = MapBuilder()
    builder.apply(policyDocument)
    cdkBuilder.policyDocument(builder.map)
  }

  /**
   * @param policyDocument An endpoint policy, which controls access to the service from the VPC.
   * The default endpoint policy allows full access to the service. Endpoint policies are supported
   * only for gateway and interface endpoints.
   *
   * For CloudFormation templates in YAML, you can provide the policy in JSON or YAML format. AWS
   * CloudFormation converts YAML policies to JSON format before calling the API to create or modify
   * the VPC endpoint.
   */
  public fun policyDocument(policyDocument: Any) {
    cdkBuilder.policyDocument(policyDocument)
  }

  /**
   * @param privateDnsEnabled Indicate whether to associate a private hosted zone with the specified
   * VPC.
   * The private hosted zone contains a record set for the default public DNS name for the service
   * for the Region (for example, `kinesis.us-east-1.amazonaws.com` ), which resolves to the private IP
   * addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the
   * default public DNS name for the service instead of the public DNS names that are automatically
   * generated by the VPC endpoint service.
   *
   * To use a private hosted zone, you must set the following VPC attributes to `true` :
   * `enableDnsHostnames` and `enableDnsSupport` .
   *
   * This property is supported only for interface endpoints.
   *
   * Default: `false`
   */
  public fun privateDnsEnabled(privateDnsEnabled: Boolean) {
    cdkBuilder.privateDnsEnabled(privateDnsEnabled)
  }

  /**
   * @param privateDnsEnabled Indicate whether to associate a private hosted zone with the specified
   * VPC.
   * The private hosted zone contains a record set for the default public DNS name for the service
   * for the Region (for example, `kinesis.us-east-1.amazonaws.com` ), which resolves to the private IP
   * addresses of the endpoint network interfaces in the VPC. This enables you to make requests to the
   * default public DNS name for the service instead of the public DNS names that are automatically
   * generated by the VPC endpoint service.
   *
   * To use a private hosted zone, you must set the following VPC attributes to `true` :
   * `enableDnsHostnames` and `enableDnsSupport` .
   *
   * This property is supported only for interface endpoints.
   *
   * Default: `false`
   */
  public fun privateDnsEnabled(privateDnsEnabled: IResolvable) {
    cdkBuilder.privateDnsEnabled(privateDnsEnabled)
  }

  /**
   * @param routeTableIds The IDs of the route tables.
   * Routing is supported only for gateway endpoints.
   */
  public fun routeTableIds(vararg routeTableIds: String) {
    _routeTableIds.addAll(listOf(*routeTableIds))
  }

  /**
   * @param routeTableIds The IDs of the route tables.
   * Routing is supported only for gateway endpoints.
   */
  public fun routeTableIds(routeTableIds: Collection<String>) {
    _routeTableIds.addAll(routeTableIds)
  }

  /**
   * @param securityGroupIds The IDs of the security groups to associate with the endpoint network
   * interfaces.
   * If this parameter is not specified, we use the default security group for the VPC. Security
   * groups are supported only for interface endpoints.
   */
  public fun securityGroupIds(vararg securityGroupIds: String) {
    _securityGroupIds.addAll(listOf(*securityGroupIds))
  }

  /**
   * @param securityGroupIds The IDs of the security groups to associate with the endpoint network
   * interfaces.
   * If this parameter is not specified, we use the default security group for the VPC. Security
   * groups are supported only for interface endpoints.
   */
  public fun securityGroupIds(securityGroupIds: Collection<String>) {
    _securityGroupIds.addAll(securityGroupIds)
  }

  /**
   * @param serviceName The name of the endpoint service. 
   */
  public fun serviceName(serviceName: String) {
    cdkBuilder.serviceName(serviceName)
  }

  /**
   * @param subnetIds The IDs of the subnets in which to create endpoint network interfaces.
   * You must specify this property for an interface endpoint or a Gateway Load Balancer endpoint.
   * You can't specify this property for a gateway endpoint. For a Gateway Load Balancer endpoint, you
   * can specify only one subnet.
   */
  public fun subnetIds(vararg subnetIds: String) {
    _subnetIds.addAll(listOf(*subnetIds))
  }

  /**
   * @param subnetIds The IDs of the subnets in which to create endpoint network interfaces.
   * You must specify this property for an interface endpoint or a Gateway Load Balancer endpoint.
   * You can't specify this property for a gateway endpoint. For a Gateway Load Balancer endpoint, you
   * can specify only one subnet.
   */
  public fun subnetIds(subnetIds: Collection<String>) {
    _subnetIds.addAll(subnetIds)
  }

  /**
   * @param vpcEndpointType The type of endpoint.
   * Default: Gateway
   */
  public fun vpcEndpointType(vpcEndpointType: String) {
    cdkBuilder.vpcEndpointType(vpcEndpointType)
  }

  /**
   * @param vpcId The ID of the VPC. 
   */
  public fun vpcId(vpcId: String) {
    cdkBuilder.vpcId(vpcId)
  }

  public fun build(): CfnVPCEndpointProps {
    if(_routeTableIds.isNotEmpty()) cdkBuilder.routeTableIds(_routeTableIds)
    if(_securityGroupIds.isNotEmpty()) cdkBuilder.securityGroupIds(_securityGroupIds)
    if(_subnetIds.isNotEmpty()) cdkBuilder.subnetIds(_subnetIds)
    return cdkBuilder.build()
  }
}
