@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.ecs

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import kotlin.Unit
import kotlin.collections.Collection
import kotlin.collections.MutableList
import software.amazon.awscdk.services.ecs.ExternalTaskDefinition
import software.amazon.awscdk.services.ecs.NetworkMode
import software.amazon.awscdk.services.ecs.ProxyConfiguration
import software.amazon.awscdk.services.ecs.Volume
import software.amazon.awscdk.services.iam.IRole
import software.constructs.Construct

/**
 * The details of a task definition run on an External cluster.
 *
 * Example:
 *
 * ```
 * ExternalTaskDefinition externalTaskDefinition = new ExternalTaskDefinition(this, "TaskDef");
 * ContainerDefinition container = externalTaskDefinition.addContainer("WebContainer",
 * ContainerDefinitionOptions.builder()
 * // Use an image from DockerHub
 * .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 * .memoryLimitMiB(1024)
 * .build());
 * ```
 */
@CdkDslMarker
public class ExternalTaskDefinitionDsl(
  scope: Construct,
  id: String,
) {
  private val cdkBuilder: ExternalTaskDefinition.Builder =
      ExternalTaskDefinition.Builder.create(scope, id)

  private val _volumes: MutableList<Volume> = mutableListOf()

  /**
   * The name of the IAM task execution role that grants the ECS agent permission to call AWS APIs
   * on your behalf.
   *
   * The role will be used to retrieve container images from ECR and create CloudWatch log groups.
   *
   * Default: - An execution role will be automatically created if you use ECR images in your task
   * definition.
   *
   * @param executionRole The name of the IAM task execution role that grants the ECS agent
   * permission to call AWS APIs on your behalf. 
   */
  public fun executionRole(executionRole: IRole) {
    cdkBuilder.executionRole(executionRole)
  }

  /**
   * The name of a family that this task definition is registered to.
   *
   * A family groups multiple versions of a task definition.
   *
   * Default: - Automatically generated name.
   *
   * @param family The name of a family that this task definition is registered to. 
   */
  public fun family(family: String) {
    cdkBuilder.family(family)
  }

  /**
   * The networking mode to use for the containers in the task.
   *
   * With ECS Anywhere, supported modes are bridge, host and none.
   *
   * Default: NetworkMode.BRIDGE
   *
   * @param networkMode The networking mode to use for the containers in the task. 
   */
  public fun networkMode(networkMode: NetworkMode) {
    cdkBuilder.networkMode(networkMode)
  }

  /**
   * The configuration details for the App Mesh proxy.
   *
   * Default: - No proxy configuration.
   *
   * @param proxyConfiguration The configuration details for the App Mesh proxy. 
   */
  public fun proxyConfiguration(proxyConfiguration: ProxyConfiguration) {
    cdkBuilder.proxyConfiguration(proxyConfiguration)
  }

  /**
   * The name of the IAM role that grants containers in the task permission to call AWS APIs on your
   * behalf.
   *
   * Default: - A task role is automatically created for you.
   *
   * @param taskRole The name of the IAM role that grants containers in the task permission to call
   * AWS APIs on your behalf. 
   */
  public fun taskRole(taskRole: IRole) {
    cdkBuilder.taskRole(taskRole)
  }

  /**
   * The list of volume definitions for the task.
   *
   * For more information, see
   * [Task Definition Parameter
   * Volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide//task_definition_parameters.html#volumes).
   *
   * Default: - No volumes are passed to the Docker daemon on a container instance.
   *
   * @param volumes The list of volume definitions for the task. 
   */
  public fun volumes(volumes: VolumeDsl.() -> Unit) {
    _volumes.add(VolumeDsl().apply(volumes).build())
  }

  /**
   * The list of volume definitions for the task.
   *
   * For more information, see
   * [Task Definition Parameter
   * Volumes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide//task_definition_parameters.html#volumes).
   *
   * Default: - No volumes are passed to the Docker daemon on a container instance.
   *
   * @param volumes The list of volume definitions for the task. 
   */
  public fun volumes(volumes: Collection<Volume>) {
    _volumes.addAll(volumes)
  }

  public fun build(): ExternalTaskDefinition {
    if(_volumes.isNotEmpty()) cdkBuilder.volumes(_volumes)
    return cdkBuilder.build()
  }
}
