@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.guardduty

import cloudshift.awscdk.common.CdkDslMarker
import software.amazon.awscdk.IResolvable
import software.amazon.awscdk.services.guardduty.CfnDetector

/**
 * Describes whether Malware Protection will be enabled as a data source.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.guardduty.*;
 * CFNMalwareProtectionConfigurationProperty cFNMalwareProtectionConfigurationProperty =
 * CFNMalwareProtectionConfigurationProperty.builder()
 * .scanEc2InstanceWithFindings(CFNScanEc2InstanceWithFindingsConfigurationProperty.builder()
 * .ebsVolumes(false)
 * .build())
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-guardduty-detector-cfnmalwareprotectionconfiguration.html)
 */
@CdkDslMarker
public class CfnDetectorCFNMalwareProtectionConfigurationPropertyDsl {
  private val cdkBuilder: CfnDetector.CFNMalwareProtectionConfigurationProperty.Builder =
      CfnDetector.CFNMalwareProtectionConfigurationProperty.builder()

  /**
   * @param scanEc2InstanceWithFindings Describes the configuration of Malware Protection for EC2
   * instances with findings.
   */
  public fun scanEc2InstanceWithFindings(scanEc2InstanceWithFindings: IResolvable) {
    cdkBuilder.scanEc2InstanceWithFindings(scanEc2InstanceWithFindings)
  }

  /**
   * @param scanEc2InstanceWithFindings Describes the configuration of Malware Protection for EC2
   * instances with findings.
   */
  public
      fun scanEc2InstanceWithFindings(scanEc2InstanceWithFindings: CfnDetector.CFNScanEc2InstanceWithFindingsConfigurationProperty) {
    cdkBuilder.scanEc2InstanceWithFindings(scanEc2InstanceWithFindings)
  }

  public fun build(): CfnDetector.CFNMalwareProtectionConfigurationProperty = cdkBuilder.build()
}
