@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.iam

import cloudshift.awscdk.common.CdkDslMarker
import cloudshift.awscdk.dsl.CfnTagDsl
import kotlin.String
import kotlin.Unit
import kotlin.collections.Collection
import kotlin.collections.MutableList
import software.amazon.awscdk.CfnTag
import software.amazon.awscdk.services.iam.CfnSAMLProvider
import software.constructs.Construct

/**
 * Creates an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.
 *
 * The SAML provider resource that you create with this operation can be used as a principal in an
 * IAM role's trust policy. Such a policy can enable federated users who sign in using the SAML IdP to
 * assume the role. You can create an IAM role that supports Web-based single sign-on (SSO) to the AWS
 * Management Console or one that supports API access to AWS .
 *
 * When you create the SAML provider resource, you upload a SAML metadata document that you get from
 * your IdP. That document includes the issuer's name, expiration information, and keys that can be
 * used to validate the SAML authentication response (assertions) that the IdP sends. You must generate
 * the metadata document using the identity management software that is used as your organization's
 * IdP.
 *
 *
 * This operation requires [Signature Version
 * 4](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html) .
 *
 *
 * For more information, see [Enabling SAML 2.0 federated users to access the AWS Management
 * Console](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html)
 * and [About SAML 2.0-based
 * federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html) in the
 * *IAM User Guide* .
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * CfnSAMLProvider cfnSAMLProvider = CfnSAMLProvider.Builder.create(this, "MyCfnSAMLProvider")
 * .samlMetadataDocument("samlMetadataDocument")
 * // the properties below are optional
 * .name("name")
 * .tags(List.of(CfnTag.builder()
 * .key("key")
 * .value("value")
 * .build()))
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html)
 */
@CdkDslMarker
public class CfnSAMLProviderDsl(
  scope: Construct,
  id: String,
) {
  private val cdkBuilder: CfnSAMLProvider.Builder = CfnSAMLProvider.Builder.create(scope, id)

  private val _tags: MutableList<CfnTag> = mutableListOf()

  /**
   * The name of the provider to create.
   *
   * This parameter allows (through its [regex
   * pattern](https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex) ) a string of characters
   * consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any
   * of the following characters: _+=,.&#64;-
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-name)
   * @param name The name of the provider to create. 
   */
  public fun name(name: String) {
    cdkBuilder.name(name)
  }

  /**
   * An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document
   * includes the issuer's name, expiration information, and keys that can be used to validate the SAML
   * authentication response (assertions) that are received from the IdP. You must generate the
   * metadata document using the identity management software that is used as your organization's IdP.
   *
   * For more information, see [About SAML 2.0-based
   * federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html) in the
   * *IAM User Guide*
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-samlmetadatadocument)
   * @param samlMetadataDocument An XML document generated by an identity provider (IdP) that
   * supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that
   * can be used to validate the SAML authentication response (assertions) that are received from the
   * IdP. You must generate the metadata document using the identity management software that is used
   * as your organization's IdP. 
   */
  public fun samlMetadataDocument(samlMetadataDocument: String) {
    cdkBuilder.samlMetadataDocument(samlMetadataDocument)
  }

  /**
   * A list of tags that you want to attach to the new IAM SAML provider.
   *
   * Each tag consists of a key name and an associated value. For more information about tagging,
   * see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the
   * *IAM User Guide* .
   *
   *
   * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the
   * entire request fails and the resource is not created.
   *
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-tags)
   * @param tags A list of tags that you want to attach to the new IAM SAML provider. 
   */
  public fun tags(tags: CfnTagDsl.() -> Unit) {
    _tags.add(CfnTagDsl().apply(tags).build())
  }

  /**
   * A list of tags that you want to attach to the new IAM SAML provider.
   *
   * Each tag consists of a key name and an associated value. For more information about tagging,
   * see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the
   * *IAM User Guide* .
   *
   *
   * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the
   * entire request fails and the resource is not created.
   *
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html#cfn-iam-samlprovider-tags)
   * @param tags A list of tags that you want to attach to the new IAM SAML provider. 
   */
  public fun tags(tags: Collection<CfnTag>) {
    _tags.addAll(tags)
  }

  public fun build(): CfnSAMLProvider {
    if(_tags.isNotEmpty()) cdkBuilder.tags(_tags)
    return cdkBuilder.build()
  }
}
