@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.iam

import cloudshift.awscdk.common.CdkDslMarker
import cloudshift.awscdk.dsl.CfnTagDsl
import kotlin.String
import kotlin.Unit
import kotlin.collections.Collection
import kotlin.collections.MutableList
import software.amazon.awscdk.CfnTag
import software.amazon.awscdk.services.iam.CfnSAMLProviderProps

/**
 * Properties for defining a `CfnSAMLProvider`.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iam.*;
 * CfnSAMLProviderProps cfnSAMLProviderProps = CfnSAMLProviderProps.builder()
 * .samlMetadataDocument("samlMetadataDocument")
 * // the properties below are optional
 * .name("name")
 * .tags(List.of(CfnTag.builder()
 * .key("key")
 * .value("value")
 * .build()))
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-samlprovider.html)
 */
@CdkDslMarker
public class CfnSAMLProviderPropsDsl {
  private val cdkBuilder: CfnSAMLProviderProps.Builder = CfnSAMLProviderProps.builder()

  private val _tags: MutableList<CfnTag> = mutableListOf()

  /**
   * @param name The name of the provider to create.
   * This parameter allows (through its [regex
   * pattern](https://docs.aws.amazon.com/http://wikipedia.org/wiki/regex) ) a string of characters
   * consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any
   * of the following characters: _+=,.&#64;-
   */
  public fun name(name: String) {
    cdkBuilder.name(name)
  }

  /**
   * @param samlMetadataDocument An XML document generated by an identity provider (IdP) that
   * supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that
   * can be used to validate the SAML authentication response (assertions) that are received from the
   * IdP. You must generate the metadata document using the identity management software that is used
   * as your organization's IdP. 
   * For more information, see [About SAML 2.0-based
   * federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html) in the
   * *IAM User Guide*
   */
  public fun samlMetadataDocument(samlMetadataDocument: String) {
    cdkBuilder.samlMetadataDocument(samlMetadataDocument)
  }

  /**
   * @param tags A list of tags that you want to attach to the new IAM SAML provider.
   * Each tag consists of a key name and an associated value. For more information about tagging,
   * see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the
   * *IAM User Guide* .
   *
   *
   * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the
   * entire request fails and the resource is not created.
   */
  public fun tags(tags: CfnTagDsl.() -> Unit) {
    _tags.add(CfnTagDsl().apply(tags).build())
  }

  /**
   * @param tags A list of tags that you want to attach to the new IAM SAML provider.
   * Each tag consists of a key name and an associated value. For more information about tagging,
   * see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the
   * *IAM User Guide* .
   *
   *
   * If any one of the tags is invalid or if you exceed the allowed maximum number of tags, then the
   * entire request fails and the resource is not created.
   */
  public fun tags(tags: Collection<CfnTag>) {
    _tags.addAll(tags)
  }

  public fun build(): CfnSAMLProviderProps {
    if(_tags.isNotEmpty()) cdkBuilder.tags(_tags)
    return cdkBuilder.build()
  }
}
