@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.iam

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.services.iam.IRole
import software.amazon.awscdk.services.iam.InstanceProfile
import software.constructs.Construct

/**
 * IAM Instance Profile.
 *
 * Example:
 *
 * ```
 * Role role = Role.Builder.create(this, "Role")
 * .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
 * .build();
 * IInstanceProfile instanceProfile = InstanceProfile.fromInstanceProfileAttributes(this,
 * "ImportedInstanceProfile", InstanceProfileAttributes.builder()
 * .instanceProfileArn("arn:aws:iam::account-id:instance-profile/MyInstanceProfile")
 * .role(role)
 * .build());
 * ```
 */
@CdkDslMarker
public class InstanceProfileDsl(
  scope: Construct,
  id: String,
) {
  private val cdkBuilder: InstanceProfile.Builder = InstanceProfile.Builder.create(scope, id)

  /**
   * The name of the InstanceProfile to create.
   *
   * Default: - generated by CloudFormation
   *
   * @param instanceProfileName The name of the InstanceProfile to create. 
   */
  public fun instanceProfileName(instanceProfileName: String) {
    cdkBuilder.instanceProfileName(instanceProfileName)
  }

  /**
   * The path to the InstanceProfile.
   *
   * Default: /
   *
   * @param path The path to the InstanceProfile. 
   */
  public fun path(path: String) {
    cdkBuilder.path(path)
  }

  /**
   * An IAM role to associate with the instance profile that is used by EC2 instances.
   *
   * The role must be assumable by the service principal `ec2.amazonaws.com`:
   *
   * Default: - a role will be automatically created, it can be accessed via the `role` property
   *
   * Example:
   *
   * ```
   * Role role = Role.Builder.create(this, "MyRole")
   * .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
   * .build();
   * ```
   *
   * @param role An IAM role to associate with the instance profile that is used by EC2 instances. 
   */
  public fun role(role: IRole) {
    cdkBuilder.role(role)
  }

  public fun build(): InstanceProfile = cdkBuilder.build()
}
