@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.iam

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.services.iam.SamlMetadataDocument
import software.amazon.awscdk.services.iam.SamlProviderProps

/**
 * Properties for a SAML provider.
 *
 * Example:
 *
 * ```
 * SamlProvider provider = SamlProvider.Builder.create(this, "Provider")
 * .metadataDocument(SamlMetadataDocument.fromFile("/path/to/saml-metadata-document.xml"))
 * .build();
 * Role.Builder.create(this, "Role")
 * .assumedBy(new SamlConsolePrincipal(provider))
 * .build();
 * ```
 */
@CdkDslMarker
public class SamlProviderPropsDsl {
  private val cdkBuilder: SamlProviderProps.Builder = SamlProviderProps.builder()

  /**
   * @param metadataDocument An XML document generated by an identity provider (IdP) that supports
   * SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be
   * used to validate the SAML authentication response (assertions) that are received from the IdP. You
   * must generate the metadata document using the identity management software that is used as your
   * organization's IdP. 
   */
  public fun metadataDocument(metadataDocument: SamlMetadataDocument) {
    cdkBuilder.metadataDocument(metadataDocument)
  }

  /**
   * @param name The name of the provider to create.
   * This parameter allows a string of characters consisting of upper and
   * lowercase alphanumeric characters with no spaces. You can also include
   * any of the following characters: _+=,.&#64;-
   *
   * Length must be between 1 and 128 characters.
   */
  public fun name(name: String) {
    cdkBuilder.name(name)
  }

  public fun build(): SamlProviderProps = cdkBuilder.build()
}
