@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.iot

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.services.iot.CfnCertificate
import software.constructs.Construct

/**
 * Use the `AWS::IoT::Certificate` resource to declare an AWS IoT X.509 certificate. For information
 * about working with X.509 certificates, see [X.509 Client
 * Certificates](https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html) in the
 * *AWS IoT Developer Guide* .
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnCertificate cfnCertificate = CfnCertificate.Builder.create(this, "MyCfnCertificate")
 * .status("status")
 * // the properties below are optional
 * .caCertificatePem("caCertificatePem")
 * .certificateMode("certificateMode")
 * .certificatePem("certificatePem")
 * .certificateSigningRequest("certificateSigningRequest")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html)
 */
@CdkDslMarker
public class CfnCertificateDsl(
  scope: Construct,
  id: String,
) {
  private val cdkBuilder: CfnCertificate.Builder = CfnCertificate.Builder.create(scope, id)

  /**
   * The CA certificate used to sign the device certificate being registered, not available when
   * CertificateMode is SNI_ONLY.
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-cacertificatepem)
   * @param caCertificatePem The CA certificate used to sign the device certificate being
   * registered, not available when CertificateMode is SNI_ONLY. 
   */
  public fun caCertificatePem(caCertificatePem: String) {
    cdkBuilder.caCertificatePem(caCertificatePem)
  }

  /**
   * Specifies which mode of certificate registration to use with this resource.
   *
   * Valid options are DEFAULT with CaCertificatePem and CertificatePem, SNI_ONLY with
   * CertificatePem, and Default with CertificateSigningRequest.
   *
   * `DEFAULT` : A certificate in `DEFAULT` mode is either generated by AWS IoT Core or registered
   * with an issuer certificate authority (CA). Devices with certificates in `DEFAULT` mode aren't
   * required to send the Server Name Indication (SNI) extension when connecting to AWS IoT Core .
   * However, to use features such as custom domains and VPC endpoints, we recommend that you use the
   * SNI extension when connecting to AWS IoT Core .
   *
   * `SNI_ONLY` : A certificate in `SNI_ONLY` mode is registered without an issuer CA. Devices with
   * certificates in `SNI_ONLY` mode must send the SNI extension when connecting to AWS IoT Core .
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatemode)
   * @param certificateMode Specifies which mode of certificate registration to use with this
   * resource. 
   */
  public fun certificateMode(certificateMode: String) {
    cdkBuilder.certificateMode(certificateMode)
  }

  /**
   * The certificate data in PEM format.
   *
   * Requires SNI_ONLY for the certificate mode or the accompanying CACertificatePem for
   * registration.
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatepem)
   * @param certificatePem The certificate data in PEM format. 
   */
  public fun certificatePem(certificatePem: String) {
    cdkBuilder.certificatePem(certificatePem)
  }

  /**
   * The certificate signing request (CSR).
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatesigningrequest)
   * @param certificateSigningRequest The certificate signing request (CSR). 
   */
  public fun certificateSigningRequest(certificateSigningRequest: String) {
    cdkBuilder.certificateSigningRequest(certificateSigningRequest)
  }

  /**
   * The status of the certificate.
   *
   * Valid values are ACTIVE, INACTIVE, REVOKED, PENDING_TRANSFER, and PENDING_ACTIVATION.
   *
   * The status value REGISTER_INACTIVE is deprecated and should not be used.
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-status)
   * @param status The status of the certificate. 
   */
  public fun status(status: String) {
    cdkBuilder.status(status)
  }

  public fun build(): CfnCertificate = cdkBuilder.build()
}
