@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.iot

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.services.iot.CfnCertificateProps

/**
 * Properties for defining a `CfnCertificate`.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnCertificateProps cfnCertificateProps = CfnCertificateProps.builder()
 * .status("status")
 * // the properties below are optional
 * .caCertificatePem("caCertificatePem")
 * .certificateMode("certificateMode")
 * .certificatePem("certificatePem")
 * .certificateSigningRequest("certificateSigningRequest")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html)
 */
@CdkDslMarker
public class CfnCertificatePropsDsl {
  private val cdkBuilder: CfnCertificateProps.Builder = CfnCertificateProps.builder()

  /**
   * @param caCertificatePem The CA certificate used to sign the device certificate being
   * registered, not available when CertificateMode is SNI_ONLY.
   */
  public fun caCertificatePem(caCertificatePem: String) {
    cdkBuilder.caCertificatePem(caCertificatePem)
  }

  /**
   * @param certificateMode Specifies which mode of certificate registration to use with this
   * resource.
   * Valid options are DEFAULT with CaCertificatePem and CertificatePem, SNI_ONLY with
   * CertificatePem, and Default with CertificateSigningRequest.
   *
   * `DEFAULT` : A certificate in `DEFAULT` mode is either generated by AWS IoT Core or registered
   * with an issuer certificate authority (CA). Devices with certificates in `DEFAULT` mode aren't
   * required to send the Server Name Indication (SNI) extension when connecting to AWS IoT Core .
   * However, to use features such as custom domains and VPC endpoints, we recommend that you use the
   * SNI extension when connecting to AWS IoT Core .
   *
   * `SNI_ONLY` : A certificate in `SNI_ONLY` mode is registered without an issuer CA. Devices with
   * certificates in `SNI_ONLY` mode must send the SNI extension when connecting to AWS IoT Core .
   */
  public fun certificateMode(certificateMode: String) {
    cdkBuilder.certificateMode(certificateMode)
  }

  /**
   * @param certificatePem The certificate data in PEM format.
   * Requires SNI_ONLY for the certificate mode or the accompanying CACertificatePem for
   * registration.
   */
  public fun certificatePem(certificatePem: String) {
    cdkBuilder.certificatePem(certificatePem)
  }

  /**
   * @param certificateSigningRequest The certificate signing request (CSR).
   */
  public fun certificateSigningRequest(certificateSigningRequest: String) {
    cdkBuilder.certificateSigningRequest(certificateSigningRequest)
  }

  /**
   * @param status The status of the certificate. 
   * Valid values are ACTIVE, INACTIVE, REVOKED, PENDING_TRANSFER, and PENDING_ACTIVATION.
   *
   * The status value REGISTER_INACTIVE is deprecated and should not be used.
   */
  public fun status(status: String) {
    cdkBuilder.status(status)
  }

  public fun build(): CfnCertificateProps = cdkBuilder.build()
}
