@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.iotanalytics

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.services.iotanalytics.CfnDataset

/**
 * The schedule for when to trigger an update.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotanalytics.*;
 * ScheduleProperty scheduleProperty = ScheduleProperty.builder()
 * .scheduleExpression("scheduleExpression")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-schedule.html)
 */
@CdkDslMarker
public class CfnDatasetSchedulePropertyDsl {
  private val cdkBuilder: CfnDataset.ScheduleProperty.Builder =
      CfnDataset.ScheduleProperty.builder()

  /**
   * @param scheduleExpression The expression that defines when to trigger an update. 
   * For more information, see [Schedule Expressions for
   * Rules](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html) in the
   * Amazon CloudWatch documentation.
   */
  public fun scheduleExpression(scheduleExpression: String) {
    cdkBuilder.scheduleExpression(scheduleExpression)
  }

  public fun build(): CfnDataset.ScheduleProperty = cdkBuilder.build()
}
