@file:Suppress("RedundantVisibilityModifier", "RedundantUnitReturnType", "RemoveRedundantQualifierName", "unused", "UnusedImport", "ClassName", "REDUNDANT_PROJECTION", "DEPRECATION")

package cloudshift.awscdk.dsl.services.lakeformation

import cloudshift.awscdk.common.CdkDslMarker
import software.amazon.awscdk.services.lakeformation.CfnPermissions
import kotlin.String

/**
 * A structure for the database object.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lakeformation.*;
 * DatabaseResourceProperty databaseResourceProperty = DatabaseResourceProperty.builder()
 * .catalogId("catalogId")
 * .name("name")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lakeformation-permissions-databaseresource.html)
 */
@CdkDslMarker
public class CfnPermissionsDatabaseResourcePropertyDsl {
    private val cdkBuilder: CfnPermissions.DatabaseResourceProperty.Builder =
        CfnPermissions.DatabaseResourceProperty.builder()

    /**
     * @param catalogId The identifier for the Data Catalog .
     * By default, it is the account ID of the caller.
     */
    public fun catalogId(catalogId: String) {
        cdkBuilder.catalogId(catalogId)
    }

    /**
     * @param name The name of the database resource.
     * Unique to the Data Catalog.
     */
    public fun name(name: String) {
        cdkBuilder.name(name)
    }

    public fun build(): CfnPermissions.DatabaseResourceProperty = cdkBuilder.build()
}
