@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.lambda.eventsources

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.Any
import kotlin.Boolean
import kotlin.Number
import kotlin.String
import kotlin.collections.Collection
import kotlin.collections.Map
import kotlin.collections.MutableList
import software.amazon.awscdk.Duration
import software.amazon.awscdk.services.lambda.eventsources.SqsEventSource
import software.amazon.awscdk.services.sqs.IQueue

/**
 * Use an Amazon SQS queue as an event source for AWS Lambda.
 *
 * Example:
 *
 * ```
 * import software.amazon.awscdk.services.lambda.eventsources.SqsEventSource;
 * Function fn;
 * Queue queue = new Queue(this, "MyQueue");
 * SqsEventSource eventSource = new SqsEventSource(queue);
 * fn.addEventSource(eventSource);
 * String eventSourceId = eventSource.getEventSourceMappingId();
 * String eventSourceMappingArn = eventSource.getEventSourceMappingArn();
 * ```
 */
@CdkDslMarker
public class SqsEventSourceDsl(
  queue: IQueue,
) {
  private val cdkBuilder: SqsEventSource.Builder = SqsEventSource.Builder.create(queue)

  private val _filters: MutableList<Map<String, Any>> = mutableListOf()

  /**
   * The largest number of records that AWS Lambda will retrieve from your event source at the time
   * of invoking your function.
   *
   * Your function receives an
   * event with all the retrieved records.
   *
   * Valid Range: Minimum value of 1. Maximum value of 10.
   * If `maxBatchingWindow` is configured, this value can go up to 10,000.
   *
   * Default: 10
   *
   * @param batchSize The largest number of records that AWS Lambda will retrieve from your event
   * source at the time of invoking your function. 
   */
  public fun batchSize(batchSize: Number) {
    cdkBuilder.batchSize(batchSize)
  }

  /**
   * If the SQS event source mapping should be enabled.
   *
   * Default: true
   *
   * @param enabled If the SQS event source mapping should be enabled. 
   */
  public fun enabled(enabled: Boolean) {
    cdkBuilder.enabled(enabled)
  }

  /**
   * Add filter criteria option.
   *
   * Default: - None
   *
   * @param filters Add filter criteria option. 
   */
  public fun filters(vararg filters: Map<String, Any>) {
    _filters.addAll(listOf(*filters))
  }

  /**
   * Add filter criteria option.
   *
   * Default: - None
   *
   * @param filters Add filter criteria option. 
   */
  public fun filters(filters: Collection<Map<String, Any>>) {
    _filters.addAll(filters)
  }

  /**
   * The maximum amount of time to gather records before invoking the function.
   *
   * Valid Range: Minimum value of 0 minutes. Maximum value of 5 minutes.
   *
   * Default: - no batching window. The lambda function will be invoked immediately with the records
   * that are available.
   *
   * @param maxBatchingWindow The maximum amount of time to gather records before invoking the
   * function. 
   */
  public fun maxBatchingWindow(maxBatchingWindow: Duration) {
    cdkBuilder.maxBatchingWindow(maxBatchingWindow)
  }

  /**
   * The maximum concurrency setting limits the number of concurrent instances of the function that
   * an Amazon SQS event source can invoke.
   *
   * Default: - No specific limit.
   *
   * @see <a
   * href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency
   * Valid Range: Minimum value of 2. Maximum value of
   * 1000.">https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency
   * Valid Range: Minimum value of 2. Maximum value of 1000.</a>
   * @param maxConcurrency The maximum concurrency setting limits the number of concurrent instances
   * of the function that an Amazon SQS event source can invoke. 
   */
  public fun maxConcurrency(maxConcurrency: Number) {
    cdkBuilder.maxConcurrency(maxConcurrency)
  }

  /**
   * Allow functions to return partially successful responses for a batch of records.
   *
   * Default: false
   *
   * [Documentation](https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#services-sqs-batchfailurereporting)
   * @param reportBatchItemFailures Allow functions to return partially successful responses for a
   * batch of records. 
   */
  public fun reportBatchItemFailures(reportBatchItemFailures: Boolean) {
    cdkBuilder.reportBatchItemFailures(reportBatchItemFailures)
  }

  public fun build(): SqsEventSource {
    if(_filters.isNotEmpty()) cdkBuilder.filters(_filters)
    return cdkBuilder.build()
  }
}
