@file:Suppress("RedundantVisibilityModifier", "RedundantUnitReturnType", "RemoveRedundantQualifierName", "unused", "UnusedImport", "ClassName", "REDUNDANT_PROJECTION", "DEPRECATION")

package cloudshift.awscdk.dsl.services.mediaconnect

import cloudshift.awscdk.common.CdkDslMarker
import software.amazon.awscdk.IResolvable
import software.amazon.awscdk.services.mediaconnect.CfnFlow
import kotlin.String

/**
 * The source configuration for cloud flows receiving a stream from a bridge.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediaconnect.*;
 * GatewayBridgeSourceProperty gatewayBridgeSourceProperty = GatewayBridgeSourceProperty.builder()
 * .bridgeArn("bridgeArn")
 * // the properties below are optional
 * .vpcInterfaceAttachment(VpcInterfaceAttachmentProperty.builder()
 * .vpcInterfaceName("vpcInterfaceName")
 * .build())
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediaconnect-flow-gatewaybridgesource.html)
 */
@CdkDslMarker
public class CfnFlowGatewayBridgeSourcePropertyDsl {
    private val cdkBuilder: CfnFlow.GatewayBridgeSourceProperty.Builder =
        CfnFlow.GatewayBridgeSourceProperty.builder()

    /**
     * @param bridgeArn The ARN of the bridge feeding this flow.
     */
    public fun bridgeArn(bridgeArn: String) {
        cdkBuilder.bridgeArn(bridgeArn)
    }

    /**
     * @param vpcInterfaceAttachment The settings for attaching a VPC interface to an resource.
     */
    public fun vpcInterfaceAttachment(vpcInterfaceAttachment: IResolvable) {
        cdkBuilder.vpcInterfaceAttachment(vpcInterfaceAttachment)
    }

    /**
     * @param vpcInterfaceAttachment The settings for attaching a VPC interface to an resource.
     */
    public fun vpcInterfaceAttachment(vpcInterfaceAttachment: CfnFlow.VpcInterfaceAttachmentProperty) {
        cdkBuilder.vpcInterfaceAttachment(vpcInterfaceAttachment)
    }

    public fun build(): CfnFlow.GatewayBridgeSourceProperty = cdkBuilder.build()
}
