@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.medialive

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.Any
import kotlin.String
import kotlin.collections.Collection
import kotlin.collections.MutableList
import software.amazon.awscdk.IResolvable
import software.amazon.awscdk.services.medialive.CfnChannel

/**
 * The settings for one output group.
 *
 * The parent of this entity is EncoderSettings.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.medialive.*;
 * OutputGroupProperty outputGroupProperty = OutputGroupProperty.builder()
 * .name("name")
 * .outputGroupSettings(OutputGroupSettingsProperty.builder()
 * .archiveGroupSettings(ArchiveGroupSettingsProperty.builder()
 * .archiveCdnSettings(ArchiveCdnSettingsProperty.builder()
 * .archiveS3Settings(ArchiveS3SettingsProperty.builder()
 * .cannedAcl("cannedAcl")
 * .build())
 * .build())
 * .destination(OutputLocationRefProperty.builder()
 * .destinationRefId("destinationRefId")
 * .build())
 * .rolloverInterval(123)
 * .build())
 * .frameCaptureGroupSettings(FrameCaptureGroupSettingsProperty.builder()
 * .destination(OutputLocationRefProperty.builder()
 * .destinationRefId("destinationRefId")
 * .build())
 * .frameCaptureCdnSettings(FrameCaptureCdnSettingsProperty.builder()
 * .frameCaptureS3Settings(FrameCaptureS3SettingsProperty.builder()
 * .cannedAcl("cannedAcl")
 * .build())
 * .build())
 * .build())
 * .hlsGroupSettings(HlsGroupSettingsProperty.builder()
 * .adMarkers(List.of("adMarkers"))
 * .baseUrlContent("baseUrlContent")
 * .baseUrlContent1("baseUrlContent1")
 * .baseUrlManifest("baseUrlManifest")
 * .baseUrlManifest1("baseUrlManifest1")
 * .captionLanguageMappings(List.of(CaptionLanguageMappingProperty.builder()
 * .captionChannel(123)
 * .languageCode("languageCode")
 * .languageDescription("languageDescription")
 * .build()))
 * .captionLanguageSetting("captionLanguageSetting")
 * .clientCache("clientCache")
 * .codecSpecification("codecSpecification")
 * .constantIv("constantIv")
 * .destination(OutputLocationRefProperty.builder()
 * .destinationRefId("destinationRefId")
 * .build())
 * .directoryStructure("directoryStructure")
 * .discontinuityTags("discontinuityTags")
 * .encryptionType("encryptionType")
 * .hlsCdnSettings(HlsCdnSettingsProperty.builder()
 * .hlsAkamaiSettings(HlsAkamaiSettingsProperty.builder()
 * .connectionRetryInterval(123)
 * .filecacheDuration(123)
 * .httpTransferMode("httpTransferMode")
 * .numRetries(123)
 * .restartDelay(123)
 * .salt("salt")
 * .token("token")
 * .build())
 * .hlsBasicPutSettings(HlsBasicPutSettingsProperty.builder()
 * .connectionRetryInterval(123)
 * .filecacheDuration(123)
 * .numRetries(123)
 * .restartDelay(123)
 * .build())
 * .hlsMediaStoreSettings(HlsMediaStoreSettingsProperty.builder()
 * .connectionRetryInterval(123)
 * .filecacheDuration(123)
 * .mediaStoreStorageClass("mediaStoreStorageClass")
 * .numRetries(123)
 * .restartDelay(123)
 * .build())
 * .hlsS3Settings(HlsS3SettingsProperty.builder()
 * .cannedAcl("cannedAcl")
 * .build())
 * .hlsWebdavSettings(HlsWebdavSettingsProperty.builder()
 * .connectionRetryInterval(123)
 * .filecacheDuration(123)
 * .httpTransferMode("httpTransferMode")
 * .numRetries(123)
 * .restartDelay(123)
 * .build())
 * .build())
 * .hlsId3SegmentTagging("hlsId3SegmentTagging")
 * .iFrameOnlyPlaylists("iFrameOnlyPlaylists")
 * .incompleteSegmentBehavior("incompleteSegmentBehavior")
 * .indexNSegments(123)
 * .inputLossAction("inputLossAction")
 * .ivInManifest("ivInManifest")
 * .ivSource("ivSource")
 * .keepSegments(123)
 * .keyFormat("keyFormat")
 * .keyFormatVersions("keyFormatVersions")
 * .keyProviderSettings(KeyProviderSettingsProperty.builder()
 * .staticKeySettings(StaticKeySettingsProperty.builder()
 * .keyProviderServer(InputLocationProperty.builder()
 * .passwordParam("passwordParam")
 * .uri("uri")
 * .username("username")
 * .build())
 * .staticKeyValue("staticKeyValue")
 * .build())
 * .build())
 * .manifestCompression("manifestCompression")
 * .manifestDurationFormat("manifestDurationFormat")
 * .minSegmentLength(123)
 * .mode("mode")
 * .outputSelection("outputSelection")
 * .programDateTime("programDateTime")
 * .programDateTimeClock("programDateTimeClock")
 * .programDateTimePeriod(123)
 * .redundantManifest("redundantManifest")
 * .segmentationMode("segmentationMode")
 * .segmentLength(123)
 * .segmentsPerSubdirectory(123)
 * .streamInfResolution("streamInfResolution")
 * .timedMetadataId3Frame("timedMetadataId3Frame")
 * .timedMetadataId3Period(123)
 * .timestampDeltaMilliseconds(123)
 * .tsFileMode("tsFileMode")
 * .build())
 * .mediaPackageGroupSettings(MediaPackageGroupSettingsProperty.builder()
 * .destination(OutputLocationRefProperty.builder()
 * .destinationRefId("destinationRefId")
 * .build())
 * .build())
 * .msSmoothGroupSettings(MsSmoothGroupSettingsProperty.builder()
 * .acquisitionPointId("acquisitionPointId")
 * .audioOnlyTimecodeControl("audioOnlyTimecodeControl")
 * .certificateMode("certificateMode")
 * .connectionRetryInterval(123)
 * .destination(OutputLocationRefProperty.builder()
 * .destinationRefId("destinationRefId")
 * .build())
 * .eventId("eventId")
 * .eventIdMode("eventIdMode")
 * .eventStopBehavior("eventStopBehavior")
 * .filecacheDuration(123)
 * .fragmentLength(123)
 * .inputLossAction("inputLossAction")
 * .numRetries(123)
 * .restartDelay(123)
 * .segmentationMode("segmentationMode")
 * .sendDelayMs(123)
 * .sparseTrackType("sparseTrackType")
 * .streamManifestBehavior("streamManifestBehavior")
 * .timestampOffset("timestampOffset")
 * .timestampOffsetMode("timestampOffsetMode")
 * .build())
 * .multiplexGroupSettings(MultiplexGroupSettingsProperty.builder().build())
 * .rtmpGroupSettings(RtmpGroupSettingsProperty.builder()
 * .adMarkers(List.of("adMarkers"))
 * .authenticationScheme("authenticationScheme")
 * .cacheFullBehavior("cacheFullBehavior")
 * .cacheLength(123)
 * .captionData("captionData")
 * .inputLossAction("inputLossAction")
 * .restartDelay(123)
 * .build())
 * .udpGroupSettings(UdpGroupSettingsProperty.builder()
 * .inputLossAction("inputLossAction")
 * .timedMetadataId3Frame("timedMetadataId3Frame")
 * .timedMetadataId3Period(123)
 * .build())
 * .build())
 * .outputs(List.of(OutputProperty.builder()
 * .audioDescriptionNames(List.of("audioDescriptionNames"))
 * .captionDescriptionNames(List.of("captionDescriptionNames"))
 * .outputName("outputName")
 * .outputSettings(OutputSettingsProperty.builder()
 * .archiveOutputSettings(ArchiveOutputSettingsProperty.builder()
 * .containerSettings(ArchiveContainerSettingsProperty.builder()
 * .m2TsSettings(M2tsSettingsProperty.builder()
 * .absentInputAudioBehavior("absentInputAudioBehavior")
 * .arib("arib")
 * .aribCaptionsPid("aribCaptionsPid")
 * .aribCaptionsPidControl("aribCaptionsPidControl")
 * .audioBufferModel("audioBufferModel")
 * .audioFramesPerPes(123)
 * .audioPids("audioPids")
 * .audioStreamType("audioStreamType")
 * .bitrate(123)
 * .bufferModel("bufferModel")
 * .ccDescriptor("ccDescriptor")
 * .dvbNitSettings(DvbNitSettingsProperty.builder()
 * .networkId(123)
 * .networkName("networkName")
 * .repInterval(123)
 * .build())
 * .dvbSdtSettings(DvbSdtSettingsProperty.builder()
 * .outputSdt("outputSdt")
 * .repInterval(123)
 * .serviceName("serviceName")
 * .serviceProviderName("serviceProviderName")
 * .build())
 * .dvbSubPids("dvbSubPids")
 * .dvbTdtSettings(DvbTdtSettingsProperty.builder()
 * .repInterval(123)
 * .build())
 * .dvbTeletextPid("dvbTeletextPid")
 * .ebif("ebif")
 * .ebpAudioInterval("ebpAudioInterval")
 * .ebpLookaheadMs(123)
 * .ebpPlacement("ebpPlacement")
 * .ecmPid("ecmPid")
 * .esRateInPes("esRateInPes")
 * .etvPlatformPid("etvPlatformPid")
 * .etvSignalPid("etvSignalPid")
 * .fragmentTime(123)
 * .klv("klv")
 * .klvDataPids("klvDataPids")
 * .nielsenId3Behavior("nielsenId3Behavior")
 * .nullPacketBitrate(123)
 * .patInterval(123)
 * .pcrControl("pcrControl")
 * .pcrPeriod(123)
 * .pcrPid("pcrPid")
 * .pmtInterval(123)
 * .pmtPid("pmtPid")
 * .programNum(123)
 * .rateMode("rateMode")
 * .scte27Pids("scte27Pids")
 * .scte35Control("scte35Control")
 * .scte35Pid("scte35Pid")
 * .scte35PrerollPullupMilliseconds(123)
 * .segmentationMarkers("segmentationMarkers")
 * .segmentationStyle("segmentationStyle")
 * .segmentationTime(123)
 * .timedMetadataBehavior("timedMetadataBehavior")
 * .timedMetadataPid("timedMetadataPid")
 * .transportStreamId(123)
 * .videoPid("videoPid")
 * .build())
 * .rawSettings(RawSettingsProperty.builder().build())
 * .build())
 * .extension("extension")
 * .nameModifier("nameModifier")
 * .build())
 * .frameCaptureOutputSettings(FrameCaptureOutputSettingsProperty.builder()
 * .nameModifier("nameModifier")
 * .build())
 * .hlsOutputSettings(HlsOutputSettingsProperty.builder()
 * .h265PackagingType("h265PackagingType")
 * .hlsSettings(HlsSettingsProperty.builder()
 * .audioOnlyHlsSettings(AudioOnlyHlsSettingsProperty.builder()
 * .audioGroupId("audioGroupId")
 * .audioOnlyImage(InputLocationProperty.builder()
 * .passwordParam("passwordParam")
 * .uri("uri")
 * .username("username")
 * .build())
 * .audioTrackType("audioTrackType")
 * .segmentType("segmentType")
 * .build())
 * .fmp4HlsSettings(Fmp4HlsSettingsProperty.builder()
 * .audioRenditionSets("audioRenditionSets")
 * .nielsenId3Behavior("nielsenId3Behavior")
 * .timedMetadataBehavior("timedMetadataBehavior")
 * .build())
 * .frameCaptureHlsSettings(FrameCaptureHlsSettingsProperty.builder().build())
 * .standardHlsSettings(StandardHlsSettingsProperty.builder()
 * .audioRenditionSets("audioRenditionSets")
 * .m3U8Settings(M3u8SettingsProperty.builder()
 * .audioFramesPerPes(123)
 * .audioPids("audioPids")
 * .ecmPid("ecmPid")
 * .nielsenId3Behavior("nielsenId3Behavior")
 * .patInterval(123)
 * .pcrControl("pcrControl")
 * .pcrPeriod(123)
 * .pcrPid("pcrPid")
 * .pmtInterval(123)
 * .pmtPid("pmtPid")
 * .programNum(123)
 * .scte35Behavior("scte35Behavior")
 * .scte35Pid("scte35Pid")
 * .timedMetadataBehavior("timedMetadataBehavior")
 * .timedMetadataPid("timedMetadataPid")
 * .transportStreamId(123)
 * .videoPid("videoPid")
 * .build())
 * .build())
 * .build())
 * .nameModifier("nameModifier")
 * .segmentModifier("segmentModifier")
 * .build())
 * .mediaPackageOutputSettings(MediaPackageOutputSettingsProperty.builder().build())
 * .msSmoothOutputSettings(MsSmoothOutputSettingsProperty.builder()
 * .h265PackagingType("h265PackagingType")
 * .nameModifier("nameModifier")
 * .build())
 * .multiplexOutputSettings(MultiplexOutputSettingsProperty.builder()
 * .destination(OutputLocationRefProperty.builder()
 * .destinationRefId("destinationRefId")
 * .build())
 * .build())
 * .rtmpOutputSettings(RtmpOutputSettingsProperty.builder()
 * .certificateMode("certificateMode")
 * .connectionRetryInterval(123)
 * .destination(OutputLocationRefProperty.builder()
 * .destinationRefId("destinationRefId")
 * .build())
 * .numRetries(123)
 * .build())
 * .udpOutputSettings(UdpOutputSettingsProperty.builder()
 * .bufferMsec(123)
 * .containerSettings(UdpContainerSettingsProperty.builder()
 * .m2TsSettings(M2tsSettingsProperty.builder()
 * .absentInputAudioBehavior("absentInputAudioBehavior")
 * .arib("arib")
 * .aribCaptionsPid("aribCaptionsPid")
 * .aribCaptionsPidControl("aribCaptionsPidControl")
 * .audioBufferModel("audioBufferModel")
 * .audioFramesPerPes(123)
 * .audioPids("audioPids")
 * .audioStreamType("audioStreamType")
 * .bitrate(123)
 * .bufferModel("bufferModel")
 * .ccDescriptor("ccDescriptor")
 * .dvbNitSettings(DvbNitSettingsProperty.builder()
 * .networkId(123)
 * .networkName("networkName")
 * .repInterval(123)
 * .build())
 * .dvbSdtSettings(DvbSdtSettingsProperty.builder()
 * .outputSdt("outputSdt")
 * .repInterval(123)
 * .serviceName("serviceName")
 * .serviceProviderName("serviceProviderName")
 * .build())
 * .dvbSubPids("dvbSubPids")
 * .dvbTdtSettings(DvbTdtSettingsProperty.builder()
 * .repInterval(123)
 * .build())
 * .dvbTeletextPid("dvbTeletextPid")
 * .ebif("ebif")
 * .ebpAudioInterval("ebpAudioInterval")
 * .ebpLookaheadMs(123)
 * .ebpPlacement("ebpPlacement")
 * .ecmPid("ecmPid")
 * .esRateInPes("esRateInPes")
 * .etvPlatformPid("etvPlatformPid")
 * .etvSignalPid("etvSignalPid")
 * .fragmentTime(123)
 * .klv("klv")
 * .klvDataPids("klvDataPids")
 * .nielsenId3Behavior("nielsenId3Behavior")
 * .nullPacketBitrate(123)
 * .patInterval(123)
 * .pcrControl("pcrControl")
 * .pcrPeriod(123)
 * .pcrPid("pcrPid")
 * .pmtInterval(123)
 * .pmtPid("pmtPid")
 * .programNum(123)
 * .rateMode("rateMode")
 * .scte27Pids("scte27Pids")
 * .scte35Control("scte35Control")
 * .scte35Pid("scte35Pid")
 * .scte35PrerollPullupMilliseconds(123)
 * .segmentationMarkers("segmentationMarkers")
 * .segmentationStyle("segmentationStyle")
 * .segmentationTime(123)
 * .timedMetadataBehavior("timedMetadataBehavior")
 * .timedMetadataPid("timedMetadataPid")
 * .transportStreamId(123)
 * .videoPid("videoPid")
 * .build())
 * .build())
 * .destination(OutputLocationRefProperty.builder()
 * .destinationRefId("destinationRefId")
 * .build())
 * .fecOutputSettings(FecOutputSettingsProperty.builder()
 * .columnDepth(123)
 * .includeFec("includeFec")
 * .rowLength(123)
 * .build())
 * .build())
 * .build())
 * .videoDescriptionName("videoDescriptionName")
 * .build()))
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-medialive-channel-outputgroup.html)
 */
@CdkDslMarker
public class CfnChannelOutputGroupPropertyDsl {
  private val cdkBuilder: CfnChannel.OutputGroupProperty.Builder =
      CfnChannel.OutputGroupProperty.builder()

  private val _outputs: MutableList<Any> = mutableListOf()

  /**
   * @param name A custom output group name that you can optionally define.
   * Only letters, numbers, and the underscore character are allowed. The maximum length is 32
   * characters.
   */
  public fun name(name: String) {
    cdkBuilder.name(name)
  }

  /**
   * @param outputGroupSettings The settings associated with the output group.
   */
  public fun outputGroupSettings(outputGroupSettings: IResolvable) {
    cdkBuilder.outputGroupSettings(outputGroupSettings)
  }

  /**
   * @param outputGroupSettings The settings associated with the output group.
   */
  public fun outputGroupSettings(outputGroupSettings: CfnChannel.OutputGroupSettingsProperty) {
    cdkBuilder.outputGroupSettings(outputGroupSettings)
  }

  /**
   * @param outputs The settings for the outputs in the output group.
   */
  public fun outputs(vararg outputs: Any) {
    _outputs.addAll(listOf(*outputs))
  }

  /**
   * @param outputs The settings for the outputs in the output group.
   */
  public fun outputs(outputs: Collection<Any>) {
    _outputs.addAll(outputs)
  }

  /**
   * @param outputs The settings for the outputs in the output group.
   */
  public fun outputs(outputs: IResolvable) {
    cdkBuilder.outputs(outputs)
  }

  public fun build(): CfnChannel.OutputGroupProperty {
    if(_outputs.isNotEmpty()) cdkBuilder.outputs(_outputs)
    return cdkBuilder.build()
  }
}
