@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.mediatailor

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.services.mediatailor.CfnPlaybackConfiguration

/**
 * The configuration for DASH content.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediatailor.*;
 * DashConfigurationProperty dashConfigurationProperty = DashConfigurationProperty.builder()
 * .manifestEndpointPrefix("manifestEndpointPrefix")
 * .mpdLocation("mpdLocation")
 * .originManifestType("originManifestType")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediatailor-playbackconfiguration-dashconfiguration.html)
 */
@CdkDslMarker
public class CfnPlaybackConfigurationDashConfigurationPropertyDsl {
  private val cdkBuilder: CfnPlaybackConfiguration.DashConfigurationProperty.Builder =
      CfnPlaybackConfiguration.DashConfigurationProperty.builder()

  /**
   * @param manifestEndpointPrefix The URL generated by MediaTailor to initiate a playback session.
   * The session uses server-side reporting. This setting is ignored in PUT operations.
   */
  public fun manifestEndpointPrefix(manifestEndpointPrefix: String) {
    cdkBuilder.manifestEndpointPrefix(manifestEndpointPrefix)
  }

  /**
   * @param mpdLocation The setting that controls whether MediaTailor includes the Location tag in
   * DASH manifests.
   * MediaTailor populates the Location tag with the URL for manifest update requests, to be used by
   * players that don't support sticky redirects. Disable this if you have CDN routing rules set up for
   * accessing MediaTailor manifests, and you are either using client-side reporting or your players
   * support sticky HTTP redirects. Valid values are `DISABLED` and `EMT_DEFAULT` . The `EMT_DEFAULT`
   * setting enables the inclusion of the tag and is the default value.
   */
  public fun mpdLocation(mpdLocation: String) {
    cdkBuilder.mpdLocation(mpdLocation)
  }

  /**
   * @param originManifestType The setting that controls whether MediaTailor handles manifests from
   * the origin server as multi-period manifests or single-period manifests.
   * If your origin server produces single-period manifests, set this to `SINGLE_PERIOD` . The
   * default setting is `MULTI_PERIOD` . For multi-period manifests, omit this setting or set it to
   * `MULTI_PERIOD` .
   */
  public fun originManifestType(originManifestType: String) {
    cdkBuilder.originManifestType(originManifestType)
  }

  public fun build(): CfnPlaybackConfiguration.DashConfigurationProperty = cdkBuilder.build()
}
