@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.personalize

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.services.personalize.CfnDataset

/**
 * The Amazon S3 bucket that contains the training data to import.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.personalize.*;
 * DataSourceProperty dataSourceProperty = DataSourceProperty.builder()
 * .dataLocation("dataLocation")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-personalize-dataset-datasource.html)
 */
@CdkDslMarker
public class CfnDatasetDataSourcePropertyDsl {
  private val cdkBuilder: CfnDataset.DataSourceProperty.Builder =
      CfnDataset.DataSourceProperty.builder()

  /**
   * @param dataLocation The path to the Amazon S3 bucket where the data that you want to upload to
   * your dataset is stored.
   */
  public fun dataLocation(dataLocation: String) {
    cdkBuilder.dataLocation(dataLocation)
  }

  public fun build(): CfnDataset.DataSourceProperty = cdkBuilder.build()
}
