@file:Suppress("RedundantVisibilityModifier", "RedundantUnitReturnType", "RemoveRedundantQualifierName", "unused", "UnusedImport", "ClassName", "REDUNDANT_PROJECTION", "DEPRECATION")

package cloudshift.awscdk.dsl.services.quicksight

import cloudshift.awscdk.common.CdkDslMarker
import software.amazon.awscdk.IResolvable
import software.amazon.awscdk.services.quicksight.CfnAnalysis
import kotlin.String

/**
 * The options for a paper canvas of a section-based layout.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * SectionBasedLayoutPaperCanvasSizeOptionsProperty sectionBasedLayoutPaperCanvasSizeOptionsProperty
 * = SectionBasedLayoutPaperCanvasSizeOptionsProperty.builder()
 * .paperMargin(SpacingProperty.builder()
 * .bottom("bottom")
 * .left("left")
 * .right("right")
 * .top("top")
 * .build())
 * .paperOrientation("paperOrientation")
 * .paperSize("paperSize")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutpapercanvassizeoptions.html)
 */
@CdkDslMarker
public class CfnAnalysisSectionBasedLayoutPaperCanvasSizeOptionsPropertyDsl {
    private val cdkBuilder: CfnAnalysis.SectionBasedLayoutPaperCanvasSizeOptionsProperty.Builder =
        CfnAnalysis.SectionBasedLayoutPaperCanvasSizeOptionsProperty.builder()

    /**
     * @param paperMargin Defines the spacing between the canvas content and the top, bottom, left,
     * and right edges.
     */
    public fun paperMargin(paperMargin: IResolvable) {
        cdkBuilder.paperMargin(paperMargin)
    }

    /**
     * @param paperMargin Defines the spacing between the canvas content and the top, bottom, left,
     * and right edges.
     */
    public fun paperMargin(paperMargin: CfnAnalysis.SpacingProperty) {
        cdkBuilder.paperMargin(paperMargin)
    }

    /**
     * @param paperOrientation The paper orientation that is used to define canvas dimensions. Choose
     * one of the following options:.
     * * PORTRAIT
     * * LANDSCAPE
     */
    public fun paperOrientation(paperOrientation: String) {
        cdkBuilder.paperOrientation(paperOrientation)
    }

    /**
     * @param paperSize The paper size that is used to define canvas dimensions.
     */
    public fun paperSize(paperSize: String) {
        cdkBuilder.paperSize(paperSize)
    }

    public fun build(): CfnAnalysis.SectionBasedLayoutPaperCanvasSizeOptionsProperty = cdkBuilder.build()
}
