@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.quicksight

import kotlin.String
import kotlin.Unit
import software.amazon.awscdk.services.quicksight.CfnAnalysis
import software.amazon.awscdk.services.quicksight.CfnAnalysisProps
import software.amazon.awscdk.services.quicksight.CfnDashboard
import software.amazon.awscdk.services.quicksight.CfnDashboardProps
import software.amazon.awscdk.services.quicksight.CfnDataSet
import software.amazon.awscdk.services.quicksight.CfnDataSetProps
import software.amazon.awscdk.services.quicksight.CfnDataSource
import software.amazon.awscdk.services.quicksight.CfnDataSourceProps
import software.amazon.awscdk.services.quicksight.CfnRefreshSchedule
import software.amazon.awscdk.services.quicksight.CfnRefreshScheduleProps
import software.amazon.awscdk.services.quicksight.CfnTemplate
import software.amazon.awscdk.services.quicksight.CfnTemplateProps
import software.amazon.awscdk.services.quicksight.CfnTheme
import software.amazon.awscdk.services.quicksight.CfnThemeProps
import software.amazon.awscdk.services.quicksight.CfnTopic
import software.amazon.awscdk.services.quicksight.CfnTopicProps
import software.amazon.awscdk.services.quicksight.CfnVPCConnection
import software.amazon.awscdk.services.quicksight.CfnVPCConnectionProps
import software.constructs.Construct

public object quicksight {
  /**
   * Creates an analysis in Amazon QuickSight.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html)
   */
  public inline fun cfnAnalysis(
    scope: Construct,
    id: String,
    block: CfnAnalysisDsl.() -> Unit = {},
  ): CfnAnalysis {
    val builder = CfnAnalysisDsl(scope, id)
    builder.apply(block)
    return builder.build()
  }

  /**
   * An aggregation function aggregates values from a dimension or measure.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * AggregationFunctionProperty aggregationFunctionProperty = AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationfunction.html)
   */
  public inline
      fun cfnAnalysisAggregationFunctionProperty(block: CfnAnalysisAggregationFunctionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.AggregationFunctionProperty {
    val builder = CfnAnalysisAggregationFunctionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration options to sort aggregated values.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * AggregationSortConfigurationProperty aggregationSortConfigurationProperty =
   * AggregationSortConfigurationProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sortDirection("sortDirection")
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-aggregationsortconfiguration.html)
   */
  public inline
      fun cfnAnalysisAggregationSortConfigurationProperty(block: CfnAnalysisAggregationSortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.AggregationSortConfigurationProperty {
    val builder = CfnAnalysisAggregationSortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration for default analysis settings.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * AnalysisDefaultsProperty analysisDefaultsProperty = AnalysisDefaultsProperty.builder()
   * .defaultNewSheetConfiguration(DefaultNewSheetConfigurationProperty.builder()
   * .interactiveLayoutConfiguration(DefaultInteractiveLayoutConfigurationProperty.builder()
   * .freeForm(DefaultFreeFormLayoutConfigurationProperty.builder()
   * .canvasSizeOptions(FreeFormLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(FreeFormLayoutScreenCanvasSizeOptionsProperty.builder()
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build())
   * .grid(DefaultGridLayoutConfigurationProperty.builder()
   * .canvasSizeOptions(GridLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptionsProperty.builder()
   * .resizeOption("resizeOption")
   * // the properties below are optional
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build())
   * .build())
   * .paginatedLayoutConfiguration(DefaultPaginatedLayoutConfigurationProperty.builder()
   * .sectionBased(DefaultSectionBasedLayoutConfigurationProperty.builder()
   * .canvasSizeOptions(SectionBasedLayoutCanvasSizeOptionsProperty.builder()
   * .paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptionsProperty.builder()
   * .paperMargin(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .paperOrientation("paperOrientation")
   * .paperSize("paperSize")
   * .build())
   * .build())
   * .build())
   * .build())
   * .sheetContentType("sheetContentType")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefaults.html)
   */
  public inline
      fun cfnAnalysisAnalysisDefaultsProperty(block: CfnAnalysisAnalysisDefaultsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.AnalysisDefaultsProperty {
    val builder = CfnAnalysisAnalysisDefaultsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The definition of an analysis.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysisdefinition.html)
   */
  public inline
      fun cfnAnalysisAnalysisDefinitionProperty(block: CfnAnalysisAnalysisDefinitionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.AnalysisDefinitionProperty {
    val builder = CfnAnalysisAnalysisDefinitionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Analysis error.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * AnalysisErrorProperty analysisErrorProperty = AnalysisErrorProperty.builder()
   * .message("message")
   * .type("type")
   * .violatedEntities(List.of(EntityProperty.builder()
   * .path("path")
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysiserror.html)
   */
  public inline
      fun cfnAnalysisAnalysisErrorProperty(block: CfnAnalysisAnalysisErrorPropertyDsl.() -> Unit =
      {}): CfnAnalysis.AnalysisErrorProperty {
    val builder = CfnAnalysisAnalysisErrorPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The source entity of an analysis.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * AnalysisSourceEntityProperty analysisSourceEntityProperty =
   * AnalysisSourceEntityProperty.builder()
   * .sourceTemplate(AnalysisSourceTemplateProperty.builder()
   * .arn("arn")
   * .dataSetReferences(List.of(DataSetReferenceProperty.builder()
   * .dataSetArn("dataSetArn")
   * .dataSetPlaceholder("dataSetPlaceholder")
   * .build()))
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourceentity.html)
   */
  public inline
      fun cfnAnalysisAnalysisSourceEntityProperty(block: CfnAnalysisAnalysisSourceEntityPropertyDsl.() -> Unit
      = {}): CfnAnalysis.AnalysisSourceEntityProperty {
    val builder = CfnAnalysisAnalysisSourceEntityPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The source template of an analysis.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * AnalysisSourceTemplateProperty analysisSourceTemplateProperty =
   * AnalysisSourceTemplateProperty.builder()
   * .arn("arn")
   * .dataSetReferences(List.of(DataSetReferenceProperty.builder()
   * .dataSetArn("dataSetArn")
   * .dataSetPlaceholder("dataSetPlaceholder")
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-analysissourcetemplate.html)
   */
  public inline
      fun cfnAnalysisAnalysisSourceTemplateProperty(block: CfnAnalysisAnalysisSourceTemplatePropertyDsl.() -> Unit
      = {}): CfnAnalysis.AnalysisSourceTemplateProperty {
    val builder = CfnAnalysisAnalysisSourceTemplatePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The date configuration of the filter.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * AnchorDateConfigurationProperty anchorDateConfigurationProperty =
   * AnchorDateConfigurationProperty.builder()
   * .anchorOption("anchorOption")
   * .parameterName("parameterName")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-anchordateconfiguration.html)
   */
  public inline
      fun cfnAnalysisAnchorDateConfigurationProperty(block: CfnAnalysisAnchorDateConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.AnchorDateConfigurationProperty {
    val builder = CfnAnalysisAnchorDateConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The arc axis configuration of a `GaugeChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ArcAxisConfigurationProperty arcAxisConfigurationProperty =
   * ArcAxisConfigurationProperty.builder()
   * .range(ArcAxisDisplayRangeProperty.builder()
   * .max(123)
   * .min(123)
   * .build())
   * .reserveRange(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisconfiguration.html)
   */
  public inline
      fun cfnAnalysisArcAxisConfigurationProperty(block: CfnAnalysisArcAxisConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ArcAxisConfigurationProperty {
    val builder = CfnAnalysisArcAxisConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The arc axis range of a `GaugeChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ArcAxisDisplayRangeProperty arcAxisDisplayRangeProperty = ArcAxisDisplayRangeProperty.builder()
   * .max(123)
   * .min(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcaxisdisplayrange.html)
   */
  public inline
      fun cfnAnalysisArcAxisDisplayRangeProperty(block: CfnAnalysisArcAxisDisplayRangePropertyDsl.() -> Unit
      = {}): CfnAnalysis.ArcAxisDisplayRangeProperty {
    val builder = CfnAnalysisArcAxisDisplayRangePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The arc configuration of a `GaugeChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ArcConfigurationProperty arcConfigurationProperty = ArcConfigurationProperty.builder()
   * .arcAngle(123)
   * .arcThickness("arcThickness")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcconfiguration.html)
   */
  public inline
      fun cfnAnalysisArcConfigurationProperty(block: CfnAnalysisArcConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ArcConfigurationProperty {
    val builder = CfnAnalysisArcConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the arc thickness of a `GaugeChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ArcOptionsProperty arcOptionsProperty = ArcOptionsProperty.builder()
   * .arcThickness("arcThickness")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-arcoptions.html)
   */
  public inline fun cfnAnalysisArcOptionsProperty(block: CfnAnalysisArcOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ArcOptionsProperty {
    val builder = CfnAnalysisArcOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The data options for an axis.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * Object dataDriven;
   * AxisDataOptionsProperty axisDataOptionsProperty = AxisDataOptionsProperty.builder()
   * .dateAxisOptions(DateAxisOptionsProperty.builder()
   * .missingDateVisibility("missingDateVisibility")
   * .build())
   * .numericAxisOptions(NumericAxisOptionsProperty.builder()
   * .range(AxisDisplayRangeProperty.builder()
   * .dataDriven(dataDriven)
   * .minMax(AxisDisplayMinMaxRangeProperty.builder()
   * .maximum(123)
   * .minimum(123)
   * .build())
   * .build())
   * .scale(AxisScaleProperty.builder()
   * .linear(AxisLinearScaleProperty.builder()
   * .stepCount(123)
   * .stepSize(123)
   * .build())
   * .logarithmic(AxisLogarithmicScaleProperty.builder()
   * .base(123)
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdataoptions.html)
   */
  public inline
      fun cfnAnalysisAxisDataOptionsProperty(block: CfnAnalysisAxisDataOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.AxisDataOptionsProperty {
    val builder = CfnAnalysisAxisDataOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The minimum and maximum setup for an axis display range.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * AxisDisplayMinMaxRangeProperty axisDisplayMinMaxRangeProperty =
   * AxisDisplayMinMaxRangeProperty.builder()
   * .maximum(123)
   * .minimum(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayminmaxrange.html)
   */
  public inline
      fun cfnAnalysisAxisDisplayMinMaxRangeProperty(block: CfnAnalysisAxisDisplayMinMaxRangePropertyDsl.() -> Unit
      = {}): CfnAnalysis.AxisDisplayMinMaxRangeProperty {
    val builder = CfnAnalysisAxisDisplayMinMaxRangePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The display options for the axis label.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * Object dataDriven;
   * AxisDisplayOptionsProperty axisDisplayOptionsProperty = AxisDisplayOptionsProperty.builder()
   * .axisLineVisibility("axisLineVisibility")
   * .axisOffset("axisOffset")
   * .dataOptions(AxisDataOptionsProperty.builder()
   * .dateAxisOptions(DateAxisOptionsProperty.builder()
   * .missingDateVisibility("missingDateVisibility")
   * .build())
   * .numericAxisOptions(NumericAxisOptionsProperty.builder()
   * .range(AxisDisplayRangeProperty.builder()
   * .dataDriven(dataDriven)
   * .minMax(AxisDisplayMinMaxRangeProperty.builder()
   * .maximum(123)
   * .minimum(123)
   * .build())
   * .build())
   * .scale(AxisScaleProperty.builder()
   * .linear(AxisLinearScaleProperty.builder()
   * .stepCount(123)
   * .stepSize(123)
   * .build())
   * .logarithmic(AxisLogarithmicScaleProperty.builder()
   * .base(123)
   * .build())
   * .build())
   * .build())
   * .build())
   * .gridLineVisibility("gridLineVisibility")
   * .scrollbarOptions(ScrollBarOptionsProperty.builder()
   * .visibility("visibility")
   * .visibleRange(VisibleRangeOptionsProperty.builder()
   * .percentRange(PercentVisibleRangeProperty.builder()
   * .from(123)
   * .to(123)
   * .build())
   * .build())
   * .build())
   * .tickLabelOptions(AxisTickLabelOptionsProperty.builder()
   * .labelOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .rotationAngle(123)
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayoptions.html)
   */
  public inline
      fun cfnAnalysisAxisDisplayOptionsProperty(block: CfnAnalysisAxisDisplayOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.AxisDisplayOptionsProperty {
    val builder = CfnAnalysisAxisDisplayOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The range setup of a numeric axis display range.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * Object dataDriven;
   * AxisDisplayRangeProperty axisDisplayRangeProperty = AxisDisplayRangeProperty.builder()
   * .dataDriven(dataDriven)
   * .minMax(AxisDisplayMinMaxRangeProperty.builder()
   * .maximum(123)
   * .minimum(123)
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisdisplayrange.html)
   */
  public inline
      fun cfnAnalysisAxisDisplayRangeProperty(block: CfnAnalysisAxisDisplayRangePropertyDsl.() -> Unit
      = {}): CfnAnalysis.AxisDisplayRangeProperty {
    val builder = CfnAnalysisAxisDisplayRangePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The label options for a chart axis.
   *
   * You must specify the field that the label is targeted to.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * AxisLabelOptionsProperty axisLabelOptionsProperty = AxisLabelOptionsProperty.builder()
   * .applyTo(AxisLabelReferenceOptionsProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * .build())
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabeloptions.html)
   */
  public inline
      fun cfnAnalysisAxisLabelOptionsProperty(block: CfnAnalysisAxisLabelOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.AxisLabelOptionsProperty {
    val builder = CfnAnalysisAxisLabelOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The reference that specifies where the axis label is applied to.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * AxisLabelReferenceOptionsProperty axisLabelReferenceOptionsProperty =
   * AxisLabelReferenceOptionsProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislabelreferenceoptions.html)
   */
  public inline
      fun cfnAnalysisAxisLabelReferenceOptionsProperty(block: CfnAnalysisAxisLabelReferenceOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.AxisLabelReferenceOptionsProperty {
    val builder = CfnAnalysisAxisLabelReferenceOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The liner axis scale setup.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * AxisLinearScaleProperty axisLinearScaleProperty = AxisLinearScaleProperty.builder()
   * .stepCount(123)
   * .stepSize(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislinearscale.html)
   */
  public inline
      fun cfnAnalysisAxisLinearScaleProperty(block: CfnAnalysisAxisLinearScalePropertyDsl.() -> Unit
      = {}): CfnAnalysis.AxisLinearScaleProperty {
    val builder = CfnAnalysisAxisLinearScalePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The logarithmic axis scale setup.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * AxisLogarithmicScaleProperty axisLogarithmicScaleProperty =
   * AxisLogarithmicScaleProperty.builder()
   * .base(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axislogarithmicscale.html)
   */
  public inline
      fun cfnAnalysisAxisLogarithmicScaleProperty(block: CfnAnalysisAxisLogarithmicScalePropertyDsl.() -> Unit
      = {}): CfnAnalysis.AxisLogarithmicScaleProperty {
    val builder = CfnAnalysisAxisLogarithmicScalePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The scale setup options for a numeric axis display.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * AxisScaleProperty axisScaleProperty = AxisScaleProperty.builder()
   * .linear(AxisLinearScaleProperty.builder()
   * .stepCount(123)
   * .stepSize(123)
   * .build())
   * .logarithmic(AxisLogarithmicScaleProperty.builder()
   * .base(123)
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisscale.html)
   */
  public inline fun cfnAnalysisAxisScaleProperty(block: CfnAnalysisAxisScalePropertyDsl.() -> Unit =
      {}): CfnAnalysis.AxisScaleProperty {
    val builder = CfnAnalysisAxisScalePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The tick label options of an axis.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * AxisTickLabelOptionsProperty axisTickLabelOptionsProperty =
   * AxisTickLabelOptionsProperty.builder()
   * .labelOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .rotationAngle(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-axisticklabeloptions.html)
   */
  public inline
      fun cfnAnalysisAxisTickLabelOptionsProperty(block: CfnAnalysisAxisTickLabelOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.AxisTickLabelOptionsProperty {
    val builder = CfnAnalysisAxisTickLabelOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The aggregated field wells of a bar chart.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisBarChartAggregatedFieldWellsProperty(block: CfnAnalysisBarChartAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.BarChartAggregatedFieldWellsProperty {
    val builder = CfnAnalysisBarChartAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a `BarChartVisual` .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartconfiguration.html)
   */
  public inline
      fun cfnAnalysisBarChartConfigurationProperty(block: CfnAnalysisBarChartConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.BarChartConfigurationProperty {
    val builder = CfnAnalysisBarChartConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field wells of a `BarChartVisual` .
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartfieldwells.html)
   */
  public inline
      fun cfnAnalysisBarChartFieldWellsProperty(block: CfnAnalysisBarChartFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.BarChartFieldWellsProperty {
    val builder = CfnAnalysisBarChartFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * sort-configuration-description.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * BarChartSortConfigurationProperty barChartSortConfigurationProperty =
   * BarChartSortConfigurationProperty.builder()
   * .categoryItemsLimit(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .categorySort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .colorItemsLimit(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .colorSort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .smallMultiplesLimitConfiguration(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .smallMultiplesSort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartsortconfiguration.html)
   */
  public inline
      fun cfnAnalysisBarChartSortConfigurationProperty(block: CfnAnalysisBarChartSortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.BarChartSortConfigurationProperty {
    val builder = CfnAnalysisBarChartSortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A bar chart.
   *
   * The `BarChartVisual` structure describes a visual that is a member of the bar chart family. The
   * following charts can be described using this structure:
   *
   * * Horizontal bar chart
   * * Vertical bar chart
   * * Horizontal stacked bar chart
   * * Vertical stacked bar chart
   * * Horizontal stacked 100% bar chart
   * * Vertical stacked 100% bar chart
   *
   * For more information, see [Using bar
   * charts](https://docs.aws.amazon.com/quicksight/latest/user/bar-charts.html) in the *Amazon
   * QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-barchartvisual.html)
   */
  public inline
      fun cfnAnalysisBarChartVisualProperty(block: CfnAnalysisBarChartVisualPropertyDsl.() -> Unit =
      {}): CfnAnalysis.BarChartVisualProperty {
    val builder = CfnAnalysisBarChartVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the bin count of a histogram.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * BinCountOptionsProperty binCountOptionsProperty = BinCountOptionsProperty.builder()
   * .value(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bincountoptions.html)
   */
  public inline
      fun cfnAnalysisBinCountOptionsProperty(block: CfnAnalysisBinCountOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.BinCountOptionsProperty {
    val builder = CfnAnalysisBinCountOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the bin width of a histogram.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * BinWidthOptionsProperty binWidthOptionsProperty = BinWidthOptionsProperty.builder()
   * .binCountLimit(123)
   * .value(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-binwidthoptions.html)
   */
  public inline
      fun cfnAnalysisBinWidthOptionsProperty(block: CfnAnalysisBinWidthOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.BinWidthOptionsProperty {
    val builder = CfnAnalysisBinWidthOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a body section.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * BodySectionConfigurationProperty bodySectionConfigurationProperty =
   * BodySectionConfigurationProperty.builder()
   * .content(BodySectionContentProperty.builder()
   * .layout(SectionLayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * .build())
   * .build())
   * .build())
   * .sectionId("sectionId")
   * // the properties below are optional
   * .pageBreakConfiguration(SectionPageBreakConfigurationProperty.builder()
   * .after(SectionAfterPageBreakProperty.builder()
   * .status("status")
   * .build())
   * .build())
   * .style(SectionStyleProperty.builder()
   * .height("height")
   * .padding(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectionconfiguration.html)
   */
  public inline
      fun cfnAnalysisBodySectionConfigurationProperty(block: CfnAnalysisBodySectionConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.BodySectionConfigurationProperty {
    val builder = CfnAnalysisBodySectionConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of content in a body section.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * BodySectionContentProperty bodySectionContentProperty = BodySectionContentProperty.builder()
   * .layout(SectionLayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-bodysectioncontent.html)
   */
  public inline
      fun cfnAnalysisBodySectionContentProperty(block: CfnAnalysisBodySectionContentPropertyDsl.() -> Unit
      = {}): CfnAnalysis.BodySectionContentProperty {
    val builder = CfnAnalysisBodySectionContentPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The aggregated field well for a box plot.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * BoxPlotAggregatedFieldWellsProperty boxPlotAggregatedFieldWellsProperty =
   * BoxPlotAggregatedFieldWellsProperty.builder()
   * .groupBy(List.of(DimensionFieldProperty.builder()
   * .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .dateDimensionField(DateDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .dateGranularity("dateGranularity")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .numericalDimensionField(NumericalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .build()))
   * .values(List.of(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisBoxPlotAggregatedFieldWellsProperty(block: CfnAnalysisBoxPlotAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.BoxPlotAggregatedFieldWellsProperty {
    val builder = CfnAnalysisBoxPlotAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a `BoxPlotVisual` .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotchartconfiguration.html)
   */
  public inline
      fun cfnAnalysisBoxPlotChartConfigurationProperty(block: CfnAnalysisBoxPlotChartConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.BoxPlotChartConfigurationProperty {
    val builder = CfnAnalysisBoxPlotChartConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field wells of a `BoxPlotVisual` .
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * BoxPlotFieldWellsProperty boxPlotFieldWellsProperty = BoxPlotFieldWellsProperty.builder()
   * .boxPlotAggregatedFieldWells(BoxPlotAggregatedFieldWellsProperty.builder()
   * .groupBy(List.of(DimensionFieldProperty.builder()
   * .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .dateDimensionField(DateDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .dateGranularity("dateGranularity")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .numericalDimensionField(NumericalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .build()))
   * .values(List.of(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotfieldwells.html)
   */
  public inline
      fun cfnAnalysisBoxPlotFieldWellsProperty(block: CfnAnalysisBoxPlotFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.BoxPlotFieldWellsProperty {
    val builder = CfnAnalysisBoxPlotFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options of a box plot visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * BoxPlotOptionsProperty boxPlotOptionsProperty = BoxPlotOptionsProperty.builder()
   * .allDataPointsVisibility("allDataPointsVisibility")
   * .outlierVisibility("outlierVisibility")
   * .styleOptions(BoxPlotStyleOptionsProperty.builder()
   * .fillStyle("fillStyle")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotoptions.html)
   */
  public inline
      fun cfnAnalysisBoxPlotOptionsProperty(block: CfnAnalysisBoxPlotOptionsPropertyDsl.() -> Unit =
      {}): CfnAnalysis.BoxPlotOptionsProperty {
    val builder = CfnAnalysisBoxPlotOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration of a `BoxPlotVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * BoxPlotSortConfigurationProperty boxPlotSortConfigurationProperty =
   * BoxPlotSortConfigurationProperty.builder()
   * .categorySort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .paginationConfiguration(PaginationConfigurationProperty.builder()
   * .pageNumber(123)
   * .pageSize(123)
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotsortconfiguration.html)
   */
  public inline
      fun cfnAnalysisBoxPlotSortConfigurationProperty(block: CfnAnalysisBoxPlotSortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.BoxPlotSortConfigurationProperty {
    val builder = CfnAnalysisBoxPlotSortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The style options of the box plot.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * BoxPlotStyleOptionsProperty boxPlotStyleOptionsProperty = BoxPlotStyleOptionsProperty.builder()
   * .fillStyle("fillStyle")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotstyleoptions.html)
   */
  public inline
      fun cfnAnalysisBoxPlotStyleOptionsProperty(block: CfnAnalysisBoxPlotStyleOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.BoxPlotStyleOptionsProperty {
    val builder = CfnAnalysisBoxPlotStyleOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A box plot.
   *
   * For more information, see [Using box
   * plots](https://docs.aws.amazon.com/quicksight/latest/user/box-plots.html) in the *Amazon
   * QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-boxplotvisual.html)
   */
  public inline
      fun cfnAnalysisBoxPlotVisualProperty(block: CfnAnalysisBoxPlotVisualPropertyDsl.() -> Unit =
      {}): CfnAnalysis.BoxPlotVisualProperty {
    val builder = CfnAnalysisBoxPlotVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The calculated field of an analysis.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CalculatedFieldProperty calculatedFieldProperty = CalculatedFieldProperty.builder()
   * .dataSetIdentifier("dataSetIdentifier")
   * .expression("expression")
   * .name("name")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedfield.html)
   */
  public inline
      fun cfnAnalysisCalculatedFieldProperty(block: CfnAnalysisCalculatedFieldPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CalculatedFieldProperty {
    val builder = CfnAnalysisCalculatedFieldPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The table calculation measure field for pivot tables.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CalculatedMeasureFieldProperty calculatedMeasureFieldProperty =
   * CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-calculatedmeasurefield.html)
   */
  public inline
      fun cfnAnalysisCalculatedMeasureFieldProperty(block: CfnAnalysisCalculatedMeasureFieldPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CalculatedMeasureFieldProperty {
    val builder = CfnAnalysisCalculatedMeasureFieldPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The values that are displayed in a control can be configured to only show values that are valid
   * based on what's selected in other controls.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CascadingControlConfigurationProperty cascadingControlConfigurationProperty =
   * CascadingControlConfigurationProperty.builder()
   * .sourceControls(List.of(CascadingControlSourceProperty.builder()
   * .columnToMatch(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceSheetControlId("sourceSheetControlId")
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolconfiguration.html)
   */
  public inline
      fun cfnAnalysisCascadingControlConfigurationProperty(block: CfnAnalysisCascadingControlConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CascadingControlConfigurationProperty {
    val builder = CfnAnalysisCascadingControlConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The source controls that are used in a `CascadingControlConfiguration` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CascadingControlSourceProperty cascadingControlSourceProperty =
   * CascadingControlSourceProperty.builder()
   * .columnToMatch(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceSheetControlId("sourceSheetControlId")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-cascadingcontrolsource.html)
   */
  public inline
      fun cfnAnalysisCascadingControlSourceProperty(block: CfnAnalysisCascadingControlSourcePropertyDsl.() -> Unit
      = {}): CfnAnalysis.CascadingControlSourceProperty {
    val builder = CfnAnalysisCascadingControlSourcePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The dimension type field with categorical type columns..
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CategoricalDimensionFieldProperty categoricalDimensionFieldProperty =
   * CategoricalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricaldimensionfield.html)
   */
  public inline
      fun cfnAnalysisCategoricalDimensionFieldProperty(block: CfnAnalysisCategoricalDimensionFieldPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CategoricalDimensionFieldProperty {
    val builder = CfnAnalysisCategoricalDimensionFieldPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The measure type field with categorical type columns.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CategoricalMeasureFieldProperty categoricalMeasureFieldProperty =
   * CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoricalmeasurefield.html)
   */
  public inline
      fun cfnAnalysisCategoricalMeasureFieldProperty(block: CfnAnalysisCategoricalMeasureFieldPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CategoricalMeasureFieldProperty {
    val builder = CfnAnalysisCategoricalMeasureFieldPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The numeric equality type drill down filter.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CategoryDrillDownFilterProperty categoryDrillDownFilterProperty =
   * CategoryDrillDownFilterProperty.builder()
   * .categoryValues(List.of("categoryValues"))
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categorydrilldownfilter.html)
   */
  public inline
      fun cfnAnalysisCategoryDrillDownFilterProperty(block: CfnAnalysisCategoryDrillDownFilterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CategoryDrillDownFilterProperty {
    val builder = CfnAnalysisCategoryDrillDownFilterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration for a `CategoryFilter` .
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CategoryFilterConfigurationProperty categoryFilterConfigurationProperty =
   * CategoryFilterConfigurationProperty.builder()
   * .customFilterConfiguration(CustomFilterConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .categoryValue("categoryValue")
   * .parameterName("parameterName")
   * .selectAllOptions("selectAllOptions")
   * .build())
   * .customFilterListConfiguration(CustomFilterListConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .categoryValues(List.of("categoryValues"))
   * .selectAllOptions("selectAllOptions")
   * .build())
   * .filterListConfiguration(FilterListConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * // the properties below are optional
   * .categoryValues(List.of("categoryValues"))
   * .selectAllOptions("selectAllOptions")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilterconfiguration.html)
   */
  public inline
      fun cfnAnalysisCategoryFilterConfigurationProperty(block: CfnAnalysisCategoryFilterConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CategoryFilterConfigurationProperty {
    val builder = CfnAnalysisCategoryFilterConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A `CategoryFilter` filters text values.
   *
   * For more information, see [Adding text
   * filters](https://docs.aws.amazon.com/quicksight/latest/user/add-a-text-filter-data-prep.html) in
   * the *Amazon QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CategoryFilterProperty categoryFilterProperty = CategoryFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .configuration(CategoryFilterConfigurationProperty.builder()
   * .customFilterConfiguration(CustomFilterConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .categoryValue("categoryValue")
   * .parameterName("parameterName")
   * .selectAllOptions("selectAllOptions")
   * .build())
   * .customFilterListConfiguration(CustomFilterListConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .categoryValues(List.of("categoryValues"))
   * .selectAllOptions("selectAllOptions")
   * .build())
   * .filterListConfiguration(FilterListConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * // the properties below are optional
   * .categoryValues(List.of("categoryValues"))
   * .selectAllOptions("selectAllOptions")
   * .build())
   * .build())
   * .filterId("filterId")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-categoryfilter.html)
   */
  public inline
      fun cfnAnalysisCategoryFilterProperty(block: CfnAnalysisCategoryFilterPropertyDsl.() -> Unit =
      {}): CfnAnalysis.CategoryFilterProperty {
    val builder = CfnAnalysisCategoryFilterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The label options for an axis on a chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ChartAxisLabelOptionsProperty chartAxisLabelOptionsProperty =
   * ChartAxisLabelOptionsProperty.builder()
   * .axisLabelOptions(List.of(AxisLabelOptionsProperty.builder()
   * .applyTo(AxisLabelReferenceOptionsProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * .build())
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .build()))
   * .sortIconVisibility("sortIconVisibility")
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-chartaxislabeloptions.html)
   */
  public inline
      fun cfnAnalysisChartAxisLabelOptionsProperty(block: CfnAnalysisChartAxisLabelOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ChartAxisLabelOptionsProperty {
    val builder = CfnAnalysisChartAxisLabelOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The cluster marker configuration of the geospatial map selected point style.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ClusterMarkerConfigurationProperty clusterMarkerConfigurationProperty =
   * ClusterMarkerConfigurationProperty.builder()
   * .clusterMarker(ClusterMarkerProperty.builder()
   * .simpleClusterMarker(SimpleClusterMarkerProperty.builder()
   * .color("color")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarkerconfiguration.html)
   */
  public inline
      fun cfnAnalysisClusterMarkerConfigurationProperty(block: CfnAnalysisClusterMarkerConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ClusterMarkerConfigurationProperty {
    val builder = CfnAnalysisClusterMarkerConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The cluster marker that is a part of the cluster marker configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ClusterMarkerProperty clusterMarkerProperty = ClusterMarkerProperty.builder()
   * .simpleClusterMarker(SimpleClusterMarkerProperty.builder()
   * .color("color")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-clustermarker.html)
   */
  public inline
      fun cfnAnalysisClusterMarkerProperty(block: CfnAnalysisClusterMarkerPropertyDsl.() -> Unit =
      {}): CfnAnalysis.ClusterMarkerProperty {
    val builder = CfnAnalysisClusterMarkerPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Determines the color scale that is applied to the visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ColorScaleProperty colorScaleProperty = ColorScaleProperty.builder()
   * .colorFillType("colorFillType")
   * .colors(List.of(DataColorProperty.builder()
   * .color("color")
   * .dataValue(123)
   * .build()))
   * // the properties below are optional
   * .nullValueColor(DataColorProperty.builder()
   * .color("color")
   * .dataValue(123)
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-colorscale.html)
   */
  public inline fun cfnAnalysisColorScaleProperty(block: CfnAnalysisColorScalePropertyDsl.() -> Unit
      = {}): CfnAnalysis.ColorScaleProperty {
    val builder = CfnAnalysisColorScalePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The general configuration of a column.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ColumnConfigurationProperty columnConfigurationProperty = ColumnConfigurationProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .formatConfiguration(FormatConfigurationProperty.builder()
   * .dateTimeFormatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .numberFormatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .stringFormatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .role("role")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnconfiguration.html)
   */
  public inline
      fun cfnAnalysisColumnConfigurationProperty(block: CfnAnalysisColumnConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ColumnConfigurationProperty {
    val builder = CfnAnalysisColumnConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The option that determines the hierarchy of the fields for a visual element.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ColumnHierarchyProperty columnHierarchyProperty = ColumnHierarchyProperty.builder()
   * .dateTimeHierarchy(DateTimeHierarchyProperty.builder()
   * .hierarchyId("hierarchyId")
   * // the properties below are optional
   * .drillDownFilters(List.of(DrillDownFilterProperty.builder()
   * .categoryFilter(CategoryDrillDownFilterProperty.builder()
   * .categoryValues(List.of("categoryValues"))
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .numericEqualityFilter(NumericEqualityDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .value(123)
   * .build())
   * .timeRangeFilter(TimeRangeDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .rangeMaximum("rangeMaximum")
   * .rangeMinimum("rangeMinimum")
   * .timeGranularity("timeGranularity")
   * .build())
   * .build()))
   * .build())
   * .explicitHierarchy(ExplicitHierarchyProperty.builder()
   * .columns(List.of(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build()))
   * .hierarchyId("hierarchyId")
   * // the properties below are optional
   * .drillDownFilters(List.of(DrillDownFilterProperty.builder()
   * .categoryFilter(CategoryDrillDownFilterProperty.builder()
   * .categoryValues(List.of("categoryValues"))
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .numericEqualityFilter(NumericEqualityDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .value(123)
   * .build())
   * .timeRangeFilter(TimeRangeDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .rangeMaximum("rangeMaximum")
   * .rangeMinimum("rangeMinimum")
   * .timeGranularity("timeGranularity")
   * .build())
   * .build()))
   * .build())
   * .predefinedHierarchy(PredefinedHierarchyProperty.builder()
   * .columns(List.of(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build()))
   * .hierarchyId("hierarchyId")
   * // the properties below are optional
   * .drillDownFilters(List.of(DrillDownFilterProperty.builder()
   * .categoryFilter(CategoryDrillDownFilterProperty.builder()
   * .categoryValues(List.of("categoryValues"))
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .numericEqualityFilter(NumericEqualityDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .value(123)
   * .build())
   * .timeRangeFilter(TimeRangeDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .rangeMaximum("rangeMaximum")
   * .rangeMinimum("rangeMinimum")
   * .timeGranularity("timeGranularity")
   * .build())
   * .build()))
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnhierarchy.html)
   */
  public inline
      fun cfnAnalysisColumnHierarchyProperty(block: CfnAnalysisColumnHierarchyPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ColumnHierarchyProperty {
    val builder = CfnAnalysisColumnHierarchyPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A column of a data set.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ColumnIdentifierProperty columnIdentifierProperty = ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnidentifier.html)
   */
  public inline
      fun cfnAnalysisColumnIdentifierProperty(block: CfnAnalysisColumnIdentifierPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ColumnIdentifierProperty {
    val builder = CfnAnalysisColumnIdentifierPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration for a column that is not used in a field well.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ColumnSortProperty columnSortProperty = ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columnsort.html)
   */
  public inline fun cfnAnalysisColumnSortProperty(block: CfnAnalysisColumnSortPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ColumnSortProperty {
    val builder = CfnAnalysisColumnSortPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The tooltip item for the columns that are not part of a field well.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ColumnTooltipItemProperty columnTooltipItemProperty = ColumnTooltipItemProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregation(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .label("label")
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-columntooltipitem.html)
   */
  public inline
      fun cfnAnalysisColumnTooltipItemProperty(block: CfnAnalysisColumnTooltipItemPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ColumnTooltipItemProperty {
    val builder = CfnAnalysisColumnTooltipItemPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The aggregated field wells of a combo chart.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisComboChartAggregatedFieldWellsProperty(block: CfnAnalysisComboChartAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ComboChartAggregatedFieldWellsProperty {
    val builder = CfnAnalysisComboChartAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a `ComboChartVisual` .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartconfiguration.html)
   */
  public inline
      fun cfnAnalysisComboChartConfigurationProperty(block: CfnAnalysisComboChartConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ComboChartConfigurationProperty {
    val builder = CfnAnalysisComboChartConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field wells of the visual.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartfieldwells.html)
   */
  public inline
      fun cfnAnalysisComboChartFieldWellsProperty(block: CfnAnalysisComboChartFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ComboChartFieldWellsProperty {
    val builder = CfnAnalysisComboChartFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration of a `ComboChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ComboChartSortConfigurationProperty comboChartSortConfigurationProperty =
   * ComboChartSortConfigurationProperty.builder()
   * .categoryItemsLimit(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .categorySort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .colorItemsLimit(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .colorSort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartsortconfiguration.html)
   */
  public inline
      fun cfnAnalysisComboChartSortConfigurationProperty(block: CfnAnalysisComboChartSortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ComboChartSortConfigurationProperty {
    val builder = CfnAnalysisComboChartSortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A combo chart.
   *
   * The `ComboChartVisual` includes stacked bar combo charts and clustered bar combo charts
   *
   * For more information, see [Using combo
   * charts](https://docs.aws.amazon.com/quicksight/latest/user/combo-charts.html) in the *Amazon
   * QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-combochartvisual.html)
   */
  public inline
      fun cfnAnalysisComboChartVisualProperty(block: CfnAnalysisComboChartVisualPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ComboChartVisualProperty {
    val builder = CfnAnalysisComboChartVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The comparison display configuration of a KPI or gauge chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ComparisonConfigurationProperty comparisonConfigurationProperty =
   * ComparisonConfigurationProperty.builder()
   * .comparisonFormat(ComparisonFormatConfigurationProperty.builder()
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .comparisonMethod("comparisonMethod")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-comparisonconfiguration.html)
   */
  public inline
      fun cfnAnalysisComparisonConfigurationProperty(block: CfnAnalysisComparisonConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ComparisonConfigurationProperty {
    val builder = CfnAnalysisComparisonConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The format of the comparison.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ComparisonFormatConfigurationProperty comparisonFormatConfigurationProperty =
   * ComparisonFormatConfigurationProperty.builder()
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-comparisonformatconfiguration.html)
   */
  public inline
      fun cfnAnalysisComparisonFormatConfigurationProperty(block: CfnAnalysisComparisonFormatConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ComparisonFormatConfigurationProperty {
    val builder = CfnAnalysisComparisonFormatConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The computation union that is used in an insight visual.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-computation.html)
   */
  public inline
      fun cfnAnalysisComputationProperty(block: CfnAnalysisComputationPropertyDsl.() -> Unit = {}):
      CfnAnalysis.ComputationProperty {
    val builder = CfnAnalysisComputationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The formatting configuration for the color.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ConditionalFormattingColorProperty conditionalFormattingColorProperty =
   * ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcolor.html)
   */
  public inline
      fun cfnAnalysisConditionalFormattingColorProperty(block: CfnAnalysisConditionalFormattingColorPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ConditionalFormattingColorProperty {
    val builder = CfnAnalysisConditionalFormattingColorPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Determines the custom condition for an icon set.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ConditionalFormattingCustomIconConditionProperty
   * conditionalFormattingCustomIconConditionProperty =
   * ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconcondition.html)
   */
  public inline
      fun cfnAnalysisConditionalFormattingCustomIconConditionProperty(block: CfnAnalysisConditionalFormattingCustomIconConditionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ConditionalFormattingCustomIconConditionProperty {
    val builder = CfnAnalysisConditionalFormattingCustomIconConditionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Custom icon options for an icon set.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ConditionalFormattingCustomIconOptionsProperty conditionalFormattingCustomIconOptionsProperty =
   * ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingcustomiconoptions.html)
   */
  public inline
      fun cfnAnalysisConditionalFormattingCustomIconOptionsProperty(block: CfnAnalysisConditionalFormattingCustomIconOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ConditionalFormattingCustomIconOptionsProperty {
    val builder = CfnAnalysisConditionalFormattingCustomIconOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Formatting configuration for gradient color.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ConditionalFormattingGradientColorProperty conditionalFormattingGradientColorProperty =
   * ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattinggradientcolor.html)
   */
  public inline
      fun cfnAnalysisConditionalFormattingGradientColorProperty(block: CfnAnalysisConditionalFormattingGradientColorPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ConditionalFormattingGradientColorProperty {
    val builder = CfnAnalysisConditionalFormattingGradientColorPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Determines the icon display configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ConditionalFormattingIconDisplayConfigurationProperty
   * conditionalFormattingIconDisplayConfigurationProperty =
   * ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingicondisplayconfiguration.html)
   */
  public inline
      fun cfnAnalysisConditionalFormattingIconDisplayConfigurationProperty(block: CfnAnalysisConditionalFormattingIconDisplayConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ConditionalFormattingIconDisplayConfigurationProperty {
    val builder = CfnAnalysisConditionalFormattingIconDisplayConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The formatting configuration for the icon.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ConditionalFormattingIconProperty conditionalFormattingIconProperty =
   * ConditionalFormattingIconProperty.builder()
   * .customCondition(ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build())
   * .iconSet(ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingicon.html)
   */
  public inline
      fun cfnAnalysisConditionalFormattingIconProperty(block: CfnAnalysisConditionalFormattingIconPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ConditionalFormattingIconProperty {
    val builder = CfnAnalysisConditionalFormattingIconPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Formatting configuration for icon set.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ConditionalFormattingIconSetProperty conditionalFormattingIconSetProperty =
   * ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingiconset.html)
   */
  public inline
      fun cfnAnalysisConditionalFormattingIconSetProperty(block: CfnAnalysisConditionalFormattingIconSetPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ConditionalFormattingIconSetProperty {
    val builder = CfnAnalysisConditionalFormattingIconSetPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Formatting configuration for solid color.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ConditionalFormattingSolidColorProperty conditionalFormattingSolidColorProperty =
   * ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-conditionalformattingsolidcolor.html)
   */
  public inline
      fun cfnAnalysisConditionalFormattingSolidColorProperty(block: CfnAnalysisConditionalFormattingSolidColorPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ConditionalFormattingSolidColorProperty {
    val builder = CfnAnalysisConditionalFormattingSolidColorPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The contribution analysis visual display for a line, pie, or bar chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ContributionAnalysisDefaultProperty contributionAnalysisDefaultProperty =
   * ContributionAnalysisDefaultProperty.builder()
   * .contributorDimensions(List.of(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build()))
   * .measureFieldId("measureFieldId")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-contributionanalysisdefault.html)
   */
  public inline
      fun cfnAnalysisContributionAnalysisDefaultProperty(block: CfnAnalysisContributionAnalysisDefaultPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ContributionAnalysisDefaultProperty {
    val builder = CfnAnalysisContributionAnalysisDefaultPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the currency display format configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CurrencyDisplayFormatConfigurationProperty currencyDisplayFormatConfigurationProperty =
   * CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-currencydisplayformatconfiguration.html)
   */
  public inline
      fun cfnAnalysisCurrencyDisplayFormatConfigurationProperty(block: CfnAnalysisCurrencyDisplayFormatConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CurrencyDisplayFormatConfigurationProperty {
    val builder = CfnAnalysisCurrencyDisplayFormatConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The filter operation that filters data included in a visual or in an entire sheet.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CustomActionFilterOperationProperty customActionFilterOperationProperty =
   * CustomActionFilterOperationProperty.builder()
   * .selectedFieldsConfiguration(FilterOperationSelectedFieldsConfigurationProperty.builder()
   * .selectedColumns(List.of(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build()))
   * .selectedFieldOptions("selectedFieldOptions")
   * .selectedFields(List.of("selectedFields"))
   * .build())
   * .targetVisualsConfiguration(FilterOperationTargetVisualsConfigurationProperty.builder()
   * .sameSheetTargetVisualConfiguration(SameSheetTargetVisualConfigurationProperty.builder()
   * .targetVisualOptions("targetVisualOptions")
   * .targetVisuals(List.of("targetVisuals"))
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionfilteroperation.html)
   */
  public inline
      fun cfnAnalysisCustomActionFilterOperationProperty(block: CfnAnalysisCustomActionFilterOperationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CustomActionFilterOperationProperty {
    val builder = CfnAnalysisCustomActionFilterOperationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The navigation operation that navigates between different sheets in the same analysis.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CustomActionNavigationOperationProperty customActionNavigationOperationProperty =
   * CustomActionNavigationOperationProperty.builder()
   * .localNavigationConfiguration(LocalNavigationConfigurationProperty.builder()
   * .targetSheetId("targetSheetId")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionnavigationoperation.html)
   */
  public inline
      fun cfnAnalysisCustomActionNavigationOperationProperty(block: CfnAnalysisCustomActionNavigationOperationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CustomActionNavigationOperationProperty {
    val builder = CfnAnalysisCustomActionNavigationOperationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The set parameter operation that sets parameters in custom action.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CustomActionSetParametersOperationProperty customActionSetParametersOperationProperty =
   * CustomActionSetParametersOperationProperty.builder()
   * .parameterValueConfigurations(List.of(SetParameterValueConfigurationProperty.builder()
   * .destinationParameterName("destinationParameterName")
   * .value(DestinationParameterValueConfigurationProperty.builder()
   * .customValuesConfiguration(CustomValuesConfigurationProperty.builder()
   * .customValues(CustomParameterValuesProperty.builder()
   * .dateTimeValues(List.of("dateTimeValues"))
   * .decimalValues(List.of(123))
   * .integerValues(List.of(123))
   * .stringValues(List.of("stringValues"))
   * .build())
   * // the properties below are optional
   * .includeNullValue(false)
   * .build())
   * .selectAllValueOptions("selectAllValueOptions")
   * .sourceColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceField("sourceField")
   * .sourceParameterName("sourceParameterName")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionsetparametersoperation.html)
   */
  public inline
      fun cfnAnalysisCustomActionSetParametersOperationProperty(block: CfnAnalysisCustomActionSetParametersOperationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CustomActionSetParametersOperationProperty {
    val builder = CfnAnalysisCustomActionSetParametersOperationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The URL operation that opens a link to another webpage.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CustomActionURLOperationProperty customActionURLOperationProperty =
   * CustomActionURLOperationProperty.builder()
   * .urlTarget("urlTarget")
   * .urlTemplate("urlTemplate")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customactionurloperation.html)
   */
  public inline
      fun cfnAnalysisCustomActionURLOperationProperty(block: CfnAnalysisCustomActionURLOperationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CustomActionURLOperationProperty {
    val builder = CfnAnalysisCustomActionURLOperationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a `CustomContentVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CustomContentConfigurationProperty customContentConfigurationProperty =
   * CustomContentConfigurationProperty.builder()
   * .contentType("contentType")
   * .contentUrl("contentUrl")
   * .imageScaling("imageScaling")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentconfiguration.html)
   */
  public inline
      fun cfnAnalysisCustomContentConfigurationProperty(block: CfnAnalysisCustomContentConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CustomContentConfigurationProperty {
    val builder = CfnAnalysisCustomContentConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A visual that contains custom content.
   *
   * For more information, see [Using custom visual
   * content](https://docs.aws.amazon.com/quicksight/latest/user/custom-visual-content.html) in the
   * *Amazon QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CustomContentVisualProperty customContentVisualProperty = CustomContentVisualProperty.builder()
   * .dataSetIdentifier("dataSetIdentifier")
   * .visualId("visualId")
   * // the properties below are optional
   * .actions(List.of(VisualCustomActionProperty.builder()
   * .actionOperations(List.of(VisualCustomActionOperationProperty.builder()
   * .filterOperation(CustomActionFilterOperationProperty.builder()
   * .selectedFieldsConfiguration(FilterOperationSelectedFieldsConfigurationProperty.builder()
   * .selectedColumns(List.of(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build()))
   * .selectedFieldOptions("selectedFieldOptions")
   * .selectedFields(List.of("selectedFields"))
   * .build())
   * .targetVisualsConfiguration(FilterOperationTargetVisualsConfigurationProperty.builder()
   * .sameSheetTargetVisualConfiguration(SameSheetTargetVisualConfigurationProperty.builder()
   * .targetVisualOptions("targetVisualOptions")
   * .targetVisuals(List.of("targetVisuals"))
   * .build())
   * .build())
   * .build())
   * .navigationOperation(CustomActionNavigationOperationProperty.builder()
   * .localNavigationConfiguration(LocalNavigationConfigurationProperty.builder()
   * .targetSheetId("targetSheetId")
   * .build())
   * .build())
   * .setParametersOperation(CustomActionSetParametersOperationProperty.builder()
   * .parameterValueConfigurations(List.of(SetParameterValueConfigurationProperty.builder()
   * .destinationParameterName("destinationParameterName")
   * .value(DestinationParameterValueConfigurationProperty.builder()
   * .customValuesConfiguration(CustomValuesConfigurationProperty.builder()
   * .customValues(CustomParameterValuesProperty.builder()
   * .dateTimeValues(List.of("dateTimeValues"))
   * .decimalValues(List.of(123))
   * .integerValues(List.of(123))
   * .stringValues(List.of("stringValues"))
   * .build())
   * // the properties below are optional
   * .includeNullValue(false)
   * .build())
   * .selectAllValueOptions("selectAllValueOptions")
   * .sourceColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceField("sourceField")
   * .sourceParameterName("sourceParameterName")
   * .build())
   * .build()))
   * .build())
   * .urlOperation(CustomActionURLOperationProperty.builder()
   * .urlTarget("urlTarget")
   * .urlTemplate("urlTemplate")
   * .build())
   * .build()))
   * .customActionId("customActionId")
   * .name("name")
   * .trigger("trigger")
   * // the properties below are optional
   * .status("status")
   * .build()))
   * .chartConfiguration(CustomContentConfigurationProperty.builder()
   * .contentType("contentType")
   * .contentUrl("contentUrl")
   * .imageScaling("imageScaling")
   * .build())
   * .subtitle(VisualSubtitleLabelOptionsProperty.builder()
   * .formatText(LongFormatTextProperty.builder()
   * .plainText("plainText")
   * .richText("richText")
   * .build())
   * .visibility("visibility")
   * .build())
   * .title(VisualTitleLabelOptionsProperty.builder()
   * .formatText(ShortFormatTextProperty.builder()
   * .plainText("plainText")
   * .richText("richText")
   * .build())
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customcontentvisual.html)
   */
  public inline
      fun cfnAnalysisCustomContentVisualProperty(block: CfnAnalysisCustomContentVisualPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CustomContentVisualProperty {
    val builder = CfnAnalysisCustomContentVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A custom filter that filters based on a single value.
   *
   * This filter can be partially matched.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CustomFilterConfigurationProperty customFilterConfigurationProperty =
   * CustomFilterConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .categoryValue("categoryValue")
   * .parameterName("parameterName")
   * .selectAllOptions("selectAllOptions")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterconfiguration.html)
   */
  public inline
      fun cfnAnalysisCustomFilterConfigurationProperty(block: CfnAnalysisCustomFilterConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CustomFilterConfigurationProperty {
    val builder = CfnAnalysisCustomFilterConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A list of custom filter values.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CustomFilterListConfigurationProperty customFilterListConfigurationProperty =
   * CustomFilterListConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .categoryValues(List.of("categoryValues"))
   * .selectAllOptions("selectAllOptions")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customfilterlistconfiguration.html)
   */
  public inline
      fun cfnAnalysisCustomFilterListConfigurationProperty(block: CfnAnalysisCustomFilterListConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CustomFilterListConfigurationProperty {
    val builder = CfnAnalysisCustomFilterListConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The custom narrative options.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CustomNarrativeOptionsProperty customNarrativeOptionsProperty =
   * CustomNarrativeOptionsProperty.builder()
   * .narrative("narrative")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customnarrativeoptions.html)
   */
  public inline
      fun cfnAnalysisCustomNarrativeOptionsProperty(block: CfnAnalysisCustomNarrativeOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CustomNarrativeOptionsProperty {
    val builder = CfnAnalysisCustomNarrativeOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The customized parameter values.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CustomParameterValuesProperty customParameterValuesProperty =
   * CustomParameterValuesProperty.builder()
   * .dateTimeValues(List.of("dateTimeValues"))
   * .decimalValues(List.of(123))
   * .integerValues(List.of(123))
   * .stringValues(List.of("stringValues"))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customparametervalues.html)
   */
  public inline
      fun cfnAnalysisCustomParameterValuesProperty(block: CfnAnalysisCustomParameterValuesPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CustomParameterValuesProperty {
    val builder = CfnAnalysisCustomParameterValuesPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of custom values for the destination parameter in
   * `DestinationParameterValueConfiguration` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * CustomValuesConfigurationProperty customValuesConfigurationProperty =
   * CustomValuesConfigurationProperty.builder()
   * .customValues(CustomParameterValuesProperty.builder()
   * .dateTimeValues(List.of("dateTimeValues"))
   * .decimalValues(List.of(123))
   * .integerValues(List.of(123))
   * .stringValues(List.of("stringValues"))
   * .build())
   * // the properties below are optional
   * .includeNullValue(false)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-customvaluesconfiguration.html)
   */
  public inline
      fun cfnAnalysisCustomValuesConfigurationProperty(block: CfnAnalysisCustomValuesConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.CustomValuesConfigurationProperty {
    val builder = CfnAnalysisCustomValuesConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options for data bars.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DataBarsOptionsProperty dataBarsOptionsProperty = DataBarsOptionsProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .negativeColor("negativeColor")
   * .positiveColor("positiveColor")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-databarsoptions.html)
   */
  public inline
      fun cfnAnalysisDataBarsOptionsProperty(block: CfnAnalysisDataBarsOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DataBarsOptionsProperty {
    val builder = CfnAnalysisDataBarsOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Determines the color that is applied to a particular data value.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DataColorProperty dataColorProperty = DataColorProperty.builder()
   * .color("color")
   * .dataValue(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datacolor.html)
   */
  public inline fun cfnAnalysisDataColorProperty(block: CfnAnalysisDataColorPropertyDsl.() -> Unit =
      {}): CfnAnalysis.DataColorProperty {
    val builder = CfnAnalysisDataColorPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The data field series item configuration of a line chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DataFieldSeriesItemProperty dataFieldSeriesItemProperty = DataFieldSeriesItemProperty.builder()
   * .axisBinding("axisBinding")
   * .fieldId("fieldId")
   * // the properties below are optional
   * .fieldValue("fieldValue")
   * .settings(LineChartSeriesSettingsProperty.builder()
   * .lineStyleSettings(LineChartLineStyleSettingsProperty.builder()
   * .lineInterpolation("lineInterpolation")
   * .lineStyle("lineStyle")
   * .lineVisibility("lineVisibility")
   * .lineWidth("lineWidth")
   * .build())
   * .markerStyleSettings(LineChartMarkerStyleSettingsProperty.builder()
   * .markerColor("markerColor")
   * .markerShape("markerShape")
   * .markerSize("markerSize")
   * .markerVisibility("markerVisibility")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datafieldseriesitem.html)
   */
  public inline
      fun cfnAnalysisDataFieldSeriesItemProperty(block: CfnAnalysisDataFieldSeriesItemPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DataFieldSeriesItemProperty {
    val builder = CfnAnalysisDataFieldSeriesItemPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the presentation of the data labels.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DataLabelOptionsProperty dataLabelOptionsProperty = DataLabelOptionsProperty.builder()
   * .categoryLabelVisibility("categoryLabelVisibility")
   * .dataLabelTypes(List.of(DataLabelTypeProperty.builder()
   * .dataPathLabelType(DataPathLabelTypeProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .visibility("visibility")
   * .build())
   * .fieldLabelType(FieldLabelTypeProperty.builder()
   * .fieldId("fieldId")
   * .visibility("visibility")
   * .build())
   * .maximumLabelType(MaximumLabelTypeProperty.builder()
   * .visibility("visibility")
   * .build())
   * .minimumLabelType(MinimumLabelTypeProperty.builder()
   * .visibility("visibility")
   * .build())
   * .rangeEndsLabelType(RangeEndsLabelTypeProperty.builder()
   * .visibility("visibility")
   * .build())
   * .build()))
   * .labelColor("labelColor")
   * .labelContent("labelContent")
   * .labelFontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .measureLabelVisibility("measureLabelVisibility")
   * .overlap("overlap")
   * .position("position")
   * .totalsVisibility("totalsVisibility")
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeloptions.html)
   */
  public inline
      fun cfnAnalysisDataLabelOptionsProperty(block: CfnAnalysisDataLabelOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DataLabelOptionsProperty {
    val builder = CfnAnalysisDataLabelOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The option that determines the data label type.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DataLabelTypeProperty dataLabelTypeProperty = DataLabelTypeProperty.builder()
   * .dataPathLabelType(DataPathLabelTypeProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .visibility("visibility")
   * .build())
   * .fieldLabelType(FieldLabelTypeProperty.builder()
   * .fieldId("fieldId")
   * .visibility("visibility")
   * .build())
   * .maximumLabelType(MaximumLabelTypeProperty.builder()
   * .visibility("visibility")
   * .build())
   * .minimumLabelType(MinimumLabelTypeProperty.builder()
   * .visibility("visibility")
   * .build())
   * .rangeEndsLabelType(RangeEndsLabelTypeProperty.builder()
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datalabeltype.html)
   */
  public inline
      fun cfnAnalysisDataLabelTypeProperty(block: CfnAnalysisDataLabelTypePropertyDsl.() -> Unit =
      {}): CfnAnalysis.DataLabelTypeProperty {
    val builder = CfnAnalysisDataLabelTypePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The color map that determines the color options for a particular element.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DataPathColorProperty dataPathColorProperty = DataPathColorProperty.builder()
   * .color("color")
   * .element(DataPathValueProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .build())
   * // the properties below are optional
   * .timeGranularity("timeGranularity")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathcolor.html)
   */
  public inline
      fun cfnAnalysisDataPathColorProperty(block: CfnAnalysisDataPathColorPropertyDsl.() -> Unit =
      {}): CfnAnalysis.DataPathColorProperty {
    val builder = CfnAnalysisDataPathColorPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The option that specifies individual data values for labels.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DataPathLabelTypeProperty dataPathLabelTypeProperty = DataPathLabelTypeProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathlabeltype.html)
   */
  public inline
      fun cfnAnalysisDataPathLabelTypeProperty(block: CfnAnalysisDataPathLabelTypePropertyDsl.() -> Unit
      = {}): CfnAnalysis.DataPathLabelTypeProperty {
    val builder = CfnAnalysisDataPathLabelTypePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Allows data paths to be sorted by a specific data value.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DataPathSortProperty dataPathSortProperty = DataPathSortProperty.builder()
   * .direction("direction")
   * .sortPaths(List.of(DataPathValueProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathsort.html)
   */
  public inline
      fun cfnAnalysisDataPathSortProperty(block: CfnAnalysisDataPathSortPropertyDsl.() -> Unit =
      {}): CfnAnalysis.DataPathSortProperty {
    val builder = CfnAnalysisDataPathSortPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The data path that needs to be sorted.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DataPathValueProperty dataPathValueProperty = DataPathValueProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datapathvalue.html)
   */
  public inline
      fun cfnAnalysisDataPathValueProperty(block: CfnAnalysisDataPathValuePropertyDsl.() -> Unit =
      {}): CfnAnalysis.DataPathValueProperty {
    val builder = CfnAnalysisDataPathValuePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A data set.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DataSetIdentifierDeclarationProperty dataSetIdentifierDeclarationProperty =
   * DataSetIdentifierDeclarationProperty.builder()
   * .dataSetArn("dataSetArn")
   * .identifier("identifier")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetidentifierdeclaration.html)
   */
  public inline
      fun cfnAnalysisDataSetIdentifierDeclarationProperty(block: CfnAnalysisDataSetIdentifierDeclarationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DataSetIdentifierDeclarationProperty {
    val builder = CfnAnalysisDataSetIdentifierDeclarationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Dataset reference.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DataSetReferenceProperty dataSetReferenceProperty = DataSetReferenceProperty.builder()
   * .dataSetArn("dataSetArn")
   * .dataSetPlaceholder("dataSetPlaceholder")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datasetreference.html)
   */
  public inline
      fun cfnAnalysisDataSetReferenceProperty(block: CfnAnalysisDataSetReferencePropertyDsl.() -> Unit
      = {}): CfnAnalysis.DataSetReferenceProperty {
    val builder = CfnAnalysisDataSetReferencePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine how a date axis is displayed.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DateAxisOptionsProperty dateAxisOptionsProperty = DateAxisOptionsProperty.builder()
   * .missingDateVisibility("missingDateVisibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dateaxisoptions.html)
   */
  public inline
      fun cfnAnalysisDateAxisOptionsProperty(block: CfnAnalysisDateAxisOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DateAxisOptionsProperty {
    val builder = CfnAnalysisDateAxisOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The dimension type field with date type columns.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DateDimensionFieldProperty dateDimensionFieldProperty = DateDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .dateGranularity("dateGranularity")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datedimensionfield.html)
   */
  public inline
      fun cfnAnalysisDateDimensionFieldProperty(block: CfnAnalysisDateDimensionFieldPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DateDimensionFieldProperty {
    val builder = CfnAnalysisDateDimensionFieldPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The measure type field with date type columns.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DateMeasureFieldProperty dateMeasureFieldProperty = DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datemeasurefield.html)
   */
  public inline
      fun cfnAnalysisDateMeasureFieldProperty(block: CfnAnalysisDateMeasureFieldPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DateMeasureFieldProperty {
    val builder = CfnAnalysisDateMeasureFieldPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The default values of the `DateTimeParameterDeclaration` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DateTimeDefaultValuesProperty dateTimeDefaultValuesProperty =
   * DateTimeDefaultValuesProperty.builder()
   * .dynamicValue(DynamicDefaultValueProperty.builder()
   * .defaultValueColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .groupNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .userNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .rollingDate(RollingDateConfigurationProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .staticValues(List.of("staticValues"))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimedefaultvalues.html)
   */
  public inline
      fun cfnAnalysisDateTimeDefaultValuesProperty(block: CfnAnalysisDateTimeDefaultValuesPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DateTimeDefaultValuesProperty {
    val builder = CfnAnalysisDateTimeDefaultValuesPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Formatting configuration for `DateTime` fields.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DateTimeFormatConfigurationProperty dateTimeFormatConfigurationProperty =
   * DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeformatconfiguration.html)
   */
  public inline
      fun cfnAnalysisDateTimeFormatConfigurationProperty(block: CfnAnalysisDateTimeFormatConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DateTimeFormatConfigurationProperty {
    val builder = CfnAnalysisDateTimeFormatConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The option that determines the hierarchy of any `DateTime` fields.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DateTimeHierarchyProperty dateTimeHierarchyProperty = DateTimeHierarchyProperty.builder()
   * .hierarchyId("hierarchyId")
   * // the properties below are optional
   * .drillDownFilters(List.of(DrillDownFilterProperty.builder()
   * .categoryFilter(CategoryDrillDownFilterProperty.builder()
   * .categoryValues(List.of("categoryValues"))
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .numericEqualityFilter(NumericEqualityDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .value(123)
   * .build())
   * .timeRangeFilter(TimeRangeDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .rangeMaximum("rangeMaximum")
   * .rangeMinimum("rangeMinimum")
   * .timeGranularity("timeGranularity")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimehierarchy.html)
   */
  public inline
      fun cfnAnalysisDateTimeHierarchyProperty(block: CfnAnalysisDateTimeHierarchyPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DateTimeHierarchyProperty {
    val builder = CfnAnalysisDateTimeHierarchyPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A parameter declaration for the `DateTime` data type.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DateTimeParameterDeclarationProperty dateTimeParameterDeclarationProperty =
   * DateTimeParameterDeclarationProperty.builder()
   * .name("name")
   * // the properties below are optional
   * .defaultValues(DateTimeDefaultValuesProperty.builder()
   * .dynamicValue(DynamicDefaultValueProperty.builder()
   * .defaultValueColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .groupNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .userNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .rollingDate(RollingDateConfigurationProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .staticValues(List.of("staticValues"))
   * .build())
   * .mappedDataSetParameters(List.of(MappedDataSetParameterProperty.builder()
   * .dataSetIdentifier("dataSetIdentifier")
   * .dataSetParameterName("dataSetParameterName")
   * .build()))
   * .timeGranularity("timeGranularity")
   * .valueWhenUnset(DateTimeValueWhenUnsetConfigurationProperty.builder()
   * .customValue("customValue")
   * .valueWhenUnsetOption("valueWhenUnsetOption")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameterdeclaration.html)
   */
  public inline
      fun cfnAnalysisDateTimeParameterDeclarationProperty(block: CfnAnalysisDateTimeParameterDeclarationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DateTimeParameterDeclarationProperty {
    val builder = CfnAnalysisDateTimeParameterDeclarationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A date-time parameter.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DateTimeParameterProperty dateTimeParameterProperty = DateTimeParameterProperty.builder()
   * .name("name")
   * .values(List.of("values"))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimeparameter.html)
   */
  public inline
      fun cfnAnalysisDateTimeParameterProperty(block: CfnAnalysisDateTimeParameterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DateTimeParameterProperty {
    val builder = CfnAnalysisDateTimeParameterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The display options of a control.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DateTimePickerControlDisplayOptionsProperty dateTimePickerControlDisplayOptionsProperty =
   * DateTimePickerControlDisplayOptionsProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimepickercontroldisplayoptions.html)
   */
  public inline
      fun cfnAnalysisDateTimePickerControlDisplayOptionsProperty(block: CfnAnalysisDateTimePickerControlDisplayOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DateTimePickerControlDisplayOptionsProperty {
    val builder = CfnAnalysisDateTimePickerControlDisplayOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration that defines the default value of a `DateTime` parameter when a value has not
   * been set.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DateTimeValueWhenUnsetConfigurationProperty dateTimeValueWhenUnsetConfigurationProperty =
   * DateTimeValueWhenUnsetConfigurationProperty.builder()
   * .customValue("customValue")
   * .valueWhenUnsetOption("valueWhenUnsetOption")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-datetimevaluewhenunsetconfiguration.html)
   */
  public inline
      fun cfnAnalysisDateTimeValueWhenUnsetConfigurationProperty(block: CfnAnalysisDateTimeValueWhenUnsetConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DateTimeValueWhenUnsetConfigurationProperty {
    val builder = CfnAnalysisDateTimeValueWhenUnsetConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The default values of the `DecimalParameterDeclaration` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DecimalDefaultValuesProperty decimalDefaultValuesProperty =
   * DecimalDefaultValuesProperty.builder()
   * .dynamicValue(DynamicDefaultValueProperty.builder()
   * .defaultValueColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .groupNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .userNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .staticValues(List.of(123))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimaldefaultvalues.html)
   */
  public inline
      fun cfnAnalysisDecimalDefaultValuesProperty(block: CfnAnalysisDecimalDefaultValuesPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DecimalDefaultValuesProperty {
    val builder = CfnAnalysisDecimalDefaultValuesPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A parameter declaration for the `Decimal` data type.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DecimalParameterDeclarationProperty decimalParameterDeclarationProperty =
   * DecimalParameterDeclarationProperty.builder()
   * .name("name")
   * .parameterValueType("parameterValueType")
   * // the properties below are optional
   * .defaultValues(DecimalDefaultValuesProperty.builder()
   * .dynamicValue(DynamicDefaultValueProperty.builder()
   * .defaultValueColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .groupNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .userNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .staticValues(List.of(123))
   * .build())
   * .mappedDataSetParameters(List.of(MappedDataSetParameterProperty.builder()
   * .dataSetIdentifier("dataSetIdentifier")
   * .dataSetParameterName("dataSetParameterName")
   * .build()))
   * .valueWhenUnset(DecimalValueWhenUnsetConfigurationProperty.builder()
   * .customValue(123)
   * .valueWhenUnsetOption("valueWhenUnsetOption")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameterdeclaration.html)
   */
  public inline
      fun cfnAnalysisDecimalParameterDeclarationProperty(block: CfnAnalysisDecimalParameterDeclarationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DecimalParameterDeclarationProperty {
    val builder = CfnAnalysisDecimalParameterDeclarationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A decimal parameter.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DecimalParameterProperty decimalParameterProperty = DecimalParameterProperty.builder()
   * .name("name")
   * .values(List.of(123))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalparameter.html)
   */
  public inline
      fun cfnAnalysisDecimalParameterProperty(block: CfnAnalysisDecimalParameterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DecimalParameterProperty {
    val builder = CfnAnalysisDecimalParameterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The option that determines the decimal places configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DecimalPlacesConfigurationProperty decimalPlacesConfigurationProperty =
   * DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalplacesconfiguration.html)
   */
  public inline
      fun cfnAnalysisDecimalPlacesConfigurationProperty(block: CfnAnalysisDecimalPlacesConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DecimalPlacesConfigurationProperty {
    val builder = CfnAnalysisDecimalPlacesConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration that defines the default value of a `Decimal` parameter when a value has not
   * been set.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DecimalValueWhenUnsetConfigurationProperty decimalValueWhenUnsetConfigurationProperty =
   * DecimalValueWhenUnsetConfigurationProperty.builder()
   * .customValue(123)
   * .valueWhenUnsetOption("valueWhenUnsetOption")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-decimalvaluewhenunsetconfiguration.html)
   */
  public inline
      fun cfnAnalysisDecimalValueWhenUnsetConfigurationProperty(block: CfnAnalysisDecimalValueWhenUnsetConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DecimalValueWhenUnsetConfigurationProperty {
    val builder = CfnAnalysisDecimalValueWhenUnsetConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the default settings of a free-form layout configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DefaultFreeFormLayoutConfigurationProperty defaultFreeFormLayoutConfigurationProperty =
   * DefaultFreeFormLayoutConfigurationProperty.builder()
   * .canvasSizeOptions(FreeFormLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(FreeFormLayoutScreenCanvasSizeOptionsProperty.builder()
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultfreeformlayoutconfiguration.html)
   */
  public inline
      fun cfnAnalysisDefaultFreeFormLayoutConfigurationProperty(block: CfnAnalysisDefaultFreeFormLayoutConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DefaultFreeFormLayoutConfigurationProperty {
    val builder = CfnAnalysisDefaultFreeFormLayoutConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the default settings for a grid layout configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DefaultGridLayoutConfigurationProperty defaultGridLayoutConfigurationProperty =
   * DefaultGridLayoutConfigurationProperty.builder()
   * .canvasSizeOptions(GridLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptionsProperty.builder()
   * .resizeOption("resizeOption")
   * // the properties below are optional
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultgridlayoutconfiguration.html)
   */
  public inline
      fun cfnAnalysisDefaultGridLayoutConfigurationProperty(block: CfnAnalysisDefaultGridLayoutConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DefaultGridLayoutConfigurationProperty {
    val builder = CfnAnalysisDefaultGridLayoutConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the default settings for interactive layout configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DefaultInteractiveLayoutConfigurationProperty defaultInteractiveLayoutConfigurationProperty =
   * DefaultInteractiveLayoutConfigurationProperty.builder()
   * .freeForm(DefaultFreeFormLayoutConfigurationProperty.builder()
   * .canvasSizeOptions(FreeFormLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(FreeFormLayoutScreenCanvasSizeOptionsProperty.builder()
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build())
   * .grid(DefaultGridLayoutConfigurationProperty.builder()
   * .canvasSizeOptions(GridLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptionsProperty.builder()
   * .resizeOption("resizeOption")
   * // the properties below are optional
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultinteractivelayoutconfiguration.html)
   */
  public inline
      fun cfnAnalysisDefaultInteractiveLayoutConfigurationProperty(block: CfnAnalysisDefaultInteractiveLayoutConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DefaultInteractiveLayoutConfigurationProperty {
    val builder = CfnAnalysisDefaultInteractiveLayoutConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration for default new sheet settings.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DefaultNewSheetConfigurationProperty defaultNewSheetConfigurationProperty =
   * DefaultNewSheetConfigurationProperty.builder()
   * .interactiveLayoutConfiguration(DefaultInteractiveLayoutConfigurationProperty.builder()
   * .freeForm(DefaultFreeFormLayoutConfigurationProperty.builder()
   * .canvasSizeOptions(FreeFormLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(FreeFormLayoutScreenCanvasSizeOptionsProperty.builder()
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build())
   * .grid(DefaultGridLayoutConfigurationProperty.builder()
   * .canvasSizeOptions(GridLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptionsProperty.builder()
   * .resizeOption("resizeOption")
   * // the properties below are optional
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build())
   * .build())
   * .paginatedLayoutConfiguration(DefaultPaginatedLayoutConfigurationProperty.builder()
   * .sectionBased(DefaultSectionBasedLayoutConfigurationProperty.builder()
   * .canvasSizeOptions(SectionBasedLayoutCanvasSizeOptionsProperty.builder()
   * .paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptionsProperty.builder()
   * .paperMargin(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .paperOrientation("paperOrientation")
   * .paperSize("paperSize")
   * .build())
   * .build())
   * .build())
   * .build())
   * .sheetContentType("sheetContentType")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultnewsheetconfiguration.html)
   */
  public inline
      fun cfnAnalysisDefaultNewSheetConfigurationProperty(block: CfnAnalysisDefaultNewSheetConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DefaultNewSheetConfigurationProperty {
    val builder = CfnAnalysisDefaultNewSheetConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the default settings for a paginated layout configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DefaultPaginatedLayoutConfigurationProperty defaultPaginatedLayoutConfigurationProperty =
   * DefaultPaginatedLayoutConfigurationProperty.builder()
   * .sectionBased(DefaultSectionBasedLayoutConfigurationProperty.builder()
   * .canvasSizeOptions(SectionBasedLayoutCanvasSizeOptionsProperty.builder()
   * .paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptionsProperty.builder()
   * .paperMargin(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .paperOrientation("paperOrientation")
   * .paperSize("paperSize")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultpaginatedlayoutconfiguration.html)
   */
  public inline
      fun cfnAnalysisDefaultPaginatedLayoutConfigurationProperty(block: CfnAnalysisDefaultPaginatedLayoutConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DefaultPaginatedLayoutConfigurationProperty {
    val builder = CfnAnalysisDefaultPaginatedLayoutConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the default settings for a section-based layout configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DefaultSectionBasedLayoutConfigurationProperty defaultSectionBasedLayoutConfigurationProperty =
   * DefaultSectionBasedLayoutConfigurationProperty.builder()
   * .canvasSizeOptions(SectionBasedLayoutCanvasSizeOptionsProperty.builder()
   * .paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptionsProperty.builder()
   * .paperMargin(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .paperOrientation("paperOrientation")
   * .paperSize("paperSize")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-defaultsectionbasedlayoutconfiguration.html)
   */
  public inline
      fun cfnAnalysisDefaultSectionBasedLayoutConfigurationProperty(block: CfnAnalysisDefaultSectionBasedLayoutConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DefaultSectionBasedLayoutConfigurationProperty {
    val builder = CfnAnalysisDefaultSectionBasedLayoutConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of destination parameter values.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DestinationParameterValueConfigurationProperty destinationParameterValueConfigurationProperty =
   * DestinationParameterValueConfigurationProperty.builder()
   * .customValuesConfiguration(CustomValuesConfigurationProperty.builder()
   * .customValues(CustomParameterValuesProperty.builder()
   * .dateTimeValues(List.of("dateTimeValues"))
   * .decimalValues(List.of(123))
   * .integerValues(List.of(123))
   * .stringValues(List.of("stringValues"))
   * .build())
   * // the properties below are optional
   * .includeNullValue(false)
   * .build())
   * .selectAllValueOptions("selectAllValueOptions")
   * .sourceColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceField("sourceField")
   * .sourceParameterName("sourceParameterName")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-destinationparametervalueconfiguration.html)
   */
  public inline
      fun cfnAnalysisDestinationParameterValueConfigurationProperty(block: CfnAnalysisDestinationParameterValueConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DestinationParameterValueConfigurationProperty {
    val builder = CfnAnalysisDestinationParameterValueConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The dimension type field.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DimensionFieldProperty dimensionFieldProperty = DimensionFieldProperty.builder()
   * .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .dateDimensionField(DateDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .dateGranularity("dateGranularity")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .numericalDimensionField(NumericalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dimensionfield.html)
   */
  public inline
      fun cfnAnalysisDimensionFieldProperty(block: CfnAnalysisDimensionFieldPropertyDsl.() -> Unit =
      {}): CfnAnalysis.DimensionFieldProperty {
    val builder = CfnAnalysisDimensionFieldPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The label options of the label that is displayed in the center of a donut chart.
   *
   * This option isn't available for pie charts.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DonutCenterOptionsProperty donutCenterOptionsProperty = DonutCenterOptionsProperty.builder()
   * .labelVisibility("labelVisibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-donutcenteroptions.html)
   */
  public inline
      fun cfnAnalysisDonutCenterOptionsProperty(block: CfnAnalysisDonutCenterOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DonutCenterOptionsProperty {
    val builder = CfnAnalysisDonutCenterOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options for configuring a donut chart or pie chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DonutOptionsProperty donutOptionsProperty = DonutOptionsProperty.builder()
   * .arcOptions(ArcOptionsProperty.builder()
   * .arcThickness("arcThickness")
   * .build())
   * .donutCenterOptions(DonutCenterOptionsProperty.builder()
   * .labelVisibility("labelVisibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-donutoptions.html)
   */
  public inline
      fun cfnAnalysisDonutOptionsProperty(block: CfnAnalysisDonutOptionsPropertyDsl.() -> Unit =
      {}): CfnAnalysis.DonutOptionsProperty {
    val builder = CfnAnalysisDonutOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The drill down filter for the column hierarchies.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DrillDownFilterProperty drillDownFilterProperty = DrillDownFilterProperty.builder()
   * .categoryFilter(CategoryDrillDownFilterProperty.builder()
   * .categoryValues(List.of("categoryValues"))
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .numericEqualityFilter(NumericEqualityDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .value(123)
   * .build())
   * .timeRangeFilter(TimeRangeDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .rangeMaximum("rangeMaximum")
   * .rangeMinimum("rangeMinimum")
   * .timeGranularity("timeGranularity")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-drilldownfilter.html)
   */
  public inline
      fun cfnAnalysisDrillDownFilterProperty(block: CfnAnalysisDrillDownFilterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DrillDownFilterProperty {
    val builder = CfnAnalysisDrillDownFilterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The display options of a control.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DropDownControlDisplayOptionsProperty dropDownControlDisplayOptionsProperty =
   * DropDownControlDisplayOptionsProperty.builder()
   * .selectAllOptions(ListControlSelectAllOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dropdowncontroldisplayoptions.html)
   */
  public inline
      fun cfnAnalysisDropDownControlDisplayOptionsProperty(block: CfnAnalysisDropDownControlDisplayOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.DropDownControlDisplayOptionsProperty {
    val builder = CfnAnalysisDropDownControlDisplayOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Defines different defaults to the users or groups based on mapping.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * DynamicDefaultValueProperty dynamicDefaultValueProperty = DynamicDefaultValueProperty.builder()
   * .defaultValueColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .groupNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .userNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-dynamicdefaultvalue.html)
   */
  public inline
      fun cfnAnalysisDynamicDefaultValueProperty(block: CfnAnalysisDynamicDefaultValuePropertyDsl.() -> Unit
      = {}): CfnAnalysis.DynamicDefaultValueProperty {
    val builder = CfnAnalysisDynamicDefaultValuePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * An empty visual.
   *
   * Empty visuals are used in layouts but have not been configured to show any data. A new visual
   * created in the Amazon QuickSight console is considered an `EmptyVisual` until a visual type is
   * selected.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * EmptyVisualProperty emptyVisualProperty = EmptyVisualProperty.builder()
   * .dataSetIdentifier("dataSetIdentifier")
   * .visualId("visualId")
   * // the properties below are optional
   * .actions(List.of(VisualCustomActionProperty.builder()
   * .actionOperations(List.of(VisualCustomActionOperationProperty.builder()
   * .filterOperation(CustomActionFilterOperationProperty.builder()
   * .selectedFieldsConfiguration(FilterOperationSelectedFieldsConfigurationProperty.builder()
   * .selectedColumns(List.of(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build()))
   * .selectedFieldOptions("selectedFieldOptions")
   * .selectedFields(List.of("selectedFields"))
   * .build())
   * .targetVisualsConfiguration(FilterOperationTargetVisualsConfigurationProperty.builder()
   * .sameSheetTargetVisualConfiguration(SameSheetTargetVisualConfigurationProperty.builder()
   * .targetVisualOptions("targetVisualOptions")
   * .targetVisuals(List.of("targetVisuals"))
   * .build())
   * .build())
   * .build())
   * .navigationOperation(CustomActionNavigationOperationProperty.builder()
   * .localNavigationConfiguration(LocalNavigationConfigurationProperty.builder()
   * .targetSheetId("targetSheetId")
   * .build())
   * .build())
   * .setParametersOperation(CustomActionSetParametersOperationProperty.builder()
   * .parameterValueConfigurations(List.of(SetParameterValueConfigurationProperty.builder()
   * .destinationParameterName("destinationParameterName")
   * .value(DestinationParameterValueConfigurationProperty.builder()
   * .customValuesConfiguration(CustomValuesConfigurationProperty.builder()
   * .customValues(CustomParameterValuesProperty.builder()
   * .dateTimeValues(List.of("dateTimeValues"))
   * .decimalValues(List.of(123))
   * .integerValues(List.of(123))
   * .stringValues(List.of("stringValues"))
   * .build())
   * // the properties below are optional
   * .includeNullValue(false)
   * .build())
   * .selectAllValueOptions("selectAllValueOptions")
   * .sourceColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceField("sourceField")
   * .sourceParameterName("sourceParameterName")
   * .build())
   * .build()))
   * .build())
   * .urlOperation(CustomActionURLOperationProperty.builder()
   * .urlTarget("urlTarget")
   * .urlTemplate("urlTemplate")
   * .build())
   * .build()))
   * .customActionId("customActionId")
   * .name("name")
   * .trigger("trigger")
   * // the properties below are optional
   * .status("status")
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-emptyvisual.html)
   */
  public inline
      fun cfnAnalysisEmptyVisualProperty(block: CfnAnalysisEmptyVisualPropertyDsl.() -> Unit = {}):
      CfnAnalysis.EmptyVisualProperty {
    val builder = CfnAnalysisEmptyVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * An object, structure, or sub-structure of an analysis, template, or dashboard.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * EntityProperty entityProperty = EntityProperty.builder()
   * .path("path")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-entity.html)
   */
  public inline fun cfnAnalysisEntityProperty(block: CfnAnalysisEntityPropertyDsl.() -> Unit = {}):
      CfnAnalysis.EntityProperty {
    val builder = CfnAnalysisEntityPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The exclude period of `TimeRangeFilter` or `RelativeDatesFilter` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ExcludePeriodConfigurationProperty excludePeriodConfigurationProperty =
   * ExcludePeriodConfigurationProperty.builder()
   * .amount(123)
   * .granularity("granularity")
   * // the properties below are optional
   * .status("status")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-excludeperiodconfiguration.html)
   */
  public inline
      fun cfnAnalysisExcludePeriodConfigurationProperty(block: CfnAnalysisExcludePeriodConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ExcludePeriodConfigurationProperty {
    val builder = CfnAnalysisExcludePeriodConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The option that determines the hierarchy of the fields that are built within a visual's field
   * wells.
   *
   * These fields can't be duplicated to other visuals.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ExplicitHierarchyProperty explicitHierarchyProperty = ExplicitHierarchyProperty.builder()
   * .columns(List.of(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build()))
   * .hierarchyId("hierarchyId")
   * // the properties below are optional
   * .drillDownFilters(List.of(DrillDownFilterProperty.builder()
   * .categoryFilter(CategoryDrillDownFilterProperty.builder()
   * .categoryValues(List.of("categoryValues"))
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .numericEqualityFilter(NumericEqualityDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .value(123)
   * .build())
   * .timeRangeFilter(TimeRangeDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .rangeMaximum("rangeMaximum")
   * .rangeMinimum("rangeMinimum")
   * .timeGranularity("timeGranularity")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-explicithierarchy.html)
   */
  public inline
      fun cfnAnalysisExplicitHierarchyProperty(block: CfnAnalysisExplicitHierarchyPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ExplicitHierarchyProperty {
    val builder = CfnAnalysisExplicitHierarchyPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The setup for the detailed tooltip.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FieldBasedTooltipProperty fieldBasedTooltipProperty = FieldBasedTooltipProperty.builder()
   * .aggregationVisibility("aggregationVisibility")
   * .tooltipFields(List.of(TooltipItemProperty.builder()
   * .columnTooltipItem(ColumnTooltipItemProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregation(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .label("label")
   * .visibility("visibility")
   * .build())
   * .fieldTooltipItem(FieldTooltipItemProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .label("label")
   * .visibility("visibility")
   * .build())
   * .build()))
   * .tooltipTitleType("tooltipTitleType")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldbasedtooltip.html)
   */
  public inline
      fun cfnAnalysisFieldBasedTooltipProperty(block: CfnAnalysisFieldBasedTooltipPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FieldBasedTooltipProperty {
    val builder = CfnAnalysisFieldBasedTooltipPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field label type.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FieldLabelTypeProperty fieldLabelTypeProperty = FieldLabelTypeProperty.builder()
   * .fieldId("fieldId")
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldlabeltype.html)
   */
  public inline
      fun cfnAnalysisFieldLabelTypeProperty(block: CfnAnalysisFieldLabelTypePropertyDsl.() -> Unit =
      {}): CfnAnalysis.FieldLabelTypeProperty {
    val builder = CfnAnalysisFieldLabelTypePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field series item configuration of a line chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FieldSeriesItemProperty fieldSeriesItemProperty = FieldSeriesItemProperty.builder()
   * .axisBinding("axisBinding")
   * .fieldId("fieldId")
   * // the properties below are optional
   * .settings(LineChartSeriesSettingsProperty.builder()
   * .lineStyleSettings(LineChartLineStyleSettingsProperty.builder()
   * .lineInterpolation("lineInterpolation")
   * .lineStyle("lineStyle")
   * .lineVisibility("lineVisibility")
   * .lineWidth("lineWidth")
   * .build())
   * .markerStyleSettings(LineChartMarkerStyleSettingsProperty.builder()
   * .markerColor("markerColor")
   * .markerShape("markerShape")
   * .markerSize("markerSize")
   * .markerVisibility("markerVisibility")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldseriesitem.html)
   */
  public inline
      fun cfnAnalysisFieldSeriesItemProperty(block: CfnAnalysisFieldSeriesItemPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FieldSeriesItemProperty {
    val builder = CfnAnalysisFieldSeriesItemPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field sort options in a chart configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FieldSortOptionsProperty fieldSortOptionsProperty = FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldsortoptions.html)
   */
  public inline
      fun cfnAnalysisFieldSortOptionsProperty(block: CfnAnalysisFieldSortOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FieldSortOptionsProperty {
    val builder = CfnAnalysisFieldSortOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration for a field in a field well.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FieldSortProperty fieldSortProperty = FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldsort.html)
   */
  public inline fun cfnAnalysisFieldSortProperty(block: CfnAnalysisFieldSortPropertyDsl.() -> Unit =
      {}): CfnAnalysis.FieldSortProperty {
    val builder = CfnAnalysisFieldSortPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The tooltip item for the fields.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FieldTooltipItemProperty fieldTooltipItemProperty = FieldTooltipItemProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .label("label")
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fieldtooltipitem.html)
   */
  public inline
      fun cfnAnalysisFieldTooltipItemProperty(block: CfnAnalysisFieldTooltipItemPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FieldTooltipItemProperty {
    val builder = CfnAnalysisFieldTooltipItemPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The aggregated field well of the filled map.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilledMapAggregatedFieldWellsProperty filledMapAggregatedFieldWellsProperty =
   * FilledMapAggregatedFieldWellsProperty.builder()
   * .geospatial(List.of(DimensionFieldProperty.builder()
   * .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .dateDimensionField(DateDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .dateGranularity("dateGranularity")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .numericalDimensionField(NumericalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .build()))
   * .values(List.of(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisFilledMapAggregatedFieldWellsProperty(block: CfnAnalysisFilledMapAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilledMapAggregatedFieldWellsProperty {
    val builder = CfnAnalysisFilledMapAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Conditional formatting options of a `FilledMapVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilledMapConditionalFormattingOptionProperty filledMapConditionalFormattingOptionProperty =
   * FilledMapConditionalFormattingOptionProperty.builder()
   * .shape(FilledMapShapeConditionalFormattingProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .format(ShapeConditionalFormatProperty.builder()
   * .backgroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconditionalformattingoption.html)
   */
  public inline
      fun cfnAnalysisFilledMapConditionalFormattingOptionProperty(block: CfnAnalysisFilledMapConditionalFormattingOptionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilledMapConditionalFormattingOptionProperty {
    val builder = CfnAnalysisFilledMapConditionalFormattingOptionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The conditional formatting of a `FilledMapVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilledMapConditionalFormattingProperty filledMapConditionalFormattingProperty =
   * FilledMapConditionalFormattingProperty.builder()
   * .conditionalFormattingOptions(List.of(FilledMapConditionalFormattingOptionProperty.builder()
   * .shape(FilledMapShapeConditionalFormattingProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .format(ShapeConditionalFormatProperty.builder()
   * .backgroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconditionalformatting.html)
   */
  public inline
      fun cfnAnalysisFilledMapConditionalFormattingProperty(block: CfnAnalysisFilledMapConditionalFormattingPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilledMapConditionalFormattingProperty {
    val builder = CfnAnalysisFilledMapConditionalFormattingPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration for a `FilledMapVisual` .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapconfiguration.html)
   */
  public inline
      fun cfnAnalysisFilledMapConfigurationProperty(block: CfnAnalysisFilledMapConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilledMapConfigurationProperty {
    val builder = CfnAnalysisFilledMapConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field wells of a `FilledMapVisual` .
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilledMapFieldWellsProperty filledMapFieldWellsProperty = FilledMapFieldWellsProperty.builder()
   * .filledMapAggregatedFieldWells(FilledMapAggregatedFieldWellsProperty.builder()
   * .geospatial(List.of(DimensionFieldProperty.builder()
   * .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .dateDimensionField(DateDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .dateGranularity("dateGranularity")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .numericalDimensionField(NumericalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .build()))
   * .values(List.of(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapfieldwells.html)
   */
  public inline
      fun cfnAnalysisFilledMapFieldWellsProperty(block: CfnAnalysisFilledMapFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilledMapFieldWellsProperty {
    val builder = CfnAnalysisFilledMapFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The conditional formatting that determines the shape of the filled map.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilledMapShapeConditionalFormattingProperty filledMapShapeConditionalFormattingProperty =
   * FilledMapShapeConditionalFormattingProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .format(ShapeConditionalFormatProperty.builder()
   * .backgroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapshapeconditionalformatting.html)
   */
  public inline
      fun cfnAnalysisFilledMapShapeConditionalFormattingProperty(block: CfnAnalysisFilledMapShapeConditionalFormattingPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilledMapShapeConditionalFormattingProperty {
    val builder = CfnAnalysisFilledMapShapeConditionalFormattingPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration of a `FilledMapVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilledMapSortConfigurationProperty filledMapSortConfigurationProperty =
   * FilledMapSortConfigurationProperty.builder()
   * .categorySort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapsortconfiguration.html)
   */
  public inline
      fun cfnAnalysisFilledMapSortConfigurationProperty(block: CfnAnalysisFilledMapSortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilledMapSortConfigurationProperty {
    val builder = CfnAnalysisFilledMapSortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A filled map.
   *
   * For more information, see [Creating filled
   * maps](https://docs.aws.amazon.com/quicksight/latest/user/filled-maps.html) in the *Amazon
   * QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filledmapvisual.html)
   */
  public inline
      fun cfnAnalysisFilledMapVisualProperty(block: CfnAnalysisFilledMapVisualPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilledMapVisualProperty {
    val builder = CfnAnalysisFilledMapVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The control of a filter that is used to interact with a dashboard or an analysis.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterControlProperty filterControlProperty = FilterControlProperty.builder()
   * .dateTimePicker(FilterDateTimePickerControlProperty.builder()
   * .filterControlId("filterControlId")
   * .sourceFilterId("sourceFilterId")
   * .title("title")
   * // the properties below are optional
   * .displayOptions(DateTimePickerControlDisplayOptionsProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .type("type")
   * .build())
   * .dropdown(FilterDropDownControlProperty.builder()
   * .filterControlId("filterControlId")
   * .sourceFilterId("sourceFilterId")
   * .title("title")
   * // the properties below are optional
   * .cascadingControlConfiguration(CascadingControlConfigurationProperty.builder()
   * .sourceControls(List.of(CascadingControlSourceProperty.builder()
   * .columnToMatch(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceSheetControlId("sourceSheetControlId")
   * .build()))
   * .build())
   * .displayOptions(DropDownControlDisplayOptionsProperty.builder()
   * .selectAllOptions(ListControlSelectAllOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .selectableValues(FilterSelectableValuesProperty.builder()
   * .values(List.of("values"))
   * .build())
   * .type("type")
   * .build())
   * .list(FilterListControlProperty.builder()
   * .filterControlId("filterControlId")
   * .sourceFilterId("sourceFilterId")
   * .title("title")
   * // the properties below are optional
   * .cascadingControlConfiguration(CascadingControlConfigurationProperty.builder()
   * .sourceControls(List.of(CascadingControlSourceProperty.builder()
   * .columnToMatch(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceSheetControlId("sourceSheetControlId")
   * .build()))
   * .build())
   * .displayOptions(ListControlDisplayOptionsProperty.builder()
   * .searchOptions(ListControlSearchOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .selectAllOptions(ListControlSelectAllOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .selectableValues(FilterSelectableValuesProperty.builder()
   * .values(List.of("values"))
   * .build())
   * .type("type")
   * .build())
   * .relativeDateTime(FilterRelativeDateTimeControlProperty.builder()
   * .filterControlId("filterControlId")
   * .sourceFilterId("sourceFilterId")
   * .title("title")
   * // the properties below are optional
   * .displayOptions(RelativeDateTimeControlDisplayOptionsProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .build())
   * .slider(FilterSliderControlProperty.builder()
   * .filterControlId("filterControlId")
   * .maximumValue(123)
   * .minimumValue(123)
   * .sourceFilterId("sourceFilterId")
   * .stepSize(123)
   * .title("title")
   * // the properties below are optional
   * .displayOptions(SliderControlDisplayOptionsProperty.builder()
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .type("type")
   * .build())
   * .textArea(FilterTextAreaControlProperty.builder()
   * .filterControlId("filterControlId")
   * .sourceFilterId("sourceFilterId")
   * .title("title")
   * // the properties below are optional
   * .delimiter("delimiter")
   * .displayOptions(TextAreaControlDisplayOptionsProperty.builder()
   * .placeholderOptions(TextControlPlaceholderOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .build())
   * .textField(FilterTextFieldControlProperty.builder()
   * .filterControlId("filterControlId")
   * .sourceFilterId("sourceFilterId")
   * .title("title")
   * // the properties below are optional
   * .displayOptions(TextFieldControlDisplayOptionsProperty.builder()
   * .placeholderOptions(TextControlPlaceholderOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtercontrol.html)
   */
  public inline
      fun cfnAnalysisFilterControlProperty(block: CfnAnalysisFilterControlPropertyDsl.() -> Unit =
      {}): CfnAnalysis.FilterControlProperty {
    val builder = CfnAnalysisFilterControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A control from a date filter that is used to specify date and time.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterDateTimePickerControlProperty filterDateTimePickerControlProperty =
   * FilterDateTimePickerControlProperty.builder()
   * .filterControlId("filterControlId")
   * .sourceFilterId("sourceFilterId")
   * .title("title")
   * // the properties below are optional
   * .displayOptions(DateTimePickerControlDisplayOptionsProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .type("type")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdatetimepickercontrol.html)
   */
  public inline
      fun cfnAnalysisFilterDateTimePickerControlProperty(block: CfnAnalysisFilterDateTimePickerControlPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilterDateTimePickerControlProperty {
    val builder = CfnAnalysisFilterDateTimePickerControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A control to display a dropdown list with buttons that are used to select a single value.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterDropDownControlProperty filterDropDownControlProperty =
   * FilterDropDownControlProperty.builder()
   * .filterControlId("filterControlId")
   * .sourceFilterId("sourceFilterId")
   * .title("title")
   * // the properties below are optional
   * .cascadingControlConfiguration(CascadingControlConfigurationProperty.builder()
   * .sourceControls(List.of(CascadingControlSourceProperty.builder()
   * .columnToMatch(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceSheetControlId("sourceSheetControlId")
   * .build()))
   * .build())
   * .displayOptions(DropDownControlDisplayOptionsProperty.builder()
   * .selectAllOptions(ListControlSelectAllOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .selectableValues(FilterSelectableValuesProperty.builder()
   * .values(List.of("values"))
   * .build())
   * .type("type")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterdropdowncontrol.html)
   */
  public inline
      fun cfnAnalysisFilterDropDownControlProperty(block: CfnAnalysisFilterDropDownControlPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilterDropDownControlProperty {
    val builder = CfnAnalysisFilterDropDownControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A grouping of individual filters. Filter groups are applied to the same group of visuals.
   *
   * For more information, see [Adding filter conditions (group filters) with AND and OR
   * operators](https://docs.aws.amazon.com/quicksight/latest/user/add-a-compound-filter.html) in the
   * *Amazon QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterGroupProperty filterGroupProperty = FilterGroupProperty.builder()
   * .crossDataset("crossDataset")
   * .filterGroupId("filterGroupId")
   * .filters(List.of(FilterProperty.builder()
   * .categoryFilter(CategoryFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .configuration(CategoryFilterConfigurationProperty.builder()
   * .customFilterConfiguration(CustomFilterConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .categoryValue("categoryValue")
   * .parameterName("parameterName")
   * .selectAllOptions("selectAllOptions")
   * .build())
   * .customFilterListConfiguration(CustomFilterListConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .categoryValues(List.of("categoryValues"))
   * .selectAllOptions("selectAllOptions")
   * .build())
   * .filterListConfiguration(FilterListConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * // the properties below are optional
   * .categoryValues(List.of("categoryValues"))
   * .selectAllOptions("selectAllOptions")
   * .build())
   * .build())
   * .filterId("filterId")
   * .build())
   * .numericEqualityFilter(NumericEqualityFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * .matchOperator("matchOperator")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .parameterName("parameterName")
   * .selectAllOptions("selectAllOptions")
   * .value(123)
   * .build())
   * .numericRangeFilter(NumericRangeFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .includeMaximum(false)
   * .includeMinimum(false)
   * .rangeMaximum(NumericRangeFilterValueProperty.builder()
   * .parameter("parameter")
   * .staticValue(123)
   * .build())
   * .rangeMinimum(NumericRangeFilterValueProperty.builder()
   * .parameter("parameter")
   * .staticValue(123)
   * .build())
   * .selectAllOptions("selectAllOptions")
   * .build())
   * .relativeDatesFilter(RelativeDatesFilterProperty.builder()
   * .anchorDateConfiguration(AnchorDateConfigurationProperty.builder()
   * .anchorOption("anchorOption")
   * .parameterName("parameterName")
   * .build())
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * .nullOption("nullOption")
   * .relativeDateType("relativeDateType")
   * .timeGranularity("timeGranularity")
   * // the properties below are optional
   * .excludePeriodConfiguration(ExcludePeriodConfigurationProperty.builder()
   * .amount(123)
   * .granularity("granularity")
   * // the properties below are optional
   * .status("status")
   * .build())
   * .minimumGranularity("minimumGranularity")
   * .parameterName("parameterName")
   * .relativeDateValue(123)
   * .build())
   * .timeEqualityFilter(TimeEqualityFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * // the properties below are optional
   * .parameterName("parameterName")
   * .timeGranularity("timeGranularity")
   * .value("value")
   * .build())
   * .timeRangeFilter(TimeRangeFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .excludePeriodConfiguration(ExcludePeriodConfigurationProperty.builder()
   * .amount(123)
   * .granularity("granularity")
   * // the properties below are optional
   * .status("status")
   * .build())
   * .includeMaximum(false)
   * .includeMinimum(false)
   * .rangeMaximumValue(TimeRangeFilterValueProperty.builder()
   * .parameter("parameter")
   * .rollingDate(RollingDateConfigurationProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .staticValue("staticValue")
   * .build())
   * .rangeMinimumValue(TimeRangeFilterValueProperty.builder()
   * .parameter("parameter")
   * .rollingDate(RollingDateConfigurationProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .staticValue("staticValue")
   * .build())
   * .timeGranularity("timeGranularity")
   * .build())
   * .topBottomFilter(TopBottomFilterProperty.builder()
   * .aggregationSortConfigurations(List.of(AggregationSortConfigurationProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sortDirection("sortDirection")
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build()))
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * // the properties below are optional
   * .limit(123)
   * .parameterName("parameterName")
   * .timeGranularity("timeGranularity")
   * .build())
   * .build()))
   * .scopeConfiguration(FilterScopeConfigurationProperty.builder()
   * .selectedSheets(SelectedSheetsFilterScopeConfigurationProperty.builder()
   * .sheetVisualScopingConfigurations(List.of(SheetVisualScopingConfigurationProperty.builder()
   * .scope("scope")
   * .sheetId("sheetId")
   * // the properties below are optional
   * .visualIds(List.of("visualIds"))
   * .build()))
   * .build())
   * .build())
   * // the properties below are optional
   * .status("status")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtergroup.html)
   */
  public inline
      fun cfnAnalysisFilterGroupProperty(block: CfnAnalysisFilterGroupPropertyDsl.() -> Unit = {}):
      CfnAnalysis.FilterGroupProperty {
    val builder = CfnAnalysisFilterGroupPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A list of filter configurations.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterListConfigurationProperty filterListConfigurationProperty =
   * FilterListConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * // the properties below are optional
   * .categoryValues(List.of("categoryValues"))
   * .selectAllOptions("selectAllOptions")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistconfiguration.html)
   */
  public inline
      fun cfnAnalysisFilterListConfigurationProperty(block: CfnAnalysisFilterListConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilterListConfigurationProperty {
    val builder = CfnAnalysisFilterListConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A control to display a list of buttons or boxes.
   *
   * This is used to select either a single value or multiple values.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterListControlProperty filterListControlProperty = FilterListControlProperty.builder()
   * .filterControlId("filterControlId")
   * .sourceFilterId("sourceFilterId")
   * .title("title")
   * // the properties below are optional
   * .cascadingControlConfiguration(CascadingControlConfigurationProperty.builder()
   * .sourceControls(List.of(CascadingControlSourceProperty.builder()
   * .columnToMatch(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceSheetControlId("sourceSheetControlId")
   * .build()))
   * .build())
   * .displayOptions(ListControlDisplayOptionsProperty.builder()
   * .searchOptions(ListControlSearchOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .selectAllOptions(ListControlSelectAllOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .selectableValues(FilterSelectableValuesProperty.builder()
   * .values(List.of("values"))
   * .build())
   * .type("type")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterlistcontrol.html)
   */
  public inline
      fun cfnAnalysisFilterListControlProperty(block: CfnAnalysisFilterListControlPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilterListControlProperty {
    val builder = CfnAnalysisFilterListControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of selected fields in the `CustomActionFilterOperation` .
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterOperationSelectedFieldsConfigurationProperty
   * filterOperationSelectedFieldsConfigurationProperty =
   * FilterOperationSelectedFieldsConfigurationProperty.builder()
   * .selectedColumns(List.of(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build()))
   * .selectedFieldOptions("selectedFieldOptions")
   * .selectedFields(List.of("selectedFields"))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filteroperationselectedfieldsconfiguration.html)
   */
  public inline
      fun cfnAnalysisFilterOperationSelectedFieldsConfigurationProperty(block: CfnAnalysisFilterOperationSelectedFieldsConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilterOperationSelectedFieldsConfigurationProperty {
    val builder = CfnAnalysisFilterOperationSelectedFieldsConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of target visuals that you want to be filtered.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterOperationTargetVisualsConfigurationProperty
   * filterOperationTargetVisualsConfigurationProperty =
   * FilterOperationTargetVisualsConfigurationProperty.builder()
   * .sameSheetTargetVisualConfiguration(SameSheetTargetVisualConfigurationProperty.builder()
   * .targetVisualOptions("targetVisualOptions")
   * .targetVisuals(List.of("targetVisuals"))
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filteroperationtargetvisualsconfiguration.html)
   */
  public inline
      fun cfnAnalysisFilterOperationTargetVisualsConfigurationProperty(block: CfnAnalysisFilterOperationTargetVisualsConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilterOperationTargetVisualsConfigurationProperty {
    val builder = CfnAnalysisFilterOperationTargetVisualsConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * With a `Filter` , you can remove portions of data from a particular visual or view.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterProperty filterProperty = FilterProperty.builder()
   * .categoryFilter(CategoryFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .configuration(CategoryFilterConfigurationProperty.builder()
   * .customFilterConfiguration(CustomFilterConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .categoryValue("categoryValue")
   * .parameterName("parameterName")
   * .selectAllOptions("selectAllOptions")
   * .build())
   * .customFilterListConfiguration(CustomFilterListConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .categoryValues(List.of("categoryValues"))
   * .selectAllOptions("selectAllOptions")
   * .build())
   * .filterListConfiguration(FilterListConfigurationProperty.builder()
   * .matchOperator("matchOperator")
   * // the properties below are optional
   * .categoryValues(List.of("categoryValues"))
   * .selectAllOptions("selectAllOptions")
   * .build())
   * .build())
   * .filterId("filterId")
   * .build())
   * .numericEqualityFilter(NumericEqualityFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * .matchOperator("matchOperator")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .parameterName("parameterName")
   * .selectAllOptions("selectAllOptions")
   * .value(123)
   * .build())
   * .numericRangeFilter(NumericRangeFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .includeMaximum(false)
   * .includeMinimum(false)
   * .rangeMaximum(NumericRangeFilterValueProperty.builder()
   * .parameter("parameter")
   * .staticValue(123)
   * .build())
   * .rangeMinimum(NumericRangeFilterValueProperty.builder()
   * .parameter("parameter")
   * .staticValue(123)
   * .build())
   * .selectAllOptions("selectAllOptions")
   * .build())
   * .relativeDatesFilter(RelativeDatesFilterProperty.builder()
   * .anchorDateConfiguration(AnchorDateConfigurationProperty.builder()
   * .anchorOption("anchorOption")
   * .parameterName("parameterName")
   * .build())
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * .nullOption("nullOption")
   * .relativeDateType("relativeDateType")
   * .timeGranularity("timeGranularity")
   * // the properties below are optional
   * .excludePeriodConfiguration(ExcludePeriodConfigurationProperty.builder()
   * .amount(123)
   * .granularity("granularity")
   * // the properties below are optional
   * .status("status")
   * .build())
   * .minimumGranularity("minimumGranularity")
   * .parameterName("parameterName")
   * .relativeDateValue(123)
   * .build())
   * .timeEqualityFilter(TimeEqualityFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * // the properties below are optional
   * .parameterName("parameterName")
   * .timeGranularity("timeGranularity")
   * .value("value")
   * .build())
   * .timeRangeFilter(TimeRangeFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .excludePeriodConfiguration(ExcludePeriodConfigurationProperty.builder()
   * .amount(123)
   * .granularity("granularity")
   * // the properties below are optional
   * .status("status")
   * .build())
   * .includeMaximum(false)
   * .includeMinimum(false)
   * .rangeMaximumValue(TimeRangeFilterValueProperty.builder()
   * .parameter("parameter")
   * .rollingDate(RollingDateConfigurationProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .staticValue("staticValue")
   * .build())
   * .rangeMinimumValue(TimeRangeFilterValueProperty.builder()
   * .parameter("parameter")
   * .rollingDate(RollingDateConfigurationProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .staticValue("staticValue")
   * .build())
   * .timeGranularity("timeGranularity")
   * .build())
   * .topBottomFilter(TopBottomFilterProperty.builder()
   * .aggregationSortConfigurations(List.of(AggregationSortConfigurationProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sortDirection("sortDirection")
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build()))
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * // the properties below are optional
   * .limit(123)
   * .parameterName("parameterName")
   * .timeGranularity("timeGranularity")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filter.html)
   */
  public inline fun cfnAnalysisFilterProperty(block: CfnAnalysisFilterPropertyDsl.() -> Unit = {}):
      CfnAnalysis.FilterProperty {
    val builder = CfnAnalysisFilterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A control from a date filter that is used to specify the relative date.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterRelativeDateTimeControlProperty filterRelativeDateTimeControlProperty =
   * FilterRelativeDateTimeControlProperty.builder()
   * .filterControlId("filterControlId")
   * .sourceFilterId("sourceFilterId")
   * .title("title")
   * // the properties below are optional
   * .displayOptions(RelativeDateTimeControlDisplayOptionsProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterrelativedatetimecontrol.html)
   */
  public inline
      fun cfnAnalysisFilterRelativeDateTimeControlProperty(block: CfnAnalysisFilterRelativeDateTimeControlPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilterRelativeDateTimeControlProperty {
    val builder = CfnAnalysisFilterRelativeDateTimeControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The scope configuration for a `FilterGroup` .
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterScopeConfigurationProperty filterScopeConfigurationProperty =
   * FilterScopeConfigurationProperty.builder()
   * .selectedSheets(SelectedSheetsFilterScopeConfigurationProperty.builder()
   * .sheetVisualScopingConfigurations(List.of(SheetVisualScopingConfigurationProperty.builder()
   * .scope("scope")
   * .sheetId("sheetId")
   * // the properties below are optional
   * .visualIds(List.of("visualIds"))
   * .build()))
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterscopeconfiguration.html)
   */
  public inline
      fun cfnAnalysisFilterScopeConfigurationProperty(block: CfnAnalysisFilterScopeConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilterScopeConfigurationProperty {
    val builder = CfnAnalysisFilterScopeConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A list of selectable values that are used in a control.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterSelectableValuesProperty filterSelectableValuesProperty =
   * FilterSelectableValuesProperty.builder()
   * .values(List.of("values"))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterselectablevalues.html)
   */
  public inline
      fun cfnAnalysisFilterSelectableValuesProperty(block: CfnAnalysisFilterSelectableValuesPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilterSelectableValuesProperty {
    val builder = CfnAnalysisFilterSelectableValuesPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A control to display a horizontal toggle bar.
   *
   * This is used to change a value by sliding the toggle.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterSliderControlProperty filterSliderControlProperty = FilterSliderControlProperty.builder()
   * .filterControlId("filterControlId")
   * .maximumValue(123)
   * .minimumValue(123)
   * .sourceFilterId("sourceFilterId")
   * .stepSize(123)
   * .title("title")
   * // the properties below are optional
   * .displayOptions(SliderControlDisplayOptionsProperty.builder()
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .type("type")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filterslidercontrol.html)
   */
  public inline
      fun cfnAnalysisFilterSliderControlProperty(block: CfnAnalysisFilterSliderControlPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilterSliderControlProperty {
    val builder = CfnAnalysisFilterSliderControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A control to display a text box that is used to enter multiple entries.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterTextAreaControlProperty filterTextAreaControlProperty =
   * FilterTextAreaControlProperty.builder()
   * .filterControlId("filterControlId")
   * .sourceFilterId("sourceFilterId")
   * .title("title")
   * // the properties below are optional
   * .delimiter("delimiter")
   * .displayOptions(TextAreaControlDisplayOptionsProperty.builder()
   * .placeholderOptions(TextControlPlaceholderOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtertextareacontrol.html)
   */
  public inline
      fun cfnAnalysisFilterTextAreaControlProperty(block: CfnAnalysisFilterTextAreaControlPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilterTextAreaControlProperty {
    val builder = CfnAnalysisFilterTextAreaControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A control to display a text box that is used to enter a single entry.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FilterTextFieldControlProperty filterTextFieldControlProperty =
   * FilterTextFieldControlProperty.builder()
   * .filterControlId("filterControlId")
   * .sourceFilterId("sourceFilterId")
   * .title("title")
   * // the properties below are optional
   * .displayOptions(TextFieldControlDisplayOptionsProperty.builder()
   * .placeholderOptions(TextControlPlaceholderOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-filtertextfieldcontrol.html)
   */
  public inline
      fun cfnAnalysisFilterTextFieldControlProperty(block: CfnAnalysisFilterTextFieldControlPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FilterTextFieldControlProperty {
    val builder = CfnAnalysisFilterTextFieldControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Configures the display properties of the given text.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FontConfigurationProperty fontConfigurationProperty = FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontconfiguration.html)
   */
  public inline
      fun cfnAnalysisFontConfigurationProperty(block: CfnAnalysisFontConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FontConfigurationProperty {
    val builder = CfnAnalysisFontConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The option that determines the text display size.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FontSizeProperty fontSizeProperty = FontSizeProperty.builder()
   * .relative("relative")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontsize.html)
   */
  public inline fun cfnAnalysisFontSizeProperty(block: CfnAnalysisFontSizePropertyDsl.() -> Unit =
      {}): CfnAnalysis.FontSizeProperty {
    val builder = CfnAnalysisFontSizePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The option that determines the text display weight, or boldness.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FontWeightProperty fontWeightProperty = FontWeightProperty.builder()
   * .name("name")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-fontweight.html)
   */
  public inline fun cfnAnalysisFontWeightProperty(block: CfnAnalysisFontWeightPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FontWeightProperty {
    val builder = CfnAnalysisFontWeightPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The forecast computation configuration.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastcomputation.html)
   */
  public inline
      fun cfnAnalysisForecastComputationProperty(block: CfnAnalysisForecastComputationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ForecastComputationProperty {
    val builder = CfnAnalysisForecastComputationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The forecast configuration that is used in a line chart's display properties.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ForecastConfigurationProperty forecastConfigurationProperty =
   * ForecastConfigurationProperty.builder()
   * .forecastProperties(TimeBasedForecastPropertiesProperty.builder()
   * .lowerBoundary(123)
   * .periodsBackward(123)
   * .periodsForward(123)
   * .predictionInterval(123)
   * .seasonality(123)
   * .upperBoundary(123)
   * .build())
   * .scenario(ForecastScenarioProperty.builder()
   * .whatIfPointScenario(WhatIfPointScenarioProperty.builder()
   * .date("date")
   * .value(123)
   * .build())
   * .whatIfRangeScenario(WhatIfRangeScenarioProperty.builder()
   * .endDate("endDate")
   * .startDate("startDate")
   * .value(123)
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastconfiguration.html)
   */
  public inline
      fun cfnAnalysisForecastConfigurationProperty(block: CfnAnalysisForecastConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ForecastConfigurationProperty {
    val builder = CfnAnalysisForecastConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The forecast scenario of a forecast in the line chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ForecastScenarioProperty forecastScenarioProperty = ForecastScenarioProperty.builder()
   * .whatIfPointScenario(WhatIfPointScenarioProperty.builder()
   * .date("date")
   * .value(123)
   * .build())
   * .whatIfRangeScenario(WhatIfRangeScenarioProperty.builder()
   * .endDate("endDate")
   * .startDate("startDate")
   * .value(123)
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-forecastscenario.html)
   */
  public inline
      fun cfnAnalysisForecastScenarioProperty(block: CfnAnalysisForecastScenarioPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ForecastScenarioProperty {
    val builder = CfnAnalysisForecastScenarioPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The formatting configuration for all types of field.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FormatConfigurationProperty formatConfigurationProperty = FormatConfigurationProperty.builder()
   * .dateTimeFormatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .numberFormatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .stringFormatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-formatconfiguration.html)
   */
  public inline
      fun cfnAnalysisFormatConfigurationProperty(block: CfnAnalysisFormatConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FormatConfigurationProperty {
    val builder = CfnAnalysisFormatConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Configuration options for the canvas of a free-form layout.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FreeFormLayoutCanvasSizeOptionsProperty freeFormLayoutCanvasSizeOptionsProperty =
   * FreeFormLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(FreeFormLayoutScreenCanvasSizeOptionsProperty.builder()
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutcanvassizeoptions.html)
   */
  public inline
      fun cfnAnalysisFreeFormLayoutCanvasSizeOptionsProperty(block: CfnAnalysisFreeFormLayoutCanvasSizeOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FreeFormLayoutCanvasSizeOptionsProperty {
    val builder = CfnAnalysisFreeFormLayoutCanvasSizeOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a free-form layout.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FreeFormLayoutConfigurationProperty freeFormLayoutConfigurationProperty =
   * FreeFormLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * // the properties below are optional
   * .canvasSizeOptions(FreeFormLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(FreeFormLayoutScreenCanvasSizeOptionsProperty.builder()
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutconfiguration.html)
   */
  public inline
      fun cfnAnalysisFreeFormLayoutConfigurationProperty(block: CfnAnalysisFreeFormLayoutConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FreeFormLayoutConfigurationProperty {
    val builder = CfnAnalysisFreeFormLayoutConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The background style configuration of a free-form layout element.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FreeFormLayoutElementBackgroundStyleProperty freeFormLayoutElementBackgroundStyleProperty =
   * FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelementbackgroundstyle.html)
   */
  public inline
      fun cfnAnalysisFreeFormLayoutElementBackgroundStyleProperty(block: CfnAnalysisFreeFormLayoutElementBackgroundStylePropertyDsl.() -> Unit
      = {}): CfnAnalysis.FreeFormLayoutElementBackgroundStyleProperty {
    val builder = CfnAnalysisFreeFormLayoutElementBackgroundStylePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The background style configuration of a free-form layout element.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FreeFormLayoutElementBorderStyleProperty freeFormLayoutElementBorderStyleProperty =
   * FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelementborderstyle.html)
   */
  public inline
      fun cfnAnalysisFreeFormLayoutElementBorderStyleProperty(block: CfnAnalysisFreeFormLayoutElementBorderStylePropertyDsl.() -> Unit
      = {}): CfnAnalysis.FreeFormLayoutElementBorderStyleProperty {
    val builder = CfnAnalysisFreeFormLayoutElementBorderStylePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * An element within a free-form layout.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FreeFormLayoutElementProperty freeFormLayoutElementProperty =
   * FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutelement.html)
   */
  public inline
      fun cfnAnalysisFreeFormLayoutElementProperty(block: CfnAnalysisFreeFormLayoutElementPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FreeFormLayoutElementProperty {
    val builder = CfnAnalysisFreeFormLayoutElementPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the sizing of the canvas used in a free-form layout.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FreeFormLayoutScreenCanvasSizeOptionsProperty freeFormLayoutScreenCanvasSizeOptionsProperty =
   * FreeFormLayoutScreenCanvasSizeOptionsProperty.builder()
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformlayoutscreencanvassizeoptions.html)
   */
  public inline
      fun cfnAnalysisFreeFormLayoutScreenCanvasSizeOptionsProperty(block: CfnAnalysisFreeFormLayoutScreenCanvasSizeOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FreeFormLayoutScreenCanvasSizeOptionsProperty {
    val builder = CfnAnalysisFreeFormLayoutScreenCanvasSizeOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The free-form layout configuration of a section.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FreeFormSectionLayoutConfigurationProperty freeFormSectionLayoutConfigurationProperty =
   * FreeFormSectionLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-freeformsectionlayoutconfiguration.html)
   */
  public inline
      fun cfnAnalysisFreeFormSectionLayoutConfigurationProperty(block: CfnAnalysisFreeFormSectionLayoutConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FreeFormSectionLayoutConfigurationProperty {
    val builder = CfnAnalysisFreeFormSectionLayoutConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field well configuration of a `FunnelChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FunnelChartAggregatedFieldWellsProperty funnelChartAggregatedFieldWellsProperty =
   * FunnelChartAggregatedFieldWellsProperty.builder()
   * .category(List.of(DimensionFieldProperty.builder()
   * .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .dateDimensionField(DateDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .dateGranularity("dateGranularity")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .numericalDimensionField(NumericalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .build()))
   * .values(List.of(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisFunnelChartAggregatedFieldWellsProperty(block: CfnAnalysisFunnelChartAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FunnelChartAggregatedFieldWellsProperty {
    val builder = CfnAnalysisFunnelChartAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a `FunnelChartVisual` .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartconfiguration.html)
   */
  public inline
      fun cfnAnalysisFunnelChartConfigurationProperty(block: CfnAnalysisFunnelChartConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FunnelChartConfigurationProperty {
    val builder = CfnAnalysisFunnelChartConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the presentation of the data labels.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FunnelChartDataLabelOptionsProperty funnelChartDataLabelOptionsProperty =
   * FunnelChartDataLabelOptionsProperty.builder()
   * .categoryLabelVisibility("categoryLabelVisibility")
   * .labelColor("labelColor")
   * .labelFontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .measureDataLabelStyle("measureDataLabelStyle")
   * .measureLabelVisibility("measureLabelVisibility")
   * .position("position")
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartdatalabeloptions.html)
   */
  public inline
      fun cfnAnalysisFunnelChartDataLabelOptionsProperty(block: CfnAnalysisFunnelChartDataLabelOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FunnelChartDataLabelOptionsProperty {
    val builder = CfnAnalysisFunnelChartDataLabelOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field well configuration of a `FunnelChartVisual` .
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FunnelChartFieldWellsProperty funnelChartFieldWellsProperty =
   * FunnelChartFieldWellsProperty.builder()
   * .funnelChartAggregatedFieldWells(FunnelChartAggregatedFieldWellsProperty.builder()
   * .category(List.of(DimensionFieldProperty.builder()
   * .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .dateDimensionField(DateDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .dateGranularity("dateGranularity")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .numericalDimensionField(NumericalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .build()))
   * .values(List.of(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartfieldwells.html)
   */
  public inline
      fun cfnAnalysisFunnelChartFieldWellsProperty(block: CfnAnalysisFunnelChartFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FunnelChartFieldWellsProperty {
    val builder = CfnAnalysisFunnelChartFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration of a `FunnelChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * FunnelChartSortConfigurationProperty funnelChartSortConfigurationProperty =
   * FunnelChartSortConfigurationProperty.builder()
   * .categoryItemsLimit(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .categorySort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartsortconfiguration.html)
   */
  public inline
      fun cfnAnalysisFunnelChartSortConfigurationProperty(block: CfnAnalysisFunnelChartSortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FunnelChartSortConfigurationProperty {
    val builder = CfnAnalysisFunnelChartSortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A funnel chart.
   *
   * For more information, see [Using funnel
   * charts](https://docs.aws.amazon.com/quicksight/latest/user/funnel-visual-content.html) in the
   * *Amazon QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-funnelchartvisual.html)
   */
  public inline
      fun cfnAnalysisFunnelChartVisualProperty(block: CfnAnalysisFunnelChartVisualPropertyDsl.() -> Unit
      = {}): CfnAnalysis.FunnelChartVisualProperty {
    val builder = CfnAnalysisFunnelChartVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the presentation of the arc of a `GaugeChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GaugeChartArcConditionalFormattingProperty gaugeChartArcConditionalFormattingProperty =
   * GaugeChartArcConditionalFormattingProperty.builder()
   * .foregroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartarcconditionalformatting.html)
   */
  public inline
      fun cfnAnalysisGaugeChartArcConditionalFormattingProperty(block: CfnAnalysisGaugeChartArcConditionalFormattingPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GaugeChartArcConditionalFormattingProperty {
    val builder = CfnAnalysisGaugeChartArcConditionalFormattingPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Conditional formatting options of a `GaugeChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GaugeChartConditionalFormattingOptionProperty gaugeChartConditionalFormattingOptionProperty =
   * GaugeChartConditionalFormattingOptionProperty.builder()
   * .arc(GaugeChartArcConditionalFormattingProperty.builder()
   * .foregroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .primaryValue(GaugeChartPrimaryValueConditionalFormattingProperty.builder()
   * .icon(ConditionalFormattingIconProperty.builder()
   * .customCondition(ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build())
   * .iconSet(ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconditionalformattingoption.html)
   */
  public inline
      fun cfnAnalysisGaugeChartConditionalFormattingOptionProperty(block: CfnAnalysisGaugeChartConditionalFormattingOptionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GaugeChartConditionalFormattingOptionProperty {
    val builder = CfnAnalysisGaugeChartConditionalFormattingOptionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The conditional formatting of a `GaugeChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GaugeChartConditionalFormattingProperty gaugeChartConditionalFormattingProperty =
   * GaugeChartConditionalFormattingProperty.builder()
   * .conditionalFormattingOptions(List.of(GaugeChartConditionalFormattingOptionProperty.builder()
   * .arc(GaugeChartArcConditionalFormattingProperty.builder()
   * .foregroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .primaryValue(GaugeChartPrimaryValueConditionalFormattingProperty.builder()
   * .icon(ConditionalFormattingIconProperty.builder()
   * .customCondition(ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build())
   * .iconSet(ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconditionalformatting.html)
   */
  public inline
      fun cfnAnalysisGaugeChartConditionalFormattingProperty(block: CfnAnalysisGaugeChartConditionalFormattingPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GaugeChartConditionalFormattingProperty {
    val builder = CfnAnalysisGaugeChartConditionalFormattingPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a `GaugeChartVisual` .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartconfiguration.html)
   */
  public inline
      fun cfnAnalysisGaugeChartConfigurationProperty(block: CfnAnalysisGaugeChartConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GaugeChartConfigurationProperty {
    val builder = CfnAnalysisGaugeChartConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field well configuration of a `GaugeChartVisual` .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartfieldwells.html)
   */
  public inline
      fun cfnAnalysisGaugeChartFieldWellsProperty(block: CfnAnalysisGaugeChartFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GaugeChartFieldWellsProperty {
    val builder = CfnAnalysisGaugeChartFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the presentation of the `GaugeChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GaugeChartOptionsProperty gaugeChartOptionsProperty = GaugeChartOptionsProperty.builder()
   * .arc(ArcConfigurationProperty.builder()
   * .arcAngle(123)
   * .arcThickness("arcThickness")
   * .build())
   * .arcAxis(ArcAxisConfigurationProperty.builder()
   * .range(ArcAxisDisplayRangeProperty.builder()
   * .max(123)
   * .min(123)
   * .build())
   * .reserveRange(123)
   * .build())
   * .comparison(ComparisonConfigurationProperty.builder()
   * .comparisonFormat(ComparisonFormatConfigurationProperty.builder()
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .comparisonMethod("comparisonMethod")
   * .build())
   * .primaryValueDisplayType("primaryValueDisplayType")
   * .primaryValueFontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartoptions.html)
   */
  public inline
      fun cfnAnalysisGaugeChartOptionsProperty(block: CfnAnalysisGaugeChartOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GaugeChartOptionsProperty {
    val builder = CfnAnalysisGaugeChartOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The conditional formatting for the primary value of a `GaugeChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GaugeChartPrimaryValueConditionalFormattingProperty
   * gaugeChartPrimaryValueConditionalFormattingProperty =
   * GaugeChartPrimaryValueConditionalFormattingProperty.builder()
   * .icon(ConditionalFormattingIconProperty.builder()
   * .customCondition(ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build())
   * .iconSet(ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartprimaryvalueconditionalformatting.html)
   */
  public inline
      fun cfnAnalysisGaugeChartPrimaryValueConditionalFormattingProperty(block: CfnAnalysisGaugeChartPrimaryValueConditionalFormattingPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GaugeChartPrimaryValueConditionalFormattingProperty {
    val builder = CfnAnalysisGaugeChartPrimaryValueConditionalFormattingPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A gauge chart.
   *
   * For more information, see [Using gauge
   * charts](https://docs.aws.amazon.com/quicksight/latest/user/gauge-chart.html) in the *Amazon
   * QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gaugechartvisual.html)
   */
  public inline
      fun cfnAnalysisGaugeChartVisualProperty(block: CfnAnalysisGaugeChartVisualPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GaugeChartVisualProperty {
    val builder = CfnAnalysisGaugeChartVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The bound options (north, south, west, east) of the geospatial window options.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GeospatialCoordinateBoundsProperty geospatialCoordinateBoundsProperty =
   * GeospatialCoordinateBoundsProperty.builder()
   * .east(123)
   * .north(123)
   * .south(123)
   * .west(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialcoordinatebounds.html)
   */
  public inline
      fun cfnAnalysisGeospatialCoordinateBoundsProperty(block: CfnAnalysisGeospatialCoordinateBoundsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GeospatialCoordinateBoundsProperty {
    val builder = CfnAnalysisGeospatialCoordinateBoundsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The color scale specification for the heatmap point style.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GeospatialHeatmapColorScaleProperty geospatialHeatmapColorScaleProperty =
   * GeospatialHeatmapColorScaleProperty.builder()
   * .colors(List.of(GeospatialHeatmapDataColorProperty.builder()
   * .color("color")
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialheatmapcolorscale.html)
   */
  public inline
      fun cfnAnalysisGeospatialHeatmapColorScaleProperty(block: CfnAnalysisGeospatialHeatmapColorScalePropertyDsl.() -> Unit
      = {}): CfnAnalysis.GeospatialHeatmapColorScaleProperty {
    val builder = CfnAnalysisGeospatialHeatmapColorScalePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The heatmap configuration of the geospatial point style.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GeospatialHeatmapConfigurationProperty geospatialHeatmapConfigurationProperty =
   * GeospatialHeatmapConfigurationProperty.builder()
   * .heatmapColor(GeospatialHeatmapColorScaleProperty.builder()
   * .colors(List.of(GeospatialHeatmapDataColorProperty.builder()
   * .color("color")
   * .build()))
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialheatmapconfiguration.html)
   */
  public inline
      fun cfnAnalysisGeospatialHeatmapConfigurationProperty(block: CfnAnalysisGeospatialHeatmapConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GeospatialHeatmapConfigurationProperty {
    val builder = CfnAnalysisGeospatialHeatmapConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The color to be used in the heatmap point style.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GeospatialHeatmapDataColorProperty geospatialHeatmapDataColorProperty =
   * GeospatialHeatmapDataColorProperty.builder()
   * .color("color")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialheatmapdatacolor.html)
   */
  public inline
      fun cfnAnalysisGeospatialHeatmapDataColorProperty(block: CfnAnalysisGeospatialHeatmapDataColorPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GeospatialHeatmapDataColorProperty {
    val builder = CfnAnalysisGeospatialHeatmapDataColorPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The aggregated field wells for a geospatial map.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisGeospatialMapAggregatedFieldWellsProperty(block: CfnAnalysisGeospatialMapAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GeospatialMapAggregatedFieldWellsProperty {
    val builder = CfnAnalysisGeospatialMapAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a `GeospatialMapVisual` .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapconfiguration.html)
   */
  public inline
      fun cfnAnalysisGeospatialMapConfigurationProperty(block: CfnAnalysisGeospatialMapConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GeospatialMapConfigurationProperty {
    val builder = CfnAnalysisGeospatialMapConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field wells of a `GeospatialMapVisual` .
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapfieldwells.html)
   */
  public inline
      fun cfnAnalysisGeospatialMapFieldWellsProperty(block: CfnAnalysisGeospatialMapFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GeospatialMapFieldWellsProperty {
    val builder = CfnAnalysisGeospatialMapFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The map style options of the geospatial map.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GeospatialMapStyleOptionsProperty geospatialMapStyleOptionsProperty =
   * GeospatialMapStyleOptionsProperty.builder()
   * .baseMapStyle("baseMapStyle")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapstyleoptions.html)
   */
  public inline
      fun cfnAnalysisGeospatialMapStyleOptionsProperty(block: CfnAnalysisGeospatialMapStyleOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GeospatialMapStyleOptionsProperty {
    val builder = CfnAnalysisGeospatialMapStyleOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A geospatial map or a points on map visual.
   *
   * For more information, see [Creating point
   * maps](https://docs.aws.amazon.com/quicksight/latest/user/point-maps.html) in the *Amazon
   * QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialmapvisual.html)
   */
  public inline
      fun cfnAnalysisGeospatialMapVisualProperty(block: CfnAnalysisGeospatialMapVisualPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GeospatialMapVisualProperty {
    val builder = CfnAnalysisGeospatialMapVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The point style of the geospatial map.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GeospatialPointStyleOptionsProperty geospatialPointStyleOptionsProperty =
   * GeospatialPointStyleOptionsProperty.builder()
   * .clusterMarkerConfiguration(ClusterMarkerConfigurationProperty.builder()
   * .clusterMarker(ClusterMarkerProperty.builder()
   * .simpleClusterMarker(SimpleClusterMarkerProperty.builder()
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .heatmapConfiguration(GeospatialHeatmapConfigurationProperty.builder()
   * .heatmapColor(GeospatialHeatmapColorScaleProperty.builder()
   * .colors(List.of(GeospatialHeatmapDataColorProperty.builder()
   * .color("color")
   * .build()))
   * .build())
   * .build())
   * .selectedPointStyle("selectedPointStyle")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialpointstyleoptions.html)
   */
  public inline
      fun cfnAnalysisGeospatialPointStyleOptionsProperty(block: CfnAnalysisGeospatialPointStyleOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GeospatialPointStyleOptionsProperty {
    val builder = CfnAnalysisGeospatialPointStyleOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The window options of the geospatial map visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GeospatialWindowOptionsProperty geospatialWindowOptionsProperty =
   * GeospatialWindowOptionsProperty.builder()
   * .bounds(GeospatialCoordinateBoundsProperty.builder()
   * .east(123)
   * .north(123)
   * .south(123)
   * .west(123)
   * .build())
   * .mapZoomMode("mapZoomMode")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-geospatialwindowoptions.html)
   */
  public inline
      fun cfnAnalysisGeospatialWindowOptionsProperty(block: CfnAnalysisGeospatialWindowOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GeospatialWindowOptionsProperty {
    val builder = CfnAnalysisGeospatialWindowOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Determines the border options for a table visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GlobalTableBorderOptionsProperty globalTableBorderOptionsProperty =
   * GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-globaltableborderoptions.html)
   */
  public inline
      fun cfnAnalysisGlobalTableBorderOptionsProperty(block: CfnAnalysisGlobalTableBorderOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GlobalTableBorderOptionsProperty {
    val builder = CfnAnalysisGlobalTableBorderOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Determines the gradient color settings.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GradientColorProperty gradientColorProperty = GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gradientcolor.html)
   */
  public inline
      fun cfnAnalysisGradientColorProperty(block: CfnAnalysisGradientColorPropertyDsl.() -> Unit =
      {}): CfnAnalysis.GradientColorProperty {
    val builder = CfnAnalysisGradientColorPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Determines the gradient stop configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GradientStopProperty gradientStopProperty = GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gradientstop.html)
   */
  public inline
      fun cfnAnalysisGradientStopProperty(block: CfnAnalysisGradientStopPropertyDsl.() -> Unit =
      {}): CfnAnalysis.GradientStopProperty {
    val builder = CfnAnalysisGradientStopPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Configuration options for the canvas of a grid layout.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GridLayoutCanvasSizeOptionsProperty gridLayoutCanvasSizeOptionsProperty =
   * GridLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptionsProperty.builder()
   * .resizeOption("resizeOption")
   * // the properties below are optional
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutcanvassizeoptions.html)
   */
  public inline
      fun cfnAnalysisGridLayoutCanvasSizeOptionsProperty(block: CfnAnalysisGridLayoutCanvasSizeOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GridLayoutCanvasSizeOptionsProperty {
    val builder = CfnAnalysisGridLayoutCanvasSizeOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration for a grid layout. Also called a tiled layout.
   *
   * Visuals snap to a grid with standard spacing and alignment. Dashboards are displayed as
   * designed, with options to fit to screen or view at actual size.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GridLayoutConfigurationProperty gridLayoutConfigurationProperty =
   * GridLayoutConfigurationProperty.builder()
   * .elements(List.of(GridLayoutElementProperty.builder()
   * .columnSpan(123)
   * .elementId("elementId")
   * .elementType("elementType")
   * .rowSpan(123)
   * // the properties below are optional
   * .columnIndex(123)
   * .rowIndex(123)
   * .build()))
   * // the properties below are optional
   * .canvasSizeOptions(GridLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptionsProperty.builder()
   * .resizeOption("resizeOption")
   * // the properties below are optional
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutconfiguration.html)
   */
  public inline
      fun cfnAnalysisGridLayoutConfigurationProperty(block: CfnAnalysisGridLayoutConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GridLayoutConfigurationProperty {
    val builder = CfnAnalysisGridLayoutConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * An element within a grid layout.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GridLayoutElementProperty gridLayoutElementProperty = GridLayoutElementProperty.builder()
   * .columnSpan(123)
   * .elementId("elementId")
   * .elementType("elementType")
   * .rowSpan(123)
   * // the properties below are optional
   * .columnIndex(123)
   * .rowIndex(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutelement.html)
   */
  public inline
      fun cfnAnalysisGridLayoutElementProperty(block: CfnAnalysisGridLayoutElementPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GridLayoutElementProperty {
    val builder = CfnAnalysisGridLayoutElementPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the sizing of the canvas used in a grid layout.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GridLayoutScreenCanvasSizeOptionsProperty gridLayoutScreenCanvasSizeOptionsProperty =
   * GridLayoutScreenCanvasSizeOptionsProperty.builder()
   * .resizeOption("resizeOption")
   * // the properties below are optional
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-gridlayoutscreencanvassizeoptions.html)
   */
  public inline
      fun cfnAnalysisGridLayoutScreenCanvasSizeOptionsProperty(block: CfnAnalysisGridLayoutScreenCanvasSizeOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GridLayoutScreenCanvasSizeOptionsProperty {
    val builder = CfnAnalysisGridLayoutScreenCanvasSizeOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The growth rate computation configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * GrowthRateComputationProperty growthRateComputationProperty =
   * GrowthRateComputationProperty.builder()
   * .computationId("computationId")
   * .time(DimensionFieldProperty.builder()
   * .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .dateDimensionField(DateDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .dateGranularity("dateGranularity")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .numericalDimensionField(NumericalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .build())
   * // the properties below are optional
   * .name("name")
   * .periodSize(123)
   * .value(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-growthratecomputation.html)
   */
  public inline
      fun cfnAnalysisGrowthRateComputationProperty(block: CfnAnalysisGrowthRateComputationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.GrowthRateComputationProperty {
    val builder = CfnAnalysisGrowthRateComputationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a header or footer section.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * HeaderFooterSectionConfigurationProperty headerFooterSectionConfigurationProperty =
   * HeaderFooterSectionConfigurationProperty.builder()
   * .layout(SectionLayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * .build())
   * .build())
   * .sectionId("sectionId")
   * // the properties below are optional
   * .style(SectionStyleProperty.builder()
   * .height("height")
   * .padding(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-headerfootersectionconfiguration.html)
   */
  public inline
      fun cfnAnalysisHeaderFooterSectionConfigurationProperty(block: CfnAnalysisHeaderFooterSectionConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.HeaderFooterSectionConfigurationProperty {
    val builder = CfnAnalysisHeaderFooterSectionConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The aggregated field wells of a heat map.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisHeatMapAggregatedFieldWellsProperty(block: CfnAnalysisHeatMapAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.HeatMapAggregatedFieldWellsProperty {
    val builder = CfnAnalysisHeatMapAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a heat map.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapconfiguration.html)
   */
  public inline
      fun cfnAnalysisHeatMapConfigurationProperty(block: CfnAnalysisHeatMapConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.HeatMapConfigurationProperty {
    val builder = CfnAnalysisHeatMapConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field well configuration of a heat map.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapfieldwells.html)
   */
  public inline
      fun cfnAnalysisHeatMapFieldWellsProperty(block: CfnAnalysisHeatMapFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.HeatMapFieldWellsProperty {
    val builder = CfnAnalysisHeatMapFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration of a heat map.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * HeatMapSortConfigurationProperty heatMapSortConfigurationProperty =
   * HeatMapSortConfigurationProperty.builder()
   * .heatMapColumnItemsLimitConfiguration(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .heatMapColumnSort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .heatMapRowItemsLimitConfiguration(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .heatMapRowSort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapsortconfiguration.html)
   */
  public inline
      fun cfnAnalysisHeatMapSortConfigurationProperty(block: CfnAnalysisHeatMapSortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.HeatMapSortConfigurationProperty {
    val builder = CfnAnalysisHeatMapSortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A heat map.
   *
   * For more information, see [Using heat
   * maps](https://docs.aws.amazon.com/quicksight/latest/user/heat-map.html) in the *Amazon QuickSight
   * User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-heatmapvisual.html)
   */
  public inline
      fun cfnAnalysisHeatMapVisualProperty(block: CfnAnalysisHeatMapVisualPropertyDsl.() -> Unit =
      {}): CfnAnalysis.HeatMapVisualProperty {
    val builder = CfnAnalysisHeatMapVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field well configuration of a histogram.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * HistogramAggregatedFieldWellsProperty histogramAggregatedFieldWellsProperty =
   * HistogramAggregatedFieldWellsProperty.builder()
   * .values(List.of(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisHistogramAggregatedFieldWellsProperty(block: CfnAnalysisHistogramAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.HistogramAggregatedFieldWellsProperty {
    val builder = CfnAnalysisHistogramAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the presentation of histogram bins.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * HistogramBinOptionsProperty histogramBinOptionsProperty = HistogramBinOptionsProperty.builder()
   * .binCount(BinCountOptionsProperty.builder()
   * .value(123)
   * .build())
   * .binWidth(BinWidthOptionsProperty.builder()
   * .binCountLimit(123)
   * .value(123)
   * .build())
   * .selectedBinType("selectedBinType")
   * .startValue(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogrambinoptions.html)
   */
  public inline
      fun cfnAnalysisHistogramBinOptionsProperty(block: CfnAnalysisHistogramBinOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.HistogramBinOptionsProperty {
    val builder = CfnAnalysisHistogramBinOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration for a `HistogramVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * Object dataDriven;
   * HistogramConfigurationProperty histogramConfigurationProperty =
   * HistogramConfigurationProperty.builder()
   * .binOptions(HistogramBinOptionsProperty.builder()
   * .binCount(BinCountOptionsProperty.builder()
   * .value(123)
   * .build())
   * .binWidth(BinWidthOptionsProperty.builder()
   * .binCountLimit(123)
   * .value(123)
   * .build())
   * .selectedBinType("selectedBinType")
   * .startValue(123)
   * .build())
   * .dataLabels(DataLabelOptionsProperty.builder()
   * .categoryLabelVisibility("categoryLabelVisibility")
   * .dataLabelTypes(List.of(DataLabelTypeProperty.builder()
   * .dataPathLabelType(DataPathLabelTypeProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .visibility("visibility")
   * .build())
   * .fieldLabelType(FieldLabelTypeProperty.builder()
   * .fieldId("fieldId")
   * .visibility("visibility")
   * .build())
   * .maximumLabelType(MaximumLabelTypeProperty.builder()
   * .visibility("visibility")
   * .build())
   * .minimumLabelType(MinimumLabelTypeProperty.builder()
   * .visibility("visibility")
   * .build())
   * .rangeEndsLabelType(RangeEndsLabelTypeProperty.builder()
   * .visibility("visibility")
   * .build())
   * .build()))
   * .labelColor("labelColor")
   * .labelContent("labelContent")
   * .labelFontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .measureLabelVisibility("measureLabelVisibility")
   * .overlap("overlap")
   * .position("position")
   * .totalsVisibility("totalsVisibility")
   * .visibility("visibility")
   * .build())
   * .fieldWells(HistogramFieldWellsProperty.builder()
   * .histogramAggregatedFieldWells(HistogramAggregatedFieldWellsProperty.builder()
   * .values(List.of(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build())
   * .build())
   * .tooltip(TooltipOptionsProperty.builder()
   * .fieldBasedTooltip(FieldBasedTooltipProperty.builder()
   * .aggregationVisibility("aggregationVisibility")
   * .tooltipFields(List.of(TooltipItemProperty.builder()
   * .columnTooltipItem(ColumnTooltipItemProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregation(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .label("label")
   * .visibility("visibility")
   * .build())
   * .fieldTooltipItem(FieldTooltipItemProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .label("label")
   * .visibility("visibility")
   * .build())
   * .build()))
   * .tooltipTitleType("tooltipTitleType")
   * .build())
   * .selectedTooltipType("selectedTooltipType")
   * .tooltipVisibility("tooltipVisibility")
   * .build())
   * .visualPalette(VisualPaletteProperty.builder()
   * .chartColor("chartColor")
   * .colorMap(List.of(DataPathColorProperty.builder()
   * .color("color")
   * .element(DataPathValueProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .build())
   * // the properties below are optional
   * .timeGranularity("timeGranularity")
   * .build()))
   * .build())
   * .xAxisDisplayOptions(AxisDisplayOptionsProperty.builder()
   * .axisLineVisibility("axisLineVisibility")
   * .axisOffset("axisOffset")
   * .dataOptions(AxisDataOptionsProperty.builder()
   * .dateAxisOptions(DateAxisOptionsProperty.builder()
   * .missingDateVisibility("missingDateVisibility")
   * .build())
   * .numericAxisOptions(NumericAxisOptionsProperty.builder()
   * .range(AxisDisplayRangeProperty.builder()
   * .dataDriven(dataDriven)
   * .minMax(AxisDisplayMinMaxRangeProperty.builder()
   * .maximum(123)
   * .minimum(123)
   * .build())
   * .build())
   * .scale(AxisScaleProperty.builder()
   * .linear(AxisLinearScaleProperty.builder()
   * .stepCount(123)
   * .stepSize(123)
   * .build())
   * .logarithmic(AxisLogarithmicScaleProperty.builder()
   * .base(123)
   * .build())
   * .build())
   * .build())
   * .build())
   * .gridLineVisibility("gridLineVisibility")
   * .scrollbarOptions(ScrollBarOptionsProperty.builder()
   * .visibility("visibility")
   * .visibleRange(VisibleRangeOptionsProperty.builder()
   * .percentRange(PercentVisibleRangeProperty.builder()
   * .from(123)
   * .to(123)
   * .build())
   * .build())
   * .build())
   * .tickLabelOptions(AxisTickLabelOptionsProperty.builder()
   * .labelOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .rotationAngle(123)
   * .build())
   * .build())
   * .xAxisLabelOptions(ChartAxisLabelOptionsProperty.builder()
   * .axisLabelOptions(List.of(AxisLabelOptionsProperty.builder()
   * .applyTo(AxisLabelReferenceOptionsProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * .build())
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .build()))
   * .sortIconVisibility("sortIconVisibility")
   * .visibility("visibility")
   * .build())
   * .yAxisDisplayOptions(AxisDisplayOptionsProperty.builder()
   * .axisLineVisibility("axisLineVisibility")
   * .axisOffset("axisOffset")
   * .dataOptions(AxisDataOptionsProperty.builder()
   * .dateAxisOptions(DateAxisOptionsProperty.builder()
   * .missingDateVisibility("missingDateVisibility")
   * .build())
   * .numericAxisOptions(NumericAxisOptionsProperty.builder()
   * .range(AxisDisplayRangeProperty.builder()
   * .dataDriven(dataDriven)
   * .minMax(AxisDisplayMinMaxRangeProperty.builder()
   * .maximum(123)
   * .minimum(123)
   * .build())
   * .build())
   * .scale(AxisScaleProperty.builder()
   * .linear(AxisLinearScaleProperty.builder()
   * .stepCount(123)
   * .stepSize(123)
   * .build())
   * .logarithmic(AxisLogarithmicScaleProperty.builder()
   * .base(123)
   * .build())
   * .build())
   * .build())
   * .build())
   * .gridLineVisibility("gridLineVisibility")
   * .scrollbarOptions(ScrollBarOptionsProperty.builder()
   * .visibility("visibility")
   * .visibleRange(VisibleRangeOptionsProperty.builder()
   * .percentRange(PercentVisibleRangeProperty.builder()
   * .from(123)
   * .to(123)
   * .build())
   * .build())
   * .build())
   * .tickLabelOptions(AxisTickLabelOptionsProperty.builder()
   * .labelOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .rotationAngle(123)
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramconfiguration.html)
   */
  public inline
      fun cfnAnalysisHistogramConfigurationProperty(block: CfnAnalysisHistogramConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.HistogramConfigurationProperty {
    val builder = CfnAnalysisHistogramConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field well configuration of a histogram.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * HistogramFieldWellsProperty histogramFieldWellsProperty = HistogramFieldWellsProperty.builder()
   * .histogramAggregatedFieldWells(HistogramAggregatedFieldWellsProperty.builder()
   * .values(List.of(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramfieldwells.html)
   */
  public inline
      fun cfnAnalysisHistogramFieldWellsProperty(block: CfnAnalysisHistogramFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.HistogramFieldWellsProperty {
    val builder = CfnAnalysisHistogramFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A histogram.
   *
   * For more information, see [Using
   * histograms](https://docs.aws.amazon.com/quicksight/latest/user/histogram-charts.html) in the
   * *Amazon QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-histogramvisual.html)
   */
  public inline
      fun cfnAnalysisHistogramVisualProperty(block: CfnAnalysisHistogramVisualPropertyDsl.() -> Unit
      = {}): CfnAnalysis.HistogramVisualProperty {
    val builder = CfnAnalysisHistogramVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of an insight visual.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-insightconfiguration.html)
   */
  public inline
      fun cfnAnalysisInsightConfigurationProperty(block: CfnAnalysisInsightConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.InsightConfigurationProperty {
    val builder = CfnAnalysisInsightConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * An insight visual.
   *
   * For more information, see [Working with
   * insights](https://docs.aws.amazon.com/quicksight/latest/user/computational-insights.html) in the
   * *Amazon QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-insightvisual.html)
   */
  public inline
      fun cfnAnalysisInsightVisualProperty(block: CfnAnalysisInsightVisualPropertyDsl.() -> Unit =
      {}): CfnAnalysis.InsightVisualProperty {
    val builder = CfnAnalysisInsightVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The default values of the `IntegerParameterDeclaration` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * IntegerDefaultValuesProperty integerDefaultValuesProperty =
   * IntegerDefaultValuesProperty.builder()
   * .dynamicValue(DynamicDefaultValueProperty.builder()
   * .defaultValueColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .groupNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .userNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .staticValues(List.of(123))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerdefaultvalues.html)
   */
  public inline
      fun cfnAnalysisIntegerDefaultValuesProperty(block: CfnAnalysisIntegerDefaultValuesPropertyDsl.() -> Unit
      = {}): CfnAnalysis.IntegerDefaultValuesProperty {
    val builder = CfnAnalysisIntegerDefaultValuesPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A parameter declaration for the `Integer` data type.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * IntegerParameterDeclarationProperty integerParameterDeclarationProperty =
   * IntegerParameterDeclarationProperty.builder()
   * .name("name")
   * .parameterValueType("parameterValueType")
   * // the properties below are optional
   * .defaultValues(IntegerDefaultValuesProperty.builder()
   * .dynamicValue(DynamicDefaultValueProperty.builder()
   * .defaultValueColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .groupNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .userNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .staticValues(List.of(123))
   * .build())
   * .mappedDataSetParameters(List.of(MappedDataSetParameterProperty.builder()
   * .dataSetIdentifier("dataSetIdentifier")
   * .dataSetParameterName("dataSetParameterName")
   * .build()))
   * .valueWhenUnset(IntegerValueWhenUnsetConfigurationProperty.builder()
   * .customValue(123)
   * .valueWhenUnsetOption("valueWhenUnsetOption")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameterdeclaration.html)
   */
  public inline
      fun cfnAnalysisIntegerParameterDeclarationProperty(block: CfnAnalysisIntegerParameterDeclarationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.IntegerParameterDeclarationProperty {
    val builder = CfnAnalysisIntegerParameterDeclarationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * An integer parameter.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * IntegerParameterProperty integerParameterProperty = IntegerParameterProperty.builder()
   * .name("name")
   * .values(List.of(123))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integerparameter.html)
   */
  public inline
      fun cfnAnalysisIntegerParameterProperty(block: CfnAnalysisIntegerParameterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.IntegerParameterProperty {
    val builder = CfnAnalysisIntegerParameterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A parameter declaration for the `Integer` data type.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * IntegerValueWhenUnsetConfigurationProperty integerValueWhenUnsetConfigurationProperty =
   * IntegerValueWhenUnsetConfigurationProperty.builder()
   * .customValue(123)
   * .valueWhenUnsetOption("valueWhenUnsetOption")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-integervaluewhenunsetconfiguration.html)
   */
  public inline
      fun cfnAnalysisIntegerValueWhenUnsetConfigurationProperty(block: CfnAnalysisIntegerValueWhenUnsetConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.IntegerValueWhenUnsetConfigurationProperty {
    val builder = CfnAnalysisIntegerValueWhenUnsetConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The limit configuration of the visual display for an axis.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ItemsLimitConfigurationProperty itemsLimitConfigurationProperty =
   * ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-itemslimitconfiguration.html)
   */
  public inline
      fun cfnAnalysisItemsLimitConfigurationProperty(block: CfnAnalysisItemsLimitConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ItemsLimitConfigurationProperty {
    val builder = CfnAnalysisItemsLimitConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The conditional formatting options of a KPI visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * KPIConditionalFormattingOptionProperty kPIConditionalFormattingOptionProperty =
   * KPIConditionalFormattingOptionProperty.builder()
   * .primaryValue(KPIPrimaryValueConditionalFormattingProperty.builder()
   * .icon(ConditionalFormattingIconProperty.builder()
   * .customCondition(ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build())
   * .iconSet(ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .progressBar(KPIProgressBarConditionalFormattingProperty.builder()
   * .foregroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconditionalformattingoption.html)
   */
  public inline
      fun cfnAnalysisKPIConditionalFormattingOptionProperty(block: CfnAnalysisKPIConditionalFormattingOptionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.KPIConditionalFormattingOptionProperty {
    val builder = CfnAnalysisKPIConditionalFormattingOptionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The conditional formatting of a KPI visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * KPIConditionalFormattingProperty kPIConditionalFormattingProperty =
   * KPIConditionalFormattingProperty.builder()
   * .conditionalFormattingOptions(List.of(KPIConditionalFormattingOptionProperty.builder()
   * .primaryValue(KPIPrimaryValueConditionalFormattingProperty.builder()
   * .icon(ConditionalFormattingIconProperty.builder()
   * .customCondition(ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build())
   * .iconSet(ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .progressBar(KPIProgressBarConditionalFormattingProperty.builder()
   * .foregroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconditionalformatting.html)
   */
  public inline
      fun cfnAnalysisKPIConditionalFormattingProperty(block: CfnAnalysisKPIConditionalFormattingPropertyDsl.() -> Unit
      = {}): CfnAnalysis.KPIConditionalFormattingProperty {
    val builder = CfnAnalysisKPIConditionalFormattingPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a KPI visual.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiconfiguration.html)
   */
  public inline
      fun cfnAnalysisKPIConfigurationProperty(block: CfnAnalysisKPIConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.KPIConfigurationProperty {
    val builder = CfnAnalysisKPIConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field well configuration of a KPI visual.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpifieldwells.html)
   */
  public inline
      fun cfnAnalysisKPIFieldWellsProperty(block: CfnAnalysisKPIFieldWellsPropertyDsl.() -> Unit =
      {}): CfnAnalysis.KPIFieldWellsProperty {
    val builder = CfnAnalysisKPIFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the presentation of a KPI visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * KPIOptionsProperty kPIOptionsProperty = KPIOptionsProperty.builder()
   * .comparison(ComparisonConfigurationProperty.builder()
   * .comparisonFormat(ComparisonFormatConfigurationProperty.builder()
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .comparisonMethod("comparisonMethod")
   * .build())
   * .primaryValueDisplayType("primaryValueDisplayType")
   * .primaryValueFontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .progressBar(ProgressBarOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .secondaryValue(SecondaryValueOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .secondaryValueFontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .trendArrows(TrendArrowOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpioptions.html)
   */
  public inline fun cfnAnalysisKPIOptionsProperty(block: CfnAnalysisKPIOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.KPIOptionsProperty {
    val builder = CfnAnalysisKPIOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The conditional formatting for the primary value of a KPI visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * KPIPrimaryValueConditionalFormattingProperty kPIPrimaryValueConditionalFormattingProperty =
   * KPIPrimaryValueConditionalFormattingProperty.builder()
   * .icon(ConditionalFormattingIconProperty.builder()
   * .customCondition(ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build())
   * .iconSet(ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiprimaryvalueconditionalformatting.html)
   */
  public inline
      fun cfnAnalysisKPIPrimaryValueConditionalFormattingProperty(block: CfnAnalysisKPIPrimaryValueConditionalFormattingPropertyDsl.() -> Unit
      = {}): CfnAnalysis.KPIPrimaryValueConditionalFormattingProperty {
    val builder = CfnAnalysisKPIPrimaryValueConditionalFormattingPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The conditional formatting for the progress bar of a KPI visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * KPIProgressBarConditionalFormattingProperty kPIProgressBarConditionalFormattingProperty =
   * KPIProgressBarConditionalFormattingProperty.builder()
   * .foregroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpiprogressbarconditionalformatting.html)
   */
  public inline
      fun cfnAnalysisKPIProgressBarConditionalFormattingProperty(block: CfnAnalysisKPIProgressBarConditionalFormattingPropertyDsl.() -> Unit
      = {}): CfnAnalysis.KPIProgressBarConditionalFormattingProperty {
    val builder = CfnAnalysisKPIProgressBarConditionalFormattingPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration of a KPI visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * KPISortConfigurationProperty kPISortConfigurationProperty =
   * KPISortConfigurationProperty.builder()
   * .trendGroupSort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpisortconfiguration.html)
   */
  public inline
      fun cfnAnalysisKPISortConfigurationProperty(block: CfnAnalysisKPISortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.KPISortConfigurationProperty {
    val builder = CfnAnalysisKPISortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A key performance indicator (KPI).
   *
   * For more information, see [Using
   * KPIs](https://docs.aws.amazon.com/quicksight/latest/user/kpi.html) in the *Amazon QuickSight User
   * Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-kpivisual.html)
   */
  public inline fun cfnAnalysisKPIVisualProperty(block: CfnAnalysisKPIVisualPropertyDsl.() -> Unit =
      {}): CfnAnalysis.KPIVisualProperty {
    val builder = CfnAnalysisKPIVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The share label options for the labels.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * LabelOptionsProperty labelOptionsProperty = LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-labeloptions.html)
   */
  public inline
      fun cfnAnalysisLabelOptionsProperty(block: CfnAnalysisLabelOptionsPropertyDsl.() -> Unit =
      {}): CfnAnalysis.LabelOptionsProperty {
    val builder = CfnAnalysisLabelOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration that determines what the type of layout will be used on a sheet.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * LayoutConfigurationProperty layoutConfigurationProperty = LayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * // the properties below are optional
   * .canvasSizeOptions(FreeFormLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(FreeFormLayoutScreenCanvasSizeOptionsProperty.builder()
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build())
   * .gridLayout(GridLayoutConfigurationProperty.builder()
   * .elements(List.of(GridLayoutElementProperty.builder()
   * .columnSpan(123)
   * .elementId("elementId")
   * .elementType("elementType")
   * .rowSpan(123)
   * // the properties below are optional
   * .columnIndex(123)
   * .rowIndex(123)
   * .build()))
   * // the properties below are optional
   * .canvasSizeOptions(GridLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptionsProperty.builder()
   * .resizeOption("resizeOption")
   * // the properties below are optional
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build())
   * .sectionBasedLayout(SectionBasedLayoutConfigurationProperty.builder()
   * .bodySections(List.of(BodySectionConfigurationProperty.builder()
   * .content(BodySectionContentProperty.builder()
   * .layout(SectionLayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * .build())
   * .build())
   * .build())
   * .sectionId("sectionId")
   * // the properties below are optional
   * .pageBreakConfiguration(SectionPageBreakConfigurationProperty.builder()
   * .after(SectionAfterPageBreakProperty.builder()
   * .status("status")
   * .build())
   * .build())
   * .style(SectionStyleProperty.builder()
   * .height("height")
   * .padding(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .build())
   * .build()))
   * .canvasSizeOptions(SectionBasedLayoutCanvasSizeOptionsProperty.builder()
   * .paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptionsProperty.builder()
   * .paperMargin(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .paperOrientation("paperOrientation")
   * .paperSize("paperSize")
   * .build())
   * .build())
   * .footerSections(List.of(HeaderFooterSectionConfigurationProperty.builder()
   * .layout(SectionLayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * .build())
   * .build())
   * .sectionId("sectionId")
   * // the properties below are optional
   * .style(SectionStyleProperty.builder()
   * .height("height")
   * .padding(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .build())
   * .build()))
   * .headerSections(List.of(HeaderFooterSectionConfigurationProperty.builder()
   * .layout(SectionLayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * .build())
   * .build())
   * .sectionId("sectionId")
   * // the properties below are optional
   * .style(SectionStyleProperty.builder()
   * .height("height")
   * .padding(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .build())
   * .build()))
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layoutconfiguration.html)
   */
  public inline
      fun cfnAnalysisLayoutConfigurationProperty(block: CfnAnalysisLayoutConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.LayoutConfigurationProperty {
    val builder = CfnAnalysisLayoutConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A `Layout` defines the placement of elements within a sheet.
   *
   * For more information, see [Types of
   * layout](https://docs.aws.amazon.com/quicksight/latest/user/types-of-layout.html) in the *Amazon
   * QuickSight User Guide* .
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * LayoutProperty layoutProperty = LayoutProperty.builder()
   * .configuration(LayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * // the properties below are optional
   * .canvasSizeOptions(FreeFormLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(FreeFormLayoutScreenCanvasSizeOptionsProperty.builder()
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build())
   * .gridLayout(GridLayoutConfigurationProperty.builder()
   * .elements(List.of(GridLayoutElementProperty.builder()
   * .columnSpan(123)
   * .elementId("elementId")
   * .elementType("elementType")
   * .rowSpan(123)
   * // the properties below are optional
   * .columnIndex(123)
   * .rowIndex(123)
   * .build()))
   * // the properties below are optional
   * .canvasSizeOptions(GridLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptionsProperty.builder()
   * .resizeOption("resizeOption")
   * // the properties below are optional
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build())
   * .sectionBasedLayout(SectionBasedLayoutConfigurationProperty.builder()
   * .bodySections(List.of(BodySectionConfigurationProperty.builder()
   * .content(BodySectionContentProperty.builder()
   * .layout(SectionLayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * .build())
   * .build())
   * .build())
   * .sectionId("sectionId")
   * // the properties below are optional
   * .pageBreakConfiguration(SectionPageBreakConfigurationProperty.builder()
   * .after(SectionAfterPageBreakProperty.builder()
   * .status("status")
   * .build())
   * .build())
   * .style(SectionStyleProperty.builder()
   * .height("height")
   * .padding(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .build())
   * .build()))
   * .canvasSizeOptions(SectionBasedLayoutCanvasSizeOptionsProperty.builder()
   * .paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptionsProperty.builder()
   * .paperMargin(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .paperOrientation("paperOrientation")
   * .paperSize("paperSize")
   * .build())
   * .build())
   * .footerSections(List.of(HeaderFooterSectionConfigurationProperty.builder()
   * .layout(SectionLayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * .build())
   * .build())
   * .sectionId("sectionId")
   * // the properties below are optional
   * .style(SectionStyleProperty.builder()
   * .height("height")
   * .padding(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .build())
   * .build()))
   * .headerSections(List.of(HeaderFooterSectionConfigurationProperty.builder()
   * .layout(SectionLayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * .build())
   * .build())
   * .sectionId("sectionId")
   * // the properties below are optional
   * .style(SectionStyleProperty.builder()
   * .height("height")
   * .padding(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .build())
   * .build()))
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-layout.html)
   */
  public inline fun cfnAnalysisLayoutProperty(block: CfnAnalysisLayoutPropertyDsl.() -> Unit = {}):
      CfnAnalysis.LayoutProperty {
    val builder = CfnAnalysisLayoutPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options for the legend setup of a visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * LegendOptionsProperty legendOptionsProperty = LegendOptionsProperty.builder()
   * .height("height")
   * .position("position")
   * .title(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .width("width")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-legendoptions.html)
   */
  public inline
      fun cfnAnalysisLegendOptionsProperty(block: CfnAnalysisLegendOptionsPropertyDsl.() -> Unit =
      {}): CfnAnalysis.LegendOptionsProperty {
    val builder = CfnAnalysisLegendOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field well configuration of a line chart.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisLineChartAggregatedFieldWellsProperty(block: CfnAnalysisLineChartAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.LineChartAggregatedFieldWellsProperty {
    val builder = CfnAnalysisLineChartAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a line chart.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartconfiguration.html)
   */
  public inline
      fun cfnAnalysisLineChartConfigurationProperty(block: CfnAnalysisLineChartConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.LineChartConfigurationProperty {
    val builder = CfnAnalysisLineChartConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the default presentation of all line series in `LineChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * LineChartDefaultSeriesSettingsProperty lineChartDefaultSeriesSettingsProperty =
   * LineChartDefaultSeriesSettingsProperty.builder()
   * .axisBinding("axisBinding")
   * .lineStyleSettings(LineChartLineStyleSettingsProperty.builder()
   * .lineInterpolation("lineInterpolation")
   * .lineStyle("lineStyle")
   * .lineVisibility("lineVisibility")
   * .lineWidth("lineWidth")
   * .build())
   * .markerStyleSettings(LineChartMarkerStyleSettingsProperty.builder()
   * .markerColor("markerColor")
   * .markerShape("markerShape")
   * .markerSize("markerSize")
   * .markerVisibility("markerVisibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartdefaultseriessettings.html)
   */
  public inline
      fun cfnAnalysisLineChartDefaultSeriesSettingsProperty(block: CfnAnalysisLineChartDefaultSeriesSettingsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.LineChartDefaultSeriesSettingsProperty {
    val builder = CfnAnalysisLineChartDefaultSeriesSettingsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field well configuration of a line chart.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartfieldwells.html)
   */
  public inline
      fun cfnAnalysisLineChartFieldWellsProperty(block: CfnAnalysisLineChartFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.LineChartFieldWellsProperty {
    val builder = CfnAnalysisLineChartFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Line styles options for a line series in `LineChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * LineChartLineStyleSettingsProperty lineChartLineStyleSettingsProperty =
   * LineChartLineStyleSettingsProperty.builder()
   * .lineInterpolation("lineInterpolation")
   * .lineStyle("lineStyle")
   * .lineVisibility("lineVisibility")
   * .lineWidth("lineWidth")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartlinestylesettings.html)
   */
  public inline
      fun cfnAnalysisLineChartLineStyleSettingsProperty(block: CfnAnalysisLineChartLineStyleSettingsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.LineChartLineStyleSettingsProperty {
    val builder = CfnAnalysisLineChartLineStyleSettingsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Marker styles options for a line series in `LineChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * LineChartMarkerStyleSettingsProperty lineChartMarkerStyleSettingsProperty =
   * LineChartMarkerStyleSettingsProperty.builder()
   * .markerColor("markerColor")
   * .markerShape("markerShape")
   * .markerSize("markerSize")
   * .markerVisibility("markerVisibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartmarkerstylesettings.html)
   */
  public inline
      fun cfnAnalysisLineChartMarkerStyleSettingsProperty(block: CfnAnalysisLineChartMarkerStyleSettingsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.LineChartMarkerStyleSettingsProperty {
    val builder = CfnAnalysisLineChartMarkerStyleSettingsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the presentation of a line series in the visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * LineChartSeriesSettingsProperty lineChartSeriesSettingsProperty =
   * LineChartSeriesSettingsProperty.builder()
   * .lineStyleSettings(LineChartLineStyleSettingsProperty.builder()
   * .lineInterpolation("lineInterpolation")
   * .lineStyle("lineStyle")
   * .lineVisibility("lineVisibility")
   * .lineWidth("lineWidth")
   * .build())
   * .markerStyleSettings(LineChartMarkerStyleSettingsProperty.builder()
   * .markerColor("markerColor")
   * .markerShape("markerShape")
   * .markerSize("markerSize")
   * .markerVisibility("markerVisibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartseriessettings.html)
   */
  public inline
      fun cfnAnalysisLineChartSeriesSettingsProperty(block: CfnAnalysisLineChartSeriesSettingsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.LineChartSeriesSettingsProperty {
    val builder = CfnAnalysisLineChartSeriesSettingsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration of a line chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * LineChartSortConfigurationProperty lineChartSortConfigurationProperty =
   * LineChartSortConfigurationProperty.builder()
   * .categoryItemsLimitConfiguration(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .categorySort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .colorItemsLimitConfiguration(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .smallMultiplesLimitConfiguration(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .smallMultiplesSort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartsortconfiguration.html)
   */
  public inline
      fun cfnAnalysisLineChartSortConfigurationProperty(block: CfnAnalysisLineChartSortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.LineChartSortConfigurationProperty {
    val builder = CfnAnalysisLineChartSortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A line chart.
   *
   * For more information, see [Using line
   * charts](https://docs.aws.amazon.com/quicksight/latest/user/line-charts.html) in the *Amazon
   * QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-linechartvisual.html)
   */
  public inline
      fun cfnAnalysisLineChartVisualProperty(block: CfnAnalysisLineChartVisualPropertyDsl.() -> Unit
      = {}): CfnAnalysis.LineChartVisualProperty {
    val builder = CfnAnalysisLineChartVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The series axis configuration of a line chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * Object dataDriven;
   * LineSeriesAxisDisplayOptionsProperty lineSeriesAxisDisplayOptionsProperty =
   * LineSeriesAxisDisplayOptionsProperty.builder()
   * .axisOptions(AxisDisplayOptionsProperty.builder()
   * .axisLineVisibility("axisLineVisibility")
   * .axisOffset("axisOffset")
   * .dataOptions(AxisDataOptionsProperty.builder()
   * .dateAxisOptions(DateAxisOptionsProperty.builder()
   * .missingDateVisibility("missingDateVisibility")
   * .build())
   * .numericAxisOptions(NumericAxisOptionsProperty.builder()
   * .range(AxisDisplayRangeProperty.builder()
   * .dataDriven(dataDriven)
   * .minMax(AxisDisplayMinMaxRangeProperty.builder()
   * .maximum(123)
   * .minimum(123)
   * .build())
   * .build())
   * .scale(AxisScaleProperty.builder()
   * .linear(AxisLinearScaleProperty.builder()
   * .stepCount(123)
   * .stepSize(123)
   * .build())
   * .logarithmic(AxisLogarithmicScaleProperty.builder()
   * .base(123)
   * .build())
   * .build())
   * .build())
   * .build())
   * .gridLineVisibility("gridLineVisibility")
   * .scrollbarOptions(ScrollBarOptionsProperty.builder()
   * .visibility("visibility")
   * .visibleRange(VisibleRangeOptionsProperty.builder()
   * .percentRange(PercentVisibleRangeProperty.builder()
   * .from(123)
   * .to(123)
   * .build())
   * .build())
   * .build())
   * .tickLabelOptions(AxisTickLabelOptionsProperty.builder()
   * .labelOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .rotationAngle(123)
   * .build())
   * .build())
   * .missingDataConfigurations(List.of(MissingDataConfigurationProperty.builder()
   * .treatmentOption("treatmentOption")
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-lineseriesaxisdisplayoptions.html)
   */
  public inline
      fun cfnAnalysisLineSeriesAxisDisplayOptionsProperty(block: CfnAnalysisLineSeriesAxisDisplayOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.LineSeriesAxisDisplayOptionsProperty {
    val builder = CfnAnalysisLineSeriesAxisDisplayOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The display options of a control.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ListControlDisplayOptionsProperty listControlDisplayOptionsProperty =
   * ListControlDisplayOptionsProperty.builder()
   * .searchOptions(ListControlSearchOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .selectAllOptions(ListControlSelectAllOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-listcontroldisplayoptions.html)
   */
  public inline
      fun cfnAnalysisListControlDisplayOptionsProperty(block: CfnAnalysisListControlDisplayOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ListControlDisplayOptionsProperty {
    val builder = CfnAnalysisListControlDisplayOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of the search options in a list control.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ListControlSearchOptionsProperty listControlSearchOptionsProperty =
   * ListControlSearchOptionsProperty.builder()
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-listcontrolsearchoptions.html)
   */
  public inline
      fun cfnAnalysisListControlSearchOptionsProperty(block: CfnAnalysisListControlSearchOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ListControlSearchOptionsProperty {
    val builder = CfnAnalysisListControlSearchOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of the `Select all` options in a list control.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ListControlSelectAllOptionsProperty listControlSelectAllOptionsProperty =
   * ListControlSelectAllOptionsProperty.builder()
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-listcontrolselectalloptions.html)
   */
  public inline
      fun cfnAnalysisListControlSelectAllOptionsProperty(block: CfnAnalysisListControlSelectAllOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ListControlSelectAllOptionsProperty {
    val builder = CfnAnalysisListControlSelectAllOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of loading animation in free-form layout.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * LoadingAnimationProperty loadingAnimationProperty = LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-loadinganimation.html)
   */
  public inline
      fun cfnAnalysisLoadingAnimationProperty(block: CfnAnalysisLoadingAnimationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.LoadingAnimationProperty {
    val builder = CfnAnalysisLoadingAnimationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The navigation configuration for `CustomActionNavigationOperation` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * LocalNavigationConfigurationProperty localNavigationConfigurationProperty =
   * LocalNavigationConfigurationProperty.builder()
   * .targetSheetId("targetSheetId")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-localnavigationconfiguration.html)
   */
  public inline
      fun cfnAnalysisLocalNavigationConfigurationProperty(block: CfnAnalysisLocalNavigationConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.LocalNavigationConfigurationProperty {
    val builder = CfnAnalysisLocalNavigationConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The text format for a subtitle.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * LongFormatTextProperty longFormatTextProperty = LongFormatTextProperty.builder()
   * .plainText("plainText")
   * .richText("richText")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-longformattext.html)
   */
  public inline
      fun cfnAnalysisLongFormatTextProperty(block: CfnAnalysisLongFormatTextPropertyDsl.() -> Unit =
      {}): CfnAnalysis.LongFormatTextProperty {
    val builder = CfnAnalysisLongFormatTextPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A dataset parameter that is mapped to an analysis parameter.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * MappedDataSetParameterProperty mappedDataSetParameterProperty =
   * MappedDataSetParameterProperty.builder()
   * .dataSetIdentifier("dataSetIdentifier")
   * .dataSetParameterName("dataSetParameterName")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-mappeddatasetparameter.html)
   */
  public inline
      fun cfnAnalysisMappedDataSetParameterProperty(block: CfnAnalysisMappedDataSetParameterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.MappedDataSetParameterProperty {
    val builder = CfnAnalysisMappedDataSetParameterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The maximum label of a data path label.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * MaximumLabelTypeProperty maximumLabelTypeProperty = MaximumLabelTypeProperty.builder()
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-maximumlabeltype.html)
   */
  public inline
      fun cfnAnalysisMaximumLabelTypeProperty(block: CfnAnalysisMaximumLabelTypePropertyDsl.() -> Unit
      = {}): CfnAnalysis.MaximumLabelTypeProperty {
    val builder = CfnAnalysisMaximumLabelTypePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The maximum and minimum computation configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * MaximumMinimumComputationProperty maximumMinimumComputationProperty =
   * MaximumMinimumComputationProperty.builder()
   * .computationId("computationId")
   * .time(DimensionFieldProperty.builder()
   * .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .dateDimensionField(DateDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .dateGranularity("dateGranularity")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .numericalDimensionField(NumericalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .build())
   * .type("type")
   * // the properties below are optional
   * .name("name")
   * .value(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-maximumminimumcomputation.html)
   */
  public inline
      fun cfnAnalysisMaximumMinimumComputationProperty(block: CfnAnalysisMaximumMinimumComputationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.MaximumMinimumComputationProperty {
    val builder = CfnAnalysisMaximumMinimumComputationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The measure (metric) type field.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * MeasureFieldProperty measureFieldProperty = MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-measurefield.html)
   */
  public inline
      fun cfnAnalysisMeasureFieldProperty(block: CfnAnalysisMeasureFieldPropertyDsl.() -> Unit =
      {}): CfnAnalysis.MeasureFieldProperty {
    val builder = CfnAnalysisMeasureFieldPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The metric comparison computation configuration.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-metriccomparisoncomputation.html)
   */
  public inline
      fun cfnAnalysisMetricComparisonComputationProperty(block: CfnAnalysisMetricComparisonComputationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.MetricComparisonComputationProperty {
    val builder = CfnAnalysisMetricComparisonComputationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The minimum label of a data path label.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * MinimumLabelTypeProperty minimumLabelTypeProperty = MinimumLabelTypeProperty.builder()
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-minimumlabeltype.html)
   */
  public inline
      fun cfnAnalysisMinimumLabelTypeProperty(block: CfnAnalysisMinimumLabelTypePropertyDsl.() -> Unit
      = {}): CfnAnalysis.MinimumLabelTypeProperty {
    val builder = CfnAnalysisMinimumLabelTypePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration options that determine how missing data is treated during the rendering of a
   * line chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * MissingDataConfigurationProperty missingDataConfigurationProperty =
   * MissingDataConfigurationProperty.builder()
   * .treatmentOption("treatmentOption")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-missingdataconfiguration.html)
   */
  public inline
      fun cfnAnalysisMissingDataConfigurationProperty(block: CfnAnalysisMissingDataConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.MissingDataConfigurationProperty {
    val builder = CfnAnalysisMissingDataConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the negative value configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * NegativeValueConfigurationProperty negativeValueConfigurationProperty =
   * NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-negativevalueconfiguration.html)
   */
  public inline
      fun cfnAnalysisNegativeValueConfigurationProperty(block: CfnAnalysisNegativeValueConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.NegativeValueConfigurationProperty {
    val builder = CfnAnalysisNegativeValueConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the null value format configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * NullValueFormatConfigurationProperty nullValueFormatConfigurationProperty =
   * NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-nullvalueformatconfiguration.html)
   */
  public inline
      fun cfnAnalysisNullValueFormatConfigurationProperty(block: CfnAnalysisNullValueFormatConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.NullValueFormatConfigurationProperty {
    val builder = CfnAnalysisNullValueFormatConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the number display format configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * NumberDisplayFormatConfigurationProperty numberDisplayFormatConfigurationProperty =
   * NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numberdisplayformatconfiguration.html)
   */
  public inline
      fun cfnAnalysisNumberDisplayFormatConfigurationProperty(block: CfnAnalysisNumberDisplayFormatConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.NumberDisplayFormatConfigurationProperty {
    val builder = CfnAnalysisNumberDisplayFormatConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Formatting configuration for number fields.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * NumberFormatConfigurationProperty numberFormatConfigurationProperty =
   * NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numberformatconfiguration.html)
   */
  public inline
      fun cfnAnalysisNumberFormatConfigurationProperty(block: CfnAnalysisNumberFormatConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.NumberFormatConfigurationProperty {
    val builder = CfnAnalysisNumberFormatConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options for an axis with a numeric field.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * Object dataDriven;
   * NumericAxisOptionsProperty numericAxisOptionsProperty = NumericAxisOptionsProperty.builder()
   * .range(AxisDisplayRangeProperty.builder()
   * .dataDriven(dataDriven)
   * .minMax(AxisDisplayMinMaxRangeProperty.builder()
   * .maximum(123)
   * .minimum(123)
   * .build())
   * .build())
   * .scale(AxisScaleProperty.builder()
   * .linear(AxisLinearScaleProperty.builder()
   * .stepCount(123)
   * .stepSize(123)
   * .build())
   * .logarithmic(AxisLogarithmicScaleProperty.builder()
   * .base(123)
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericaxisoptions.html)
   */
  public inline
      fun cfnAnalysisNumericAxisOptionsProperty(block: CfnAnalysisNumericAxisOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.NumericAxisOptionsProperty {
    val builder = CfnAnalysisNumericAxisOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The category drill down filter.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * NumericEqualityDrillDownFilterProperty numericEqualityDrillDownFilterProperty =
   * NumericEqualityDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .value(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalitydrilldownfilter.html)
   */
  public inline
      fun cfnAnalysisNumericEqualityDrillDownFilterProperty(block: CfnAnalysisNumericEqualityDrillDownFilterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.NumericEqualityDrillDownFilterProperty {
    val builder = CfnAnalysisNumericEqualityDrillDownFilterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A `NumericEqualityFilter` filters values that are equal to the specified value.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * NumericEqualityFilterProperty numericEqualityFilterProperty =
   * NumericEqualityFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * .matchOperator("matchOperator")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .parameterName("parameterName")
   * .selectAllOptions("selectAllOptions")
   * .value(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericequalityfilter.html)
   */
  public inline
      fun cfnAnalysisNumericEqualityFilterProperty(block: CfnAnalysisNumericEqualityFilterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.NumericEqualityFilterProperty {
    val builder = CfnAnalysisNumericEqualityFilterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the numeric format configuration.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * NumericFormatConfigurationProperty numericFormatConfigurationProperty =
   * NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericformatconfiguration.html)
   */
  public inline
      fun cfnAnalysisNumericFormatConfigurationProperty(block: CfnAnalysisNumericFormatConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.NumericFormatConfigurationProperty {
    val builder = CfnAnalysisNumericFormatConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A `NumericRangeFilter` filters values that are within the value range.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * NumericRangeFilterProperty numericRangeFilterProperty = NumericRangeFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .includeMaximum(false)
   * .includeMinimum(false)
   * .rangeMaximum(NumericRangeFilterValueProperty.builder()
   * .parameter("parameter")
   * .staticValue(123)
   * .build())
   * .rangeMinimum(NumericRangeFilterValueProperty.builder()
   * .parameter("parameter")
   * .staticValue(123)
   * .build())
   * .selectAllOptions("selectAllOptions")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefilter.html)
   */
  public inline
      fun cfnAnalysisNumericRangeFilterProperty(block: CfnAnalysisNumericRangeFilterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.NumericRangeFilterProperty {
    val builder = CfnAnalysisNumericRangeFilterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The value input pf the numeric range filter.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * NumericRangeFilterValueProperty numericRangeFilterValueProperty =
   * NumericRangeFilterValueProperty.builder()
   * .parameter("parameter")
   * .staticValue(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericrangefiltervalue.html)
   */
  public inline
      fun cfnAnalysisNumericRangeFilterValueProperty(block: CfnAnalysisNumericRangeFilterValuePropertyDsl.() -> Unit
      = {}): CfnAnalysis.NumericRangeFilterValueProperty {
    val builder = CfnAnalysisNumericRangeFilterValuePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the numeric separator configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * NumericSeparatorConfigurationProperty numericSeparatorConfigurationProperty =
   * NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericseparatorconfiguration.html)
   */
  public inline
      fun cfnAnalysisNumericSeparatorConfigurationProperty(block: CfnAnalysisNumericSeparatorConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.NumericSeparatorConfigurationProperty {
    val builder = CfnAnalysisNumericSeparatorConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Aggregation for numerical values.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * NumericalAggregationFunctionProperty numericalAggregationFunctionProperty =
   * NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericalaggregationfunction.html)
   */
  public inline
      fun cfnAnalysisNumericalAggregationFunctionProperty(block: CfnAnalysisNumericalAggregationFunctionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.NumericalAggregationFunctionProperty {
    val builder = CfnAnalysisNumericalAggregationFunctionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The dimension type field with numerical type columns.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * NumericalDimensionFieldProperty numericalDimensionFieldProperty =
   * NumericalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericaldimensionfield.html)
   */
  public inline
      fun cfnAnalysisNumericalDimensionFieldProperty(block: CfnAnalysisNumericalDimensionFieldPropertyDsl.() -> Unit
      = {}): CfnAnalysis.NumericalDimensionFieldProperty {
    val builder = CfnAnalysisNumericalDimensionFieldPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The measure type field with numerical type columns.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * NumericalMeasureFieldProperty numericalMeasureFieldProperty =
   * NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-numericalmeasurefield.html)
   */
  public inline
      fun cfnAnalysisNumericalMeasureFieldProperty(block: CfnAnalysisNumericalMeasureFieldPropertyDsl.() -> Unit
      = {}): CfnAnalysis.NumericalMeasureFieldProperty {
    val builder = CfnAnalysisNumericalMeasureFieldPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The pagination configuration for a table visual or boxplot.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PaginationConfigurationProperty paginationConfigurationProperty =
   * PaginationConfigurationProperty.builder()
   * .pageNumber(123)
   * .pageSize(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-paginationconfiguration.html)
   */
  public inline
      fun cfnAnalysisPaginationConfigurationProperty(block: CfnAnalysisPaginationConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PaginationConfigurationProperty {
    val builder = CfnAnalysisPaginationConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A collection of options that configure how each panel displays in a small multiples chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PanelConfigurationProperty panelConfigurationProperty = PanelConfigurationProperty.builder()
   * .backgroundColor("backgroundColor")
   * .backgroundVisibility("backgroundVisibility")
   * .borderColor("borderColor")
   * .borderStyle("borderStyle")
   * .borderThickness("borderThickness")
   * .borderVisibility("borderVisibility")
   * .gutterSpacing("gutterSpacing")
   * .gutterVisibility("gutterVisibility")
   * .title(PanelTitleOptionsProperty.builder()
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-panelconfiguration.html)
   */
  public inline
      fun cfnAnalysisPanelConfigurationProperty(block: CfnAnalysisPanelConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PanelConfigurationProperty {
    val builder = CfnAnalysisPanelConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the title styles for each small multiples panel.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PanelTitleOptionsProperty panelTitleOptionsProperty = PanelTitleOptionsProperty.builder()
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-paneltitleoptions.html)
   */
  public inline
      fun cfnAnalysisPanelTitleOptionsProperty(block: CfnAnalysisPanelTitleOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PanelTitleOptionsProperty {
    val builder = CfnAnalysisPanelTitleOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The control of a parameter that users can interact with in a dashboard or an analysis.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ParameterControlProperty parameterControlProperty = ParameterControlProperty.builder()
   * .dateTimePicker(ParameterDateTimePickerControlProperty.builder()
   * .parameterControlId("parameterControlId")
   * .sourceParameterName("sourceParameterName")
   * .title("title")
   * // the properties below are optional
   * .displayOptions(DateTimePickerControlDisplayOptionsProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .build())
   * .dropdown(ParameterDropDownControlProperty.builder()
   * .parameterControlId("parameterControlId")
   * .sourceParameterName("sourceParameterName")
   * .title("title")
   * // the properties below are optional
   * .cascadingControlConfiguration(CascadingControlConfigurationProperty.builder()
   * .sourceControls(List.of(CascadingControlSourceProperty.builder()
   * .columnToMatch(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceSheetControlId("sourceSheetControlId")
   * .build()))
   * .build())
   * .displayOptions(DropDownControlDisplayOptionsProperty.builder()
   * .selectAllOptions(ListControlSelectAllOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .selectableValues(ParameterSelectableValuesProperty.builder()
   * .linkToDataSetColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .values(List.of("values"))
   * .build())
   * .type("type")
   * .build())
   * .list(ParameterListControlProperty.builder()
   * .parameterControlId("parameterControlId")
   * .sourceParameterName("sourceParameterName")
   * .title("title")
   * // the properties below are optional
   * .cascadingControlConfiguration(CascadingControlConfigurationProperty.builder()
   * .sourceControls(List.of(CascadingControlSourceProperty.builder()
   * .columnToMatch(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceSheetControlId("sourceSheetControlId")
   * .build()))
   * .build())
   * .displayOptions(ListControlDisplayOptionsProperty.builder()
   * .searchOptions(ListControlSearchOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .selectAllOptions(ListControlSelectAllOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .selectableValues(ParameterSelectableValuesProperty.builder()
   * .linkToDataSetColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .values(List.of("values"))
   * .build())
   * .type("type")
   * .build())
   * .slider(ParameterSliderControlProperty.builder()
   * .maximumValue(123)
   * .minimumValue(123)
   * .parameterControlId("parameterControlId")
   * .sourceParameterName("sourceParameterName")
   * .stepSize(123)
   * .title("title")
   * // the properties below are optional
   * .displayOptions(SliderControlDisplayOptionsProperty.builder()
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .build())
   * .textArea(ParameterTextAreaControlProperty.builder()
   * .parameterControlId("parameterControlId")
   * .sourceParameterName("sourceParameterName")
   * .title("title")
   * // the properties below are optional
   * .delimiter("delimiter")
   * .displayOptions(TextAreaControlDisplayOptionsProperty.builder()
   * .placeholderOptions(TextControlPlaceholderOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .build())
   * .textField(ParameterTextFieldControlProperty.builder()
   * .parameterControlId("parameterControlId")
   * .sourceParameterName("sourceParameterName")
   * .title("title")
   * // the properties below are optional
   * .displayOptions(TextFieldControlDisplayOptionsProperty.builder()
   * .placeholderOptions(TextControlPlaceholderOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametercontrol.html)
   */
  public inline
      fun cfnAnalysisParameterControlProperty(block: CfnAnalysisParameterControlPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ParameterControlProperty {
    val builder = CfnAnalysisParameterControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A control from a date parameter that specifies date and time.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ParameterDateTimePickerControlProperty parameterDateTimePickerControlProperty =
   * ParameterDateTimePickerControlProperty.builder()
   * .parameterControlId("parameterControlId")
   * .sourceParameterName("sourceParameterName")
   * .title("title")
   * // the properties below are optional
   * .displayOptions(DateTimePickerControlDisplayOptionsProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdatetimepickercontrol.html)
   */
  public inline
      fun cfnAnalysisParameterDateTimePickerControlProperty(block: CfnAnalysisParameterDateTimePickerControlPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ParameterDateTimePickerControlProperty {
    val builder = CfnAnalysisParameterDateTimePickerControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The declaration definition of a parameter.
   *
   * For more information, see [Parameters in Amazon
   * QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html) in
   * the *Amazon QuickSight User Guide* .
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ParameterDeclarationProperty parameterDeclarationProperty =
   * ParameterDeclarationProperty.builder()
   * .dateTimeParameterDeclaration(DateTimeParameterDeclarationProperty.builder()
   * .name("name")
   * // the properties below are optional
   * .defaultValues(DateTimeDefaultValuesProperty.builder()
   * .dynamicValue(DynamicDefaultValueProperty.builder()
   * .defaultValueColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .groupNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .userNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .rollingDate(RollingDateConfigurationProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .staticValues(List.of("staticValues"))
   * .build())
   * .mappedDataSetParameters(List.of(MappedDataSetParameterProperty.builder()
   * .dataSetIdentifier("dataSetIdentifier")
   * .dataSetParameterName("dataSetParameterName")
   * .build()))
   * .timeGranularity("timeGranularity")
   * .valueWhenUnset(DateTimeValueWhenUnsetConfigurationProperty.builder()
   * .customValue("customValue")
   * .valueWhenUnsetOption("valueWhenUnsetOption")
   * .build())
   * .build())
   * .decimalParameterDeclaration(DecimalParameterDeclarationProperty.builder()
   * .name("name")
   * .parameterValueType("parameterValueType")
   * // the properties below are optional
   * .defaultValues(DecimalDefaultValuesProperty.builder()
   * .dynamicValue(DynamicDefaultValueProperty.builder()
   * .defaultValueColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .groupNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .userNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .staticValues(List.of(123))
   * .build())
   * .mappedDataSetParameters(List.of(MappedDataSetParameterProperty.builder()
   * .dataSetIdentifier("dataSetIdentifier")
   * .dataSetParameterName("dataSetParameterName")
   * .build()))
   * .valueWhenUnset(DecimalValueWhenUnsetConfigurationProperty.builder()
   * .customValue(123)
   * .valueWhenUnsetOption("valueWhenUnsetOption")
   * .build())
   * .build())
   * .integerParameterDeclaration(IntegerParameterDeclarationProperty.builder()
   * .name("name")
   * .parameterValueType("parameterValueType")
   * // the properties below are optional
   * .defaultValues(IntegerDefaultValuesProperty.builder()
   * .dynamicValue(DynamicDefaultValueProperty.builder()
   * .defaultValueColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .groupNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .userNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .staticValues(List.of(123))
   * .build())
   * .mappedDataSetParameters(List.of(MappedDataSetParameterProperty.builder()
   * .dataSetIdentifier("dataSetIdentifier")
   * .dataSetParameterName("dataSetParameterName")
   * .build()))
   * .valueWhenUnset(IntegerValueWhenUnsetConfigurationProperty.builder()
   * .customValue(123)
   * .valueWhenUnsetOption("valueWhenUnsetOption")
   * .build())
   * .build())
   * .stringParameterDeclaration(StringParameterDeclarationProperty.builder()
   * .name("name")
   * .parameterValueType("parameterValueType")
   * // the properties below are optional
   * .defaultValues(StringDefaultValuesProperty.builder()
   * .dynamicValue(DynamicDefaultValueProperty.builder()
   * .defaultValueColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .groupNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .userNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .staticValues(List.of("staticValues"))
   * .build())
   * .mappedDataSetParameters(List.of(MappedDataSetParameterProperty.builder()
   * .dataSetIdentifier("dataSetIdentifier")
   * .dataSetParameterName("dataSetParameterName")
   * .build()))
   * .valueWhenUnset(StringValueWhenUnsetConfigurationProperty.builder()
   * .customValue("customValue")
   * .valueWhenUnsetOption("valueWhenUnsetOption")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdeclaration.html)
   */
  public inline
      fun cfnAnalysisParameterDeclarationProperty(block: CfnAnalysisParameterDeclarationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ParameterDeclarationProperty {
    val builder = CfnAnalysisParameterDeclarationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A control to display a dropdown list with buttons that are used to select a single value.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ParameterDropDownControlProperty parameterDropDownControlProperty =
   * ParameterDropDownControlProperty.builder()
   * .parameterControlId("parameterControlId")
   * .sourceParameterName("sourceParameterName")
   * .title("title")
   * // the properties below are optional
   * .cascadingControlConfiguration(CascadingControlConfigurationProperty.builder()
   * .sourceControls(List.of(CascadingControlSourceProperty.builder()
   * .columnToMatch(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceSheetControlId("sourceSheetControlId")
   * .build()))
   * .build())
   * .displayOptions(DropDownControlDisplayOptionsProperty.builder()
   * .selectAllOptions(ListControlSelectAllOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .selectableValues(ParameterSelectableValuesProperty.builder()
   * .linkToDataSetColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .values(List.of("values"))
   * .build())
   * .type("type")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterdropdowncontrol.html)
   */
  public inline
      fun cfnAnalysisParameterDropDownControlProperty(block: CfnAnalysisParameterDropDownControlPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ParameterDropDownControlProperty {
    val builder = CfnAnalysisParameterDropDownControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A control to display a list with buttons or boxes that are used to select either a single value
   * or multiple values.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ParameterListControlProperty parameterListControlProperty =
   * ParameterListControlProperty.builder()
   * .parameterControlId("parameterControlId")
   * .sourceParameterName("sourceParameterName")
   * .title("title")
   * // the properties below are optional
   * .cascadingControlConfiguration(CascadingControlConfigurationProperty.builder()
   * .sourceControls(List.of(CascadingControlSourceProperty.builder()
   * .columnToMatch(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceSheetControlId("sourceSheetControlId")
   * .build()))
   * .build())
   * .displayOptions(ListControlDisplayOptionsProperty.builder()
   * .searchOptions(ListControlSearchOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .selectAllOptions(ListControlSelectAllOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .selectableValues(ParameterSelectableValuesProperty.builder()
   * .linkToDataSetColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .values(List.of("values"))
   * .build())
   * .type("type")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterlistcontrol.html)
   */
  public inline
      fun cfnAnalysisParameterListControlProperty(block: CfnAnalysisParameterListControlPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ParameterListControlProperty {
    val builder = CfnAnalysisParameterListControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A list of selectable values that are used in a control.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ParameterSelectableValuesProperty parameterSelectableValuesProperty =
   * ParameterSelectableValuesProperty.builder()
   * .linkToDataSetColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .values(List.of("values"))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterselectablevalues.html)
   */
  public inline
      fun cfnAnalysisParameterSelectableValuesProperty(block: CfnAnalysisParameterSelectableValuesPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ParameterSelectableValuesProperty {
    val builder = CfnAnalysisParameterSelectableValuesPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A control to display a horizontal toggle bar.
   *
   * This is used to change a value by sliding the toggle.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ParameterSliderControlProperty parameterSliderControlProperty =
   * ParameterSliderControlProperty.builder()
   * .maximumValue(123)
   * .minimumValue(123)
   * .parameterControlId("parameterControlId")
   * .sourceParameterName("sourceParameterName")
   * .stepSize(123)
   * .title("title")
   * // the properties below are optional
   * .displayOptions(SliderControlDisplayOptionsProperty.builder()
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameterslidercontrol.html)
   */
  public inline
      fun cfnAnalysisParameterSliderControlProperty(block: CfnAnalysisParameterSliderControlPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ParameterSliderControlProperty {
    val builder = CfnAnalysisParameterSliderControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A control to display a text box that is used to enter multiple entries.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ParameterTextAreaControlProperty parameterTextAreaControlProperty =
   * ParameterTextAreaControlProperty.builder()
   * .parameterControlId("parameterControlId")
   * .sourceParameterName("sourceParameterName")
   * .title("title")
   * // the properties below are optional
   * .delimiter("delimiter")
   * .displayOptions(TextAreaControlDisplayOptionsProperty.builder()
   * .placeholderOptions(TextControlPlaceholderOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametertextareacontrol.html)
   */
  public inline
      fun cfnAnalysisParameterTextAreaControlProperty(block: CfnAnalysisParameterTextAreaControlPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ParameterTextAreaControlProperty {
    val builder = CfnAnalysisParameterTextAreaControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A control to display a text box that is used to enter a single entry.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ParameterTextFieldControlProperty parameterTextFieldControlProperty =
   * ParameterTextFieldControlProperty.builder()
   * .parameterControlId("parameterControlId")
   * .sourceParameterName("sourceParameterName")
   * .title("title")
   * // the properties below are optional
   * .displayOptions(TextFieldControlDisplayOptionsProperty.builder()
   * .placeholderOptions(TextControlPlaceholderOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parametertextfieldcontrol.html)
   */
  public inline
      fun cfnAnalysisParameterTextFieldControlProperty(block: CfnAnalysisParameterTextFieldControlPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ParameterTextFieldControlProperty {
    val builder = CfnAnalysisParameterTextFieldControlPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A list of Amazon QuickSight parameters and the list's override values.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ParametersProperty parametersProperty = ParametersProperty.builder()
   * .dateTimeParameters(List.of(DateTimeParameterProperty.builder()
   * .name("name")
   * .values(List.of("values"))
   * .build()))
   * .decimalParameters(List.of(DecimalParameterProperty.builder()
   * .name("name")
   * .values(List.of(123))
   * .build()))
   * .integerParameters(List.of(IntegerParameterProperty.builder()
   * .name("name")
   * .values(List.of(123))
   * .build()))
   * .stringParameters(List.of(StringParameterProperty.builder()
   * .name("name")
   * .values(List.of("values"))
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-parameters.html)
   */
  public inline fun cfnAnalysisParametersProperty(block: CfnAnalysisParametersPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ParametersProperty {
    val builder = CfnAnalysisParametersPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The percent range in the visible range.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PercentVisibleRangeProperty percentVisibleRangeProperty = PercentVisibleRangeProperty.builder()
   * .from(123)
   * .to(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentvisiblerange.html)
   */
  public inline
      fun cfnAnalysisPercentVisibleRangeProperty(block: CfnAnalysisPercentVisibleRangePropertyDsl.() -> Unit
      = {}): CfnAnalysis.PercentVisibleRangeProperty {
    val builder = CfnAnalysisPercentVisibleRangePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the percentage display format configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PercentageDisplayFormatConfigurationProperty percentageDisplayFormatConfigurationProperty =
   * PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentagedisplayformatconfiguration.html)
   */
  public inline
      fun cfnAnalysisPercentageDisplayFormatConfigurationProperty(block: CfnAnalysisPercentageDisplayFormatConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PercentageDisplayFormatConfigurationProperty {
    val builder = CfnAnalysisPercentageDisplayFormatConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * An aggregation based on the percentile of values in a dimension or measure.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PercentileAggregationProperty percentileAggregationProperty =
   * PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-percentileaggregation.html)
   */
  public inline
      fun cfnAnalysisPercentileAggregationProperty(block: CfnAnalysisPercentileAggregationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PercentileAggregationProperty {
    val builder = CfnAnalysisPercentileAggregationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The period over period computation configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PeriodOverPeriodComputationProperty periodOverPeriodComputationProperty =
   * PeriodOverPeriodComputationProperty.builder()
   * .computationId("computationId")
   * .time(DimensionFieldProperty.builder()
   * .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .dateDimensionField(DateDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .dateGranularity("dateGranularity")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .numericalDimensionField(NumericalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .build())
   * // the properties below are optional
   * .name("name")
   * .value(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-periodoverperiodcomputation.html)
   */
  public inline
      fun cfnAnalysisPeriodOverPeriodComputationProperty(block: CfnAnalysisPeriodOverPeriodComputationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PeriodOverPeriodComputationProperty {
    val builder = CfnAnalysisPeriodOverPeriodComputationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The period to date computation configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PeriodToDateComputationProperty periodToDateComputationProperty =
   * PeriodToDateComputationProperty.builder()
   * .computationId("computationId")
   * .time(DimensionFieldProperty.builder()
   * .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .dateDimensionField(DateDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .dateGranularity("dateGranularity")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .numericalDimensionField(NumericalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .build())
   * // the properties below are optional
   * .name("name")
   * .periodTimeGranularity("periodTimeGranularity")
   * .value(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-periodtodatecomputation.html)
   */
  public inline
      fun cfnAnalysisPeriodToDateComputationProperty(block: CfnAnalysisPeriodToDateComputationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PeriodToDateComputationProperty {
    val builder = CfnAnalysisPeriodToDateComputationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field well configuration of a pie chart.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisPieChartAggregatedFieldWellsProperty(block: CfnAnalysisPieChartAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PieChartAggregatedFieldWellsProperty {
    val builder = CfnAnalysisPieChartAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a pie chart.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartconfiguration.html)
   */
  public inline
      fun cfnAnalysisPieChartConfigurationProperty(block: CfnAnalysisPieChartConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PieChartConfigurationProperty {
    val builder = CfnAnalysisPieChartConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field well configuration of a pie chart.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartfieldwells.html)
   */
  public inline
      fun cfnAnalysisPieChartFieldWellsProperty(block: CfnAnalysisPieChartFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PieChartFieldWellsProperty {
    val builder = CfnAnalysisPieChartFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration of a pie chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PieChartSortConfigurationProperty pieChartSortConfigurationProperty =
   * PieChartSortConfigurationProperty.builder()
   * .categoryItemsLimit(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .categorySort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .smallMultiplesLimitConfiguration(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .smallMultiplesSort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartsortconfiguration.html)
   */
  public inline
      fun cfnAnalysisPieChartSortConfigurationProperty(block: CfnAnalysisPieChartSortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PieChartSortConfigurationProperty {
    val builder = CfnAnalysisPieChartSortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A pie or donut chart.
   *
   * The `PieChartVisual` structure describes a visual that is a member of the pie chart family.
   *
   * The following charts can be described by using this structure:
   *
   * * Pie charts
   * * Donut charts
   *
   * For more information, see [Using pie
   * charts](https://docs.aws.amazon.com/quicksight/latest/user/pie-chart.html) in the *Amazon
   * QuickSight User Guide* .
   *
   * For more information, see [Using donut
   * charts](https://docs.aws.amazon.com/quicksight/latest/user/donut-chart.html) in the *Amazon
   * QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-piechartvisual.html)
   */
  public inline
      fun cfnAnalysisPieChartVisualProperty(block: CfnAnalysisPieChartVisualPropertyDsl.() -> Unit =
      {}): CfnAnalysis.PieChartVisualProperty {
    val builder = CfnAnalysisPieChartVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field sort options for a pivot table sort configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotFieldSortOptionsProperty pivotFieldSortOptionsProperty =
   * PivotFieldSortOptionsProperty.builder()
   * .fieldId("fieldId")
   * .sortBy(PivotTableSortByProperty.builder()
   * .column(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .dataPath(DataPathSortProperty.builder()
   * .direction("direction")
   * .sortPaths(List.of(DataPathValueProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .build()))
   * .build())
   * .field(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivotfieldsortoptions.html)
   */
  public inline
      fun cfnAnalysisPivotFieldSortOptionsProperty(block: CfnAnalysisPivotFieldSortOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotFieldSortOptionsProperty {
    val builder = CfnAnalysisPivotFieldSortOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The aggregated field well for the pivot table.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisPivotTableAggregatedFieldWellsProperty(block: CfnAnalysisPivotTableAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableAggregatedFieldWellsProperty {
    val builder = CfnAnalysisPivotTableAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The cell conditional formatting option for a pivot table.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTableCellConditionalFormattingProperty pivotTableCellConditionalFormattingProperty =
   * PivotTableCellConditionalFormattingProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .scope(PivotTableConditionalFormattingScopeProperty.builder()
   * .role("role")
   * .build())
   * .scopes(List.of(PivotTableConditionalFormattingScopeProperty.builder()
   * .role("role")
   * .build()))
   * .textFormat(TextConditionalFormatProperty.builder()
   * .backgroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .icon(ConditionalFormattingIconProperty.builder()
   * .customCondition(ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build())
   * .iconSet(ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablecellconditionalformatting.html)
   */
  public inline
      fun cfnAnalysisPivotTableCellConditionalFormattingProperty(block: CfnAnalysisPivotTableCellConditionalFormattingPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableCellConditionalFormattingProperty {
    val builder = CfnAnalysisPivotTableCellConditionalFormattingPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Conditional formatting options for a `PivotTableVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTableConditionalFormattingOptionProperty pivotTableConditionalFormattingOptionProperty =
   * PivotTableConditionalFormattingOptionProperty.builder()
   * .cell(PivotTableCellConditionalFormattingProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .scope(PivotTableConditionalFormattingScopeProperty.builder()
   * .role("role")
   * .build())
   * .scopes(List.of(PivotTableConditionalFormattingScopeProperty.builder()
   * .role("role")
   * .build()))
   * .textFormat(TextConditionalFormatProperty.builder()
   * .backgroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .icon(ConditionalFormattingIconProperty.builder()
   * .customCondition(ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build())
   * .iconSet(ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconditionalformattingoption.html)
   */
  public inline
      fun cfnAnalysisPivotTableConditionalFormattingOptionProperty(block: CfnAnalysisPivotTableConditionalFormattingOptionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableConditionalFormattingOptionProperty {
    val builder = CfnAnalysisPivotTableConditionalFormattingOptionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The conditional formatting for a `PivotTableVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTableConditionalFormattingProperty pivotTableConditionalFormattingProperty =
   * PivotTableConditionalFormattingProperty.builder()
   * .conditionalFormattingOptions(List.of(PivotTableConditionalFormattingOptionProperty.builder()
   * .cell(PivotTableCellConditionalFormattingProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .scope(PivotTableConditionalFormattingScopeProperty.builder()
   * .role("role")
   * .build())
   * .scopes(List.of(PivotTableConditionalFormattingScopeProperty.builder()
   * .role("role")
   * .build()))
   * .textFormat(TextConditionalFormatProperty.builder()
   * .backgroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .icon(ConditionalFormattingIconProperty.builder()
   * .customCondition(ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build())
   * .iconSet(ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconditionalformatting.html)
   */
  public inline
      fun cfnAnalysisPivotTableConditionalFormattingProperty(block: CfnAnalysisPivotTableConditionalFormattingPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableConditionalFormattingProperty {
    val builder = CfnAnalysisPivotTableConditionalFormattingPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The scope of the cell for conditional formatting.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTableConditionalFormattingScopeProperty pivotTableConditionalFormattingScopeProperty =
   * PivotTableConditionalFormattingScopeProperty.builder()
   * .role("role")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconditionalformattingscope.html)
   */
  public inline
      fun cfnAnalysisPivotTableConditionalFormattingScopeProperty(block: CfnAnalysisPivotTableConditionalFormattingScopePropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableConditionalFormattingScopeProperty {
    val builder = CfnAnalysisPivotTableConditionalFormattingScopePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration for a `PivotTableVisual` .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableconfiguration.html)
   */
  public inline
      fun cfnAnalysisPivotTableConfigurationProperty(block: CfnAnalysisPivotTableConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableConfigurationProperty {
    val builder = CfnAnalysisPivotTableConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The data path options for the pivot table field options.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTableDataPathOptionProperty pivotTableDataPathOptionProperty =
   * PivotTableDataPathOptionProperty.builder()
   * .dataPathList(List.of(DataPathValueProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .build()))
   * // the properties below are optional
   * .width("width")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottabledatapathoption.html)
   */
  public inline
      fun cfnAnalysisPivotTableDataPathOptionProperty(block: CfnAnalysisPivotTableDataPathOptionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableDataPathOptionProperty {
    val builder = CfnAnalysisPivotTableDataPathOptionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The collapse state options for the pivot table field options.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTableFieldCollapseStateOptionProperty pivotTableFieldCollapseStateOptionProperty =
   * PivotTableFieldCollapseStateOptionProperty.builder()
   * .target(PivotTableFieldCollapseStateTargetProperty.builder()
   * .fieldDataPathValues(List.of(DataPathValueProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .build()))
   * .fieldId("fieldId")
   * .build())
   * // the properties below are optional
   * .state("state")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldcollapsestateoption.html)
   */
  public inline
      fun cfnAnalysisPivotTableFieldCollapseStateOptionProperty(block: CfnAnalysisPivotTableFieldCollapseStateOptionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableFieldCollapseStateOptionProperty {
    val builder = CfnAnalysisPivotTableFieldCollapseStateOptionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The target of a pivot table field collapse state.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTableFieldCollapseStateTargetProperty pivotTableFieldCollapseStateTargetProperty =
   * PivotTableFieldCollapseStateTargetProperty.builder()
   * .fieldDataPathValues(List.of(DataPathValueProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .build()))
   * .fieldId("fieldId")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldcollapsestatetarget.html)
   */
  public inline
      fun cfnAnalysisPivotTableFieldCollapseStateTargetProperty(block: CfnAnalysisPivotTableFieldCollapseStateTargetPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableFieldCollapseStateTargetProperty {
    val builder = CfnAnalysisPivotTableFieldCollapseStateTargetPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The selected field options for the pivot table field options.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTableFieldOptionProperty pivotTableFieldOptionProperty =
   * PivotTableFieldOptionProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .customLabel("customLabel")
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldoption.html)
   */
  public inline
      fun cfnAnalysisPivotTableFieldOptionProperty(block: CfnAnalysisPivotTableFieldOptionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableFieldOptionProperty {
    val builder = CfnAnalysisPivotTableFieldOptionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field options for a pivot table visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTableFieldOptionsProperty pivotTableFieldOptionsProperty =
   * PivotTableFieldOptionsProperty.builder()
   * .collapseStateOptions(List.of(PivotTableFieldCollapseStateOptionProperty.builder()
   * .target(PivotTableFieldCollapseStateTargetProperty.builder()
   * .fieldDataPathValues(List.of(DataPathValueProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .build()))
   * .fieldId("fieldId")
   * .build())
   * // the properties below are optional
   * .state("state")
   * .build()))
   * .dataPathOptions(List.of(PivotTableDataPathOptionProperty.builder()
   * .dataPathList(List.of(DataPathValueProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .build()))
   * // the properties below are optional
   * .width("width")
   * .build()))
   * .selectedFieldOptions(List.of(PivotTableFieldOptionProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .customLabel("customLabel")
   * .visibility("visibility")
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldoptions.html)
   */
  public inline
      fun cfnAnalysisPivotTableFieldOptionsProperty(block: CfnAnalysisPivotTableFieldOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableFieldOptionsProperty {
    val builder = CfnAnalysisPivotTableFieldOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The optional configuration of subtotals cells.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTableFieldSubtotalOptionsProperty pivotTableFieldSubtotalOptionsProperty =
   * PivotTableFieldSubtotalOptionsProperty.builder()
   * .fieldId("fieldId")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldsubtotaloptions.html)
   */
  public inline
      fun cfnAnalysisPivotTableFieldSubtotalOptionsProperty(block: CfnAnalysisPivotTableFieldSubtotalOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableFieldSubtotalOptionsProperty {
    val builder = CfnAnalysisPivotTableFieldSubtotalOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field wells for a pivot table visual.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablefieldwells.html)
   */
  public inline
      fun cfnAnalysisPivotTableFieldWellsProperty(block: CfnAnalysisPivotTableFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableFieldWellsProperty {
    val builder = CfnAnalysisPivotTableFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The table options for a pivot table visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTableOptionsProperty pivotTableOptionsProperty = PivotTableOptionsProperty.builder()
   * .cellStyle(TableCellStyleProperty.builder()
   * .backgroundColor("backgroundColor")
   * .border(GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .height(123)
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .textWrap("textWrap")
   * .verticalTextAlignment("verticalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .collapsedRowDimensionsVisibility("collapsedRowDimensionsVisibility")
   * .columnHeaderStyle(TableCellStyleProperty.builder()
   * .backgroundColor("backgroundColor")
   * .border(GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .height(123)
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .textWrap("textWrap")
   * .verticalTextAlignment("verticalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .columnNamesVisibility("columnNamesVisibility")
   * .metricPlacement("metricPlacement")
   * .rowAlternateColorOptions(RowAlternateColorOptionsProperty.builder()
   * .rowAlternateColors(List.of("rowAlternateColors"))
   * .status("status")
   * .build())
   * .rowFieldNamesStyle(TableCellStyleProperty.builder()
   * .backgroundColor("backgroundColor")
   * .border(GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .height(123)
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .textWrap("textWrap")
   * .verticalTextAlignment("verticalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .rowHeaderStyle(TableCellStyleProperty.builder()
   * .backgroundColor("backgroundColor")
   * .border(GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .height(123)
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .textWrap("textWrap")
   * .verticalTextAlignment("verticalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .singleMetricVisibility("singleMetricVisibility")
   * .toggleButtonsVisibility("toggleButtonsVisibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottableoptions.html)
   */
  public inline
      fun cfnAnalysisPivotTableOptionsProperty(block: CfnAnalysisPivotTableOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableOptionsProperty {
    val builder = CfnAnalysisPivotTableOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The paginated report options for a pivot table visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTablePaginatedReportOptionsProperty pivotTablePaginatedReportOptionsProperty =
   * PivotTablePaginatedReportOptionsProperty.builder()
   * .overflowColumnHeaderVisibility("overflowColumnHeaderVisibility")
   * .verticalOverflowVisibility("verticalOverflowVisibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablepaginatedreportoptions.html)
   */
  public inline
      fun cfnAnalysisPivotTablePaginatedReportOptionsProperty(block: CfnAnalysisPivotTablePaginatedReportOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTablePaginatedReportOptionsProperty {
    val builder = CfnAnalysisPivotTablePaginatedReportOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort by field for the field sort options.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTableSortByProperty pivotTableSortByProperty = PivotTableSortByProperty.builder()
   * .column(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .dataPath(DataPathSortProperty.builder()
   * .direction("direction")
   * .sortPaths(List.of(DataPathValueProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .build()))
   * .build())
   * .field(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablesortby.html)
   */
  public inline
      fun cfnAnalysisPivotTableSortByProperty(block: CfnAnalysisPivotTableSortByPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableSortByProperty {
    val builder = CfnAnalysisPivotTableSortByPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration for a `PivotTableVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTableSortConfigurationProperty pivotTableSortConfigurationProperty =
   * PivotTableSortConfigurationProperty.builder()
   * .fieldSortOptions(List.of(PivotFieldSortOptionsProperty.builder()
   * .fieldId("fieldId")
   * .sortBy(PivotTableSortByProperty.builder()
   * .column(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .dataPath(DataPathSortProperty.builder()
   * .direction("direction")
   * .sortPaths(List.of(DataPathValueProperty.builder()
   * .fieldId("fieldId")
   * .fieldValue("fieldValue")
   * .build()))
   * .build())
   * .field(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablesortconfiguration.html)
   */
  public inline
      fun cfnAnalysisPivotTableSortConfigurationProperty(block: CfnAnalysisPivotTableSortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableSortConfigurationProperty {
    val builder = CfnAnalysisPivotTableSortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The total options for a pivot table visual.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottabletotaloptions.html)
   */
  public inline
      fun cfnAnalysisPivotTableTotalOptionsProperty(block: CfnAnalysisPivotTableTotalOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableTotalOptionsProperty {
    val builder = CfnAnalysisPivotTableTotalOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A pivot table.
   *
   * For more information, see [Using pivot
   * tables](https://docs.aws.amazon.com/quicksight/latest/user/pivot-table.html) in the *Amazon
   * QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottablevisual.html)
   */
  public inline
      fun cfnAnalysisPivotTableVisualProperty(block: CfnAnalysisPivotTableVisualPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTableVisualProperty {
    val builder = CfnAnalysisPivotTableVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The optional configuration of totals cells in a `PivotTableVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PivotTotalOptionsProperty pivotTotalOptionsProperty = PivotTotalOptionsProperty.builder()
   * .customLabel("customLabel")
   * .metricHeaderCellStyle(TableCellStyleProperty.builder()
   * .backgroundColor("backgroundColor")
   * .border(GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .height(123)
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .textWrap("textWrap")
   * .verticalTextAlignment("verticalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .placement("placement")
   * .scrollStatus("scrollStatus")
   * .totalCellStyle(TableCellStyleProperty.builder()
   * .backgroundColor("backgroundColor")
   * .border(GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .height(123)
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .textWrap("textWrap")
   * .verticalTextAlignment("verticalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .totalsVisibility("totalsVisibility")
   * .valueCellStyle(TableCellStyleProperty.builder()
   * .backgroundColor("backgroundColor")
   * .border(GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .height(123)
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .textWrap("textWrap")
   * .verticalTextAlignment("verticalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-pivottotaloptions.html)
   */
  public inline
      fun cfnAnalysisPivotTotalOptionsProperty(block: CfnAnalysisPivotTotalOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PivotTotalOptionsProperty {
    val builder = CfnAnalysisPivotTotalOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The option that determines the hierarchy of the fields that are defined during data
   * preparation.
   *
   * These fields are available to use in any analysis that uses the data source.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * PredefinedHierarchyProperty predefinedHierarchyProperty = PredefinedHierarchyProperty.builder()
   * .columns(List.of(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build()))
   * .hierarchyId("hierarchyId")
   * // the properties below are optional
   * .drillDownFilters(List.of(DrillDownFilterProperty.builder()
   * .categoryFilter(CategoryDrillDownFilterProperty.builder()
   * .categoryValues(List.of("categoryValues"))
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .numericEqualityFilter(NumericEqualityDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .value(123)
   * .build())
   * .timeRangeFilter(TimeRangeDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .rangeMaximum("rangeMaximum")
   * .rangeMinimum("rangeMinimum")
   * .timeGranularity("timeGranularity")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-predefinedhierarchy.html)
   */
  public inline
      fun cfnAnalysisPredefinedHierarchyProperty(block: CfnAnalysisPredefinedHierarchyPropertyDsl.() -> Unit
      = {}): CfnAnalysis.PredefinedHierarchyProperty {
    val builder = CfnAnalysisPredefinedHierarchyPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the presentation of the progress bar of a KPI visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ProgressBarOptionsProperty progressBarOptionsProperty = ProgressBarOptionsProperty.builder()
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-progressbaroptions.html)
   */
  public inline
      fun cfnAnalysisProgressBarOptionsProperty(block: CfnAnalysisProgressBarOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ProgressBarOptionsProperty {
    val builder = CfnAnalysisProgressBarOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Properties for defining a `CfnAnalysis`.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-analysis.html)
   */
  public inline fun cfnAnalysisProps(block: CfnAnalysisPropsDsl.() -> Unit = {}): CfnAnalysisProps {
    val builder = CfnAnalysisPropsDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The aggregated field well configuration of a `RadarChartVisual` .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisRadarChartAggregatedFieldWellsProperty(block: CfnAnalysisRadarChartAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.RadarChartAggregatedFieldWellsProperty {
    val builder = CfnAnalysisRadarChartAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configured style settings of a radar chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * RadarChartAreaStyleSettingsProperty radarChartAreaStyleSettingsProperty =
   * RadarChartAreaStyleSettingsProperty.builder()
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartareastylesettings.html)
   */
  public inline
      fun cfnAnalysisRadarChartAreaStyleSettingsProperty(block: CfnAnalysisRadarChartAreaStyleSettingsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.RadarChartAreaStyleSettingsProperty {
    val builder = CfnAnalysisRadarChartAreaStyleSettingsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a `RadarChartVisual` .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartconfiguration.html)
   */
  public inline
      fun cfnAnalysisRadarChartConfigurationProperty(block: CfnAnalysisRadarChartConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.RadarChartConfigurationProperty {
    val builder = CfnAnalysisRadarChartConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field wells of a radar chart visual.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartfieldwells.html)
   */
  public inline
      fun cfnAnalysisRadarChartFieldWellsProperty(block: CfnAnalysisRadarChartFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.RadarChartFieldWellsProperty {
    val builder = CfnAnalysisRadarChartFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The series settings of a radar chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * RadarChartSeriesSettingsProperty radarChartSeriesSettingsProperty =
   * RadarChartSeriesSettingsProperty.builder()
   * .areaStyleSettings(RadarChartAreaStyleSettingsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartseriessettings.html)
   */
  public inline
      fun cfnAnalysisRadarChartSeriesSettingsProperty(block: CfnAnalysisRadarChartSeriesSettingsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.RadarChartSeriesSettingsProperty {
    val builder = CfnAnalysisRadarChartSeriesSettingsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration of a `RadarChartVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * RadarChartSortConfigurationProperty radarChartSortConfigurationProperty =
   * RadarChartSortConfigurationProperty.builder()
   * .categoryItemsLimit(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .categorySort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .colorItemsLimit(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .colorSort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartsortconfiguration.html)
   */
  public inline
      fun cfnAnalysisRadarChartSortConfigurationProperty(block: CfnAnalysisRadarChartSortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.RadarChartSortConfigurationProperty {
    val builder = CfnAnalysisRadarChartSortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A radar chart visual.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-radarchartvisual.html)
   */
  public inline
      fun cfnAnalysisRadarChartVisualProperty(block: CfnAnalysisRadarChartVisualPropertyDsl.() -> Unit
      = {}): CfnAnalysis.RadarChartVisualProperty {
    val builder = CfnAnalysisRadarChartVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The range ends label type of a data path label.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * RangeEndsLabelTypeProperty rangeEndsLabelTypeProperty = RangeEndsLabelTypeProperty.builder()
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-rangeendslabeltype.html)
   */
  public inline
      fun cfnAnalysisRangeEndsLabelTypeProperty(block: CfnAnalysisRangeEndsLabelTypePropertyDsl.() -> Unit
      = {}): CfnAnalysis.RangeEndsLabelTypeProperty {
    val builder = CfnAnalysisRangeEndsLabelTypePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration for a custom label on a `ReferenceLine` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ReferenceLineCustomLabelConfigurationProperty referenceLineCustomLabelConfigurationProperty =
   * ReferenceLineCustomLabelConfigurationProperty.builder()
   * .customLabel("customLabel")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinecustomlabelconfiguration.html)
   */
  public inline
      fun cfnAnalysisReferenceLineCustomLabelConfigurationProperty(block: CfnAnalysisReferenceLineCustomLabelConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ReferenceLineCustomLabelConfigurationProperty {
    val builder = CfnAnalysisReferenceLineCustomLabelConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The data configuration of the reference line.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ReferenceLineDataConfigurationProperty referenceLineDataConfigurationProperty =
   * ReferenceLineDataConfigurationProperty.builder()
   * .axisBinding("axisBinding")
   * .dynamicConfiguration(ReferenceLineDynamicDataConfigurationProperty.builder()
   * .calculation(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .measureAggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .staticConfiguration(ReferenceLineStaticDataConfigurationProperty.builder()
   * .value(123)
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinedataconfiguration.html)
   */
  public inline
      fun cfnAnalysisReferenceLineDataConfigurationProperty(block: CfnAnalysisReferenceLineDataConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ReferenceLineDataConfigurationProperty {
    val builder = CfnAnalysisReferenceLineDataConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The dynamic configuration of the reference line data configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ReferenceLineDynamicDataConfigurationProperty referenceLineDynamicDataConfigurationProperty =
   * ReferenceLineDynamicDataConfigurationProperty.builder()
   * .calculation(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .measureAggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinedynamicdataconfiguration.html)
   */
  public inline
      fun cfnAnalysisReferenceLineDynamicDataConfigurationProperty(block: CfnAnalysisReferenceLineDynamicDataConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ReferenceLineDynamicDataConfigurationProperty {
    val builder = CfnAnalysisReferenceLineDynamicDataConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The label configuration of a reference line.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ReferenceLineLabelConfigurationProperty referenceLineLabelConfigurationProperty =
   * ReferenceLineLabelConfigurationProperty.builder()
   * .customLabelConfiguration(ReferenceLineCustomLabelConfigurationProperty.builder()
   * .customLabel("customLabel")
   * .build())
   * .fontColor("fontColor")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .horizontalPosition("horizontalPosition")
   * .valueLabelConfiguration(ReferenceLineValueLabelConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .relativePosition("relativePosition")
   * .build())
   * .verticalPosition("verticalPosition")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinelabelconfiguration.html)
   */
  public inline
      fun cfnAnalysisReferenceLineLabelConfigurationProperty(block: CfnAnalysisReferenceLineLabelConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ReferenceLineLabelConfigurationProperty {
    val builder = CfnAnalysisReferenceLineLabelConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The reference line visual display options.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ReferenceLineProperty referenceLineProperty = ReferenceLineProperty.builder()
   * .dataConfiguration(ReferenceLineDataConfigurationProperty.builder()
   * .axisBinding("axisBinding")
   * .dynamicConfiguration(ReferenceLineDynamicDataConfigurationProperty.builder()
   * .calculation(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .measureAggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .staticConfiguration(ReferenceLineStaticDataConfigurationProperty.builder()
   * .value(123)
   * .build())
   * .build())
   * // the properties below are optional
   * .labelConfiguration(ReferenceLineLabelConfigurationProperty.builder()
   * .customLabelConfiguration(ReferenceLineCustomLabelConfigurationProperty.builder()
   * .customLabel("customLabel")
   * .build())
   * .fontColor("fontColor")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .horizontalPosition("horizontalPosition")
   * .valueLabelConfiguration(ReferenceLineValueLabelConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .relativePosition("relativePosition")
   * .build())
   * .verticalPosition("verticalPosition")
   * .build())
   * .status("status")
   * .styleConfiguration(ReferenceLineStyleConfigurationProperty.builder()
   * .color("color")
   * .pattern("pattern")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referenceline.html)
   */
  public inline
      fun cfnAnalysisReferenceLineProperty(block: CfnAnalysisReferenceLinePropertyDsl.() -> Unit =
      {}): CfnAnalysis.ReferenceLineProperty {
    val builder = CfnAnalysisReferenceLinePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The static data configuration of the reference line data configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ReferenceLineStaticDataConfigurationProperty referenceLineStaticDataConfigurationProperty =
   * ReferenceLineStaticDataConfigurationProperty.builder()
   * .value(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinestaticdataconfiguration.html)
   */
  public inline
      fun cfnAnalysisReferenceLineStaticDataConfigurationProperty(block: CfnAnalysisReferenceLineStaticDataConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ReferenceLineStaticDataConfigurationProperty {
    val builder = CfnAnalysisReferenceLineStaticDataConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The style configuration of the reference line.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ReferenceLineStyleConfigurationProperty referenceLineStyleConfigurationProperty =
   * ReferenceLineStyleConfigurationProperty.builder()
   * .color("color")
   * .pattern("pattern")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinestyleconfiguration.html)
   */
  public inline
      fun cfnAnalysisReferenceLineStyleConfigurationProperty(block: CfnAnalysisReferenceLineStyleConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ReferenceLineStyleConfigurationProperty {
    val builder = CfnAnalysisReferenceLineStyleConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The value label configuration of the label in a reference line.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ReferenceLineValueLabelConfigurationProperty referenceLineValueLabelConfigurationProperty =
   * ReferenceLineValueLabelConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .relativePosition("relativePosition")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-referencelinevaluelabelconfiguration.html)
   */
  public inline
      fun cfnAnalysisReferenceLineValueLabelConfigurationProperty(block: CfnAnalysisReferenceLineValueLabelConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ReferenceLineValueLabelConfigurationProperty {
    val builder = CfnAnalysisReferenceLineValueLabelConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The display options of a control.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * RelativeDateTimeControlDisplayOptionsProperty relativeDateTimeControlDisplayOptionsProperty =
   * RelativeDateTimeControlDisplayOptionsProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatetimecontroldisplayoptions.html)
   */
  public inline
      fun cfnAnalysisRelativeDateTimeControlDisplayOptionsProperty(block: CfnAnalysisRelativeDateTimeControlDisplayOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.RelativeDateTimeControlDisplayOptionsProperty {
    val builder = CfnAnalysisRelativeDateTimeControlDisplayOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A `RelativeDatesFilter` filters relative dates values.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * RelativeDatesFilterProperty relativeDatesFilterProperty = RelativeDatesFilterProperty.builder()
   * .anchorDateConfiguration(AnchorDateConfigurationProperty.builder()
   * .anchorOption("anchorOption")
   * .parameterName("parameterName")
   * .build())
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * .nullOption("nullOption")
   * .relativeDateType("relativeDateType")
   * .timeGranularity("timeGranularity")
   * // the properties below are optional
   * .excludePeriodConfiguration(ExcludePeriodConfigurationProperty.builder()
   * .amount(123)
   * .granularity("granularity")
   * // the properties below are optional
   * .status("status")
   * .build())
   * .minimumGranularity("minimumGranularity")
   * .parameterName("parameterName")
   * .relativeDateValue(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-relativedatesfilter.html)
   */
  public inline
      fun cfnAnalysisRelativeDatesFilterProperty(block: CfnAnalysisRelativeDatesFilterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.RelativeDatesFilterProperty {
    val builder = CfnAnalysisRelativeDatesFilterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Permission for the resource.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ResourcePermissionProperty resourcePermissionProperty = ResourcePermissionProperty.builder()
   * .actions(List.of("actions"))
   * .principal("principal")
   * // the properties below are optional
   * .resource("resource")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-resourcepermission.html)
   */
  public inline
      fun cfnAnalysisResourcePermissionProperty(block: CfnAnalysisResourcePermissionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ResourcePermissionProperty {
    val builder = CfnAnalysisResourcePermissionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The rolling date configuration of a date time filter.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * RollingDateConfigurationProperty rollingDateConfigurationProperty =
   * RollingDateConfigurationProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .dataSetIdentifier("dataSetIdentifier")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-rollingdateconfiguration.html)
   */
  public inline
      fun cfnAnalysisRollingDateConfigurationProperty(block: CfnAnalysisRollingDateConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.RollingDateConfigurationProperty {
    val builder = CfnAnalysisRollingDateConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Determines the row alternate color options.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * RowAlternateColorOptionsProperty rowAlternateColorOptionsProperty =
   * RowAlternateColorOptionsProperty.builder()
   * .rowAlternateColors(List.of("rowAlternateColors"))
   * .status("status")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-rowalternatecoloroptions.html)
   */
  public inline
      fun cfnAnalysisRowAlternateColorOptionsProperty(block: CfnAnalysisRowAlternateColorOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.RowAlternateColorOptionsProperty {
    val builder = CfnAnalysisRowAlternateColorOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of the same-sheet target visuals that you want to be filtered.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SameSheetTargetVisualConfigurationProperty sameSheetTargetVisualConfigurationProperty =
   * SameSheetTargetVisualConfigurationProperty.builder()
   * .targetVisualOptions("targetVisualOptions")
   * .targetVisuals(List.of("targetVisuals"))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-samesheettargetvisualconfiguration.html)
   */
  public inline
      fun cfnAnalysisSameSheetTargetVisualConfigurationProperty(block: CfnAnalysisSameSheetTargetVisualConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SameSheetTargetVisualConfigurationProperty {
    val builder = CfnAnalysisSameSheetTargetVisualConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field well configuration of a sankey diagram.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisSankeyDiagramAggregatedFieldWellsProperty(block: CfnAnalysisSankeyDiagramAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SankeyDiagramAggregatedFieldWellsProperty {
    val builder = CfnAnalysisSankeyDiagramAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a sankey diagram.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramchartconfiguration.html)
   */
  public inline
      fun cfnAnalysisSankeyDiagramChartConfigurationProperty(block: CfnAnalysisSankeyDiagramChartConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SankeyDiagramChartConfigurationProperty {
    val builder = CfnAnalysisSankeyDiagramChartConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field well configuration of a sankey diagram.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramfieldwells.html)
   */
  public inline
      fun cfnAnalysisSankeyDiagramFieldWellsProperty(block: CfnAnalysisSankeyDiagramFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SankeyDiagramFieldWellsProperty {
    val builder = CfnAnalysisSankeyDiagramFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration of a sankey diagram.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SankeyDiagramSortConfigurationProperty sankeyDiagramSortConfigurationProperty =
   * SankeyDiagramSortConfigurationProperty.builder()
   * .destinationItemsLimit(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .sourceItemsLimit(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .weightSort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramsortconfiguration.html)
   */
  public inline
      fun cfnAnalysisSankeyDiagramSortConfigurationProperty(block: CfnAnalysisSankeyDiagramSortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SankeyDiagramSortConfigurationProperty {
    val builder = CfnAnalysisSankeyDiagramSortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A sankey diagram.
   *
   * For more information, see [Using Sankey
   * diagrams](https://docs.aws.amazon.com/quicksight/latest/user/sankey-diagram.html) in the *Amazon
   * QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sankeydiagramvisual.html)
   */
  public inline
      fun cfnAnalysisSankeyDiagramVisualProperty(block: CfnAnalysisSankeyDiagramVisualPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SankeyDiagramVisualProperty {
    val builder = CfnAnalysisSankeyDiagramVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The aggregated field well of a scatter plot.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotcategoricallyaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisScatterPlotCategoricallyAggregatedFieldWellsProperty(block: CfnAnalysisScatterPlotCategoricallyAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ScatterPlotCategoricallyAggregatedFieldWellsProperty {
    val builder = CfnAnalysisScatterPlotCategoricallyAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a scatter plot.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotconfiguration.html)
   */
  public inline
      fun cfnAnalysisScatterPlotConfigurationProperty(block: CfnAnalysisScatterPlotConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ScatterPlotConfigurationProperty {
    val builder = CfnAnalysisScatterPlotConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field well configuration of a scatter plot.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotfieldwells.html)
   */
  public inline
      fun cfnAnalysisScatterPlotFieldWellsProperty(block: CfnAnalysisScatterPlotFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ScatterPlotFieldWellsProperty {
    val builder = CfnAnalysisScatterPlotFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The unaggregated field wells of a scatter plot.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotunaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisScatterPlotUnaggregatedFieldWellsProperty(block: CfnAnalysisScatterPlotUnaggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ScatterPlotUnaggregatedFieldWellsProperty {
    val builder = CfnAnalysisScatterPlotUnaggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A scatter plot.
   *
   * For more information, see [Using scatter
   * plots](https://docs.aws.amazon.com/quicksight/latest/user/scatter-plot.html) in the *Amazon
   * QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scatterplotvisual.html)
   */
  public inline
      fun cfnAnalysisScatterPlotVisualProperty(block: CfnAnalysisScatterPlotVisualPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ScatterPlotVisualProperty {
    val builder = CfnAnalysisScatterPlotVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The visual display options for a data zoom scroll bar.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ScrollBarOptionsProperty scrollBarOptionsProperty = ScrollBarOptionsProperty.builder()
   * .visibility("visibility")
   * .visibleRange(VisibleRangeOptionsProperty.builder()
   * .percentRange(PercentVisibleRangeProperty.builder()
   * .from(123)
   * .to(123)
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-scrollbaroptions.html)
   */
  public inline
      fun cfnAnalysisScrollBarOptionsProperty(block: CfnAnalysisScrollBarOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ScrollBarOptionsProperty {
    val builder = CfnAnalysisScrollBarOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the presentation of the secondary value of a KPI visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SecondaryValueOptionsProperty secondaryValueOptionsProperty =
   * SecondaryValueOptionsProperty.builder()
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-secondaryvalueoptions.html)
   */
  public inline
      fun cfnAnalysisSecondaryValueOptionsProperty(block: CfnAnalysisSecondaryValueOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SecondaryValueOptionsProperty {
    val builder = CfnAnalysisSecondaryValueOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a page break after a section.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SectionAfterPageBreakProperty sectionAfterPageBreakProperty =
   * SectionAfterPageBreakProperty.builder()
   * .status("status")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionafterpagebreak.html)
   */
  public inline
      fun cfnAnalysisSectionAfterPageBreakProperty(block: CfnAnalysisSectionAfterPageBreakPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SectionAfterPageBreakProperty {
    val builder = CfnAnalysisSectionAfterPageBreakPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options for the canvas of a section-based layout.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SectionBasedLayoutCanvasSizeOptionsProperty sectionBasedLayoutCanvasSizeOptionsProperty =
   * SectionBasedLayoutCanvasSizeOptionsProperty.builder()
   * .paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptionsProperty.builder()
   * .paperMargin(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .paperOrientation("paperOrientation")
   * .paperSize("paperSize")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutcanvassizeoptions.html)
   */
  public inline
      fun cfnAnalysisSectionBasedLayoutCanvasSizeOptionsProperty(block: CfnAnalysisSectionBasedLayoutCanvasSizeOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SectionBasedLayoutCanvasSizeOptionsProperty {
    val builder = CfnAnalysisSectionBasedLayoutCanvasSizeOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration for a section-based layout.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SectionBasedLayoutConfigurationProperty sectionBasedLayoutConfigurationProperty =
   * SectionBasedLayoutConfigurationProperty.builder()
   * .bodySections(List.of(BodySectionConfigurationProperty.builder()
   * .content(BodySectionContentProperty.builder()
   * .layout(SectionLayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * .build())
   * .build())
   * .build())
   * .sectionId("sectionId")
   * // the properties below are optional
   * .pageBreakConfiguration(SectionPageBreakConfigurationProperty.builder()
   * .after(SectionAfterPageBreakProperty.builder()
   * .status("status")
   * .build())
   * .build())
   * .style(SectionStyleProperty.builder()
   * .height("height")
   * .padding(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .build())
   * .build()))
   * .canvasSizeOptions(SectionBasedLayoutCanvasSizeOptionsProperty.builder()
   * .paperCanvasSizeOptions(SectionBasedLayoutPaperCanvasSizeOptionsProperty.builder()
   * .paperMargin(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .paperOrientation("paperOrientation")
   * .paperSize("paperSize")
   * .build())
   * .build())
   * .footerSections(List.of(HeaderFooterSectionConfigurationProperty.builder()
   * .layout(SectionLayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * .build())
   * .build())
   * .sectionId("sectionId")
   * // the properties below are optional
   * .style(SectionStyleProperty.builder()
   * .height("height")
   * .padding(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .build())
   * .build()))
   * .headerSections(List.of(HeaderFooterSectionConfigurationProperty.builder()
   * .layout(SectionLayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * .build())
   * .build())
   * .sectionId("sectionId")
   * // the properties below are optional
   * .style(SectionStyleProperty.builder()
   * .height("height")
   * .padding(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutconfiguration.html)
   */
  public inline
      fun cfnAnalysisSectionBasedLayoutConfigurationProperty(block: CfnAnalysisSectionBasedLayoutConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SectionBasedLayoutConfigurationProperty {
    val builder = CfnAnalysisSectionBasedLayoutConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options for a paper canvas of a section-based layout.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SectionBasedLayoutPaperCanvasSizeOptionsProperty
   * sectionBasedLayoutPaperCanvasSizeOptionsProperty =
   * SectionBasedLayoutPaperCanvasSizeOptionsProperty.builder()
   * .paperMargin(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .paperOrientation("paperOrientation")
   * .paperSize("paperSize")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionbasedlayoutpapercanvassizeoptions.html)
   */
  public inline
      fun cfnAnalysisSectionBasedLayoutPaperCanvasSizeOptionsProperty(block: CfnAnalysisSectionBasedLayoutPaperCanvasSizeOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SectionBasedLayoutPaperCanvasSizeOptionsProperty {
    val builder = CfnAnalysisSectionBasedLayoutPaperCanvasSizeOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The layout configuration of a section.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SectionLayoutConfigurationProperty sectionLayoutConfigurationProperty =
   * SectionLayoutConfigurationProperty.builder()
   * .freeFormLayout(FreeFormSectionLayoutConfigurationProperty.builder()
   * .elements(List.of(FreeFormLayoutElementProperty.builder()
   * .elementId("elementId")
   * .elementType("elementType")
   * .height("height")
   * .width("width")
   * .xAxisLocation("xAxisLocation")
   * .yAxisLocation("yAxisLocation")
   * // the properties below are optional
   * .backgroundStyle(FreeFormLayoutElementBackgroundStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .borderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .loadingAnimation(LoadingAnimationProperty.builder()
   * .visibility("visibility")
   * .build())
   * .renderingRules(List.of(SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build()))
   * .selectedBorderStyle(FreeFormLayoutElementBorderStyleProperty.builder()
   * .color("color")
   * .visibility("visibility")
   * .build())
   * .visibility("visibility")
   * .build()))
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionlayoutconfiguration.html)
   */
  public inline
      fun cfnAnalysisSectionLayoutConfigurationProperty(block: CfnAnalysisSectionLayoutConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SectionLayoutConfigurationProperty {
    val builder = CfnAnalysisSectionLayoutConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a page break for a section.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SectionPageBreakConfigurationProperty sectionPageBreakConfigurationProperty =
   * SectionPageBreakConfigurationProperty.builder()
   * .after(SectionAfterPageBreakProperty.builder()
   * .status("status")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionpagebreakconfiguration.html)
   */
  public inline
      fun cfnAnalysisSectionPageBreakConfigurationProperty(block: CfnAnalysisSectionPageBreakConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SectionPageBreakConfigurationProperty {
    val builder = CfnAnalysisSectionPageBreakConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that style a section.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SectionStyleProperty sectionStyleProperty = SectionStyleProperty.builder()
   * .height("height")
   * .padding(SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sectionstyle.html)
   */
  public inline
      fun cfnAnalysisSectionStyleProperty(block: CfnAnalysisSectionStylePropertyDsl.() -> Unit =
      {}): CfnAnalysis.SectionStyleProperty {
    val builder = CfnAnalysisSectionStylePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration for applying a filter to specific sheets or visuals.
   *
   * You can apply this filter to multiple visuals that are on one sheet or to all visuals on a
   * sheet.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SelectedSheetsFilterScopeConfigurationProperty selectedSheetsFilterScopeConfigurationProperty =
   * SelectedSheetsFilterScopeConfigurationProperty.builder()
   * .sheetVisualScopingConfigurations(List.of(SheetVisualScopingConfigurationProperty.builder()
   * .scope("scope")
   * .sheetId("sheetId")
   * // the properties below are optional
   * .visualIds(List.of("visualIds"))
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-selectedsheetsfilterscopeconfiguration.html)
   */
  public inline
      fun cfnAnalysisSelectedSheetsFilterScopeConfigurationProperty(block: CfnAnalysisSelectedSheetsFilterScopeConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SelectedSheetsFilterScopeConfigurationProperty {
    val builder = CfnAnalysisSelectedSheetsFilterScopeConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The series item configuration of a line chart.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SeriesItemProperty seriesItemProperty = SeriesItemProperty.builder()
   * .dataFieldSeriesItem(DataFieldSeriesItemProperty.builder()
   * .axisBinding("axisBinding")
   * .fieldId("fieldId")
   * // the properties below are optional
   * .fieldValue("fieldValue")
   * .settings(LineChartSeriesSettingsProperty.builder()
   * .lineStyleSettings(LineChartLineStyleSettingsProperty.builder()
   * .lineInterpolation("lineInterpolation")
   * .lineStyle("lineStyle")
   * .lineVisibility("lineVisibility")
   * .lineWidth("lineWidth")
   * .build())
   * .markerStyleSettings(LineChartMarkerStyleSettingsProperty.builder()
   * .markerColor("markerColor")
   * .markerShape("markerShape")
   * .markerSize("markerSize")
   * .markerVisibility("markerVisibility")
   * .build())
   * .build())
   * .build())
   * .fieldSeriesItem(FieldSeriesItemProperty.builder()
   * .axisBinding("axisBinding")
   * .fieldId("fieldId")
   * // the properties below are optional
   * .settings(LineChartSeriesSettingsProperty.builder()
   * .lineStyleSettings(LineChartLineStyleSettingsProperty.builder()
   * .lineInterpolation("lineInterpolation")
   * .lineStyle("lineStyle")
   * .lineVisibility("lineVisibility")
   * .lineWidth("lineWidth")
   * .build())
   * .markerStyleSettings(LineChartMarkerStyleSettingsProperty.builder()
   * .markerColor("markerColor")
   * .markerShape("markerShape")
   * .markerSize("markerSize")
   * .markerVisibility("markerVisibility")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-seriesitem.html)
   */
  public inline fun cfnAnalysisSeriesItemProperty(block: CfnAnalysisSeriesItemPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SeriesItemProperty {
    val builder = CfnAnalysisSeriesItemPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of adding parameters in action.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SetParameterValueConfigurationProperty setParameterValueConfigurationProperty =
   * SetParameterValueConfigurationProperty.builder()
   * .destinationParameterName("destinationParameterName")
   * .value(DestinationParameterValueConfigurationProperty.builder()
   * .customValuesConfiguration(CustomValuesConfigurationProperty.builder()
   * .customValues(CustomParameterValuesProperty.builder()
   * .dateTimeValues(List.of("dateTimeValues"))
   * .decimalValues(List.of(123))
   * .integerValues(List.of(123))
   * .stringValues(List.of("stringValues"))
   * .build())
   * // the properties below are optional
   * .includeNullValue(false)
   * .build())
   * .selectAllValueOptions("selectAllValueOptions")
   * .sourceColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sourceField("sourceField")
   * .sourceParameterName("sourceParameterName")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-setparametervalueconfiguration.html)
   */
  public inline
      fun cfnAnalysisSetParameterValueConfigurationProperty(block: CfnAnalysisSetParameterValueConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SetParameterValueConfigurationProperty {
    val builder = CfnAnalysisSetParameterValueConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The shape conditional formatting of a filled map visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ShapeConditionalFormatProperty shapeConditionalFormatProperty =
   * ShapeConditionalFormatProperty.builder()
   * .backgroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-shapeconditionalformat.html)
   */
  public inline
      fun cfnAnalysisShapeConditionalFormatProperty(block: CfnAnalysisShapeConditionalFormatPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ShapeConditionalFormatProperty {
    val builder = CfnAnalysisShapeConditionalFormatPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration that determines the elements and canvas size options of sheet control.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SheetControlLayoutConfigurationProperty sheetControlLayoutConfigurationProperty =
   * SheetControlLayoutConfigurationProperty.builder()
   * .gridLayout(GridLayoutConfigurationProperty.builder()
   * .elements(List.of(GridLayoutElementProperty.builder()
   * .columnSpan(123)
   * .elementId("elementId")
   * .elementType("elementType")
   * .rowSpan(123)
   * // the properties below are optional
   * .columnIndex(123)
   * .rowIndex(123)
   * .build()))
   * // the properties below are optional
   * .canvasSizeOptions(GridLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptionsProperty.builder()
   * .resizeOption("resizeOption")
   * // the properties below are optional
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetcontrollayoutconfiguration.html)
   */
  public inline
      fun cfnAnalysisSheetControlLayoutConfigurationProperty(block: CfnAnalysisSheetControlLayoutConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SheetControlLayoutConfigurationProperty {
    val builder = CfnAnalysisSheetControlLayoutConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A grid layout to define the placement of sheet control.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SheetControlLayoutProperty sheetControlLayoutProperty = SheetControlLayoutProperty.builder()
   * .configuration(SheetControlLayoutConfigurationProperty.builder()
   * .gridLayout(GridLayoutConfigurationProperty.builder()
   * .elements(List.of(GridLayoutElementProperty.builder()
   * .columnSpan(123)
   * .elementId("elementId")
   * .elementType("elementType")
   * .rowSpan(123)
   * // the properties below are optional
   * .columnIndex(123)
   * .rowIndex(123)
   * .build()))
   * // the properties below are optional
   * .canvasSizeOptions(GridLayoutCanvasSizeOptionsProperty.builder()
   * .screenCanvasSizeOptions(GridLayoutScreenCanvasSizeOptionsProperty.builder()
   * .resizeOption("resizeOption")
   * // the properties below are optional
   * .optimizedViewPortWidth("optimizedViewPortWidth")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetcontrollayout.html)
   */
  public inline
      fun cfnAnalysisSheetControlLayoutProperty(block: CfnAnalysisSheetControlLayoutPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SheetControlLayoutProperty {
    val builder = CfnAnalysisSheetControlLayoutPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A sheet is an object that contains a set of visuals that are viewed together on one page in a
   * paginated report.
   *
   * Every analysis and dashboard must contain at least one sheet.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetdefinition.html)
   */
  public inline
      fun cfnAnalysisSheetDefinitionProperty(block: CfnAnalysisSheetDefinitionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SheetDefinitionProperty {
    val builder = CfnAnalysisSheetDefinitionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The override configuration of the rendering rules of a sheet.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SheetElementConfigurationOverridesProperty sheetElementConfigurationOverridesProperty =
   * SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetelementconfigurationoverrides.html)
   */
  public inline
      fun cfnAnalysisSheetElementConfigurationOverridesProperty(block: CfnAnalysisSheetElementConfigurationOverridesPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SheetElementConfigurationOverridesProperty {
    val builder = CfnAnalysisSheetElementConfigurationOverridesPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The rendering rules of a sheet that uses a free-form layout.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SheetElementRenderingRuleProperty sheetElementRenderingRuleProperty =
   * SheetElementRenderingRuleProperty.builder()
   * .configurationOverrides(SheetElementConfigurationOverridesProperty.builder()
   * .visibility("visibility")
   * .build())
   * .expression("expression")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetelementrenderingrule.html)
   */
  public inline
      fun cfnAnalysisSheetElementRenderingRuleProperty(block: CfnAnalysisSheetElementRenderingRulePropertyDsl.() -> Unit
      = {}): CfnAnalysis.SheetElementRenderingRuleProperty {
    val builder = CfnAnalysisSheetElementRenderingRulePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A *sheet* , which is an object that contains a set of visuals that are viewed together on one
   * page in Amazon QuickSight.
   *
   * Every analysis and dashboard contains at least one sheet. Each sheet contains at least one
   * visualization widget, for example a chart, pivot table, or narrative insight. Sheets can be
   * associated with other components, such as controls, filters, and so on.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SheetProperty sheetProperty = SheetProperty.builder()
   * .name("name")
   * .sheetId("sheetId")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheet.html)
   */
  public inline fun cfnAnalysisSheetProperty(block: CfnAnalysisSheetPropertyDsl.() -> Unit = {}):
      CfnAnalysis.SheetProperty {
    val builder = CfnAnalysisSheetPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A text box.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SheetTextBoxProperty sheetTextBoxProperty = SheetTextBoxProperty.builder()
   * .sheetTextBoxId("sheetTextBoxId")
   * // the properties below are optional
   * .content("content")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheettextbox.html)
   */
  public inline
      fun cfnAnalysisSheetTextBoxProperty(block: CfnAnalysisSheetTextBoxPropertyDsl.() -> Unit =
      {}): CfnAnalysis.SheetTextBoxProperty {
    val builder = CfnAnalysisSheetTextBoxPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The filter that is applied to the options.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SheetVisualScopingConfigurationProperty sheetVisualScopingConfigurationProperty =
   * SheetVisualScopingConfigurationProperty.builder()
   * .scope("scope")
   * .sheetId("sheetId")
   * // the properties below are optional
   * .visualIds(List.of("visualIds"))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-sheetvisualscopingconfiguration.html)
   */
  public inline
      fun cfnAnalysisSheetVisualScopingConfigurationProperty(block: CfnAnalysisSheetVisualScopingConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SheetVisualScopingConfigurationProperty {
    val builder = CfnAnalysisSheetVisualScopingConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The text format for the title.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ShortFormatTextProperty shortFormatTextProperty = ShortFormatTextProperty.builder()
   * .plainText("plainText")
   * .richText("richText")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-shortformattext.html)
   */
  public inline
      fun cfnAnalysisShortFormatTextProperty(block: CfnAnalysisShortFormatTextPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ShortFormatTextProperty {
    val builder = CfnAnalysisShortFormatTextPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The simple cluster marker of the cluster marker.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SimpleClusterMarkerProperty simpleClusterMarkerProperty = SimpleClusterMarkerProperty.builder()
   * .color("color")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-simpleclustermarker.html)
   */
  public inline
      fun cfnAnalysisSimpleClusterMarkerProperty(block: CfnAnalysisSimpleClusterMarkerPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SimpleClusterMarkerProperty {
    val builder = CfnAnalysisSimpleClusterMarkerPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The display options of a control.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SliderControlDisplayOptionsProperty sliderControlDisplayOptionsProperty =
   * SliderControlDisplayOptionsProperty.builder()
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-slidercontroldisplayoptions.html)
   */
  public inline
      fun cfnAnalysisSliderControlDisplayOptionsProperty(block: CfnAnalysisSliderControlDisplayOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SliderControlDisplayOptionsProperty {
    val builder = CfnAnalysisSliderControlDisplayOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Options that determine the layout and display options of a chart's small multiples.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SmallMultiplesOptionsProperty smallMultiplesOptionsProperty =
   * SmallMultiplesOptionsProperty.builder()
   * .maxVisibleColumns(123)
   * .maxVisibleRows(123)
   * .panelConfiguration(PanelConfigurationProperty.builder()
   * .backgroundColor("backgroundColor")
   * .backgroundVisibility("backgroundVisibility")
   * .borderColor("borderColor")
   * .borderStyle("borderStyle")
   * .borderThickness("borderThickness")
   * .borderVisibility("borderVisibility")
   * .gutterSpacing("gutterSpacing")
   * .gutterVisibility("gutterVisibility")
   * .title(PanelTitleOptionsProperty.builder()
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-smallmultiplesoptions.html)
   */
  public inline
      fun cfnAnalysisSmallMultiplesOptionsProperty(block: CfnAnalysisSmallMultiplesOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SmallMultiplesOptionsProperty {
    val builder = CfnAnalysisSmallMultiplesOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of spacing (often a margin or padding).
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SpacingProperty spacingProperty = SpacingProperty.builder()
   * .bottom("bottom")
   * .left("left")
   * .right("right")
   * .top("top")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-spacing.html)
   */
  public inline fun cfnAnalysisSpacingProperty(block: CfnAnalysisSpacingPropertyDsl.() -> Unit =
      {}): CfnAnalysis.SpacingProperty {
    val builder = CfnAnalysisSpacingPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The default values of the `StringParameterDeclaration` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * StringDefaultValuesProperty stringDefaultValuesProperty = StringDefaultValuesProperty.builder()
   * .dynamicValue(DynamicDefaultValueProperty.builder()
   * .defaultValueColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .groupNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .userNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .staticValues(List.of("staticValues"))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringdefaultvalues.html)
   */
  public inline
      fun cfnAnalysisStringDefaultValuesProperty(block: CfnAnalysisStringDefaultValuesPropertyDsl.() -> Unit
      = {}): CfnAnalysis.StringDefaultValuesProperty {
    val builder = CfnAnalysisStringDefaultValuesPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Formatting configuration for string fields.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * StringFormatConfigurationProperty stringFormatConfigurationProperty =
   * StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringformatconfiguration.html)
   */
  public inline
      fun cfnAnalysisStringFormatConfigurationProperty(block: CfnAnalysisStringFormatConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.StringFormatConfigurationProperty {
    val builder = CfnAnalysisStringFormatConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A parameter declaration for the `String` data type.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * StringParameterDeclarationProperty stringParameterDeclarationProperty =
   * StringParameterDeclarationProperty.builder()
   * .name("name")
   * .parameterValueType("parameterValueType")
   * // the properties below are optional
   * .defaultValues(StringDefaultValuesProperty.builder()
   * .dynamicValue(DynamicDefaultValueProperty.builder()
   * .defaultValueColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .groupNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .userNameColumn(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .build())
   * .staticValues(List.of("staticValues"))
   * .build())
   * .mappedDataSetParameters(List.of(MappedDataSetParameterProperty.builder()
   * .dataSetIdentifier("dataSetIdentifier")
   * .dataSetParameterName("dataSetParameterName")
   * .build()))
   * .valueWhenUnset(StringValueWhenUnsetConfigurationProperty.builder()
   * .customValue("customValue")
   * .valueWhenUnsetOption("valueWhenUnsetOption")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameterdeclaration.html)
   */
  public inline
      fun cfnAnalysisStringParameterDeclarationProperty(block: CfnAnalysisStringParameterDeclarationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.StringParameterDeclarationProperty {
    val builder = CfnAnalysisStringParameterDeclarationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A string parameter.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * StringParameterProperty stringParameterProperty = StringParameterProperty.builder()
   * .name("name")
   * .values(List.of("values"))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringparameter.html)
   */
  public inline
      fun cfnAnalysisStringParameterProperty(block: CfnAnalysisStringParameterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.StringParameterProperty {
    val builder = CfnAnalysisStringParameterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration that defines the default value of a `String` parameter when a value has not
   * been set.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * StringValueWhenUnsetConfigurationProperty stringValueWhenUnsetConfigurationProperty =
   * StringValueWhenUnsetConfigurationProperty.builder()
   * .customValue("customValue")
   * .valueWhenUnsetOption("valueWhenUnsetOption")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-stringvaluewhenunsetconfiguration.html)
   */
  public inline
      fun cfnAnalysisStringValueWhenUnsetConfigurationProperty(block: CfnAnalysisStringValueWhenUnsetConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.StringValueWhenUnsetConfigurationProperty {
    val builder = CfnAnalysisStringValueWhenUnsetConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The subtotal options.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * SubtotalOptionsProperty subtotalOptionsProperty = SubtotalOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fieldLevel("fieldLevel")
   * .fieldLevelOptions(List.of(PivotTableFieldSubtotalOptionsProperty.builder()
   * .fieldId("fieldId")
   * .build()))
   * .metricHeaderCellStyle(TableCellStyleProperty.builder()
   * .backgroundColor("backgroundColor")
   * .border(GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .height(123)
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .textWrap("textWrap")
   * .verticalTextAlignment("verticalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .totalCellStyle(TableCellStyleProperty.builder()
   * .backgroundColor("backgroundColor")
   * .border(GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .height(123)
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .textWrap("textWrap")
   * .verticalTextAlignment("verticalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .totalsVisibility("totalsVisibility")
   * .valueCellStyle(TableCellStyleProperty.builder()
   * .backgroundColor("backgroundColor")
   * .border(GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .height(123)
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .textWrap("textWrap")
   * .verticalTextAlignment("verticalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-subtotaloptions.html)
   */
  public inline
      fun cfnAnalysisSubtotalOptionsProperty(block: CfnAnalysisSubtotalOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.SubtotalOptionsProperty {
    val builder = CfnAnalysisSubtotalOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The aggregated field well for the table.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableAggregatedFieldWellsProperty tableAggregatedFieldWellsProperty =
   * TableAggregatedFieldWellsProperty.builder()
   * .groupBy(List.of(DimensionFieldProperty.builder()
   * .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .dateDimensionField(DateDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .dateGranularity("dateGranularity")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .numericalDimensionField(NumericalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .hierarchyId("hierarchyId")
   * .build())
   * .build()))
   * .values(List.of(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisTableAggregatedFieldWellsProperty(block: CfnAnalysisTableAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableAggregatedFieldWellsProperty {
    val builder = CfnAnalysisTableAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The border options for a table border.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableBorderOptionsProperty tableBorderOptionsProperty = TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableborderoptions.html)
   */
  public inline
      fun cfnAnalysisTableBorderOptionsProperty(block: CfnAnalysisTableBorderOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableBorderOptionsProperty {
    val builder = CfnAnalysisTableBorderOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The cell conditional formatting option for a table.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableCellConditionalFormattingProperty tableCellConditionalFormattingProperty =
   * TableCellConditionalFormattingProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .textFormat(TextConditionalFormatProperty.builder()
   * .backgroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .icon(ConditionalFormattingIconProperty.builder()
   * .customCondition(ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build())
   * .iconSet(ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellconditionalformatting.html)
   */
  public inline
      fun cfnAnalysisTableCellConditionalFormattingProperty(block: CfnAnalysisTableCellConditionalFormattingPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableCellConditionalFormattingProperty {
    val builder = CfnAnalysisTableCellConditionalFormattingPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sizing options for the table image configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableCellImageSizingConfigurationProperty tableCellImageSizingConfigurationProperty =
   * TableCellImageSizingConfigurationProperty.builder()
   * .tableCellImageScalingConfiguration("tableCellImageScalingConfiguration")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellimagesizingconfiguration.html)
   */
  public inline
      fun cfnAnalysisTableCellImageSizingConfigurationProperty(block: CfnAnalysisTableCellImageSizingConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableCellImageSizingConfigurationProperty {
    val builder = CfnAnalysisTableCellImageSizingConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The table cell style for a cell in pivot table or table visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableCellStyleProperty tableCellStyleProperty = TableCellStyleProperty.builder()
   * .backgroundColor("backgroundColor")
   * .border(GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .height(123)
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .textWrap("textWrap")
   * .verticalTextAlignment("verticalTextAlignment")
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablecellstyle.html)
   */
  public inline
      fun cfnAnalysisTableCellStyleProperty(block: CfnAnalysisTableCellStylePropertyDsl.() -> Unit =
      {}): CfnAnalysis.TableCellStyleProperty {
    val builder = CfnAnalysisTableCellStylePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Conditional formatting options for a `PivotTableVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableConditionalFormattingOptionProperty tableConditionalFormattingOptionProperty =
   * TableConditionalFormattingOptionProperty.builder()
   * .cell(TableCellConditionalFormattingProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .textFormat(TextConditionalFormatProperty.builder()
   * .backgroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .icon(ConditionalFormattingIconProperty.builder()
   * .customCondition(ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build())
   * .iconSet(ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build())
   * .row(TableRowConditionalFormattingProperty.builder()
   * .backgroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconditionalformattingoption.html)
   */
  public inline
      fun cfnAnalysisTableConditionalFormattingOptionProperty(block: CfnAnalysisTableConditionalFormattingOptionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableConditionalFormattingOptionProperty {
    val builder = CfnAnalysisTableConditionalFormattingOptionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The conditional formatting for a `PivotTableVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableConditionalFormattingProperty tableConditionalFormattingProperty =
   * TableConditionalFormattingProperty.builder()
   * .conditionalFormattingOptions(List.of(TableConditionalFormattingOptionProperty.builder()
   * .cell(TableCellConditionalFormattingProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .textFormat(TextConditionalFormatProperty.builder()
   * .backgroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .icon(ConditionalFormattingIconProperty.builder()
   * .customCondition(ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build())
   * .iconSet(ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build())
   * .row(TableRowConditionalFormattingProperty.builder()
   * .backgroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconditionalformatting.html)
   */
  public inline
      fun cfnAnalysisTableConditionalFormattingProperty(block: CfnAnalysisTableConditionalFormattingPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableConditionalFormattingProperty {
    val builder = CfnAnalysisTableConditionalFormattingPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration for a `TableVisual` .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableconfiguration.html)
   */
  public inline
      fun cfnAnalysisTableConfigurationProperty(block: CfnAnalysisTableConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableConfigurationProperty {
    val builder = CfnAnalysisTableConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The custom icon content for the table link content configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableFieldCustomIconContentProperty tableFieldCustomIconContentProperty =
   * TableFieldCustomIconContentProperty.builder()
   * .icon("icon")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldcustomiconcontent.html)
   */
  public inline
      fun cfnAnalysisTableFieldCustomIconContentProperty(block: CfnAnalysisTableFieldCustomIconContentPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableFieldCustomIconContentProperty {
    val builder = CfnAnalysisTableFieldCustomIconContentPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The custom text content (value, font configuration) for the table link content configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableFieldCustomTextContentProperty tableFieldCustomTextContentProperty =
   * TableFieldCustomTextContentProperty.builder()
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * // the properties below are optional
   * .value("value")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldcustomtextcontent.html)
   */
  public inline
      fun cfnAnalysisTableFieldCustomTextContentProperty(block: CfnAnalysisTableFieldCustomTextContentPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableFieldCustomTextContentProperty {
    val builder = CfnAnalysisTableFieldCustomTextContentPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The image configuration of a table field URL.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableFieldImageConfigurationProperty tableFieldImageConfigurationProperty =
   * TableFieldImageConfigurationProperty.builder()
   * .sizingOptions(TableCellImageSizingConfigurationProperty.builder()
   * .tableCellImageScalingConfiguration("tableCellImageScalingConfiguration")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldimageconfiguration.html)
   */
  public inline
      fun cfnAnalysisTableFieldImageConfigurationProperty(block: CfnAnalysisTableFieldImageConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableFieldImageConfigurationProperty {
    val builder = CfnAnalysisTableFieldImageConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The link configuration of a table field URL.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableFieldLinkConfigurationProperty tableFieldLinkConfigurationProperty =
   * TableFieldLinkConfigurationProperty.builder()
   * .content(TableFieldLinkContentConfigurationProperty.builder()
   * .customIconContent(TableFieldCustomIconContentProperty.builder()
   * .icon("icon")
   * .build())
   * .customTextContent(TableFieldCustomTextContentProperty.builder()
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * // the properties below are optional
   * .value("value")
   * .build())
   * .build())
   * .target("target")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldlinkconfiguration.html)
   */
  public inline
      fun cfnAnalysisTableFieldLinkConfigurationProperty(block: CfnAnalysisTableFieldLinkConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableFieldLinkConfigurationProperty {
    val builder = CfnAnalysisTableFieldLinkConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The URL content (text, icon) for the table link configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableFieldLinkContentConfigurationProperty tableFieldLinkContentConfigurationProperty =
   * TableFieldLinkContentConfigurationProperty.builder()
   * .customIconContent(TableFieldCustomIconContentProperty.builder()
   * .icon("icon")
   * .build())
   * .customTextContent(TableFieldCustomTextContentProperty.builder()
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * // the properties below are optional
   * .value("value")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldlinkcontentconfiguration.html)
   */
  public inline
      fun cfnAnalysisTableFieldLinkContentConfigurationProperty(block: CfnAnalysisTableFieldLinkContentConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableFieldLinkContentConfigurationProperty {
    val builder = CfnAnalysisTableFieldLinkContentConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options for a table field.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableFieldOptionProperty tableFieldOptionProperty = TableFieldOptionProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .customLabel("customLabel")
   * .urlStyling(TableFieldURLConfigurationProperty.builder()
   * .imageConfiguration(TableFieldImageConfigurationProperty.builder()
   * .sizingOptions(TableCellImageSizingConfigurationProperty.builder()
   * .tableCellImageScalingConfiguration("tableCellImageScalingConfiguration")
   * .build())
   * .build())
   * .linkConfiguration(TableFieldLinkConfigurationProperty.builder()
   * .content(TableFieldLinkContentConfigurationProperty.builder()
   * .customIconContent(TableFieldCustomIconContentProperty.builder()
   * .icon("icon")
   * .build())
   * .customTextContent(TableFieldCustomTextContentProperty.builder()
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * // the properties below are optional
   * .value("value")
   * .build())
   * .build())
   * .target("target")
   * .build())
   * .build())
   * .visibility("visibility")
   * .width("width")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldoption.html)
   */
  public inline
      fun cfnAnalysisTableFieldOptionProperty(block: CfnAnalysisTableFieldOptionPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableFieldOptionProperty {
    val builder = CfnAnalysisTableFieldOptionPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field options for a table visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableFieldOptionsProperty tableFieldOptionsProperty = TableFieldOptionsProperty.builder()
   * .order(List.of("order"))
   * .selectedFieldOptions(List.of(TableFieldOptionProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .customLabel("customLabel")
   * .urlStyling(TableFieldURLConfigurationProperty.builder()
   * .imageConfiguration(TableFieldImageConfigurationProperty.builder()
   * .sizingOptions(TableCellImageSizingConfigurationProperty.builder()
   * .tableCellImageScalingConfiguration("tableCellImageScalingConfiguration")
   * .build())
   * .build())
   * .linkConfiguration(TableFieldLinkConfigurationProperty.builder()
   * .content(TableFieldLinkContentConfigurationProperty.builder()
   * .customIconContent(TableFieldCustomIconContentProperty.builder()
   * .icon("icon")
   * .build())
   * .customTextContent(TableFieldCustomTextContentProperty.builder()
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * // the properties below are optional
   * .value("value")
   * .build())
   * .build())
   * .target("target")
   * .build())
   * .build())
   * .visibility("visibility")
   * .width("width")
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldoptions.html)
   */
  public inline
      fun cfnAnalysisTableFieldOptionsProperty(block: CfnAnalysisTableFieldOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableFieldOptionsProperty {
    val builder = CfnAnalysisTableFieldOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The URL configuration for a table field.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableFieldURLConfigurationProperty tableFieldURLConfigurationProperty =
   * TableFieldURLConfigurationProperty.builder()
   * .imageConfiguration(TableFieldImageConfigurationProperty.builder()
   * .sizingOptions(TableCellImageSizingConfigurationProperty.builder()
   * .tableCellImageScalingConfiguration("tableCellImageScalingConfiguration")
   * .build())
   * .build())
   * .linkConfiguration(TableFieldLinkConfigurationProperty.builder()
   * .content(TableFieldLinkContentConfigurationProperty.builder()
   * .customIconContent(TableFieldCustomIconContentProperty.builder()
   * .icon("icon")
   * .build())
   * .customTextContent(TableFieldCustomTextContentProperty.builder()
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * // the properties below are optional
   * .value("value")
   * .build())
   * .build())
   * .target("target")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldurlconfiguration.html)
   */
  public inline
      fun cfnAnalysisTableFieldURLConfigurationProperty(block: CfnAnalysisTableFieldURLConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableFieldURLConfigurationProperty {
    val builder = CfnAnalysisTableFieldURLConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field wells for a table visual.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablefieldwells.html)
   */
  public inline
      fun cfnAnalysisTableFieldWellsProperty(block: CfnAnalysisTableFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableFieldWellsProperty {
    val builder = CfnAnalysisTableFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The inline visualization of a specific type to display within a chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableInlineVisualizationProperty tableInlineVisualizationProperty =
   * TableInlineVisualizationProperty.builder()
   * .dataBars(DataBarsOptionsProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .negativeColor("negativeColor")
   * .positiveColor("positiveColor")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableinlinevisualization.html)
   */
  public inline
      fun cfnAnalysisTableInlineVisualizationProperty(block: CfnAnalysisTableInlineVisualizationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableInlineVisualizationProperty {
    val builder = CfnAnalysisTableInlineVisualizationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The table options for a table visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableOptionsProperty tableOptionsProperty = TableOptionsProperty.builder()
   * .cellStyle(TableCellStyleProperty.builder()
   * .backgroundColor("backgroundColor")
   * .border(GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .height(123)
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .textWrap("textWrap")
   * .verticalTextAlignment("verticalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .headerStyle(TableCellStyleProperty.builder()
   * .backgroundColor("backgroundColor")
   * .border(GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .height(123)
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .textWrap("textWrap")
   * .verticalTextAlignment("verticalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .orientation("orientation")
   * .rowAlternateColorOptions(RowAlternateColorOptionsProperty.builder()
   * .rowAlternateColors(List.of("rowAlternateColors"))
   * .status("status")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableoptions.html)
   */
  public inline
      fun cfnAnalysisTableOptionsProperty(block: CfnAnalysisTableOptionsPropertyDsl.() -> Unit =
      {}): CfnAnalysis.TableOptionsProperty {
    val builder = CfnAnalysisTableOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The paginated report options for a table visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TablePaginatedReportOptionsProperty tablePaginatedReportOptionsProperty =
   * TablePaginatedReportOptionsProperty.builder()
   * .overflowColumnHeaderVisibility("overflowColumnHeaderVisibility")
   * .verticalOverflowVisibility("verticalOverflowVisibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablepaginatedreportoptions.html)
   */
  public inline
      fun cfnAnalysisTablePaginatedReportOptionsProperty(block: CfnAnalysisTablePaginatedReportOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TablePaginatedReportOptionsProperty {
    val builder = CfnAnalysisTablePaginatedReportOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The conditional formatting of a table row.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableRowConditionalFormattingProperty tableRowConditionalFormattingProperty =
   * TableRowConditionalFormattingProperty.builder()
   * .backgroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablerowconditionalformatting.html)
   */
  public inline
      fun cfnAnalysisTableRowConditionalFormattingProperty(block: CfnAnalysisTableRowConditionalFormattingPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableRowConditionalFormattingProperty {
    val builder = CfnAnalysisTableRowConditionalFormattingPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The side border options for a table.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableSideBorderOptionsProperty tableSideBorderOptionsProperty =
   * TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablesideborderoptions.html)
   */
  public inline
      fun cfnAnalysisTableSideBorderOptionsProperty(block: CfnAnalysisTableSideBorderOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableSideBorderOptionsProperty {
    val builder = CfnAnalysisTableSideBorderOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration for a `TableVisual` .
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableSortConfigurationProperty tableSortConfigurationProperty =
   * TableSortConfigurationProperty.builder()
   * .paginationConfiguration(PaginationConfigurationProperty.builder()
   * .pageNumber(123)
   * .pageSize(123)
   * .build())
   * .rowSort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablesortconfiguration.html)
   */
  public inline
      fun cfnAnalysisTableSortConfigurationProperty(block: CfnAnalysisTableSortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableSortConfigurationProperty {
    val builder = CfnAnalysisTableSortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The unaggregated field well for the table.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TableUnaggregatedFieldWellsProperty tableUnaggregatedFieldWellsProperty =
   * TableUnaggregatedFieldWellsProperty.builder()
   * .values(List.of(UnaggregatedFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(FormatConfigurationProperty.builder()
   * .dateTimeFormatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .numberFormatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .stringFormatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tableunaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisTableUnaggregatedFieldWellsProperty(block: CfnAnalysisTableUnaggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TableUnaggregatedFieldWellsProperty {
    val builder = CfnAnalysisTableUnaggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A table visual.
   *
   * For more information, see [Using tables as
   * visuals](https://docs.aws.amazon.com/quicksight/latest/user/tabular.html) in the *Amazon
   * QuickSight User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tablevisual.html)
   */
  public inline
      fun cfnAnalysisTableVisualProperty(block: CfnAnalysisTableVisualPropertyDsl.() -> Unit = {}):
      CfnAnalysis.TableVisualProperty {
    val builder = CfnAnalysisTableVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The display options of a control.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TextAreaControlDisplayOptionsProperty textAreaControlDisplayOptionsProperty =
   * TextAreaControlDisplayOptionsProperty.builder()
   * .placeholderOptions(TextControlPlaceholderOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textareacontroldisplayoptions.html)
   */
  public inline
      fun cfnAnalysisTextAreaControlDisplayOptionsProperty(block: CfnAnalysisTextAreaControlDisplayOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TextAreaControlDisplayOptionsProperty {
    val builder = CfnAnalysisTextAreaControlDisplayOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The conditional formatting for the text.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TextConditionalFormatProperty textConditionalFormatProperty =
   * TextConditionalFormatProperty.builder()
   * .backgroundColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .icon(ConditionalFormattingIconProperty.builder()
   * .customCondition(ConditionalFormattingCustomIconConditionProperty.builder()
   * .expression("expression")
   * .iconOptions(ConditionalFormattingCustomIconOptionsProperty.builder()
   * .icon("icon")
   * .unicodeIcon("unicodeIcon")
   * .build())
   * // the properties below are optional
   * .color("color")
   * .displayConfiguration(ConditionalFormattingIconDisplayConfigurationProperty.builder()
   * .iconDisplayOption("iconDisplayOption")
   * .build())
   * .build())
   * .iconSet(ConditionalFormattingIconSetProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .iconSetType("iconSetType")
   * .build())
   * .build())
   * .textColor(ConditionalFormattingColorProperty.builder()
   * .gradient(ConditionalFormattingGradientColorProperty.builder()
   * .color(GradientColorProperty.builder()
   * .stops(List.of(GradientStopProperty.builder()
   * .gradientOffset(123)
   * // the properties below are optional
   * .color("color")
   * .dataValue(123)
   * .build()))
   * .build())
   * .expression("expression")
   * .build())
   * .solid(ConditionalFormattingSolidColorProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .color("color")
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textconditionalformat.html)
   */
  public inline
      fun cfnAnalysisTextConditionalFormatProperty(block: CfnAnalysisTextConditionalFormatPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TextConditionalFormatProperty {
    val builder = CfnAnalysisTextConditionalFormatPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of the placeholder options in a text control.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TextControlPlaceholderOptionsProperty textControlPlaceholderOptionsProperty =
   * TextControlPlaceholderOptionsProperty.builder()
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textcontrolplaceholderoptions.html)
   */
  public inline
      fun cfnAnalysisTextControlPlaceholderOptionsProperty(block: CfnAnalysisTextControlPlaceholderOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TextControlPlaceholderOptionsProperty {
    val builder = CfnAnalysisTextControlPlaceholderOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The display options of a control.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TextFieldControlDisplayOptionsProperty textFieldControlDisplayOptionsProperty =
   * TextFieldControlDisplayOptionsProperty.builder()
   * .placeholderOptions(TextControlPlaceholderOptionsProperty.builder()
   * .visibility("visibility")
   * .build())
   * .titleOptions(LabelOptionsProperty.builder()
   * .customLabel("customLabel")
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-textfieldcontroldisplayoptions.html)
   */
  public inline
      fun cfnAnalysisTextFieldControlDisplayOptionsProperty(block: CfnAnalysisTextFieldControlDisplayOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TextFieldControlDisplayOptionsProperty {
    val builder = CfnAnalysisTextFieldControlDisplayOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the thousands separator configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * ThousandSeparatorOptionsProperty thousandSeparatorOptionsProperty =
   * ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-thousandseparatoroptions.html)
   */
  public inline
      fun cfnAnalysisThousandSeparatorOptionsProperty(block: CfnAnalysisThousandSeparatorOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.ThousandSeparatorOptionsProperty {
    val builder = CfnAnalysisThousandSeparatorOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The forecast properties setup of a forecast in the line chart.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TimeBasedForecastPropertiesProperty timeBasedForecastPropertiesProperty =
   * TimeBasedForecastPropertiesProperty.builder()
   * .lowerBoundary(123)
   * .periodsBackward(123)
   * .periodsForward(123)
   * .predictionInterval(123)
   * .seasonality(123)
   * .upperBoundary(123)
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timebasedforecastproperties.html)
   */
  public inline
      fun cfnAnalysisTimeBasedForecastPropertiesProperty(block: CfnAnalysisTimeBasedForecastPropertiesPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TimeBasedForecastPropertiesProperty {
    val builder = CfnAnalysisTimeBasedForecastPropertiesPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A `TimeEqualityFilter` filters values that are equal to a given value.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TimeEqualityFilterProperty timeEqualityFilterProperty = TimeEqualityFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * // the properties below are optional
   * .parameterName("parameterName")
   * .timeGranularity("timeGranularity")
   * .value("value")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timeequalityfilter.html)
   */
  public inline
      fun cfnAnalysisTimeEqualityFilterProperty(block: CfnAnalysisTimeEqualityFilterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TimeEqualityFilterProperty {
    val builder = CfnAnalysisTimeEqualityFilterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The time range drill down filter.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TimeRangeDrillDownFilterProperty timeRangeDrillDownFilterProperty =
   * TimeRangeDrillDownFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .rangeMaximum("rangeMaximum")
   * .rangeMinimum("rangeMinimum")
   * .timeGranularity("timeGranularity")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangedrilldownfilter.html)
   */
  public inline
      fun cfnAnalysisTimeRangeDrillDownFilterProperty(block: CfnAnalysisTimeRangeDrillDownFilterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TimeRangeDrillDownFilterProperty {
    val builder = CfnAnalysisTimeRangeDrillDownFilterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A `TimeRangeFilter` filters values that are between two specified values.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TimeRangeFilterProperty timeRangeFilterProperty = TimeRangeFilterProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * .nullOption("nullOption")
   * // the properties below are optional
   * .excludePeriodConfiguration(ExcludePeriodConfigurationProperty.builder()
   * .amount(123)
   * .granularity("granularity")
   * // the properties below are optional
   * .status("status")
   * .build())
   * .includeMaximum(false)
   * .includeMinimum(false)
   * .rangeMaximumValue(TimeRangeFilterValueProperty.builder()
   * .parameter("parameter")
   * .rollingDate(RollingDateConfigurationProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .staticValue("staticValue")
   * .build())
   * .rangeMinimumValue(TimeRangeFilterValueProperty.builder()
   * .parameter("parameter")
   * .rollingDate(RollingDateConfigurationProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .staticValue("staticValue")
   * .build())
   * .timeGranularity("timeGranularity")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefilter.html)
   */
  public inline
      fun cfnAnalysisTimeRangeFilterProperty(block: CfnAnalysisTimeRangeFilterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TimeRangeFilterProperty {
    val builder = CfnAnalysisTimeRangeFilterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The value of a time range filter.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TimeRangeFilterValueProperty timeRangeFilterValueProperty =
   * TimeRangeFilterValueProperty.builder()
   * .parameter("parameter")
   * .rollingDate(RollingDateConfigurationProperty.builder()
   * .expression("expression")
   * // the properties below are optional
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .staticValue("staticValue")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-timerangefiltervalue.html)
   */
  public inline
      fun cfnAnalysisTimeRangeFilterValueProperty(block: CfnAnalysisTimeRangeFilterValuePropertyDsl.() -> Unit
      = {}): CfnAnalysis.TimeRangeFilterValueProperty {
    val builder = CfnAnalysisTimeRangeFilterValuePropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The tooltip.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TooltipItemProperty tooltipItemProperty = TooltipItemProperty.builder()
   * .columnTooltipItem(ColumnTooltipItemProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregation(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .label("label")
   * .visibility("visibility")
   * .build())
   * .fieldTooltipItem(FieldTooltipItemProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .label("label")
   * .visibility("visibility")
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tooltipitem.html)
   */
  public inline
      fun cfnAnalysisTooltipItemProperty(block: CfnAnalysisTooltipItemPropertyDsl.() -> Unit = {}):
      CfnAnalysis.TooltipItemProperty {
    val builder = CfnAnalysisTooltipItemPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The display options for the visual tooltip.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TooltipOptionsProperty tooltipOptionsProperty = TooltipOptionsProperty.builder()
   * .fieldBasedTooltip(FieldBasedTooltipProperty.builder()
   * .aggregationVisibility("aggregationVisibility")
   * .tooltipFields(List.of(TooltipItemProperty.builder()
   * .columnTooltipItem(ColumnTooltipItemProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregation(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .label("label")
   * .visibility("visibility")
   * .build())
   * .fieldTooltipItem(FieldTooltipItemProperty.builder()
   * .fieldId("fieldId")
   * // the properties below are optional
   * .label("label")
   * .visibility("visibility")
   * .build())
   * .build()))
   * .tooltipTitleType("tooltipTitleType")
   * .build())
   * .selectedTooltipType("selectedTooltipType")
   * .tooltipVisibility("tooltipVisibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-tooltipoptions.html)
   */
  public inline
      fun cfnAnalysisTooltipOptionsProperty(block: CfnAnalysisTooltipOptionsPropertyDsl.() -> Unit =
      {}): CfnAnalysis.TooltipOptionsProperty {
    val builder = CfnAnalysisTooltipOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A `TopBottomFilter` filters values that are at the top or the bottom.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TopBottomFilterProperty topBottomFilterProperty = TopBottomFilterProperty.builder()
   * .aggregationSortConfigurations(List.of(AggregationSortConfigurationProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .sortDirection("sortDirection")
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build()))
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .filterId("filterId")
   * // the properties below are optional
   * .limit(123)
   * .parameterName("parameterName")
   * .timeGranularity("timeGranularity")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomfilter.html)
   */
  public inline
      fun cfnAnalysisTopBottomFilterProperty(block: CfnAnalysisTopBottomFilterPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TopBottomFilterProperty {
    val builder = CfnAnalysisTopBottomFilterPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The top movers and bottom movers computation setup.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottommoverscomputation.html)
   */
  public inline
      fun cfnAnalysisTopBottomMoversComputationProperty(block: CfnAnalysisTopBottomMoversComputationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TopBottomMoversComputationProperty {
    val builder = CfnAnalysisTopBottomMoversComputationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The top ranked and bottom ranked computation configuration.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-topbottomrankedcomputation.html)
   */
  public inline
      fun cfnAnalysisTopBottomRankedComputationProperty(block: CfnAnalysisTopBottomRankedComputationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TopBottomRankedComputationProperty {
    val builder = CfnAnalysisTopBottomRankedComputationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The total aggregation computation configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TotalAggregationComputationProperty totalAggregationComputationProperty =
   * TotalAggregationComputationProperty.builder()
   * .computationId("computationId")
   * .value(MeasureFieldProperty.builder()
   * .calculatedMeasureField(CalculatedMeasureFieldProperty.builder()
   * .expression("expression")
   * .fieldId("fieldId")
   * .build())
   * .categoricalMeasureField(CategoricalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .dateMeasureField(DateMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction("aggregationFunction")
   * .formatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .numericalMeasureField(NumericalMeasureFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .aggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .formatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build())
   * // the properties below are optional
   * .name("name")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totalaggregationcomputation.html)
   */
  public inline
      fun cfnAnalysisTotalAggregationComputationProperty(block: CfnAnalysisTotalAggregationComputationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TotalAggregationComputationProperty {
    val builder = CfnAnalysisTotalAggregationComputationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The total options for a table visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TotalOptionsProperty totalOptionsProperty = TotalOptionsProperty.builder()
   * .customLabel("customLabel")
   * .placement("placement")
   * .scrollStatus("scrollStatus")
   * .totalCellStyle(TableCellStyleProperty.builder()
   * .backgroundColor("backgroundColor")
   * .border(GlobalTableBorderOptionsProperty.builder()
   * .sideSpecificBorder(TableSideBorderOptionsProperty.builder()
   * .bottom(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerHorizontal(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .innerVertical(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .left(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .right(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .top(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .uniformBorder(TableBorderOptionsProperty.builder()
   * .color("color")
   * .style("style")
   * .thickness(123)
   * .build())
   * .build())
   * .fontConfiguration(FontConfigurationProperty.builder()
   * .fontColor("fontColor")
   * .fontDecoration("fontDecoration")
   * .fontSize(FontSizeProperty.builder()
   * .relative("relative")
   * .build())
   * .fontStyle("fontStyle")
   * .fontWeight(FontWeightProperty.builder()
   * .name("name")
   * .build())
   * .build())
   * .height(123)
   * .horizontalTextAlignment("horizontalTextAlignment")
   * .textWrap("textWrap")
   * .verticalTextAlignment("verticalTextAlignment")
   * .visibility("visibility")
   * .build())
   * .totalsVisibility("totalsVisibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-totaloptions.html)
   */
  public inline
      fun cfnAnalysisTotalOptionsProperty(block: CfnAnalysisTotalOptionsPropertyDsl.() -> Unit =
      {}): CfnAnalysis.TotalOptionsProperty {
    val builder = CfnAnalysisTotalOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * Aggregated field wells of a tree map.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapaggregatedfieldwells.html)
   */
  public inline
      fun cfnAnalysisTreeMapAggregatedFieldWellsProperty(block: CfnAnalysisTreeMapAggregatedFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TreeMapAggregatedFieldWellsProperty {
    val builder = CfnAnalysisTreeMapAggregatedFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The configuration of a tree map.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapconfiguration.html)
   */
  public inline
      fun cfnAnalysisTreeMapConfigurationProperty(block: CfnAnalysisTreeMapConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TreeMapConfigurationProperty {
    val builder = CfnAnalysisTreeMapConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The field wells of a tree map.
   *
   * This is a union type structure. For this structure to be valid, only one of the attributes can
   * be defined.
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapfieldwells.html)
   */
  public inline
      fun cfnAnalysisTreeMapFieldWellsProperty(block: CfnAnalysisTreeMapFieldWellsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TreeMapFieldWellsProperty {
    val builder = CfnAnalysisTreeMapFieldWellsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The sort configuration of a tree map.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TreeMapSortConfigurationProperty treeMapSortConfigurationProperty =
   * TreeMapSortConfigurationProperty.builder()
   * .treeMapGroupItemsLimitConfiguration(ItemsLimitConfigurationProperty.builder()
   * .itemsLimit(123)
   * .otherCategories("otherCategories")
   * .build())
   * .treeMapSort(List.of(FieldSortOptionsProperty.builder()
   * .columnSort(ColumnSortProperty.builder()
   * .direction("direction")
   * .sortBy(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * // the properties below are optional
   * .aggregationFunction(AggregationFunctionProperty.builder()
   * .categoricalAggregationFunction("categoricalAggregationFunction")
   * .dateAggregationFunction("dateAggregationFunction")
   * .numericalAggregationFunction(NumericalAggregationFunctionProperty.builder()
   * .percentileAggregation(PercentileAggregationProperty.builder()
   * .percentileValue(123)
   * .build())
   * .simpleNumericalAggregation("simpleNumericalAggregation")
   * .build())
   * .build())
   * .build())
   * .fieldSort(FieldSortProperty.builder()
   * .direction("direction")
   * .fieldId("fieldId")
   * .build())
   * .build()))
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapsortconfiguration.html)
   */
  public inline
      fun cfnAnalysisTreeMapSortConfigurationProperty(block: CfnAnalysisTreeMapSortConfigurationPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TreeMapSortConfigurationProperty {
    val builder = CfnAnalysisTreeMapSortConfigurationPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * A tree map.
   *
   * For more information, see [Using tree
   * maps](https://docs.aws.amazon.com/quicksight/latest/user/tree-map.html) in the *Amazon QuickSight
   * User Guide* .
   *
   * Example:
   *
   * ```
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-treemapvisual.html)
   */
  public inline
      fun cfnAnalysisTreeMapVisualProperty(block: CfnAnalysisTreeMapVisualPropertyDsl.() -> Unit =
      {}): CfnAnalysis.TreeMapVisualProperty {
    val builder = CfnAnalysisTreeMapVisualPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The options that determine the presentation of trend arrows in a KPI visual.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * TrendArrowOptionsProperty trendArrowOptionsProperty = TrendArrowOptionsProperty.builder()
   * .visibility("visibility")
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-trendarrowoptions.html)
   */
  public inline
      fun cfnAnalysisTrendArrowOptionsProperty(block: CfnAnalysisTrendArrowOptionsPropertyDsl.() -> Unit
      = {}): CfnAnalysis.TrendArrowOptionsProperty {
    val builder = CfnAnalysisTrendArrowOptionsPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The unaggregated field for a table.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * UnaggregatedFieldProperty unaggregatedFieldProperty = UnaggregatedFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(FormatConfigurationProperty.builder()
   * .dateTimeFormatConfiguration(DateTimeFormatConfigurationProperty.builder()
   * .dateTimeFormat("dateTimeFormat")
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .numberFormatConfiguration(NumberFormatConfigurationProperty.builder()
   * .formatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .stringFormatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .percentageDisplayFormatConfiguration(PercentageDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .build())
   * .build())
   * .build())
   * .build())
   * .build();
   * ```
   *
   * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-quicksight-analysis-unaggregatedfield.html)
   */
  public inline
      fun cfnAnalysisUnaggregatedFieldProperty(block: CfnAnalysisUnaggregatedFieldPropertyDsl.() -> Unit
      = {}): CfnAnalysis.UnaggregatedFieldProperty {
    val builder = CfnAnalysisUnaggregatedFieldPropertyDsl()
    builder.apply(block)
    return builder.build()
  }

  /**
   * The unique values computation configuration.
   *
   * Example:
   *
   * ```
   * // The code below shows an example of how to instantiate this type.
   * // The values are placeholders you should change.
   * import software.amazon.awscdk.services.quicksight.*;
   * UniqueValuesComputationProperty uniqueValuesComputationProperty =
   * UniqueValuesComputationProperty.builder()
   * .category(DimensionFieldProperty.builder()
   * .categoricalDimensionField(CategoricalDimensionFieldProperty.builder()
   * .column(ColumnIdentifierProperty.builder()
   * .columnName("columnName")
   * .dataSetIdentifier("dataSetIdentifier")
   * .build())
   * .fieldId("fieldId")
   * // the properties below are optional
   * .formatConfiguration(StringFormatConfigurationProperty.builder()
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numericFormatConfiguration(NumericFormatConfigurationProperty.builder()
   * .currencyDisplayFormatConfiguration(CurrencyDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfiguration(NullValueFormatConfigurationProperty.builder()
   * .nullString("nullString")
   * .build())
   * .numberScale("numberScale")
   * .prefix("prefix")
   * .separatorConfiguration(NumericSeparatorConfigurationProperty.builder()
   * .decimalSeparator("decimalSeparator")
   * .thousandsSeparator(ThousandSeparatorOptionsProperty.builder()
   * .symbol("symbol")
   * .visibility("visibility")
   * .build())
   * .build())
   * .suffix("suffix")
   * .symbol("symbol")
   * .build())
   * .numberDisplayFormatConfiguration(NumberDisplayFormatConfigurationProperty.builder()
   * .decimalPlacesConfiguration(DecimalPlacesConfigurationProperty.builder()
   * .decimalPlaces(123)
   * .build())
   * .negativeValueConfiguration(NegativeValueConfigurationProperty.builder()
   * .displayMode("displayMode")
   * .build())
   * .nullValueFormatConfig