@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.sagemaker

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.Boolean
import kotlin.String
import software.amazon.awscdk.IResolvable
import software.amazon.awscdk.services.sagemaker.CfnFeatureGroup

/**
 * The configuration of an `OfflineStore` .
 *
 * Provide an `OfflineStoreConfig` in a request to `CreateFeatureGroup` to create an `OfflineStore`
 * .
 *
 * To encrypt an `OfflineStore` using at rest data encryption, specify AWS Key Management Service
 * (KMS) key ID, or `KMSKeyId` , in `S3StorageConfig` .
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * OfflineStoreConfigProperty offlineStoreConfigProperty = OfflineStoreConfigProperty.builder()
 * .s3StorageConfig(S3StorageConfigProperty.builder()
 * .s3Uri("s3Uri")
 * // the properties below are optional
 * .kmsKeyId("kmsKeyId")
 * .build())
 * // the properties below are optional
 * .dataCatalogConfig(DataCatalogConfigProperty.builder()
 * .catalog("catalog")
 * .database("database")
 * .tableName("tableName")
 * .build())
 * .disableGlueTableCreation(false)
 * .tableFormat("tableFormat")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html)
 */
@CdkDslMarker
public class CfnFeatureGroupOfflineStoreConfigPropertyDsl {
  private val cdkBuilder: CfnFeatureGroup.OfflineStoreConfigProperty.Builder =
      CfnFeatureGroup.OfflineStoreConfigProperty.builder()

  /**
   * @param dataCatalogConfig The meta data of the Glue table that is autogenerated when an
   * `OfflineStore` is created.
   */
  public fun dataCatalogConfig(dataCatalogConfig: IResolvable) {
    cdkBuilder.dataCatalogConfig(dataCatalogConfig)
  }

  /**
   * @param dataCatalogConfig The meta data of the Glue table that is autogenerated when an
   * `OfflineStore` is created.
   */
  public fun dataCatalogConfig(dataCatalogConfig: CfnFeatureGroup.DataCatalogConfigProperty) {
    cdkBuilder.dataCatalogConfig(dataCatalogConfig)
  }

  /**
   * @param disableGlueTableCreation Set to `True` to disable the automatic creation of an AWS Glue
   * table when configuring an `OfflineStore` .
   * If set to `False` , Feature Store will name the `OfflineStore` Glue table following [Athena's
   * naming
   * recommendations](https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html)
   * .
   *
   * The default value is `False` .
   */
  public fun disableGlueTableCreation(disableGlueTableCreation: Boolean) {
    cdkBuilder.disableGlueTableCreation(disableGlueTableCreation)
  }

  /**
   * @param disableGlueTableCreation Set to `True` to disable the automatic creation of an AWS Glue
   * table when configuring an `OfflineStore` .
   * If set to `False` , Feature Store will name the `OfflineStore` Glue table following [Athena's
   * naming
   * recommendations](https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html)
   * .
   *
   * The default value is `False` .
   */
  public fun disableGlueTableCreation(disableGlueTableCreation: IResolvable) {
    cdkBuilder.disableGlueTableCreation(disableGlueTableCreation)
  }

  /**
   * @param s3StorageConfig The Amazon Simple Storage (Amazon S3) location of `OfflineStore` . 
   */
  public fun s3StorageConfig(s3StorageConfig: IResolvable) {
    cdkBuilder.s3StorageConfig(s3StorageConfig)
  }

  /**
   * @param s3StorageConfig The Amazon Simple Storage (Amazon S3) location of `OfflineStore` . 
   */
  public fun s3StorageConfig(s3StorageConfig: CfnFeatureGroup.S3StorageConfigProperty) {
    cdkBuilder.s3StorageConfig(s3StorageConfig)
  }

  /**
   * @param tableFormat Format for the offline store feature group.
   * Iceberg is the optimal format for feature groups shared between offline and online stores.
   */
  public fun tableFormat(tableFormat: String) {
    cdkBuilder.tableFormat(tableFormat)
  }

  public fun build(): CfnFeatureGroup.OfflineStoreConfigProperty = cdkBuilder.build()
}
