@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.sagemaker

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.services.sagemaker.CfnModelPackage

/**
 * Metadata properties of the tracking entity, trial, or trial component.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * MetadataPropertiesProperty metadataPropertiesProperty = MetadataPropertiesProperty.builder()
 * .commitId("commitId")
 * .generatedBy("generatedBy")
 * .projectId("projectId")
 * .repository("repository")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelpackage-metadataproperties.html)
 */
@CdkDslMarker
public class CfnModelPackageMetadataPropertiesPropertyDsl {
  private val cdkBuilder: CfnModelPackage.MetadataPropertiesProperty.Builder =
      CfnModelPackage.MetadataPropertiesProperty.builder()

  /**
   * @param commitId The commit ID.
   */
  public fun commitId(commitId: String) {
    cdkBuilder.commitId(commitId)
  }

  /**
   * @param generatedBy The entity this entity was generated by.
   */
  public fun generatedBy(generatedBy: String) {
    cdkBuilder.generatedBy(generatedBy)
  }

  /**
   * @param projectId The project ID.
   */
  public fun projectId(projectId: String) {
    cdkBuilder.projectId(projectId)
  }

  /**
   * @param repository The repository.
   */
  public fun repository(repository: String) {
    cdkBuilder.repository(repository)
  }

  public fun build(): CfnModelPackage.MetadataPropertiesProperty = cdkBuilder.build()
}
