@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.sagemaker

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.services.sagemaker.CfnModelPackage

/**
 * Describes the results of a transform job.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * TransformOutputProperty transformOutputProperty = TransformOutputProperty.builder()
 * .s3OutputPath("s3OutputPath")
 * // the properties below are optional
 * .accept("accept")
 * .assembleWith("assembleWith")
 * .kmsKeyId("kmsKeyId")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-modelpackage-transformoutput.html)
 */
@CdkDslMarker
public class CfnModelPackageTransformOutputPropertyDsl {
  private val cdkBuilder: CfnModelPackage.TransformOutputProperty.Builder =
      CfnModelPackage.TransformOutputProperty.builder()

  /**
   * @param accept The MIME type used to specify the output data.
   * Amazon SageMaker uses the MIME type with each http call to transfer data from the transform
   * job.
   */
  public fun accept(accept: String) {
    cdkBuilder.accept(accept)
  }

  /**
   * @param assembleWith Defines how to assemble the results of the transform job as a single S3
   * object.
   * Choose a format that is most convenient to you. To concatenate the results in binary format,
   * specify `None` . To add a newline character at the end of every transformed record, specify `Line`
   * .
   */
  public fun assembleWith(assembleWith: String) {
    cdkBuilder.assembleWith(assembleWith)
  }

  /**
   * @param kmsKeyId The AWS Key Management Service ( AWS KMS) key that Amazon SageMaker uses to
   * encrypt the model artifacts at rest using Amazon S3 server-side encryption.
   * The `KmsKeyId` can be any of the following formats:
   *
   * * Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
   * * Key ARN: `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
   * * Alias name: `alias/ExampleAlias`
   * * Alias name ARN: `arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias`
   *
   * If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for
   * your role's account. For more information, see [KMS-Managed Encryption
   * Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html) in the *Amazon
   * Simple Storage Service Developer Guide.*
   *
   * The KMS key policy must grant permission to the IAM role that you specify in your
   * [CreateModel](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html)
   * request. For more information, see [Using Key Policies in AWS
   * KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the *AWS Key
   * Management Service Developer Guide* .
   */
  public fun kmsKeyId(kmsKeyId: String) {
    cdkBuilder.kmsKeyId(kmsKeyId)
  }

  /**
   * @param s3OutputPath The Amazon S3 path where you want Amazon SageMaker to store the results of
   * the transform job. 
   * For example, `s3://bucket-name/key-name-prefix` .
   *
   * For every S3 object used as input for the transform job, batch transform stores the transformed
   * data with an . `out` suffix in a corresponding subfolder in the location in the output prefix. For
   * example, for the input data stored at `s3://bucket-name/input-name-prefix/dataset01/data.csv` ,
   * batch transform stores the transformed data at
   * `s3://bucket-name/output-name-prefix/input-name-prefix/data.csv.out` . Batch transform doesn't
   * upload partially processed objects. For an input S3 object that contains multiple records, it
   * creates an . `out` file only if the transform job succeeds on the entire file. When the input
   * contains multiple S3 objects, the batch transform job processes the listed S3 objects and uploads
   * only the output for successfully processed objects. If any object fails in the transform job batch
   * transform marks the job as failed to prompt investigation.
   */
  public fun s3OutputPath(s3OutputPath: String) {
    cdkBuilder.s3OutputPath(s3OutputPath)
  }

  public fun build(): CfnModelPackage.TransformOutputProperty = cdkBuilder.build()
}
