@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.ses

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import software.amazon.awscdk.services.ses.CfnConfigurationSet

/**
 * A domain that is used to redirect email recipients to an Amazon SES-operated domain.
 *
 * This domain captures open and click events generated by Amazon SES emails.
 *
 * For more information, see [Configuring Custom Domains to Handle Open and Click
 * Tracking](https://docs.aws.amazon.com/ses/latest/dg/configure-custom-open-click-domains.html) in the
 * *Amazon SES Developer Guide* .
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * TrackingOptionsProperty trackingOptionsProperty = TrackingOptionsProperty.builder()
 * .customRedirectDomain("customRedirectDomain")
 * .build();
 * ```
 *
 * [Documentation](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ses-configurationset-trackingoptions.html)
 */
@CdkDslMarker
public class CfnConfigurationSetTrackingOptionsPropertyDsl {
  private val cdkBuilder: CfnConfigurationSet.TrackingOptionsProperty.Builder =
      CfnConfigurationSet.TrackingOptionsProperty.builder()

  /**
   * @param customRedirectDomain The custom subdomain that is used to redirect email recipients to
   * the Amazon SES event tracking domain.
   */
  public fun customRedirectDomain(customRedirectDomain: String) {
    cdkBuilder.customRedirectDomain(customRedirectDomain)
  }

  public fun build(): CfnConfigurationSet.TrackingOptionsProperty = cdkBuilder.build()
}
