@file:Suppress("RedundantVisibilityModifier","RedundantUnitReturnType","RemoveRedundantQualifierName","unused","UnusedImport","ClassName","REDUNDANT_PROJECTION","DEPRECATION")

package cloudshift.awscdk.dsl.services.sns.subscriptions

import cloudshift.awscdk.common.CdkDslMarker
import kotlin.String
import kotlin.collections.Map
import software.amazon.awscdk.services.sns.FilterOrPolicy
import software.amazon.awscdk.services.sns.SubscriptionFilter
import software.amazon.awscdk.services.sns.subscriptions.SmsSubscription
import software.amazon.awscdk.services.sqs.IQueue

/**
 * Use an sms address as a subscription target.
 *
 * Example:
 *
 * ```
 * Topic myTopic = new Topic(this, "Topic");
 * myTopic.addSubscription(new SmsSubscription("+15551231234"));
 * ```
 */
@CdkDslMarker
public class SmsSubscriptionDsl(
  phoneNumber: String,
) {
  private val cdkBuilder: SmsSubscription.Builder = SmsSubscription.Builder.create(phoneNumber)

  /**
   * Queue to be used as dead letter queue.
   *
   * If not passed no dead letter queue is enabled.
   *
   * Default: - No dead letter queue enabled.
   *
   * @param deadLetterQueue Queue to be used as dead letter queue. 
   */
  public fun deadLetterQueue(deadLetterQueue: IQueue) {
    cdkBuilder.deadLetterQueue(deadLetterQueue)
  }

  /**
   * The filter policy.
   *
   * Default: - all messages are delivered
   *
   * @param filterPolicy The filter policy. 
   */
  public fun filterPolicy(filterPolicy: Map<String, SubscriptionFilter>) {
    cdkBuilder.filterPolicy(filterPolicy)
  }

  /**
   * The filter policy that is applied on the message body.
   *
   * To apply a filter policy to the message attributes, use `filterPolicy`. A maximum of one of
   * `filterPolicyWithMessageBody` and `filterPolicy` may be used.
   *
   * Default: - all messages are delivered
   *
   * @param filterPolicyWithMessageBody The filter policy that is applied on the message body. 
   */
  public fun filterPolicyWithMessageBody(filterPolicyWithMessageBody: Map<String, FilterOrPolicy>) {
    cdkBuilder.filterPolicyWithMessageBody(filterPolicyWithMessageBody)
  }

  public fun build(): SmsSubscription = cdkBuilder.build()
}
