@file:Suppress("RedundantVisibilityModifier", "RedundantUnitReturnType", "RemoveRedundantQualifierName", "unused", "UnusedImport", "ClassName", "REDUNDANT_PROJECTION", "DEPRECATION")

package cloudshift.awscdk.dsl.services.ssm

import cloudshift.awscdk.common.CdkDslMarker
import software.amazon.awscdk.services.ssm.ParameterOptions
import software.amazon.awscdk.services.ssm.ParameterTier
import kotlin.Boolean
import kotlin.String

/**
 * Properties needed to create a new SSM Parameter.
 *
 * Example:
 *
 * ```
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ssm.*;
 * ParameterOptions parameterOptions = ParameterOptions.builder()
 * .allowedPattern("allowedPattern")
 * .description("description")
 * .parameterName("parameterName")
 * .simpleName(false)
 * .tier(ParameterTier.ADVANCED)
 * .build();
 * ```
 */
@CdkDslMarker
public class ParameterOptionsDsl {
    private val cdkBuilder: ParameterOptions.Builder = ParameterOptions.builder()

    /**
     * @param allowedPattern A regular expression used to validate the parameter value.
     * For example, for String types with values restricted to
     * numbers, you can specify the following: `^\d+$`
     */
    public fun allowedPattern(allowedPattern: String) {
        cdkBuilder.allowedPattern(allowedPattern)
    }

    /**
     * @param description Information about the parameter that you want to add to the system.
     */
    public fun description(description: String) {
        cdkBuilder.description(description)
    }

    /**
     * @param parameterName The name of the parameter.
     */
    public fun parameterName(parameterName: String) {
        cdkBuilder.parameterName(parameterName)
    }

    /**
     * @param simpleName Indicates of the parameter name is a simple name (i.e. does not include "/"
     * separators).
     * This is only required only if `parameterName` is a token, which means we
     * are unable to detect if the name is simple or "path-like" for the purpose
     * of rendering SSM parameter ARNs.
     *
     * If `parameterName` is not specified, `simpleName` must be `true` (or
     * undefined) since the name generated by AWS CloudFormation is always a
     * simple name.
     */
    public fun simpleName(simpleName: Boolean) {
        cdkBuilder.simpleName(simpleName)
    }

    /**
     * @param tier The tier of the string parameter.
     */
    public fun tier(tier: ParameterTier) {
        cdkBuilder.tier(tier)
    }

    public fun build(): ParameterOptions = cdkBuilder.build()
}
