@file:Suppress("RedundantVisibilityModifier", "RedundantUnitReturnType", "RemoveRedundantQualifierName", "unused", "UnusedImport", "ClassName", "REDUNDANT_PROJECTION", "DEPRECATION")

package cloudshift.awscdk.dsl.services.ssm

import cloudshift.awscdk.common.CdkDslMarker
import software.amazon.awscdk.services.ssm.ParameterTier
import software.amazon.awscdk.services.ssm.StringListParameter
import software.constructs.Construct
import kotlin.Boolean
import kotlin.String
import kotlin.collections.Collection
import kotlin.collections.MutableList

/**
 * Creates a new StringList SSM Parameter.
 *
 * Example:
 *
 * ```
 * StringListParameter.valueForTypedListParameter(this, "/My/Public/Parameter",
 * ParameterValueType.AWS_EC2_IMAGE_ID);
 * ```
 */
@CdkDslMarker
public class StringListParameterDsl(
    scope: Construct,
    id: String
) {
    private val cdkBuilder: StringListParameter.Builder = StringListParameter.Builder.create(
        scope,
        id
    )

    private val _stringListValue: MutableList<String> = mutableListOf()

    /**
     * A regular expression used to validate the parameter value.
     *
     * For example, for String types with values restricted to
     * numbers, you can specify the following: `^\d+$`
     *
     * Default: no validation is performed
     *
     * @param allowedPattern A regular expression used to validate the parameter value.
     */
    public fun allowedPattern(allowedPattern: String) {
        cdkBuilder.allowedPattern(allowedPattern)
    }

    /**
     * Information about the parameter that you want to add to the system.
     *
     * Default: none
     *
     * @param description Information about the parameter that you want to add to the system.
     */
    public fun description(description: String) {
        cdkBuilder.description(description)
    }

    /**
     * The name of the parameter.
     *
     * Default: - a name will be generated by CloudFormation
     *
     * @param parameterName The name of the parameter.
     */
    public fun parameterName(parameterName: String) {
        cdkBuilder.parameterName(parameterName)
    }

    /**
     * Indicates of the parameter name is a simple name (i.e. does not include "/" separators).
     *
     * This is only required only if `parameterName` is a token, which means we
     * are unable to detect if the name is simple or "path-like" for the purpose
     * of rendering SSM parameter ARNs.
     *
     * If `parameterName` is not specified, `simpleName` must be `true` (or
     * undefined) since the name generated by AWS CloudFormation is always a
     * simple name.
     *
     * Default: - auto-detect based on `parameterName`
     *
     * @param simpleName Indicates of the parameter name is a simple name (i.e. does not include "/"
     * separators).
     */
    public fun simpleName(simpleName: Boolean) {
        cdkBuilder.simpleName(simpleName)
    }

    /**
     * The values of the parameter.
     *
     * It may not reference another parameter and `{{}}` cannot be used in the value.
     *
     * @param stringListValue The values of the parameter.
     */
    public fun stringListValue(vararg stringListValue: String) {
        _stringListValue.addAll(listOf(*stringListValue))
    }

    /**
     * The values of the parameter.
     *
     * It may not reference another parameter and `{{}}` cannot be used in the value.
     *
     * @param stringListValue The values of the parameter.
     */
    public fun stringListValue(stringListValue: Collection<String>) {
        _stringListValue.addAll(stringListValue)
    }

    /**
     * The tier of the string parameter.
     *
     * Default: - undefined
     *
     * @param tier The tier of the string parameter.
     */
    public fun tier(tier: ParameterTier) {
        cdkBuilder.tier(tier)
    }

    public fun build(): StringListParameter {
        if (_stringListValue.isNotEmpty()) cdkBuilder.stringListValue(_stringListValue)
        return cdkBuilder.build()
    }
}
