@file:Suppress("RedundantVisibilityModifier", "RedundantUnitReturnType", "RemoveRedundantQualifierName", "unused", "UnusedImport", "ClassName", "REDUNDANT_PROJECTION", "DEPRECATION")

package cloudshift.awscdk.dsl.services.ssm

import cloudshift.awscdk.common.CdkDslMarker
import software.amazon.awscdk.services.ssm.ParameterDataType
import software.amazon.awscdk.services.ssm.ParameterTier
import software.amazon.awscdk.services.ssm.ParameterType
import software.amazon.awscdk.services.ssm.StringParameter
import software.constructs.Construct
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String

/**
 * Creates a new String SSM Parameter.
 *
 * Example:
 *
 * ```
 * StringParameter ssmParameter = StringParameter.Builder.create(this, "mySsmParameter")
 * .parameterName("mySsmParameter")
 * .stringValue("mySsmParameterValue")
 * .build();
 * ```
 */
@CdkDslMarker
public class StringParameterDsl(
    scope: Construct,
    id: String
) {
    private val cdkBuilder: StringParameter.Builder = StringParameter.Builder.create(scope, id)

    /**
     * A regular expression used to validate the parameter value.
     *
     * For example, for String types with values restricted to
     * numbers, you can specify the following: `^\d+$`
     *
     * Default: no validation is performed
     *
     * @param allowedPattern A regular expression used to validate the parameter value.
     */
    public fun allowedPattern(allowedPattern: String) {
        cdkBuilder.allowedPattern(allowedPattern)
    }

    /**
     * The data type of the parameter, such as `text` or `aws:ec2:image`.
     *
     * Default: ParameterDataType.TEXT
     *
     * @param dataType The data type of the parameter, such as `text` or `aws:ec2:image`.
     */
    public fun dataType(dataType: ParameterDataType) {
        cdkBuilder.dataType(dataType)
    }

    /**
     * Information about the parameter that you want to add to the system.
     *
     * Default: none
     *
     * @param description Information about the parameter that you want to add to the system.
     */
    public fun description(description: String) {
        cdkBuilder.description(description)
    }

    /**
     * The name of the parameter.
     *
     * Default: - a name will be generated by CloudFormation
     *
     * @param parameterName The name of the parameter.
     */
    public fun parameterName(parameterName: String) {
        cdkBuilder.parameterName(parameterName)
    }

    /**
     * Indicates of the parameter name is a simple name (i.e. does not include "/" separators).
     *
     * This is only required only if `parameterName` is a token, which means we
     * are unable to detect if the name is simple or "path-like" for the purpose
     * of rendering SSM parameter ARNs.
     *
     * If `parameterName` is not specified, `simpleName` must be `true` (or
     * undefined) since the name generated by AWS CloudFormation is always a
     * simple name.
     *
     * Default: - auto-detect based on `parameterName`
     *
     * @param simpleName Indicates of the parameter name is a simple name (i.e. does not include "/"
     * separators).
     */
    public fun simpleName(simpleName: Boolean) {
        cdkBuilder.simpleName(simpleName)
    }

    /**
     * The value of the parameter.
     *
     * It may not reference another parameter and `{{}}` cannot be used in the value.
     *
     * @param stringValue The value of the parameter.
     */
    public fun stringValue(stringValue: String) {
        cdkBuilder.stringValue(stringValue)
    }

    /**
     * The tier of the string parameter.
     *
     * Default: - undefined
     *
     * @param tier The tier of the string parameter.
     */
    public fun tier(tier: ParameterTier) {
        cdkBuilder.tier(tier)
    }

    /**
     * (deprecated) The type of the string parameter.
     *
     * Default: ParameterType.STRING
     *
     * * type will always be 'String'
     * @param type The type of the string parameter.
     */
    @Deprecated(message = "deprecated in CDK")
    public fun type(type: ParameterType) {
        cdkBuilder.type(type)
    }

    public fun build(): StringParameter = cdkBuilder.build()
}
