/*
 * Decompiled with CFR 0.152.
 */
package cloudshift.awscdk.dsl.services.autoscaling;

import cloudshift.awscdk.common.CdkDslMarker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.autoscaling.RollingUpdateOptions;
import software.amazon.awscdk.services.autoscaling.ScalingProcess;

@CdkDslMarker
@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u001f\u0010\r\u001a\u00020\u00072\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\r\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcloudshift/awscdk/dsl/services/autoscaling/RollingUpdateOptionsDsl;", "", "<init>", "()V", "build", "Lsoftware/amazon/awscdk/services/autoscaling/RollingUpdateOptions;", "maxBatchSize", "", "", "minInstancesInService", "minSuccessPercentage", "pauseTime", "Lsoftware/amazon/awscdk/Duration;", "suspendProcesses", "", "Lsoftware/amazon/awscdk/services/autoscaling/ScalingProcess;", "([Lsoftware/amazon/awscdk/services/autoscaling/ScalingProcess;)V", "", "waitOnResourceSignals", "", "_suspendProcesses", "", "cdkBuilder", "Lsoftware/amazon/awscdk/services/autoscaling/RollingUpdateOptions$Builder;", "dsl"})
public final class RollingUpdateOptionsDsl {
    @NotNull
    private final RollingUpdateOptions.Builder cdkBuilder;
    @NotNull
    private final List<ScalingProcess> _suspendProcesses;

    public RollingUpdateOptionsDsl() {
        RollingUpdateOptions.Builder builder = RollingUpdateOptions.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
        this.cdkBuilder = builder;
        this._suspendProcesses = new ArrayList();
    }

    public final void maxBatchSize(@NotNull Number maxBatchSize) {
        Intrinsics.checkNotNullParameter((Object)maxBatchSize, (String)"maxBatchSize");
        this.cdkBuilder.maxBatchSize(maxBatchSize);
    }

    public final void minInstancesInService(@NotNull Number minInstancesInService) {
        Intrinsics.checkNotNullParameter((Object)minInstancesInService, (String)"minInstancesInService");
        this.cdkBuilder.minInstancesInService(minInstancesInService);
    }

    public final void minSuccessPercentage(@NotNull Number minSuccessPercentage) {
        Intrinsics.checkNotNullParameter((Object)minSuccessPercentage, (String)"minSuccessPercentage");
        this.cdkBuilder.minSuccessPercentage(minSuccessPercentage);
    }

    public final void pauseTime(@NotNull Duration pauseTime) {
        Intrinsics.checkNotNullParameter((Object)pauseTime, (String)"pauseTime");
        this.cdkBuilder.pauseTime(pauseTime);
    }

    public final void suspendProcesses(ScalingProcess ... suspendProcesses) {
        Intrinsics.checkNotNullParameter((Object)suspendProcesses, (String)"suspendProcesses");
        this._suspendProcesses.addAll(CollectionsKt.listOf((Object[])Arrays.copyOf(suspendProcesses, suspendProcesses.length)));
    }

    public final void suspendProcesses(@NotNull Collection<? extends ScalingProcess> suspendProcesses) {
        Intrinsics.checkNotNullParameter(suspendProcesses, (String)"suspendProcesses");
        this._suspendProcesses.addAll(suspendProcesses);
    }

    public final void waitOnResourceSignals(boolean waitOnResourceSignals) {
        this.cdkBuilder.waitOnResourceSignals(Boolean.valueOf(waitOnResourceSignals));
    }

    @NotNull
    public final RollingUpdateOptions build() {
        if (!((Collection)this._suspendProcesses).isEmpty()) {
            this.cdkBuilder.suspendProcesses(this._suspendProcesses);
        }
        RollingUpdateOptions rollingUpdateOptions2 = this.cdkBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)rollingUpdateOptions2, (String)"build(...)");
        return rollingUpdateOptions2;
    }
}

