/*
 * Decompiled with CFR 0.152.
 */
package cloudshift.awscdk.dsl.services.lambda.eventsources;

import cloudshift.awscdk.common.CdkDslMarker;
import cloudshift.awscdk.dsl.services.s3.NotificationKeyFilterDsl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.services.lambda.eventsources.S3EventSource;
import software.amazon.awscdk.services.s3.Bucket;
import software.amazon.awscdk.services.s3.EventType;
import software.amazon.awscdk.services.s3.NotificationKeyFilter;

@CdkDslMarker
@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u001f\u0010\b\u001a\u00020\t2\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\b\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u0014\u0010\u000e\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\rJ\u001f\u0010\u000e\u001a\u00020\t2\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\t0\u0010\u00a2\u0006\u0002\b\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcloudshift/awscdk/dsl/services/lambda/eventsources/S3EventSourceDsl;", "", "bucket", "Lsoftware/amazon/awscdk/services/s3/Bucket;", "<init>", "(Lsoftware/amazon/awscdk/services/s3/Bucket;)V", "build", "Lsoftware/amazon/awscdk/services/lambda/eventsources/S3EventSource;", "events", "", "", "Lsoftware/amazon/awscdk/services/s3/EventType;", "([Lsoftware/amazon/awscdk/services/s3/EventType;)V", "", "filters", "Lsoftware/amazon/awscdk/services/s3/NotificationKeyFilter;", "Lkotlin/Function1;", "Lcloudshift/awscdk/dsl/services/s3/NotificationKeyFilterDsl;", "Lkotlin/ExtensionFunctionType;", "_events", "", "_filters", "cdkBuilder", "Lsoftware/amazon/awscdk/services/lambda/eventsources/S3EventSource$Builder;", "dsl"})
public final class S3EventSourceDsl {
    @NotNull
    private final S3EventSource.Builder cdkBuilder;
    @NotNull
    private final List<EventType> _events;
    @NotNull
    private final List<NotificationKeyFilter> _filters;

    public S3EventSourceDsl(@NotNull Bucket bucket2) {
        Intrinsics.checkNotNullParameter((Object)bucket2, (String)"bucket");
        S3EventSource.Builder builder = S3EventSource.Builder.create((Bucket)bucket2);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"create(...)");
        this.cdkBuilder = builder;
        this._events = new ArrayList();
        this._filters = new ArrayList();
    }

    public final void events(EventType ... events2) {
        Intrinsics.checkNotNullParameter((Object)events2, (String)"events");
        this._events.addAll(CollectionsKt.listOf((Object[])Arrays.copyOf(events2, events2.length)));
    }

    public final void events(@NotNull Collection<? extends EventType> events2) {
        Intrinsics.checkNotNullParameter(events2, (String)"events");
        this._events.addAll(events2);
    }

    public final void filters(@NotNull Function1<? super NotificationKeyFilterDsl, Unit> filters2) {
        Intrinsics.checkNotNullParameter(filters2, (String)"filters");
        NotificationKeyFilterDsl notificationKeyFilterDsl = new NotificationKeyFilterDsl();
        filters2.invoke((Object)notificationKeyFilterDsl);
        this._filters.add(notificationKeyFilterDsl.build());
    }

    public final void filters(@NotNull Collection<? extends NotificationKeyFilter> filters2) {
        Intrinsics.checkNotNullParameter(filters2, (String)"filters");
        this._filters.addAll(filters2);
    }

    @NotNull
    public final S3EventSource build() {
        if (!((Collection)this._events).isEmpty()) {
            this.cdkBuilder.events(this._events);
        }
        if (!((Collection)this._filters).isEmpty()) {
            this.cdkBuilder.filters(this._filters);
        }
        S3EventSource s3EventSource2 = this.cdkBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)s3EventSource2, (String)"build(...)");
        return s3EventSource2;
    }
}

