/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient;

import com.hp.oo.sdk.content.plugin.GlobalSessionObject;
import com.hp.oo.sdk.content.plugin.SerializableSessionObject;
import io.cloudslang.content.httpclient.HttpClientInputs;
import io.cloudslang.content.httpclient.HttpComponents;
import io.cloudslang.content.httpclient.build.ContentTypeBuilder;
import io.cloudslang.content.httpclient.build.ContextBuilder;
import io.cloudslang.content.httpclient.build.CookieStoreBuilder;
import io.cloudslang.content.httpclient.build.EntityBuilder;
import io.cloudslang.content.httpclient.build.HeadersBuilder;
import io.cloudslang.content.httpclient.build.RequestBuilder;
import io.cloudslang.content.httpclient.build.RequestConfigBuilder;
import io.cloudslang.content.httpclient.build.URIBuilder;
import io.cloudslang.content.httpclient.build.auth.AuthSchemeProviderLookupBuilder;
import io.cloudslang.content.httpclient.build.auth.AuthTypes;
import io.cloudslang.content.httpclient.build.auth.CredentialsProviderBuilder;
import io.cloudslang.content.httpclient.build.conn.ConnectionManagerBuilder;
import io.cloudslang.content.httpclient.build.conn.SSLConnectionSocketFactoryBuilder;
import io.cloudslang.content.httpclient.consume.FinalLocationConsumer;
import io.cloudslang.content.httpclient.consume.HeadersConsumer;
import io.cloudslang.content.httpclient.consume.HttpResponseConsumer;
import io.cloudslang.content.httpclient.consume.StatusConsumer;
import io.cloudslang.content.httpclient.execute.HttpClientExecutor;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class CSHttpClient {
    public static final String RETURN_CODE = "returnCode";
    public static final String SUCCESS = "0";
    public static final String RETURN_RESULT = "returnResult";
    public static final String EXCEPTION = "exception";
    public static final String STATUS_CODE = "statusCode";
    public static final String FINAL_LOCATION = "finalLocation";
    public static final String RESPONSE_HEADERS = "responseHeaders";
    public static final String PROTOCOL_VERSION = "protocolVersion";
    public static final String REASON_PHRASE = "reasonPhrase";
    private CookieStoreBuilder cookieStoreBuilder;
    private AuthSchemeProviderLookupBuilder authSchemeProviderLookupBuilder;
    private RequestConfigBuilder requestConfigBuilder;
    private HeadersBuilder headersBuilder;
    private ContentTypeBuilder contentTypeBuilder;
    private EntityBuilder httpEntityBuilder;
    private RequestBuilder requestBuilder;
    private URIBuilder uriBuilder;
    private CredentialsProviderBuilder credentialsProviderBuilder;
    private SSLConnectionSocketFactoryBuilder sslConnectionSocketFactoryBuilder;
    private ConnectionManagerBuilder poolingHttpClientConnectionManagerBuilder;
    private ContextBuilder contextBuilder;
    private HttpClientExecutor httpClientExecutor;
    private HttpResponseConsumer httpResponseConsumer;
    private FinalLocationConsumer finalLocationConsumer;
    private HeadersConsumer headersConsumer;
    private StatusConsumer statusConsumer;

    public Map<String, String> execute(HttpClientInputs httpClientInputs) {
        this.initSessionsObjects(httpClientInputs);
        HttpComponents httpComponents = this.buildHttpComponents(httpClientInputs);
        CloseableHttpResponse httpResponse = this.execute(httpComponents.getCloseableHttpClient(), httpComponents.getHttpRequestBase(), httpComponents.getHttpClientContext());
        Map<String, String> result = this.parseResponse(httpResponse, httpClientInputs.getResponseCharacterSet(), httpClientInputs.getDestinationFile(), httpComponents.getUri(), httpComponents.getHttpClientContext(), httpComponents.getCookieStore(), httpClientInputs.getCookieStoreSessionObject());
        this.checkKeepAlive(httpComponents.getHttpRequestBase(), httpComponents.getConnManager(), httpClientInputs.getKeepAlive(), httpResponse);
        return result;
    }

    private void initSessionsObjects(HttpClientInputs httpClientInputs) {
        GlobalSessionObject globalSessionObject;
        SerializableSessionObject cookieStoreSessionObject = httpClientInputs.getCookieStoreSessionObject();
        if (cookieStoreSessionObject == null) {
            httpClientInputs.setCookieStoreSessionObject(new SerializableSessionObject());
        }
        if ((globalSessionObject = httpClientInputs.getConnectionPoolSessionObject()) == null) {
            httpClientInputs.setConnectionPoolSessionObject(new GlobalSessionObject());
        }
    }

    public HttpComponents buildHttpComponents(HttpClientInputs httpClientInputs) {
        this.buildDefaultServices();
        URI uri = this.uriBuilder.setUrl(httpClientInputs.getUrl()).setQueryParams(httpClientInputs.getQueryParams()).setQueryParamsAreURLEncoded(httpClientInputs.getQueryParamsAreURLEncoded()).setQueryParamsAreFormEncoded(httpClientInputs.getQueryParamsAreFormEncoded()).buildURI();
        ContentType theContentType = this.contentTypeBuilder.setContentType(httpClientInputs.getContentType()).setRequestCharacterSet(httpClientInputs.getRequestCharacterSet()).buildContentType();
        HttpEntity httpEntity = this.httpEntityBuilder.setFormParams(httpClientInputs.getFormParams()).setFormParamsAreURLEncoded(httpClientInputs.getFormParamsAreURLEncoded()).setBody(httpClientInputs.getBody()).setFilePath(httpClientInputs.getSourceFile()).setContentType(theContentType).setMultipartValuesAreURLEncoded(httpClientInputs.getMultipartValuesAreURLEncoded()).setMultipartBodies(httpClientInputs.getMultipartBodies()).setMultipartFiles(httpClientInputs.getMultipartFiles()).setMultipartBodiesContentType(httpClientInputs.getMultipartBodiesContentType()).setMultipartFilesContentType(httpClientInputs.getMultipartFilesContentType()).setChunkedRequestEntity(httpClientInputs.getChunkedRequestEntity()).buildEntity();
        HttpRequestBase httpRequestBase = this.requestBuilder.setMethod(httpClientInputs.getMethod()).setUri(uri).setEntity(httpEntity).build();
        List<Header> theHeaders = this.headersBuilder.setHeaders(httpClientInputs.getHeaders()).setContentType(theContentType).setEntityContentType(httpEntity != null ? httpEntity.getContentType() : null).buildHeaders();
        RequestConfig requestConfig = this.requestConfigBuilder.setConnectionTimeout(httpClientInputs.getConnectTimeout()).setSocketTimeout(httpClientInputs.getSocketTimeout()).setFollowRedirects(httpClientInputs.getFollowRedirects()).setProxyHost(httpClientInputs.getProxyHost()).setProxyPort(httpClientInputs.getProxyPort()).buildRequestConfig();
        httpRequestBase.setConfig(requestConfig);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        AuthTypes authTypes = new AuthTypes(httpClientInputs.getAuthType());
        CredentialsProvider credentialsProvider = this.credentialsProviderBuilder.setAuthTypes(authTypes).setUsername(httpClientInputs.getUsername()).setPassword(httpClientInputs.getPassword()).setHost(uri.getHost()).setPort(String.valueOf(uri.getPort())).setProxyUsername(httpClientInputs.getProxyUsername()).setProxyPassword(httpClientInputs.getProxyPassword()).setProxyHost(httpClientInputs.getProxyHost()).setProxyPort(httpClientInputs.getProxyPort()).buildCredentialsProvider();
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        Lookup<AuthSchemeProvider> authSchemeLookup = this.authSchemeProviderLookupBuilder.setAuthTypes(authTypes).setHost(uri.getHost()).setHeaders(theHeaders).setSkipPortAtKerberosDatabaseLookup(httpClientInputs.getKerberosSkipPortCheck()).setKerberosConfigFile(httpClientInputs.getKerberosConfFile()).setKerberosLoginConfigFile(httpClientInputs.getKerberosLoginConfFile()).setUsername(httpClientInputs.getUsername()).setPassword(httpClientInputs.getPassword()).buildAuthSchemeProviderLookup();
        httpClientBuilder.setDefaultAuthSchemeRegistry(authSchemeLookup);
        httpRequestBase.setHeaders(theHeaders.toArray(new Header[theHeaders.size()]));
        CookieStore cookieStore = this.cookieStoreBuilder.setUseCookies(httpClientInputs.getUseCookies()).setCookieStoreSessionObject(httpClientInputs.getCookieStoreSessionObject()).buildCookieStore();
        if (cookieStore != null) {
            httpClientBuilder.setDefaultCookieStore(cookieStore);
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = this.sslConnectionSocketFactoryBuilder.setTrustAllRoots(httpClientInputs.getTrustAllRoots()).setKeystore(httpClientInputs.getKeystore()).setKeystorePassword(httpClientInputs.getKeystorePassword()).setTrustKeystore(httpClientInputs.getTrustKeystore()).setTrustPassword(httpClientInputs.getTrustPassword()).setX509HostnameVerifier(httpClientInputs.getX509HostnameVerifier()).build();
        String connectionKey = ConnectionManagerBuilder.buildConnectionManagerMapKey(httpClientInputs.getTrustAllRoots(), httpClientInputs.getX509HostnameVerifier(), httpClientInputs.getKeystore(), httpClientInputs.getTrustKeystore());
        PoolingHttpClientConnectionManager connManager = this.poolingHttpClientConnectionManagerBuilder.setConnectionManagerMapKey(connectionKey).setConnectionPoolHolder(httpClientInputs.getConnectionPoolSessionObject()).setSslsf(sslConnectionSocketFactory).setDefaultMaxPerRoute(httpClientInputs.getConnectionsMaxPerRoute()).setTotalMax(httpClientInputs.getConnectionsMaxTotal()).buildConnectionManager();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connManager);
        if (StringUtils.isEmpty((CharSequence)httpClientInputs.getKeepAlive()) || Boolean.parseBoolean(httpClientInputs.getKeepAlive())) {
            httpClientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultConnectionReuseStrategy.INSTANCE);
        } else {
            httpClientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)NoConnectionReuseStrategy.INSTANCE);
        }
        CloseableHttpClient closeableHttpClient = httpClientBuilder.build();
        HttpClientContext context = this.contextBuilder.setAuthSchemeLookup(authSchemeLookup).setAuthTypes(authTypes).setCredentialsProvider(credentialsProvider).setUri(uri).setPreemptiveAuth(httpClientInputs.getPreemptiveAuth()).build();
        HttpComponents result = new HttpComponents();
        result.setCloseableHttpClient(closeableHttpClient);
        result.setHttpRequestBase(httpRequestBase);
        result.setHttpClientContext(context);
        result.setUri(uri);
        result.setConnManager(connManager);
        result.setCookieStore(cookieStore);
        result.setHttpClientBuilder(httpClientBuilder);
        return result;
    }

    public CloseableHttpResponse execute(CloseableHttpClient closeableHttpClient, HttpRequestBase httpRequestBase, HttpClientContext context) {
        return this.httpClientExecutor.setCloseableHttpClient(closeableHttpClient).setHttpRequestBase(httpRequestBase).setContext(context).execute();
    }

    public Map<String, String> parseResponse(CloseableHttpResponse httpResponse, String responseCharacterSet, String destinationFile, URI uri, HttpClientContext httpClientContext, CookieStore cookieStore, SerializableSessionObject cookieStoreSessionObject) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            this.httpResponseConsumer.setHttpResponse((HttpResponse)httpResponse).setResponseCharacterSet(responseCharacterSet).setDestinationFile(destinationFile).consume(result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.finalLocationConsumer.setUri(uri).setRedirectLocations(httpClientContext.getRedirectLocations()).setTargetHost(httpClientContext.getTargetHost()).consume(result);
        this.headersConsumer.setHeaders(httpResponse.getAllHeaders()).consume(result);
        this.statusConsumer.setStatusLine(httpResponse.getStatusLine()).consume(result);
        if (cookieStore != null) {
            try {
                cookieStoreSessionObject.setValue((Serializable)CookieStoreBuilder.serialize(cookieStore));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        result.put(RETURN_CODE, SUCCESS);
        return result;
    }

    private void checkKeepAlive(HttpRequestBase httpRequestBase, PoolingHttpClientConnectionManager connManager, String keepAliveInput, CloseableHttpResponse httpResponse) {
        boolean keepAlive;
        boolean bl = keepAlive = StringUtils.isBlank((CharSequence)keepAliveInput) || Boolean.parseBoolean(keepAliveInput);
        if (keepAlive) {
            httpRequestBase.releaseConnection();
        } else {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            httpRequestBase.releaseConnection();
            connManager.closeExpiredConnections();
        }
    }

    public void setCookieStoreBuilder(CookieStoreBuilder cookieStoreBuilder) {
        this.cookieStoreBuilder = cookieStoreBuilder;
    }

    public void setAuthSchemeProviderLookupBuilder(AuthSchemeProviderLookupBuilder authSchemeProviderLookupBuilder) {
        this.authSchemeProviderLookupBuilder = authSchemeProviderLookupBuilder;
    }

    public void setRequestConfigBuilder(RequestConfigBuilder requestConfigBuilder) {
        this.requestConfigBuilder = requestConfigBuilder;
    }

    public void setHeadersBuilder(HeadersBuilder headersBuilder) {
        this.headersBuilder = headersBuilder;
    }

    public void setHttpEntityBuilder(EntityBuilder httpEntityBuilder) {
        this.httpEntityBuilder = httpEntityBuilder;
    }

    public void setUriBuilder(URIBuilder uriBuilder) {
        this.uriBuilder = uriBuilder;
    }

    public void setCredentialsProviderBuilder(CredentialsProviderBuilder credentialsProviderBuilder) {
        this.credentialsProviderBuilder = credentialsProviderBuilder;
    }

    public void setSslConnectionSocketFactoryBuilder(SSLConnectionSocketFactoryBuilder sslConnectionSocketFactoryBuilder) {
        this.sslConnectionSocketFactoryBuilder = sslConnectionSocketFactoryBuilder;
    }

    public void setPoolingHttpClientConnectionManagerBuilder(ConnectionManagerBuilder poolingHttpClientConnectionManagerBuilder) {
        this.poolingHttpClientConnectionManagerBuilder = poolingHttpClientConnectionManagerBuilder;
    }

    private void buildDefaultServices() {
        if (this.uriBuilder == null) {
            this.uriBuilder = new URIBuilder();
        }
        if (this.contentTypeBuilder == null) {
            this.contentTypeBuilder = new ContentTypeBuilder();
        }
        if (this.httpEntityBuilder == null) {
            this.httpEntityBuilder = new EntityBuilder();
        }
        if (this.requestBuilder == null) {
            this.requestBuilder = new RequestBuilder();
        }
        if (this.headersBuilder == null) {
            this.headersBuilder = new HeadersBuilder();
        }
        if (this.requestConfigBuilder == null) {
            this.requestConfigBuilder = new RequestConfigBuilder();
        }
        if (this.credentialsProviderBuilder == null) {
            this.credentialsProviderBuilder = new CredentialsProviderBuilder();
        }
        if (this.authSchemeProviderLookupBuilder == null) {
            this.authSchemeProviderLookupBuilder = new AuthSchemeProviderLookupBuilder();
        }
        if (this.cookieStoreBuilder == null) {
            this.cookieStoreBuilder = new CookieStoreBuilder();
        }
        if (this.sslConnectionSocketFactoryBuilder == null) {
            this.sslConnectionSocketFactoryBuilder = new SSLConnectionSocketFactoryBuilder();
        }
        if (this.poolingHttpClientConnectionManagerBuilder == null) {
            this.poolingHttpClientConnectionManagerBuilder = new ConnectionManagerBuilder();
        }
        if (this.contextBuilder == null) {
            this.contextBuilder = new ContextBuilder();
        }
        if (this.httpClientExecutor == null) {
            this.httpClientExecutor = new HttpClientExecutor();
        }
        if (this.httpResponseConsumer == null) {
            this.httpResponseConsumer = new HttpResponseConsumer();
        }
        if (this.finalLocationConsumer == null) {
            this.finalLocationConsumer = new FinalLocationConsumer();
        }
        if (this.headersConsumer == null) {
            this.headersConsumer = new HeadersConsumer();
        }
        if (this.statusConsumer == null) {
            this.statusConsumer = new StatusConsumer();
        }
    }
}

