/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient;

import com.hp.oo.sdk.content.annotations.Action;
import com.hp.oo.sdk.content.annotations.Output;
import com.hp.oo.sdk.content.annotations.Param;
import com.hp.oo.sdk.content.annotations.Response;
import com.hp.oo.sdk.content.plugin.ActionMetadata.MatchType;
import com.hp.oo.sdk.content.plugin.ActionMetadata.ResponseType;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class URLEncoderAction {
    public static final String RETURN_CODE = "returnCode";
    public static final String RETURN_RESULT = "returnResult";

    @Action(name="URL Encoder", outputs={@Output(value="exception"), @Output(value="returnCode"), @Output(value="returnResult")}, responses={@Response(text="success", field="returnCode", value="0", matchType=MatchType.COMPARE_EQUAL, responseType=ResponseType.RESOLVED), @Response(text="failure", field="returnCode", value="-1", matchType=MatchType.COMPARE_EQUAL, responseType=ResponseType.ERROR)})
    public Map<String, String> execute(@Param(value="text", required=true) String text, @Param(value="characterSet") String characterSet) {
        try {
            if (StringUtils.isEmpty((CharSequence)characterSet)) {
                characterSet = "UTF-8";
            }
            String returnResult = URLEncoder.encode(text, characterSet);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put(RETURN_RESULT, returnResult);
            result.put(RETURN_CODE, "0");
            return result;
        }
        catch (Exception e) {
            return this.exceptionResult(e.getMessage(), e);
        }
    }

    private Map<String, String> exceptionResult(String message, Exception e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String eStr = writer.toString().replace("\u0000", "");
        HashMap<String, String> returnResult = new HashMap<String, String>();
        returnResult.put(RETURN_RESULT, message);
        returnResult.put(RETURN_CODE, "-1");
        returnResult.put("exception", eStr);
        return returnResult;
    }
}

