/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.build;

import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;

public class ContentTypeBuilder {
    private String contentType;
    private String requestCharacterSet;

    public ContentTypeBuilder setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public ContentTypeBuilder setRequestCharacterSet(String requestCharacterSet) {
        if (!StringUtils.isEmpty((CharSequence)requestCharacterSet)) {
            this.requestCharacterSet = requestCharacterSet;
        }
        return this;
    }

    public ContentType buildContentType() {
        ContentType parsedContentType = null;
        if (StringUtils.isNotBlank((CharSequence)this.contentType)) {
            try {
                parsedContentType = ContentType.parse((String)this.contentType);
            }
            catch (UnsupportedCharsetException | ParseException e) {
                throw new IllegalArgumentException("Could not parse input 'contentType'. " + e.getMessage(), e);
            }
            if (!StringUtils.isEmpty((CharSequence)this.requestCharacterSet)) {
                try {
                    parsedContentType = parsedContentType.withCharset(this.requestCharacterSet);
                }
                catch (UnsupportedCharsetException e) {
                    throw new IllegalArgumentException("Could not parse input 'requestCharacterSet'. " + e.getMessage(), e);
                }
            }
        }
        return parsedContentType;
    }
}

