/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.build;

import io.cloudslang.content.httpclient.build.auth.AuthTypes;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.HttpContext;

public class ContextBuilder {
    private Lookup<AuthSchemeProvider> authSchemeLookup;
    private URI uri;
    private AuthTypes authTypes;
    private CredentialsProvider credentialsProvider;
    private String preemptiveAuth;

    public ContextBuilder setAuthSchemeLookup(Lookup<AuthSchemeProvider> authSchemeLookup) {
        this.authSchemeLookup = authSchemeLookup;
        return this;
    }

    public ContextBuilder setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public ContextBuilder setAuthTypes(AuthTypes authTypes) {
        this.authTypes = authTypes;
        return this;
    }

    public ContextBuilder setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public ContextBuilder setPreemptiveAuth(String preemptiveAuth) {
        this.preemptiveAuth = preemptiveAuth;
        return this;
    }

    public HttpClientContext build() {
        if (StringUtils.isEmpty((CharSequence)this.preemptiveAuth)) {
            this.preemptiveAuth = "true";
        }
        HttpClientContext context = HttpClientContext.create();
        if (this.authTypes.size() == 1 && Boolean.parseBoolean(this.preemptiveAuth) && !this.authTypes.contains("ANONYMOUS")) {
            BasicAuthCache authCache = new BasicAuthCache();
            authCache.put(new HttpHost(this.uri.getHost(), this.uri.getPort(), this.uri.getScheme()), ((AuthSchemeProvider)this.authSchemeLookup.lookup(this.authTypes.iterator().next())).create((HttpContext)context));
            context.setCredentialsProvider(this.credentialsProvider);
            context.setAuthCache((AuthCache)authCache);
        }
        return context;
    }
}

