/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.build;

import io.cloudslang.content.httpclient.build.UrlEncodeException;
import io.cloudslang.content.httpclient.build.Utils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class EntityBuilder {
    private String body;
    private String filePath;
    private ContentType contentType;
    private String formParams;
    private String formParamsAreURLEncoded = "false";
    private String multipartBodies;
    private String multipartFiles;
    private String multipartValuesAreURLEncoded = "false";
    private String multipartBodiesContentType = "text/plain; charset=ISO-8859-1";
    private String multipartFilesContentType = "application/octet-stream";
    private String chunkedRequestEntity;

    public EntityBuilder setBody(String body) {
        this.body = body;
        return this;
    }

    public EntityBuilder setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public EntityBuilder setContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public EntityBuilder setFormParams(String formParams) {
        this.formParams = formParams;
        return this;
    }

    public EntityBuilder setFormParamsAreURLEncoded(String formParamsAreURLEncoded) {
        if (!StringUtils.isEmpty((CharSequence)formParamsAreURLEncoded)) {
            this.formParamsAreURLEncoded = formParamsAreURLEncoded;
        }
        return this;
    }

    public EntityBuilder setMultipartBodies(String multipartBodies) {
        this.multipartBodies = multipartBodies;
        return this;
    }

    public EntityBuilder setMultipartFiles(String multipartFiles) {
        this.multipartFiles = multipartFiles;
        return this;
    }

    public EntityBuilder setMultipartValuesAreURLEncoded(String multipartValuesAreURLEncoded) {
        if (!StringUtils.isEmpty((CharSequence)multipartValuesAreURLEncoded)) {
            this.multipartValuesAreURLEncoded = multipartValuesAreURLEncoded;
        }
        return this;
    }

    public EntityBuilder setMultipartBodiesContentType(String multipartBodiesContentType) {
        if (!StringUtils.isEmpty((CharSequence)multipartBodiesContentType)) {
            this.multipartBodiesContentType = multipartBodiesContentType;
        }
        return this;
    }

    public EntityBuilder setMultipartFilesContentType(String multipartFilesContentType) {
        if (!StringUtils.isEmpty((CharSequence)multipartFilesContentType)) {
            this.multipartFilesContentType = multipartFilesContentType;
        }
        return this;
    }

    public EntityBuilder setChunkedRequestEntity(String chunkedRequestEntity) {
        this.chunkedRequestEntity = chunkedRequestEntity;
        return this;
    }

    public HttpEntity buildEntity() {
        StringEntity httpEntity = null;
        if (!StringUtils.isEmpty((CharSequence)this.formParams)) {
            List<? extends NameValuePair> list = this.getNameValuePairs(this.formParams, !Boolean.parseBoolean(this.formParamsAreURLEncoded), "formParams", "formParamsAreURLEncoded");
            Charset charset = this.contentType != null ? this.contentType.getCharset() : null;
            httpEntity = new UrlEncodedFormEntity(list, charset);
        } else if (!StringUtils.isEmpty((CharSequence)this.body)) {
            httpEntity = new StringEntity(this.body, this.contentType);
        } else if (!StringUtils.isEmpty((CharSequence)this.filePath)) {
            File file = new File(this.filePath);
            if (!file.exists()) {
                throw new IllegalArgumentException("file set by input 'sourceFile' does not exist:" + this.filePath);
            }
            httpEntity = new FileEntity(file, this.contentType);
        }
        if (httpEntity != null) {
            if (!StringUtils.isEmpty((CharSequence)this.chunkedRequestEntity)) {
                httpEntity.setChunked(Boolean.parseBoolean(this.chunkedRequestEntity));
            }
            return httpEntity;
        }
        if (!StringUtils.isEmpty((CharSequence)this.multipartBodies) || !StringUtils.isEmpty((CharSequence)this.multipartFiles)) {
            List<? extends NameValuePair> list;
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            if (!StringUtils.isEmpty((CharSequence)this.multipartBodies)) {
                list = this.getNameValuePairs(this.multipartBodies, !Boolean.parseBoolean(this.multipartValuesAreURLEncoded), "multipartBodies", "multipartValuesAreURLEncoded");
                ContentType bodiesCT = ContentType.parse((String)this.multipartBodiesContentType);
                for (NameValuePair nameValuePair : list) {
                    multipartEntityBuilder.addTextBody(nameValuePair.getName(), nameValuePair.getValue(), bodiesCT);
                }
            }
            if (!StringUtils.isEmpty((CharSequence)this.multipartFiles)) {
                list = this.getNameValuePairs(this.multipartFiles, !Boolean.parseBoolean(this.multipartValuesAreURLEncoded), "multipartFiles", "multipartValuesAreURLEncoded");
                ContentType filesCT = ContentType.parse((String)this.multipartFilesContentType);
                for (NameValuePair nameValuePair : list) {
                    File file = new File(nameValuePair.getValue());
                    multipartEntityBuilder.addBinaryBody(nameValuePair.getName(), file, filesCT, file.getName());
                }
            }
            return multipartEntityBuilder.build();
        }
        return null;
    }

    private List<? extends NameValuePair> getNameValuePairs(String theInput, boolean encode, String constInput, String constEncode) {
        List<? extends NameValuePair> list;
        try {
            list = Utils.urlEncodeMultipleParams(theInput, encode);
        }
        catch (UrlEncodeException e) {
            throw new UrlEncodeException(constEncode + " is 'false' but " + constInput + " are not properly encoded. " + e.getMessage(), e);
        }
        return list;
    }
}

