/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.build;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;

public class HeadersBuilder {
    private String headers;
    private ContentType contentType;
    private Header entityContentType;

    public HeadersBuilder setHeaders(String headers) {
        this.headers = headers;
        return this;
    }

    public HeadersBuilder setContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public HeadersBuilder setEntityContentType(Header entityContentType) {
        this.entityContentType = entityContentType;
        return this;
    }

    public List<Header> buildHeaders() {
        ArrayList<Header> headersArr = new ArrayList<Header>();
        if (!StringUtils.isEmpty((CharSequence)this.headers)) {
            BufferedReader in = new BufferedReader(new StringReader(this.headers));
            try {
                String str;
                while ((str = in.readLine()) != null) {
                    CharArrayBuffer charArrayBuffer = new CharArrayBuffer(str.length());
                    charArrayBuffer.append(str);
                    headersArr.add((Header)new BufferedHeader(charArrayBuffer));
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (this.entityContentType != null) {
            headersArr.add(this.entityContentType);
        } else if (this.contentType != null && !this.contentType.toString().isEmpty()) {
            headersArr.add((Header)new BasicHeader("Content-Type", this.contentType.toString()));
        }
        return headersArr;
    }
}

