/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.build;

import java.net.URI;
import java.util.Arrays;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpRequestBase;

public class RequestBuilder {
    private static String[] methods = new String[]{"DELETE", "GET", "HEAD", "OPTIONS", "PATCH", "POST", "PUT", "TRACE"};
    private String method;
    private URI uri;
    private HttpEntity entity;

    public RequestBuilder setMethod(String method) {
        this.method = method;
        return this;
    }

    public RequestBuilder setUri(URI uri) {
        this.uri = uri;
        return this;
    }

    public RequestBuilder setEntity(HttpEntity entity) {
        this.entity = entity;
        return this;
    }

    public HttpRequestBase build() {
        if (this.method == null) {
            throw new IllegalArgumentException("The 'method' input is required. Provide one of " + Arrays.asList(methods).toString());
        }
        String method = this.method.toUpperCase().trim();
        if (Arrays.binarySearch(methods, method) < 0) {
            throw new IllegalArgumentException("invalid 'method' input '" + method + "'");
        }
        org.apache.http.client.methods.RequestBuilder requestBuilder = org.apache.http.client.methods.RequestBuilder.create((String)method);
        requestBuilder.setUri(this.uri);
        requestBuilder.setEntity(this.entity);
        return (HttpRequestBase)requestBuilder.build();
    }
}

