/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.content.httpclient.build;

import io.cloudslang.content.httpclient.build.Utils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;

public class RequestConfigBuilder {
    private String connectionTimeout = "0";
    private String socketTimeout = "0";
    private String followRedirects = "true";
    private String proxyHost;
    private String proxyPort = "8080";

    public RequestConfigBuilder setConnectionTimeout(String connectionTimeout) {
        if (!StringUtils.isEmpty((CharSequence)connectionTimeout)) {
            this.connectionTimeout = connectionTimeout;
        }
        return this;
    }

    public RequestConfigBuilder setSocketTimeout(String socketTimeout) {
        if (!StringUtils.isEmpty((CharSequence)socketTimeout)) {
            this.socketTimeout = socketTimeout;
        }
        return this;
    }

    public RequestConfigBuilder setFollowRedirects(String followRedirects) {
        if (!StringUtils.isEmpty((CharSequence)followRedirects)) {
            this.followRedirects = followRedirects;
        }
        return this;
    }

    public RequestConfigBuilder setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public RequestConfigBuilder setProxyPort(String proxyPort) {
        if (!StringUtils.isEmpty((CharSequence)proxyPort)) {
            this.proxyPort = proxyPort;
        }
        return this;
    }

    public RequestConfig buildRequestConfig() {
        HttpHost proxy = null;
        if (this.proxyHost != null && !this.proxyHost.isEmpty()) {
            int proxyPortNumber = Utils.validatePortNumber(this.proxyPort);
            proxy = new HttpHost(this.proxyHost, proxyPortNumber);
        }
        int connectionTimeout = Integer.parseInt(this.connectionTimeout);
        int socketTimeout = Integer.parseInt(this.socketTimeout);
        return RequestConfig.custom().setConnectTimeout(connectionTimeout <= 0 ? connectionTimeout : connectionTimeout * 1000).setSocketTimeout(socketTimeout <= 0 ? socketTimeout : socketTimeout * 1000).setProxy(proxy).setRedirectsEnabled(Boolean.parseBoolean(this.followRedirects)).build();
    }
}

